<?php
function runtime_query_cache($config, $vars, $status) {
	$ret = ret("查询概况", "");
	
	$qc_mem_used = $vars['query_cache_size'] - $status['Qcache_free_memory'];

$fmt = <<<MSG
<pre>
<b>重要数据</b>
------------------------------------------------------------------------
已经使用内存         %10s 共  %10s  %%使用率: %10s
登记到缓存内的查询数 %10s
缓存命中次数         %10s
被缓存查询数         %10s
从缓存删除的查询数   %10s
插入:删除            %10s
命中率:插入          %10s

<b>其它数据</b>
------------------------------------------------------------------------
%%缓存块空闲率         %10s
缓存块个数            %10s
空闲的缓存块          %10s
空闲的缓存大小        %10s
缓存块大小            %10s
非缓存查询            %10s
</pre>
MSG;
	$ret->val = sprintf($fmt
	, b($qc_mem_used), b($vars['query_cache_size']), perc($qc_mem_used, $vars['query_cache_size'])
	, b($status['Qcache_hits'])
	, b($status['Qcache_queries_in_cache'])
	, b($status['Qcache_inserts'])
	, b($status['Qcache_lowmem_prunes'])
	, radio($status['Qcache_inserts'], $status['Qcache_lowmem_prunes'])
	, radio($status['Qcache_hits'], $status['Qcache_inserts'])
	, perc($status['Qcache_free_blocks'], $status['Qcache_total_blocks'])
	, b($status['Qcache_total_blocks'])
	, b($status['Qcache_free_blocks'])
	, b($status['Qcache_free_memory'])
	, b($vars['query_cache_min_res_unit'])
	, b($status['Qcache_not_cached'])
	);
	$ret->sort = '查询缓存';
	
$fmt =<<<MSG
<p></p>
MSG;

$fmt =<<<MSG
<p>如果“从缓存删除的查询数”的值非常大，表明经常出现缓冲区不够用的情况，因此你应该考虑加大[var]query_cache_size[/var]的大小，应该尽量保证[stat]QCACHE_lowmem_prunes[/stat]的值为0或不在继续增长。</p>
<p>如果“缓存块空闲率”很高，说明内存碎片较多，需要适当减小[var]query_cache_min_res_unit[/var]的大小，默认情况下它被分配4KB。碎片较多，也容易引起“从缓存删除的查询数”继续增加，因为内存中碎片较多，无法利用。</p>
MSG;
	$ret->msg = $fmt;
	
$fmt =<<<MSG
<p>[var]query_cache_size[/var]的大小设置应不低于40KB，因为query_cache_size中会拿出一部分单元给系统结构。</p>
MSG;
	$ret->title = sprintf($fmt);
	
	return $ret;
}

function runtime_query_cache_author() {
	return array(
		'user' => 'langwan', 
		'email' => 'langwanluo@gmail.com',
		'version' => '09.12.14'
	);
}

?>