<?php

function runtime_select_and_sort($config, $vars, $status) {
	$ret = ret("查询和排序", "");
	
	$Select_scan = $status['Select_scan'];
	$Select_range = $status['Select_range'];
	$Select_full_join = $status['Select_full_join'];
	$Select_range_check = $status['Select_range_check'];
	$Select_full_range_join = $status['Select_full_range_join'];
	$Sort_scan = $status['Sort_scan'];
	$Sort_range = $status['Sort_range'];
	$Sort_merge_passes = $status['Sort_merge_passes'];
	$select = $status['Com_select'];
	
	$total = $Select_scan + $Select_range + $Select_full_join + $Select_range_check
	+ $Select_full_range_join + $Sort_scan + $Sort_range + $Sort_merge_passes;

$fmt = <<<MSG
<pre>                  hits  %%Total
--------------------------------
Scan          %8s %8s
Range         %8s %8s
Full join     %8s %8s
Range check   %8s %8s
Full rng join %8s %8s
Sort scan     %8s %8s
Sort range    %8s %8s
Sort mrg pass %8s %8s
--------------------------------
              %8s %8s
</pre>
MSG;
	$ret->val = sprintf($fmt
	, b($Select_scan), perc($Select_scan, $select)
	, b($Select_range), perc($Select_range, $select)
	, b($Select_full_join), perc($Select_full_join, $select)
	, b($Select_range_check), perc($Select_range_check, $select)
	, b($Select_full_range_join), perc($Select_full_range_join, $select)
	, b($Sort_scan), perc($Sort_scan, $select)
	, b($Sort_range), perc($Sort_range, $select)
	, b($Sort_merge_passes), perc($Sort_merge_passes, $select)
	, b($total), perc($total, $select)
	);
	$ret->sort = '查询';
	
$fmt =<<<MSG
<p>Select_scan 对第一个表进行完全扫描的联接的数量。</p>
<p>Select_range 在第一个表中使用范围的联接的数量。一般情况不是关键问题，即使该值相当大。</p>
<p>Select_full_join 没有使用索引的联接的数量。如果该值不为0,你应仔细检查表的索引。</p>
<p>Select_range_check 在每一行数据后对键值进行检查的不带键值的联接的数量。如果不为0，你应仔细检查表的索引。</p>
<p>Select_full_range_join 在引用的表中使用范围搜索的联接的数量。</p>
<p>Sort_scan 通过扫描表完成的排序的数量。</p>
<p>Sort_range 在范围内执行的排序的数量。</p>
<p>Sort_merge_passes 排序算法已经执行的合并的数量。如果这个变量值较大，应考虑增加sort_buffer_size系统变量的值。</p>
MSG;
	
	$ret->title = sprintf($fmt);
	
	
$fmt =<<<MSG
<p>这些指标应该结合慢查询记录进行观察，如果没有产生慢查询，那就没什么问题。</p>
<p>应该尽量避免全表扫描的情况，如果全表扫描比较多应该查找原因，当然也有一种例外情况就是执行的show指令较多，某些监控软件会频繁执行show指令，这也被记录成全表扫描Scan。</p>
<p>Full join 如果这个数值不是0，你要仔细检查索引，那些关联表的操作没有利用上索引。</p>
<p>Range check 在每一行数据后对键值进行检查的不带键值的联接的数量。如果不为0，你应仔细检查表的索引。</p>
<p>Full rng join 在引用的表中使用范围搜索的联接的数量。</p>
<p>Sort scan 全表扫描后进行了排序，所以还是尽量要多注意。</p>
<p>Sort mrg pass 排序算法已经执行的合并的数量。如果这个变量值较大，应考虑增加sort_buffer_size系统变量的值。</p>
MSG;
	
	$ret->msg = sprintf($fmt);	
	
	return $ret;
}

function runtime_select_and_sort_author() {
	return array(
		'user' => 'langwan', 
		'email' => 'langwanluo@gmail.com',
		'version' => '09.12.14'
	);
}

?>