<?php

function runtime_table_open_cached_radio($config, $vars, $status) {
	$ret = ret("表缓存使用率", "");
	$a = $status['Open_tables'];
	$b = empty($vars['table_open_cache']) ? $vars['table_cache'] : $vars['table_open_cache'];
	$r = perc($a, $b);
	if($r > 90) {
		$ret->no = MY_ERROR;
		$ret->msg = '建议增大table_open_cache的数量，表缓存很可能不够';
	} else {
	
$fmt = <<<MSG
MySQL是多线程的，因此许多客户可以同时在同一个表上进行查询。为了使多个客户线程在同一个表上有不同状态的问题减到最小，表被每个并发进程独立地打开。这样需要额外的内存但一般会提高性能。对于MyISAM表，数据文件需要为每个打开表的客户提供一个额外的文件描述符。(索引文件描述符在所有线程之间共享)。
[var]table_cache[/var]与[var]max_connections[/var]有关。例如，对于200个并行运行的连接，应该让表的缓存至少有200 * N，这里N是可以执行的查询的一个联接中表的最大数量。还需要为临时表和文件保留一些额外的文件描述符。';
MSG;
	$ret->msg = sprintf($fmt);

	}
	$ret->val = $r;
$fmt = <<<MSG
Open_tables      %8s
table_open_cache %8s
MSG;
	$ret->varTitle = sprintf($fmt, b($a), b($b));
	return $ret;
}

function runtime_table_open_cached_radio_author() {
	return array(
		'user' => 'langwan', 
		'email' => 'langwanluo@gmail.com',
		'version' => '09.12.14'
	);
}

?>