
$(function() {

	$('.menu').removeClass('current');
	$('#menu_'+sys_env['script']).addClass('current');
	
	$('#serverName').change(function(){
		location.href = '?script=main&serverName='+$(this).val();
	});
	var params = getQueryString(window.document.URL, 'serverName');
	setOption($('#serverName'), params);
	
	$('#shareSnapshot').click(function(){
	
	});
	
	$('#exportSnapshot').click(exportSnapshot);
	$('#flushCache').click(flushCache);

});

function show(tag, obj) {
	
	if(typeof mmc.hide == 'undefined' || typeof mmc.hide != 'Array') {
		//mmc.hide = new Array();
	}
	if($(tag).className == 'hidden') {
		$(tag).className = '';
		if(obj.className.indexOf("plus") != -1) {
			obj.className = 'minus';
		}
		//mmc.hide[tag] = 'open';
	} else {
		$(tag).className = 'hidden';
		if(obj.className.indexOf("minus") != -1) {
			obj.className = 'plus';
		}
		
		//mmc.hide[tag] = 'hidden';
		
	}
	
	//mmc.set({path: '/'});
}

function setOption(obj, value) {
	if(!value) {
		obj.get(0).options[0].selected = true;
		return;
	}
	
	var find = false;
	for(var i = 0; i < obj.get(0).options.length; i++) {
		//alert(i);
		if(obj.get(0).options[i].value == value) {
			obj.get(0).options[i].selected = true;
			find = true;
		}
	}
	
	if(find == false) {
		obj.get(0).options[0].selected = true;
	}
}

function getQueryString(sURL, key) {

	var value = ""; 
	//获取当前文档的URL,为后面分析它做准备
	//var sURL = window.document.URL;
	//URL中是否包含查询字符串
	if (sURL.indexOf("?") > 0) {
		//分解URL,第二的元素为完整的查询字符串
		//即arrayParams[1]的值为【first=1&second=2】
		var arrayParams = sURL.split("?");

		//分解查询字符串
		//arrayURLParams[0]的值为【first=1 】
		//arrayURLParams[2]的值为【second=2】
		var arrayURLParams = arrayParams[1].split("&");

		//遍历分解后的键值对
		for (var i = 0; i < arrayURLParams.length; i++) {
			//分解一个键值对
			var sParam = arrayURLParams[i].split("=");

			if ((sParam[0] == key) && (sParam[1] != "")) {
				//找到匹配的的键,且值不为空
				value = sParam[1];
			　　	break;
			}
		} 
	}
	
	return value;
}

function exportSnapshot() {
	$.getJSON('?script=do&do=exportSnapshot&serverName='+sys_env['serverName'], function(data){
		showMessage('保存快照', data.msg);
	});
}

function showMessage(title, msg) {
	var created = $('#msgDlg').attr("created");
	if(created != 'true') {
		$('#msgDlg').dialog({
			title : title,
			buttons: {
				'确定' : function() {
					$(this).dialog('close');
				}
			}
		});
		$('#msgDlg').attr("created", 'true');
	}
	$('#msgDlg').html(msg);
	$('#msgDlg').dialog('open');
	
}

function flushCache() {
	$.getJSON('?script=do&do=flush', function(data){
		showMessage('更新缓存', data.msg);
	});
}