<?php

#################################################
#
#	 This file is part of VFront.
#
#    VFront is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    VFront is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

/**
 * VFront Web Installer - Utility di installazione dell'applicazione VFront 
 * Caratteristiche richieste: PHP5.x , MySQL 5.x, php_mysqli 
 * Oppure: PHP5.x , Postgres 8.x, php_pgsql
 * @package VFront
 * @subpackage VFront_Web_Installer
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: index.php 413 2009-11-11 15:31:44Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 * 
 */

session_start();

if(isset($_GET['install_lang'])){
	
	$_SESSION['install_lang']=preg_replace("|[^a-z_]+|i",'',$_GET['install_lang']);
}



// Impostazione della lingua 
$locale = (isset($_SESSION['install_lang'])) ? $_SESSION['install_lang'] : 'en_US';

$locale_dir = '../locale'; 

$domain = 'messages';

$encoding='UTF-8';

// TEST GETTEXT
if(!function_exists('_')){
	
	require_once('../plugins/phpgettext/gettext.inc.php');
	
	// gettext setup
	T_setlocale(LC_MESSAGES, $locale);

	// Set the text domain as 'messages'
	bindtextdomain($domain, $locale_dir);
	
	// bind_textdomain_codeset is supported only in PHP 4.2.0+
	if (function_exists('bind_textdomain_codeset')) 
	  bind_textdomain_codeset($domain, $encoding);
	
	textdomain($domain);
}
else{
	
	putenv("LANGUAGE=$locale");
	putenv("LC_ALL=$locale");
	setlocale(LC_ALL, $locale, "$locale.utf8");
	bindtextdomain($domain,$locale_dir);
	textdomain($domain);
}





/**
 * @desc Esce dall'installazione
 *
 */
function esci(){
	
	session_destroy();
	header("Location: ".$_SERVER['PHP_SELF']);
	exit;
}



/**
 * @desc Esegue i GRANT necessari per il nuovo utente
 * @param bool $return_only_sql
 * @return int
 */
function grant($return_only_sql=false){
	
	global $db1, $link;
	
	require_once("../inc/vmsql.".$db1['dbtype'].".php");
	
	if($db1['dbtype']=='mysql'){
		
		$sql_user= "CREATE USER {$db1['user']}@{$db1['host']} IDENTIFIED BY '{$db1['passw']}'; ";
		
		$sql[]= "GRANT SELECT, INSERT, UPDATE, DELETE ON {$db1['frontend']}.* TO '{$db1['user']}'@{$db1['host']} IDENTIFIED BY '{$db1['passw']}';";
		$sql[]= "GRANT SELECT, INSERT, UPDATE, DELETE, SHOW VIEW ON {$db1['dbname']}.* TO '{$db1['user']}'@{$db1['host']} IDENTIFIED BY '{$db1['passw']}';";
	}
	else if ($db1['dbtype']=='postgres'){
		
		
		// crea l'utente
		$sql_user= "CREATE USER {$db1['user']} WITH PASSWORD '{$db1['passw']}'; ";
		
		// diritto d'uso dello schema frontend
		$sql[]="GRANT USAGE ON SCHEMA {$db1['frontend']} TO {$db1['user']};";
		
		
		// diritto d'uso dello schema information_schema
		$sql[]="GRANT USAGE ON SCHEMA information_schema TO {$db1['user']};";
		
		// diritto d'uso dello schema pg_catalog
		$sql[]="GRANT USAGE ON SCHEMA pg_catalog TO {$db1['user']};";
				
		
		// prendi le tabelle dei due schemi
		$q_tab=vmsql_query("SELECT table_schema || '.' || table_name FROM information_schema.tables WHERE table_schema IN ('{$db1['dbname']}','{$db1['frontend']}')",$link);
		
		while($RS_tab=pg_fetch_row($q_tab)){
			
			$sql[]="GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON ".$RS_tab[0]." TO {$db1['user']};";
		}
		
		// prendi le tabelle dell'information_schema
		$q_tab=vmsql_query("SELECT table_schema || '.' || table_name FROM information_schema.tables WHERE table_schema='information_schema'; ",$link);
		
		while($RS_tab=pg_fetch_row($q_tab)){
			
			$sql[]="GRANT SELECT ON ".$RS_tab[0]." TO {$db1['user']};";
		}
		
		
		// prendi le funzioni dei due schemi
		$q_func=vmsql_query("select 'GRANT EXECUTE ON FUNCTION '||n.nspname||'.'||p.proname||'('||oidvectortypes(p.proargtypes)||') TO {$db1['user']};' from pg_proc p, pg_namespace n where n.oid = p.pronamespace and n.nspname IN ('{$db1['dbname']}','{$db1['frontend']}');",$link);
		
		while($RS_func=vmsql_fetch_row($q_func)){
			
			$sql[]=$RS_func[0];
		}
		
		
		// prendi le sequenze dei due schemi
		$q_seq=vmsql_query("select 'GRANT ALL ON '||n.nspname||'.'||c.relname||' TO {$db1['user']};' from pg_class c, pg_namespace n where n.oid = c.relnamespace and c.relkind IN ('S') and n.nspname in ('{$db1['dbname']}','{$db1['frontend']}');",$link);
		
		while($RS_seq=vmsql_fetch_row($q_seq)){
			
			$sql[]=$RS_seq[0];
		}
	}
	

	if($return_only_sql){
		
		return $sql_user."\n".implode("\n",$sql);
	}
	
	
	$q_user=vmsql_try($sql_user,$link,false);
	
	for($i=0;$i<count($sql);$i++)
		$q=vmsql_query($sql[$i],$link) or die(vmsql_error($link));
	
	
	return vmsql_affected_rows($link,$q);
}



/**
 * @desc Genera il codice HTML da mostrare a fine installazione
 * @param bool $esito
 * @return string HTML
 */
function installazione_completata($esito){
	
	global $db1, $conf_auth;
	
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html>
	<head><title>"._('Installazione VFront')."</title>
	<style type=\"text/css\">
		@import \"install.css\";
	</style>
	<script type=\"text/javascript\" src=\"../js/scriptaculous/lib/prototype.js\" ></script>
	</head>
	<body>\n";
	
	if($esito){
	
		// prendi info:
		
			
		$INFO_TXT="";
		$INFO_POST='';

		$auth_type= ($conf_auth['tipo_external_auth']=='') ? 'vfront': $conf_auth['tipo_external_auth'].".".$conf_auth['db_ext']['dbtype'];
		
		/*$file_version
		$version=*/
		
		$INFO_TXT.="Date: ".date("Y-m-d H:i")."<br />\n";
		$INFO_TXT.="OS: ".PHP_OS."<br />\n";
		$INFO_TXT.="DB Type: ".$db1['dbtype']."<br />\n";
		$INFO_TXT.="Auth Type: ".$auth_type."<br />\n";
		$INFO_TXT.="Language: ".FRONT_LANG."<br />\n";
		$INFO_TXT.="Encoding: ".FRONT_ENCODING."<br />\n";
		$INFO_TXT.="PHP Version: ".phpversion()."<br />\n";
		
		$INFO_POST.="os=".PHP_OS."&amp;";
		$INFO_POST.="d=".date("YmdHis")."&amp;";
		$INFO_POST.="db=".$db1['dbtype']."&amp;";
		$INFO_POST.="auth=".$auth_type."&amp;";
		$INFO_POST.="l=".FRONT_LANG."&amp;";
		$INFO_POST.="enc=".FRONT_ENCODING."&amp;";
		$INFO_POST.="v=".phpversion();
		
		
		
		
		
		echo "<h1>"._("Installazione completata!")."</h1>
		
		<div id=\"ifeedback\">
			<h2>"._("Please send us a feedback!")."</h2>
			<div id=\"pleasesend\">
				<p>"._('Please help us to know the diffusion of VFront in the world :-)')."<br />
				"._('You can send some information clicking on link below.')."</p>
				
				<div id=\"sendinfo\" ><code><strong>Info to send:</strong><br />------------------<br />$INFO_TXT</code></div>
			
				<p><span class=\"fakelink\" onclick=\"window.open('http://www.vfront.org/getinfo.php?".addslashes($INFO_POST)."','infovfront','width=400,height=350,toolbar=no, location=no,status=no,menubar=no,scrollbars=yes,resizable=yes'); $('pleasesend').hide();$('thankyou').show();\">"._("Send info!")."</a></p>
			</div>
			
			<div id=\"thankyou\" style=\"display:none\">
			
				<p>"._('Thank you for the feedback!')."</p>
			</div>
			
		</div>
		
		
		<div id=\"ilogin\">
			<h2>"._("Go to login")."</h2>
			<p>"._("Vai alla pagina di login ed accedi con l'email e la password da te specificate.")."</p>
			<p><a href=\"../index.php\">"._('Vai al login')."</a></p>
		</div>\n";
	
	}
	else{
	
		echo "<h1>"._("Errore nella creazione dell'utente!")."</h1>
		<p>"._("Prova a creare manualmente l'utente nella tabella <em>utente</em> specificando livello = 3 e gruppo = 0")."</p>
		<p><a href=\"../index.php\">"._('Vai al login')."</a></p>\n";
	
	}
	
	echo "</body>\n</html>\n";
}



/**
 * @desc Genera il codice HTML da mostrare a inizio installazione
 * @return string HTML
 */
function select_lang(){
	
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html>
	<head><title>VFront Installer</title>
	<style type=\"text/css\">
		@import \"install.css\";
	</style>
	<script type=\"text/javascript\" src=\"../js/scriptaculous/lib/prototype.js\" ></script>
	<script type=\"text/javascript\" src=\"install.js\" ></script>
	</head>
	<body>\n";
	
	
	echo "<h1>VFront Installer - Select Language</h1>\n";
	
	
	$license=htmlspecialchars(join("",file("../license")));
	
	echo "
	<form action=\"".$_SERVER['PHP_SELF']."\" method=\"get\" id=\"form1\">
		
	
		<div class=\"installbox\" id=\"ilanguage\">
			<h2>Select install language</h2>
		
			<p>
				<label for=\"lang\">Language</label>
				<select name=\"install_lang\" id=\"lang\">
					<option value=\"en_US\" selected=\"selected\">English</option>
					<option value=\"it_IT\" >Italiano</option>
				</select>
			</p>
		
			<p>&nbsp;</p>
			
		</div> <!-- END ilanguage -->
	
		<div class=\"installbox\" id=\"ilicense\">
			<h2>License</h2>
		
			<p>
				<textarea cols=\"82\" rows=\"14\" id=\"license\">$license</textarea>
			</p>
		
			<p><input type=\"checkbox\" id=\"accept\" value=\"1\" /> Accept license</p>
			
		</div> <!-- END ilicense -->
		
		
		<p><input type=\"hidden\" name=\"install0\" value=\"1\" /> 
		<input type=\"button\" id=\"invia\" value=\"  Next  &gt;&gt;\" onclick=\"lic();\" /></p>
	
	</form>
	
	</body>
	</html>";
		
				
}

/**
 * @desc Genera il codice HTML da mostrare a inizio installazione
 * @return string HTML
 */
function introduzione(){
	
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html>
	<head><title>"._('Installazione VFront')."</title>
	<style type=\"text/css\">
		@import \"install.css\";
	</style>
	
	<script type=\"text/javascript\" src=\"../js/scriptaculous/lib/prototype.js\" ></script>
	</head>
	<body>\n";
	
	
	echo "<h1>"._("Installazione VFront - Requisiti di sistema")."</h1>\n";
	
	
	$cartella_writable=is_writable("../conf");
	
	$fatal=false;
	$notice=false;
	
	// prova a cambiare i diritti della directory conf:
	if(!$cartella_writable && !@chmod('../conf',0777)){
		
		echo "<p class=\"install-err\">".sprintf(_("Per favore rendi la cartella <em>conf</em> scrivibile e %s"),"<a href=\"".$_SERVER['PHP_SELF']."\">"._('prova di nuovo')."</a>")."</p>";
		
		$fatal=true;
	}
	else{
		echo "<p class=\"install-ok\">"._("La cartella <em>conf</em> &egrave; scrivibile")."</p>";
	}
	
	
	
	// controllo PHP
	$php_version = (ereg("^5*",phpversion())) ? 1:0;

	if($php_version){
			
		$classe_php='install-ok';
	}
	else{
		$fatal=true;
		$classe_php='install-err';
	}
	
	echo "<p class=\"$classe_php\">"._("PHP Version").": <strong>".phpversion()."</strong><br />\n";
	echo "<small>"._("VFront richiede una versione di PHP &gt;= 5.x")."</small></p>\n";
	
	
	
	// ESTENSIONI PHP
	$ext=get_loaded_extensions();
	
	// Check Apache Modules
	$php_modules = (array) @apache_get_modules();
	
	$l_mysqli=(in_array('mysqli',$ext)) ? 1:0;
	$l_mysql=(in_array('mysql',$ext)) ? 1:0;
	$l_pgsql=(in_array('pgsql',$ext)) ? 1:0;
	$l_modrewrite=(in_array('mod_rewrite',$php_modules)) ? 1:0;
	
	if($l_mysqli || $l_mysql){
		
		$classe_mysqli='install-ok';
		$txt_mysqli='';
		if($l_pgsql){
			$classe_pgsql='install-ok';
		}
		else{
			$classe_pgsql='install-alert';
			
			// Alt Check for MySQL
			if($l_mysql){
				$classe_mysqli='install-alert';
				$txt_mysqli=_('VFront utilizza la libreria MySQLi, ma opzionalmente pu&ograve; utilizzare la vecchia libreria mysql. Si suggerisce di caricare la nuova libreria MySQLi');
			}
			
		}
	}
	elseif($l_pgsql){
		$classe_mysqli='install-alert';
		$classe_pgsql='install-ok';
	}
	else{
		$classe_mysqli='install-err';
		$classe_pgsql='install-err';
		$fatal=true;
	}
	
	
	$class_alert['modrewrite']= ($l_modrewrite) ? 'install-ok' : 'install-alert';

	
	
	echo "<p class=\"$classe_mysqli\">"._("MySQLi extension (MySQL Improved):")."<br />\n";
	echo "<small>"._("VFront utilizza la libreria mysqli per collegarsi a MySQL, qualora si utilizzasse questo DB l'estensione <b>deve essere caricata</b>")." ".$txt_mysqli."</small></p>\n";
	
	echo "<p class=\"$classe_pgsql\">"._("Postgres extension:")."<br />\n";
	echo "<small>"._("Qualora si utilizzasse questo DB l'estensione <b>deve essere caricata</b>")."</small></p>\n";
	
			
	
	
	$class_alert['gd']= (in_array('gd',$ext)) ? 'install-ok':'install-alert';
	
	echo "<p class=\"".$class_alert['gd']."\">"._("GD Library:")."<br />\n";
	echo "<small>"._("Le GD library sono utilizzate da Vfront per la creazione dei grafici delle statistiche")."</small></p>\n";
	
	
	echo "<p class=\"".$class_alert['modrewrite']."\">"._("Modulo Apache mod_rewrite:")."<br />\n";
	echo "<small>"._("VFront utilizza il modulo mod_rewrite")."</small></p>\n";

	
	/*$l_xsl=(in_array('xsl',$ext)) ? 1:0;
	
	echo "<span class=\"grigio\">"._("Trasformazione XSL:")."</span> <strong>$l_xsl</strong>\n";
	echo "<div class=\"piccolo\">".sprintf(_("Qualora il modulo non sia caricato si suggerisce di andare nel menu delle %s ed annullare la traformazione XSLT lato server"),
									"<a href=\"variabili.php\">"._("variabili")."</a>")
									."</div><br />\n";
	*/
	
	
	$class_alert['pear']=(@include_once("PEAR.php")) ? "install-ok" : "install-alert";
	echo "<p class=\"".$class_alert['pear']."\">"._("Inclusione di PEAR:")."<br />\n";
	echo "<small>"._("PEAR viene utilizzato per la creazione dei grafici delle statistiche")."</small></p>\n";
	
	$class_alert['pear_img_graph_class']=(@include_once("Image/Graph.php")) ? "install-ok" : "install-alert";
	echo "<p class=\"".$class_alert['pear_img_graph_class']."\">"._("Inclusione del modulo PEAR Image/Graph:")."<br />\n";
	echo "<small>"._("Modulo PEAR utilizzato per la creazione dei grafici delle statistiche")."</small></p>\n";
	
	
	$class_alert['pear_img_canvas_class']=(@include_once("Image/Canvas.php")) ? "install-ok" : "install-alert";
	echo "<p class=\"".$class_alert['pear_img_canvas_class']."\">"._("Inclusione del modulo PEAR Image/Canvas:")."<br />\n";
	echo "<small>"._("Modulo PEAR utilizzato per la creazione dei grafici delle statistiche (dipendenza di Image/Graph.php)")."</small></p>\n";
	
	
	$class_alert['pear_img_color_class']=(@include_once("Image/Color.php")) ? "install-ok" : "install-alert";
	echo "<p class=\"".$class_alert['pear_img_color_class']."\">"._("Inclusione del modulo PEAR Image/Color:")."<br />\n";
	echo "<small>"._("Modulo PEAR utilizzato per la creazione dei grafici delle statistiche (dipendenza di Image/Graph.php)")."</small></p>\n";

	
	if(in_array('install-alert',$class_alert)) $notice=true;
	
	
// CARTELLE SCRIVIBILI O NO -------------------------------------
	
	
	
	###########################################
	#
	# OTHER HIDDEN TEST FOR THE CONFIGURATION
	#
	
	// test dir
	if(	is_writable('../files/tmp') &&
		is_writable('../files/html') &&
		is_writable('../files') &&
		is_writable('../files/docs') &&
		is_writable('../files/docsadmin') &&
		is_writable('../files/xsl_custom')
	){
		// ok		
	}
	else{
		$notice=true;		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	// STAMPA SE CI SONO PROBLEMI
	
	if(!$fatal){
		
		// crea un file conf/.testvfront
		if($fp=@fopen("../conf/.testvfront",'w')){
			fwrite($fp, intval($notice),1);
			fclose($fp);
		}
		
		echo "<p style=\"font-size:1.4em;\" > <a href=\"?install1\">"._("Prossimo passo")."</a> </p>\n";
		
	}
	
	
	
	
	echo "</body>\n</html>\n";
}
	
	
	
/**
 * @desc Imposta tutti i parametri del file di connessione che viene generato
 *
 */
function imposta_file_connessione(){
	

	
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html>
	<head><title>"._('Installazione VFront')."</title>
	<style type=\"text/css\">
		@import \"install.css\";
	</style>
	<script type=\"text/javascript\" src=\"../js/scriptaculous/lib/prototype.js\" ></script>
	<script type=\"text/javascript\" src=\"./install.js\" ></script>
	<script type=\"text/javascript\" >
	
	
		
	function ut(n){
		
		
		$('host').disabled= (n) ? true:false;
		$('user').disabled= (n) ? true:false;
		$('passw').disabled= (n) ? true:false;
		$('port').disabled= (n) ? true:false;
	
	}
	
	
	</script>
	</head>
	<body>\n";
	
	
	echo "<h1>"._("Installazione VFront")." - ".sprintf(_("Passo %d di %d"),1,3)."</h1>\n";
	
	
	?>
	
	
<form method="post" action="<?php echo $_SERVER['PHP_SELF'];?>" id="installform">
	

	<a name="DBconnection"></a>
	<div class="installbox" id="idb">
		
		<h2><?php echo _('DB connection');?></h2>
		
		<p>
			<label for="dbtype">DBType</label>
			<select id="dbtype" name="var[dbtype]" onchange="if(this.value=='mysql'){ $('conn_postgres').hide(); $('conn_mysql').show();}else{ $('conn_mysql').hide(); $('conn_postgres').show();}">
				<option value="mysql" selected="selected">MySQL</option>
				<option value="postgres">PostgreSQL</option>
			</select>
			<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
			<span class="desc" style="display:none"><?php echo _('Tipo di database che si vuole utilizzare con VFront');?></span>
		</p>
		
		<div id="conn_mysql">
		
		
			<p>
				<label for="dbhost1">DB host</label>
				<input type="text" name="var[dbhost1]" id="dbhost1" value="localhost" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none" ><?php echo _('Host del database (default: localhost)');?></span>
			</p>
			
			<p>
				<label for="dbport1">DB port</label>
				<input type="text" name="var[dbport1]" id="dbport1" value="3306" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Porta del database (default: 3306)');?></span>
			</p>
			
			<p>
				<label for="dbname1">DB-data name</label>
				<input type="text" name="var[dbname1]" id="dbname1" value="" onblur="set_frontend_name(this.value)" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Nome del database esistente sul quale si vuole usare VFront');?></span>
			</p>
			
			<p>
				<label for="dbfrontend1">DB-frontend name</label>
				<input type="text" name="var[dbfrontend1]" id="dbfrontend1" value="" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Nome del database da creare per le regole di VFront');?></span>
			</p>
			
			<p>
				<label for="dbuser1">DB user</label>
				<input type="text" name="var[dbuser1]" id="dbuser1" value="" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Nome utente per il collegamento al database');?></span>
			</p>
			
			<p>
				<label for="dbpassw1">DB password</label>
				<input type="password" name="var[dbpassw1]" id="dbpassw1" value="" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Password per il collegamento al database');?></span>
			</p>
			
			
		
		</div>
		
		<div id="conn_postgres" style="display:none">
			<p>
				<label for="dbhost2">DB host</label>
				<input type="text" name="var[dbhost2]" id="dbhost2" value="localhost" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Host del database (default: localhost)');?></span>
			</p>
			
			<p>
				<label for="dbport2">DB port</label>
				<input type="text" name="var[dbport2]" id="dbport2" value="5432" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Porta del database (default: 5432)');?></span>
			</p>
			
			<p>
				<label for="dbname2">DB name</label>
				<input type="text" name="var[dbname2]" id="dbname2" value="" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Nome del database esistente sul quale si vuole usare VFront');?></span>
			</p>
			
			<p>
				<label for="dbuser2">DB user</label>
				<input type="text" name="var[dbuser2]" id="dbuser2" value="" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Nome utente per il collegamento al database');?></span>
			</p>
			
			<p>
				<label for="dbpassw2">DB password</label>
				<input type="password" name="var[dbpassw2]" id="dbpassw2" value="" />
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Password per il collegamento al database');?></span>
			</p>
			
			
			
		</div>
		
		<p>
			<input	type="button" onclick="test_db_conn()" id="testdb" value="Test connection" /> <span id="testdb_feedback" >&nbsp;</span>
		</p>
		
	</div>  <!-- END idb -->
	<hr />
	
	
	
	
	<a name="Authentication"></a>
	<div class="installbox" id="iauth">
	
		<h2><?php echo _('Authentication');?></h2>
		
		<div id="authtype_box">
		
			<p>
				<label for="dbhost1"><?php echo _('Authentication method');?></label>
				<select id="authtype" name="var[authtype]" onchange="show_auth_div(this.value); show_ajax_help(this.value);">
					<option value="null" selected="selected">VFront Internal</option>
					<option value="db">Data DB (on same server)</option>
					<option value="db_ext">External DB</option>
					<option value="ldap">LDAP/Active Directory</option>
					<!--<option value="soap">Soap</option>
					<option value="OpenID">OpenID</option>-->
				</select>
				<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
				<span class="desc" style="display:none"><?php echo _('Per la gestione delle utenze e l\'autenticazione, VFront pu&ograve; utilizzare il suo database oppure fonti dati esterne, come un altro database o un server LDAP');?></span>
				<span id="auth_null">&nbsp;</span>
			</p>
	
		</div>
		
		
		
		<div id="auth_ext_common" class="auth-box" style="display:none;">
		
		
			<div id="auth_db" class="auth-box" style="display:none;">
				<p>
					<label for="authdb_dbname">Db name (on same server!)</label>
					<span id="authdb_dbname_cont"><input type="text" name="var[authdb_dbname]" id="authdb_dbname" value="" /></span>
					<span id="authdb_dbname_wait" style="display:none"><img src="../img/refresh1.gif" alt="wait" /></span>
				</p>
				
				<p>
					<label for="authdb_usertable">User table name</label>
					<span id="authdb_usertable_cont"><input type="text" name="var[authdb_usertable]" id="authdb_usertable" value="" /></span>
					<span id="authdb_usertable_wait" style="display:none"><img src="../img/refresh1.gif" alt="wait" /></span>
				</p>
				
				
			</div>
			
			<div id="auth_db_ext" class="auth-box" style="display:none;">
			
				<p>
					<label for="authdb_ext_type">External DB type</label>
					<select name="var[authdb_ext_type]" id="authdb_ext_type">
						<option value="mysql">MySQL</option>
						<option value="postgres">PostgreSQL</option>
						<option value="odbc">ODBC</option>
					</select>
				</p>
				
				<p>
					<label for="authdb_ext_host">External DB Host</label>
					<input type="text" name="var[authdb_ext_host]" id="authdb_ext_host" value="" />
				</p>
			
				<p>
					<label for="authdb_ext_port">External DB Port</label>
					<input type="text" name="var[authdb_ext_port]" id="authdb_ext_port" value="" />
				</p>
			
				<p>
					<label for="authdb_ext_user">External DB User</label>
					<input type="text" name="var[authdb_ext_user]" id="authdb_ext_user" value="" />
				</p>
			
				<p>
					<label for="authdb_ext_passwd">External DB Password</label>
					<input type="password" name="var[authdb_ext_passwd]" id="authdb_ext_passwd" value="" />
				</p>
				
				<p>
					<label for="authdb_ext_dbname">External DB Name</label>
					<input type="text" name="var[authdb_ext_dbname]" id="authdb_ext_dbname" value="" />
				</p>
			
				<p>
					<label for="authdb_ext_table">External DB Table</label>
					<input type="text" name="var[authdb_ext_table]" id="authdb_ext_table" value="" />
				</p>
			
				<p>
					<label for="authdb_ext_odbcdsn">ODBC DSN (only ODBC)</label>
					<input type="text" name="var[authdb_ext_odbcdsn]" id="authdb_ext_odbcdsn" value="" />
				</p>
			
			</div>
			
			
			<?php 
			
			#############################
			#
			#	AUTH LDAP
			
			?>
			
			<div id="auth_ldap" class="auth-box" style="display:none;">
				<p>
					<label for="ldap_host">LDAP server</label>
					<input type="text" name="var[ldap_host]" id="ldap_host" value="" />
					<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
					<span class="desc" style="display:none"><?php echo _('The domain name or IP address of your LDAP Server. For example: localhost');?></span>
				</p>
				
				<p>
					<label for="ldap_port">LDAP port</label>
					<input type="text" name="var[ldap_port]" id="ldap_port" value="389" />
					<img class="help-image" src="../img/info_small.gif" alt="help" onclick="$(this).next(0).toggle()" />
					<span class="desc" style="display:none"><?php echo _('Default').": 389";?></span>
				</p>
				
				<p>
					<label for="ldap_basedn">LDAP base dn</label>
					<input type="text" name="var[ldap_basedn]" id="ldap_basedn" value="" />
					
					
				</p>
				
				<p>
					<label for="ldap_anonymus_bind">LDAP Anonymus bind</label>
					<input type="checkbox" id="ldap_anonymus_bind" value="1" name="var[ldap_anonymus_bind]" onclick="anon_bind()" />
				</p>
				
				
				<p>
					<label for="ldap_bind_user">LDAP User for bind</label>
					<input type="text" id="ldap_bind_user" value="" name="var[ldap_bind_user]" />
				</p>
				
				<p>
					<label for="ldap_bind_passw">LDAP Password for bind</label>
					<input type="password" id="ldap_bind_passw" value="" name="var[ldap_bind_passw]" />
				</p>
				
				
				
			</div>
			
			<!--<div id="auth_soap" class="auth-box" style="display:none;">
				auth_soap
			</div>
			
			<div id="auth_OpenID" class="auth-box" style="display:none;">
				auth_OpenID
			</div>-->
		
			<p id="authext_nick_p">
				<label for="authext_nick"><?php echo _('User nickname field (or email)');?></label>
				<span id="authext_nick_cont"><input type="text" name="var[authext_nick]" id="authext_nick" value="" /></span>
				<span id="authext_nick_wait" style="display:none"><img src="../img/refresh1.gif" alt="wait" /></span>
			</p>
			
			<p id="authext_passwd_p">
				<label for="authext_passwd"><?php echo _('User password field');?></label>
				<span id="authext_passwd_cont"><input type="text" name="var[authext_passwd]" id="authext_passwd" value="" /></span>
				<span id="authext_passwd_wait" style="display:none"><img src="../img/refresh1.gif" alt="wait" /></span>
			</p>
			
			<p id="authext_passwd_encode_p">
				<label for="authext_passwd_encode"><?php echo _('Password Type');?></label>
				<select name="var[authext_passwd_encode]" id="authext_passwd_encode">
					<option value="" selected="selected">none</option>
					<option value="md5">md5</option>
					<option value="sha1">sha1</option>
				</select>
			</p>
			
			<p id="authext_mail_p">
				<label for="authext_mail"><?php echo _('User email Field (optional)');?></label>
				<span id="authext_mail_cont"><input type="text" name="var[authext_mail]" id="authext_mail" value="" /></span>
				<span id="authext_mail_wait" style="display:none"><img src="../img/refresh1.gif" alt="wait" /></span>
			</p>
				
			
			<p id="authext_name_p">
				<label for="authext_name"><?php echo _('User name Field (optional)');?></label>
				<span id="authext_name_cont"><input type="text" name="var[authext_name]" id="authext_name" value="" /></span>
				<span id="authext_name_wait" style="display:none"><img src="../img/refresh1.gif" alt="wait" /></span>
			</p>
			
			
			<p id="authext_surname_p">
				<label for="authext_surname"><?php echo _('User surname Field (optional)');?></label>
				<span id="authext_surname_cont"><input type="text" name="var[authext_surname]" id="authext_surname" value="" /></span>
				<span id="authext_surname_wait" style="display:none"><img src="../img/refresh1.gif" alt="wait" /></span>
			</p>
			
			<p>
				<input type="button" onclick="test_ext()" id="testext" value="<?php echo _('Test connection');?>" /> <span id="testext_feedback" >&nbsp;</span>
			</p>
			
		</div>
		
		
		
		
	
	</div> <!-- END iauth -->
	
	<hr />
	
	
	<div class="installbox" id="imail">
	
		<h2>Mail &amp; SMTP</h2>
		
		<p>
			<label for="mail_sysamin">Administrator email</label>
			<input type="text" name="var[mail_sysamin]" id="mail_sysamin" value="" />
		</p>
		
		<p>
			<label for="mail_dev">Developer email (optional)</label>
			<input type="text" name="var[mail_dev]" id="mail_dev" value="dev@vfront.org" />
		</p>
		
		<p>
			<label for="smtp_use">Use SMTP</label>
			<select name="var[smtp_use]" id="smtp_use" onchange="display_smtp()" >
				<option value="false">No</option>
				<option value="true">Yes</option>
			</select>
		</p>
		
		<div id="use_smtp" style="display:none" >
		
			<p>
				<label for="smtp_address">SMTP address</label>
				<input type="text" name="var[smtp_address]" id="smtp_address" value="" />
			</p>
			
			<p>
				<label for="smtp_user">SMTP user</label>
				<input type="text" name="var[smtp_user]" id="smtp_user" value="" />
			</p>
			
			<p>
				<label for="smtp_passwd">SMTP password</label>
				<input type="password" name="var[smtp_passwd]" id="smtp_passwd" value="" />
			</p>
			
			<p>
				<label for="smtp_sender">SMTP sender (email)</label>
				<input type="text" name="var[smtp_sender]" id="smtp_sender" value="" />
			</p>
			
			<p>
				<label for="smtp_sendername">SMTP sender displayed name</label>
				<input type="text" name="var[smtp_sendername]" id="smtp_sendername" value="" />
			</p>
			
			
		</div>
	
	</div>
	<!-- END idebug -->
	
	<hr />
	
	<div class="installbox" id="idebug">
		<h2>Debug</h2>
		
			<p>
				<label for="debug_sql">Debug SQL</label>
				<select name="var[debug_sql]" id="debug_sql">
					<option value="true" selected="selected">true</option>
					<option value="false">false</option>
				</select>
			</p>
		
			<p>
				<label for="rpc_debug">RPC Debug</label>
				<select name="var[rpc_debug]" id="rpc_debug">
					<option value="true" selected="selected">true</option>
					<option value="false">false</option>
				</select>
			</p>
		
	
	</div> <!-- END idebug -->
	
	
	
	<hr />
	
	<div class="installbox" id="ilang">
	
		<h2><?php echo _('Language and encoding');?></h2>
		
		<p>
			<label for="lang"><?php echo _('Language');?></label>
			<select name="var[lang]" id="lang">
			<?php
			
			if ($handle = opendir('../locale')) {
			   while (false !== ($dirr = readdir($handle))) { 
			   		if(preg_match("|[a-z]{2}_[a-z]{2}|i",$dirr)){
			   			
			   			$sel = ($dirr=='en_US') ? " selected=\"selected\"" : "";
			   			
			   		    echo "<option value=\"$dirr\"$sel>$dirr</option>\n";
			   		}
			   }
			
			   closedir($handle); 
			}
			
			?>
			</select>
		</p>
		
		<p>
			<label for="encoding"><?php echo _('Encoding');?></label>
			<select name="var[encoding]" id="encoding">
				<option value="UTF-8" selected="selected">UTF-8</option>
				<option value="iso-8859-1">iso-8859-1</option>
			</select>
		</p>
	
	</div> <!-- END ilang -->
	
	
	<hr />
	
	<div class="installbox" id="idatetime">
		<h2><?php echo _('Date and time');?></h2>
		
			<p>
				<label for="dateformat"><?php echo _('Date and time format');?></label>
				<select name="var[dateformat]" id="dateformat">
					<option value="iso" selected="selected">ISO (ISO 8601), ex: 2009-01-15</option>
					<option value="ita">Latin/Europe (Italy, German, France, etc.), ex: 15/01/2009</option>
					<option value="eng">USA, ex: 01/15/2009</option>
				</select>
			</p>
		
	</div> <!-- END idatetime -->
	
	<hr />
	
	<div class="installbox" id="ipath">
	
		<h2><?php echo _('Paths');?></h2>
		
		<?php
		
			// Linux or windows ?
			$front_root0=  (substr(realpath(__FILE__),0,1)=='/')  ? __FILE__ : str_replace("\\","/",__FILE__) ;
			$front_root= str_replace("/_install/index.php","",$front_root0);
			
			$doc_root="http://".$_SERVER['HTTP_HOST'].str_replace("/_install/index.php",'',$_SERVER['PHP_SELF']);
		
		?>
		
			<p>
				<label for="front_root">VFront root (realpath)</label>
				<input type="text" name="var[front_root]" id="front_root" value="<?php echo $front_root;?>" size="50" />
			</p>
		
			<p>
				<label for="document_root">VFront document root (http...)</label>
				<input type="text" name="var[document_root]" id="document_root" value="<?php echo $doc_root;?>" size="50" />
			</p>
		
	</div>	<!-- END ipath -->
	
	<hr />
	
	<?php
	
	
		// FOP settings:
		
		if(eregi('WIN',$_ENV['OS'])){
			$FOP_EXEC='fop.bat';
		}
		else{
			$FOP_EXEC='fop';
		}

	
	?>
	
	<div class="installbox" id="ifop">
		<h2>Apache FOP</h2>
		
			<p>
				<label for="fop_enabled">FOP Enabled</label>
				<select name="var[fop_enabled]" id="fop_enabled">
					<option value="false" selected="selected">false</option>
					<option value="true" >true</option>
				</select>
			</p>
		
			<p>
				<label for="path_fop">path fop</label>
				<input type="text" name="var[path_fop]" id="path_fop" value="<?php // echo $front_root."/plugins/fop/".$FOP_EXEC;?>" size="50" />
			</p>
	</div> <!-- END ifop -->
	
	<hr />
	
	<div class="installbox" id="imisc">
	<h2><?php echo _('Miscellaneous');?></h2>
	
		<p>
			<label for="max_tempo_edit">Max tempo edit (default: 240 seconds)</label>
			<input type="text" name="var[max_tempo_edit]" id="max_tempo_edit" value="240" size="50" />
		</p>
	
		<p>
			<label for="passfrase">Passphrase for base64</label>
			<input type="text" name="var[passfrase]" id="passfrase" value="passphrase" size="50" />
		</p>
	
		<p>
			<label for="name_proj">Name of project</label>
			<input type="text" name="var[name_proj]" id="name_proj" value="VFront" />
		</p>
		
	</div> <!-- END imisc -->
	
	<p>
		<input type="hidden" name="file_connessione" value="" id="file_connessione" />
		<input type="button" value="&lt;&lt; <?php echo _('Indietro');?> " onclick="window.location='<?php echo $_SERVER['PHP_SELF'];?>'" id="back_button" /> 
		<input type="button" value="  <?php echo _('Avanti');?>  &gt;&gt;" onclick="check_installer()" id="submit_button" /> <span id="check_feed" >&nbsp;</span>
	</p>
	
	
	
	
	
</form>
	
	<?php
	
	echo "</body>\n</html>";
	
	
	exit;
	
}

/**
 * Funzione che analizza la presenza di gruppi nel DB di VFront
 *
 * @return bool
 */
function test_presenza_gruppo_admin(){
	
	global $link,$db1;
	
	
	$GR=false;
	
	
	// cerca tabella gruppi e verifica che ce ne sia almeno 1 (lo 0)
	$sql_gruppi="SELECT * FROM {$db1['frontend']}.gruppo ORDER BY gid ASC LIMIT 1";
	
	$test_q_gruppi=vmsql_try($sql_gruppi,$link);
	
	if(!$test_q_gruppi){
		
		$GR=true;
	}
	else{
		$q_gruppi=vmsql_query($sql_gruppi,$link);
		
		$n_gruppi=vmsql_num_rows($q_gruppi);

		if($n_gruppi==0){
			$RSg=vmsql_fetch_assoc($q_gruppi);
			$GR=true;
		}
	
	}
	
	
	
	return $GR;
	
}




/**
 * Funzione di test per la generazione di una tabella.
 * Serve a testare il diritto CREATE, mediante la creazione di una tabella di nome pseudocasuale
 *
 * @return bool
 */
function test_crea_tabella(){
	
	global $link,$db1;
	
	// nome casuale
	$nome_tabella="a".md5(time());
		
	$sql_test="CREATE TABLE {$db1['dbname']}.$nome_tabella (test text);";
	
	$q_test=vmsql_query($sql_test,$link);
	
	if(!$q_test){
		
		return false;
	}
	else{
		$q_test2=vmsql_query("DROP TABLE {$db1['dbname']}.$nome_tabella ",$link);
		return true;
	}
	
}

/**
 * @desc Crea il DB e le tabelle
 *
 */
function crea_db_vfront(){
	
	global $link,$db1;
	if($db1['dbtype']=='mysql'){
		
		if(!is_file("./vfront.mysql.sql.php")){
			
			die(_("Impossibile leggere il file di origine dati SQL. Procedura interrotta."));
		}
		
		require_once("./vfront.mysql.sql.php");
	}
	else{
		
		if(!is_file("./vfront.postgres.sql.php")){
			
			die(_("Impossibile leggere il file di origine dati SQL. Procedura interrotta."));
		}
		
		require_once("./vfront.postgres.sql.php");
		
	}
	
	// crea il database
	if($db1['dbtype']=='mysql'){
		$sql_creadb=  "CREATE DATABASE IF NOT EXISTS ".$db1['frontend'];
		
		$q0=@vmsql_query($sql_creadb,$link) or die("Impossibile creare il database {$db1['frontend']}");
	
		$q_use0=vmsql_query("USE ".$db1['frontend'],$link) or die("Impossibile utilizzare il database {$db1['frontend']} con comando USE");
	
	}
	elseif($db1['dbtype']=='postgres'){
		
//		$sql_creadb=  "CREATE SCHEMA \"frontend\" AUTHORIZATION \"postgres\"";
		
//		$q0=@vmsql_query($sql_creadb,$link) or die("Impossibile creare lo schema {$db1['frontend']}");
		
	}
	



	
	
	
	$errore=0;
	
	for($i=0;$i<count($SQL_DEFINITION);$i++){
		$q_creatabelle= vmsql_query($SQL_DEFINITION[$i],$link) or ($errore=1);

		if($errore==1){
			$xerr=vmsql_error($link);
			vmsql_query("ROLLBACK",$link);
			die("$xerr<br /> Impossibile creare le tabelle nel database {$db1['frontend']}");
		}
		
	}
	
	if($db1['dbtype']=='mysql'){
		$q_use0=vmsql_query("USE ".$db1['dbname'],$link) or die("Impossibile utilizzare il database {$db1['dbname']} con comando USE");
	}
	
	if(isset($_POST['grant_user']) && $_POST['grant_user']==1){
		
		$esito_grant=grant();
	}
	
	
}





/**
 * @desc Funzione per la generazione della pagina di creazione primo utente
 *
 */
function crea_utente_admin(){
	
	global $link,$db1, $conf_auth;
	
	
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html>
	<head><title>"._("Installazione VFront")."</title>
	<style type=\"text/css\">
		@import \"install.css\";
	</style>
	<script type=\"text/javascript\" src=\"../js/yav/yav.js\" ></script>
	<script type=\"text/javascript\" src=\"../js/yav/yav-config-it.js\" ></script>
	<script type=\"text/javascript\" >
	
	var rules= new Array();
	
	rules[0]='email|required|"._("Inserire una email")."';
	rules[1]='passw1|minlength|6|"._("La password deve essere di almeno 6 caratteri")."';
	rules[2]='passw1|equal|\$passw2|"._("Le due password non sembrano coincidere")."';
	rules[3]='nome|required|"._("Inserire un nome")."';
	rules[4]='cognome|required|"._("Inserire un cognome")."';
	
	</script>
	</head>
	
	<body>\n";
	
	echo "<h1>"._("Installazione VFront")." - "._("Step 3 of 3")."</h1>\n";
	
	
	
	// analizza se il login richiesto anche esternamente
	
	if($conf_auth['tipo_external_auth']!=''){
		
		echo "<p>"._("Attenzione! E' stato impostato un sistema di autenticazione tramite archivio esterno")." ("
			 .$conf_auth['tipo_external_auth']."). "."<br />
			 ".sprintf(_("Al primo accesso sarai impostato come amministratore, quindi usa il tuo vero account per il primo login."),$conf_auth['tipo_external_auth'])."</p>";
		
		echo "<p><a href=\"index.php?install_ok\">"._("Next step")."</a></p>\n";
	}
	
	else{
	
	
	echo "<form action=\"?crea_admin\" method=\"post\" name=\"f1\" onsubmit=\"return performCheck('f1', rules,'classic');\">
		
    <div class=\"installbox\" id=\"iadmin\">
    
	<h2>"._("Creazione dell'utente amministratore")."</h2>
    
 	<p>"._("Inserisci adesso i dati per l'utente amministratore")."</p>
	
		<p>
			<label for=\"email\">"._("Email").":</label><br />
			<input type=\"text\" size=\"42\" value=\"\" name=\"email\" id=\"email\" />
		</p>
	
		<p>
			<label for=\"passw1\">"._("Password").":</label><br />
			<input type=\"password\" size=\"42\" value=\"\" name=\"passw1\" id=\"passw1\" />
		</p>
		
		<p>		
			<label for=\"passw2\">"._("Ripeti la password").":</label><br />
			<input type=\"password\" size=\"42\" value=\"\" name=\"passw2\" id=\"passw2\" />
		</p>
		
		<p>		
			<label for=\"nome\">"._("Nome").":</label><br />
			<input type=\"text\" size=\"42\" value=\"\" name=\"nome\" id=\"nome\" />
		</p>
		
		<p>		
			<label for=\"cognome\">"._("Cognome").":</label><br />
			<input type=\"text\" size=\"42\" value=\"\" name=\"cognome\" id=\"cognome\" />
		</p>		
	
	</div>
	
	
		<p>	
			<input type=\"submit\" value=\" "._("Registra dati")."\" name=\"invia\"  />
		</p>
	
	</form>\n";
	
	}
	
	echo "</body>\n</html>\n";
	
	exit;
	
}





/**
 * @desc Funzione di creazione primo utente
 *
 */
function registra_utente_admin(){
	
	global $link, $db1;
	
	require_once("../inc/func.comuni.php");
	require_once("../inc/vmsql.".$db1['dbtype'].".php");
	
	$_dati=pulisci_dom($_POST);
	
	$sql=sprintf("INSERT INTO {$db1['frontend']}.utente (nick, passwd, email, livello, gid, data_ins, nome, cognome) VALUES 
  				('%s', '%s','%s', %d, %d, '%s', '%s', '%s')",
				$_dati['email'],
				md5($_dati['passw1']),
				$_dati['email'],
				3,
				0,
				date("Y-m-d"),
				$_dati['nome'],
				$_dati['cognome']
				);
			
	$q=vmsql_query($sql,$link);
	
	if(vmsql_affected_rows($link,$q)==1){
		header("Location: ".$_SERVER['PHP_SELF']."?install_ok");
		exit;
	}
	else{
		header("Location: ".$_SERVER['PHP_SELF']."?install_ko");
		exit;
	}
	
}





if(isset($_POST['file_connessione'])){
	
	$test_include=true;
	require_once("./create_conf.php");
	header("Location: ".$_SERVER['PHP_SELF']);
	exit;
	
}


// SE ESISTE IL FILE DI CONNESSIONE IN SESSIONE
if(isset($_SESSION['file_connessione']) && is_file($_SESSION['file_connessione'])){
	
	require_once($_SESSION['file_connessione']);
	
	require_once("../inc/vmsql.{$db1['dbtype']}.php");
	
	$link=vmsql_connect($db1);
	
	/*if($db1['dbtype']=='mysql'){
		if(function_exists('mysqli_query')){
			$link = @mysqli_connect($db1['host'],$db1['user'],$db1['passw'],$db1['dbname'],$db1['port']);	
		}
		else{
			$link = @mysql_connect($db1['host'].":".$db1['port'],$db1['user'],$db1['passw']);
			$connection_DB_test=mysql_select_db($db1['dbname']);
		}
		
	}
	else
		$link = @pg_connect("host={$db1['host']} port={$db1['port']} dbname={$db1['postgres_dbname']} user={$db1['user']} password={$db1['passw']}");
	*/
	
	$utente_collegabile= ($link) ? true:false;
	
	
}
else if(isset($_GET['install1'])){
	
	imposta_file_connessione();
	exit;
}
else if(isset($_GET['install0'])){
	
	introduzione();
	exit;
}
else{
	
	select_lang();
	exit;
}



##################################################
#
#	REGISTRAZIONE del DB
#




if(isset($_GET['install_db'])){
	
	require_once("../inc/vmsql.".$db1['dbtype'].".php");
	
	if($_POST['user']==='USER_DEFAULT_CONF'){
		
		$link =vmsql_connect($db1);
		
		/*// Installa con utente di default
		if($db1['dbtype']=='mysql'){
			if(function_exists('mysqli_connect')){
				$link = @mysqli_connect($db1['host'],$db1['user'],$db1['passw'],$db1['dbname'],$db1['port']);
			}
			else{
				$link = @mysql_connect($db1['host'].":".$db1['port'], $db1['user'], $db1['passw']);
				mysql_select_db($db1['dbname']);
			}
		}
		else if($db1['dbtype']=='postgres')
			$link = @pg_connect("host={$db1['host']} port={$db1['port']} dbname={$db1['postgres_dbname']} user={$db1['user']} password={$db1['passw']}");
	*/
		
		
		
		if(!$link){
			header("Location: ".$_SERVER['PHP_SELF']."?err=1");
			exit;
		}
	}
	else{
		
		$db2=array("host"=>$_POST['host'],
					"user"=>$_POST['user'],
					"passw"=>$_POST['passw'],
					"dbname"=>$db1['dbname'],
					"port"=>$_POST['port'],
					"postgres_dbname"=>$db1['postgres_dbname']
					);
		
		$link=vmsql_connect($db2);
		
	}

	
	// testa la creazione di tabelle
	
	if(!test_crea_tabella()){
		
		header("Location: ".$_SERVER['PHP_SELF']."?err=2");
		exit;
		
	}
	else{
		
		
		crea_db_vfront();
	}
	
	header("Location: index.php?crea_utente_admin");
	exit;
	
}






#############################################
#
#	PROCEDURA STANDARD
#
#############################################

if(isset($_GET['crea_admin']) && count($_POST)>0){
	
	registra_utente_admin();
	exit;
}

else if(isset($_GET['install_ok'])){
	
	require_once("../conf/conf.vfront.php");
	installazione_completata(true);
	exit;
	
	
}

else if(isset($_GET['esci'])){
	
	esci();
	exit;
	
	
}

else if(isset($_GET['install_ko'])){
	
	installazione_completata(false);
	exit;
	
	
}

else if(test_presenza_gruppo_admin()){
	
	include_once("./vfront.{$db1['dbtype']}.sql.php");
	include_once("../plugins/highlight/highlight_sql.php");
	
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html>
	<head><title>"._('Installazione VFront')."</title>
	<style type=\"text/css\">
		@import \"install.css\";
	</style>
	
	<script type=\"text/javascript\" src=\"../js/scriptaculous/lib/prototype.js\"></script>
	<script type=\"text/javascript\">
	
	function ut(n){
		
		
		$('host').disabled= (n) ? true:false;
		$('user').disabled= (n) ? true:false;
		$('passw').disabled= (n) ? true:false;
		$('port').disabled= (n) ? true:false;
	
	}
	
	
	</script>
	
	</head>
	<body>\n";
	
	echo "<h1>"._("Installazione VFront")." - "._("Step 2 of 3")."</h1>\n";
	
	
	// errori di connessione:

	if(isset($_GET['err'])){
		
		switch ($_GET['err']){
			
			case 1: echo "<span style=\"color:red\"><b>"._("Attenzione! Procedura interrotta")."</b>. "._("Inserire una connessione per l'installazione")."</span>\n";
			break;
			
			case 2: echo "<span style=\"color:red\">"._("Impossibile creare tabelle con i diritti dell'utente indicato")."</span>\n";
			break;
			
			
			
		}
	
	}
	
	
	
	
	
	
	

	
	echo "<div id=\"createdb\" >\n";
	
	echo "<h2>"._("Installazione del DB Vfront")."</h2>
	
	
	<p>
	"._("Le tabelle saranno inserite nel database segnalato nel file CONF")." <strong>".$db1['frontend']."</strong><br />
	"._("Qualora non esistesse si cercher&agrave; di crearlo se si possiedono i diritti.")."
	</p>
	
	<form action=\"".$_SERVER['PHP_SELF']."?install_db\" method=\"post\" >
	
	
	";
	
	$PORTA = ($db1['dbtype']=='mysql') ? "3306" : "5432";
	
	$UT_DEFAULT =($db1['dbtype']=='mysql') ? "root" : "postgres";
	
	
	// Mostra il box per la connessione del superutente se non e' root|postgres
	if($UT_DEFAULT!=$db1['user']){
	
		if($utente_collegabile){
			
				echo "
				<input type=\"hidden\" name=\"tipo_link\" id=\"tl1\" value=\"1\"  /> 
			
			<p><strong>"._("Inserire i dati di un utente con diritti di scrittura sul database (ad es. root):")."</strong><br /><br />
				"._("host").": <input type=\"text\" name=\"host\" id=\"host\" value=\"localhost\" /><br />
				"._("user").": <input type=\"text\" name=\"user\" id=\"user\" value=\"$UT_DEFAULT\" /><br />
				"._("password").": <input type=\"password\" name=\"passw\" id=\"passw\" value=\"\" /><br />
				"._("porta").": <input type=\"text\" name=\"port\" id=\"port\" value=\"$PORTA\" /><br />
			</p>
			
			";
		}
		else{
			
			
			echo "
				<input type=\"hidden\" name=\"tipo_link\" id=\"tl1\" value=\"1\" />
			
			<p>
				"._("host").": <input type=\"text\" name=\"host\" id=\"host\" value=\"localhost\"  /><br />
				"._("user").": <input type=\"text\" name=\"user\" id=\"user\" value=\"root\" /><br />
				"._("password").": <input type=\"password\" name=\"passw\" id=\"passw\" value=\"\"  /><br />
				"._("porta").": <input type=\"text\" name=\"port\" id=\"port\" value=\"$PORTA\" /><br />
			</p>
			
			";
		}
		
		
		echo "
		<p>
			<input type=\"radio\" name=\"grant_user\" id=\"g0\" value=\"1\"  checked=\"checked\" /> "._("Attribuisci ad operazione avvenuta i diritti d'uso per VFRONT all'utente")." <b>".$db1['user']."</b> "._("su questo DB (si devono avere diritti GRANT)")." <br />
			<input type=\"radio\" name=\"grant_user\" id=\"g1\" value=\"0\"  /> "._("Imposta i diritti successivamente in maniera manuale")."<br />
		</p>
		";
	}
	else{
		
		// manda un segnale per usare i dati della connessione
		echo "<input type=\"hidden\" name=\"user\" id=\"user\" value=\"USER_DEFAULT_CONF\" />\n";
	}
		
	
	
	
	
	
	if($UT_DEFAULT!=$db1['user']){
	
		echo "
		<p>"._("Qualora non si disponesse di diritti sufficienti a fa una installazione automatica, <br />si volesse installare manualmente<br />oppure semplicemente si volesse andare a vedere che cosa l'installazione sta per fare sul vostro server,")."<br />
		 "._("si pu&ograve; aprire")." <span class=\"fakelink\" onclick=\"$('boxsql').toggle();\">"._("questo box")."</span></p>\n";
	
	}
	else{
		
		echo "
	<p>"._("Qualora si volesse installare manualmente<br />oppure semplicemente si volesse andare a vedere che cosa l'installazione sta per fare sul vostro server,")."<br />
	 "._("si pu&ograve; aprire")." <span class=\"fakelink\" onclick=\"$('boxsql').toggle();\">"._("questo box")."</span></p>\n";
	
		
	}
	
	
	
	echo "
	
	<p>
		<input type=\"submit\" name=\"Invia\" value=\" "._("Procedi")." \" />
		<input type=\"button\" name=\"esci\" value=\" "._("Esci dall'installazione")." \" onclick=\"location.href='?esci'\"/>
	</p>

	</form>\n";
	
	
	echo "<div id=\"boxsql\" style=\"display:none\">\n";
	echo "<code class=\"sql\">\n";
	echo syntax_highlight(nl2br("CREATE DATABASE ".$db1['frontend'].";\n\n".implode("",$SQL_DEFINITION)),"SQL");
	echo "</code>\n";
	echo "</div>\n";
	
	
	
	
	
	echo "
	</div>
	
	</body>
	</html>";
	
	
}

else if(isset($_GET['crea_utente_admin'])){
	
	// schermata di creazione amministratore
	crea_utente_admin();
	
}


else{
	
	echo "<p><b>"._("Attenzione!")."</b> "._("Questa istanza di Vfront sembra gi&agrave; stata installata.")."</p>
	<p>"._("Procedura interrotta")."</p>";
	
}


?>