<?php
/**
 * Questo file crea un'interfaccia per utilizzare i controlli avanti javascript per la validazione dei campi. 
 * A seconda del campo presentato vengono mostrate diverse opzioni di vincoli sull'input dell'utente. 
 * Il sistema mostrer� poi i controlli con il pacchetto Javascript YAV {@link http://yav.sourceforge.net/it/index.html} 
 * 
 * @desc File per il popup dei controlli javascript per la validazione dei campi
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: adv_js_control.php 262 2009-04-24 18:58:09Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */

include("../inc/conn.php");
include("../inc/layouts.php");
include("../inc/func.frontend.php");

proteggi(3);


/**
 * @desc Funzione parser per il controllo sui campi in javascript
 * @param string $str Il controllo secondo la sintassi YAV
 * @return array Array con i frammenti di controllo (viene usato il carattere | per separare)
 */
function parser_controllo_js($str){
	
	if(trim($str)!=''){
		$arr_controlli=explode("\n",trim($str));
		
		for($i=0;$i<count($arr_controlli);$i++){
			
			$mat_controlli[$i] = explode("|",trim($arr_controlli[$i]));
		}
		return $mat_controlli;
	}
	else return array();
	
}

// cancellazione del controllo
if(isset($_GET['del_jstest'])){
	
	$ID_REG= (int) $_GET['del_jstest'];
	
	$q_del = vmsql_query("UPDATE {$db1['frontend']}.registro_col SET jstest='' WHERE id_reg=$ID_REG LIMIT 1",$link);
	
	if(vmsql_affected_rows($link,$q_del)==1){
		
		header("Location: ".$_SERVER['PHP_SELF']."?id_reg=".$ID_REG."&feed_del=ok");
	}
	else{
		
		header("Location: ".$_SERVER['PHP_SELF']."?id_reg=".$ID_REG."&feed_del=ko");

	}
	
	exit;
}


if(isset($_POST['control_1'])){
	
	
	switch($_POST['tipo_sub']){
		
		case "integer" : $r="dati[".$_POST['column_name']."]|integer|".$_POST['column_name']." "._('deve essere un numero intero');
		break;
		
		case "notequal" : $r="dati[".$_POST['column_name']."]|notequal|".$_POST['control_1']."|".$_POST['column_name']." "._('deve essere diverso da')." \"{$_POST['control_1']}\"";
		break;
		
		case "numrange" : $r="dati[".$_POST['column_name']."]|numrange|".$_POST['control_1']."-".$_POST['control_2']."|".$_POST['column_name']." ".sprintf(_('deve essere compreso tra %s e %s'),$_POST['control_1'],$_POST['control_1']);
		break;
		
		case "numchar" : $r="dati[".$_POST['column_name']."]|numchar|".intval($_POST['control_1'])."|".$_POST['column_name']." ".sprintf(_('deve essere esattamente di %s cifre/caratteri'),$_POST['control_1']);
		break;
		
		// ----------------------------------
		
		case 'alphabetic' : $r="dati[".$_POST['column_name']."]|alphabetic|{$_POST['column_name']} "._('accetta solo lettere (maiuscole e minuscole)');
		break;
		
		case 'alphanum' : $r="dati[".$_POST['column_name']."]|alphanum|{$_POST['column_name']} "._('accetta solo lettere (maiuscole e minuscole) e numeri');
		break;
		
		case 'alnumhyphen' : $r="dati[".$_POST['column_name']."]|alnumhyphen|{$_POST['column_name']} "._('accetta solo lettere (maiuscole e minuscole), numeri e i caratteri _ e - (trattini)');
		break;
		
		case 'alphaspace' : $r="dati[".$_POST['column_name']."]|alphaspace|{$_POST['column_name']} "._('accetta solo lettere (maiuscole e minuscole), numeri, i caratteri _ e - (trattini) e spazi');
		break;
		
		case 'email' : $r="dati[".$_POST['column_name']."]|email|{$_POST['column_name']} "._('deve essere una email formalmente valida');
		break;
		
		case 'maxlength' : $r="dati[".$_POST['column_name']."]|maxlength|{$_POST['control_1']}|".sprintf(_('Il valore di %s deve essere lungo massimo %s caratteri'),$_POST['column_name'],$_POST['control_1']);
		break;
		
		case 'minlength' : $r="dati[".$_POST['column_name']."]|minlength|{$_POST['control_1']}|".sprintf(_('Il valore di %s deve essere lungo almeno %s caratteri'),$_POST['column_name'],$_POST['control_1']);
		break;
		
		
		case 'iva_ita' : $r="dati[".$_POST['column_name']."]|iva_ita|{$_POST['column_name']} "._('deve essere una partita iva');
		break;
		
		case 'cf_ita' : $r="dati[".$_POST['column_name']."]|cf_ita|{$_POST['column_name']} "._('deve essere un codice fiscale');
		break;
		
		
		case 'regexp' : $r="dati[".$_POST['column_name']."]|regexp|{$_POST['control_1']}|".sprintf(_('Il valore di %s deve corrispondere al pattern di caratteri %s'),$_POST['column_name'],$_POST['control_1']);
		break;
		
		
		
		
		//-----------------------------------
		
		case 'date' : $r="dati[".$_POST['column_name']."]|date|".sprintf(_('Il valore di %s deve essere una data valida'),$_POST['column_name']);
		break;
		
		case 'date_lt' : $r="dati[".$_POST['column_name']."]|date|{$_POST['control_1']}|{$_POST['column_name']} ".sprintf(_('deve essere una data precedente a %s'),$_POST['control_1']);
		break;
		
		case 'date_lt' : $r="dati[".$_POST['column_name']."]|date|{$_POST['control_1']}|{$_POST['column_name']} ".sprintf(_('deve essere una data precedente o uguale a %s'),$_POST['control_1']);
		break;
		
		//-----------------------------------
		
		case 'orario_sec' : $r="dati[".$_POST['column_name']."]|regexp|[0-9]{2}:[0-9]{2}:[0-9]{2}|{$_POST['column_name']} "._('deve essere un orario nella forma HH:mm:ss (ore, minuti, secondi)');
		break;
		
		case 'orario' : $r="dati[".$_POST['column_name']."]|regexp|[0-9]{2}:[0-9]{2}|{$_POST['column_name']} "._('deve essere un orario nella forma HH:mm (ore, minuti)');
		break;
		
		//-----------------------------------
		
		case 'double' : $r="dati[".$_POST['column_name']."]|double|{$_POST['column_name']} "._('deve essere un numero con virgola');
		break;
		
		
		default : $r='';
		
		
	}
	
	
	if($r!=''){
		
		$sql_up = "UPDATE {$db1['frontend']}.registro_col SET jstest='".str_replace("'","\'",stripslashes($r))."'
					WHERE id_reg=".intval($_POST['id_reg'])." LIMIT 1";
		
		// Esegue l'update
		$q_up=vmsql_query($sql_up,$link);
		
		if(vmsql_affected_rows($link,$q_up)==1){	
		
			header("Location: ".$_SERVER['PHP_SELF']."?id_reg=".intval($_POST['id_reg'])."&feed=ok");
		}
		else{
			
			header("Location: ".$_SERVER['PHP_SELF']."?id_reg=".intval($_POST['id_reg'])."&feed=ko");

		}
	}
	
	
	exit;
}


$ID_REG=(int) $_GET['id_reg'];

// PRENDI INFORMAZIONI SUL CAMPO
$q_c=vmsql_query("SELECT * FROM {$db1['frontend']}.registro_col WHERE id_reg=".intval($ID_REG),$link);

$RS=vmsql_fetch_assoc($q_c);

$mat_controlli = parser_controllo_js($RS['jstest']);

$a_tipo=array();

echo openLayout1(_("Opzioni controlli campi JS"),array('sty/lista.css','sty/admin.css','js/scriptaculous/lib/prototype.js'),'popup');

//echo "<h1 style=\"margin-top:50px;\">Opzioni controlli campi JS</h1>";

echo "<h2 style=\"margin-top:50px;\">".sprintf(_('Opzioni controlli per il campo %s di tipo'),"<span class=\"var\">".$RS['column_name']."</span>")." <em style=\"color:#666;\">".$RS['data_type']."</em></h2>\n";


switch($RS['data_type']){
	
	case 'int':
	case 'integer':
	case 'biginteger':
	case 'bigint':
	case 'smallint':
		$a_tipo['integer']=_("numerico intero");
		$a_tipo['notequal']=_("diverso da");
		$a_tipo['numrange']=_("intervallo numerico");
		$a_tipo['numchar']=_("numero intero con n. cifre:");
	break;
		
	case 'varchar':
	case 'char':
	case 'character':
	case 'text' :
	case 'mediumtext':
	case 'longtext':
	case 'character varying':
	
		$a_tipo['alphabetic']=_("alfabetico");
		$a_tipo['alphanum']=_("alfanumerico");
		$a_tipo['alnumhyphen']=_("alfanumerico con trattini");
		$a_tipo['alphaspace']=_("alfanumerico con trattini e spazi");
		$a_tipo['email']=_("email");
		$a_tipo['notequal']=_("diverso da");
		$a_tipo['maxlength']=_("lunghezza massima");
		$a_tipo['minlength']=_("lunghezza minima");
		$a_tipo['regexp']=_("espressione regolare");		
		$a_tipo['numchar']=_("testo con esattamente n. caratteri:");
		$a_tipo['iva_ita']=_("partita iva");
		$a_tipo['cf_ita']=_("codice fiscale");
		
	break;
	
	case 'date':
	case 'timestamp without time zone':
	case 'timestamp with time zone':
	case 'timestamp':
	
		$a_tipo['date']=_("data formattata");
		$a_tipo['date_le']=_("data precendente o uguale a");
		$a_tipo['date_lt']=_("data successiva o uguale a");
	break;
	
	case 'time':

	
		$a_tipo['orario_sec']=_("orario formattato (con la forma HH:mm:ss)");
		$a_tipo['orario']=_("orario formattato (con la forma HH:mm)");
	break;
	
	case 'double':
	case 'float':
	
		$a_tipo['double']=_("numerico con virgola");
		$a_tipo['integer']=_("numerico intero");
		$a_tipo['numrange']=_("intervallo numerico");
		$a_tipo['numchar']=_("numero con virgola con esattamente n. cifre:");
		
	break;	

	
		
	
}


/*$a_tipo['integer']="numerico intero";
$a_tipo['double']="numerico con virgola";
$a_tipo['alpahnum']="alfanumerico";
$a_tipo['alpahnum']="alfanumerico con trattini";
$a_tipo['alpahnum']="alfanumerico con spazi";
$a_tipo['email']="email";
$a_tipo['maxlength']="lunghezza massima";
$a_tipo['minlength']="lunghezza minima";
$a_tipo['notequal']="diverso da";
$a_tipo['numrange']="intervallo numerico";
$a_tipo['date']="data formattata";
$a_tipo['date_lt']="data precendente o uguale a";
$a_tipo['date_le']="data successiva o uguale a";
$a_tipo['orario_sec']="orario formattato (con la forma HH:mm:ss)";
$a_tipo['orario']="orario formattato (con la forma HH:mm)";
$a_tipo['regexp']="espressione regolare";*/

if(isset($_GET['feed_del'])){
	
	if($_GET['feed_del']=='ok'){
		
		echo "
		<script type=\"text/javascript\" >
		
		window.opener.document.getElementById('controlli_".$ID_REG."').innerHTML='"._('Controlli avanzati')."';
		
		</script>\n";
		
		echo "<p class=\"feedok\">"._('Controllo eliminato correttamente')."<br /><br /><span class=\"fakelink\" onclick=\"window.close();\">"._('Chiudi')."</span></p>\n";
	}
	else{
		echo "<p class=\"feedko\">"._('Nessun controllo eliminato')."</p>\n";
		
	}
	
	
}


if(isset($_GET['feed'])){
	
	if($_GET['feed']=='ok'){
		
		echo "
		<script type=\"text/javascript\" >
		
		window.opener.document.getElementById('controlli_".$ID_REG."').innerHTML='"._('Controlli avanzati')." <strong>(".$mat_controlli[0][1].")</strong>';
		
		</script>\n";
		
		echo "<p class=\"feedok\">"._('Controllo inserito correttamente')." <br /><br /><span class=\"fakelink\" onclick=\"window.close();\">"._('Chiudi')."</span></p>\n";
	}
	else{
		echo "<p class=\"feedko\">"._('Nessun controllo eliminato')."</p>\n";
		
	}
	
	
}


echo "<form name=\"controlli\" action=\"".$_SERVER['PHP_SELF']."\" method=\"get\">\n";


if(count($a_tipo)>0){
	
	if(count($mat_controlli)==0){
		
		echo "<p>"._('Nessun controllo impostato per questo campo')."</p>\n";
	}
	else{
		
		echo "<p>"._('Attualmente esiste un controllo di tipo')." <strong>".$mat_controlli[0][1]."</strong>: <a href=\"?del_jstest=$ID_REG\">Elimina il controllo</a></p>\n";
	}
	
	
	echo "<label for=\"tipo\">"._('Controlli per questo tipo di campo:')."</label><br />\n";
	
	
	
	
	echo "<select name=\"tipo\" id=\"tipo\" onchange=\"submit();\">\n";
	
	
		echo "<option value=\"null\" >"._('Selezionare il controllo desiderato')." ---&gt;</option>\n";
	
	foreach($a_tipo as $k=>$v){
		
		if(isset($_GET['tipo'])){
			$sel0 = ($_GET['tipo']==$k) ? "selected=\"selected\"" : "";
		}
		
		else if($mat_controlli>0){
			
			$sel0=(isset($mat_controlli[0]) && $mat_controlli[0][1]==$k) ? "selected=\"selected\"" : "";
		}
		
		
		echo "<option $sel0 value=\"$k\">$v</option>\n";
	}
	
	echo "</select>\n";
}
else{
	
	echo "<p><strong>"._('Attenzione!')."</strong> "._('Non ci sono controlli possibili per questo tipo di campo')."</p>\n";
}

switch($_GET['tipo']){
	
	case 'maxlength':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Inserire la lunghezza massima consentita:')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n";
	break;	
	
	
	
	case 'minlength':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Inserire la lunghezza minima consentita:')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n";
	break;
	
	
	case 'notequal':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Inserire il valore da non consentire:')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n";
	break;
	
	case 'numrange':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Inserire il valore minimo:')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n
					<br /><br />
					<label for=\"val2\">"._('Inserire il valore massimo:')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val2\" />\n";
	break;	
	
	
	case 'date_lt':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Data minore di :')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n
					\n";
	break;
	
	case 'date_le':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Data  minore o uguale a :')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n
					\n";
	break;
	
	
	case 'regexp':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Espressione regolare:')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n
					\n";
	break;
	
	
	case 'numchar':
		
			$aggiungi="\t\t\t<label for=\"val1\">"._('Numero di cifre/caratteri richiesti:')." </label>
					<input type=\"text\" name=\"val1\" value=\"\" id=\"val1\" />\n
					\n";
	break;
	
	default : $aggiungi='';
	
}

echo "<br /><br />". $aggiungi;
echo "<input type=\"hidden\" name=\"id_reg\" value=\"".$ID_REG."\" />\n";

echo "</form>\n";


if(isset($_GET['tipo']) && $_GET['tipo']!='null'){
	
	$onclick="if($('val1')){ $('control_1').value=\$F('val1');};";
	$onclick.="if($('val2')){ $('control_2').value=\$F('val2');};";
	$onclick.="if($('tipo')){ $('tipo_sub').value=\$F('tipo');};";
	$onclick.="submit();";
	
	echo "<br /><br /><form name=\"invia\" method=\"post\" action=\"".$_SERVER['PHP_SELF']."\" >
	<input type=\"hidden\" name=\"tipo_sub\" id=\"tipo_sub\" value=\"\" />
	<input type=\"hidden\" name=\"control_1\" id=\"control_1\" value=\"\" />
	<input type=\"hidden\" name=\"control_2\" id=\"control_2\" value=\"\" />
	<input type=\"hidden\" name=\"id_reg\" id=\"id_reg\" value=\"".$ID_REG."\" />
	<input type=\"hidden\" name=\"column_name\" id=\"column_name\" value=\"".$RS['column_name']."\" />
	<input type=\"button\" name=\"invia\" id=\"invia\" value=\"Salva il controllo\" onclick=\"$onclick\" />
	
	</form>\n";
	
	
	
	
}

echo closeLayout1();


?>