<?php
/**
 * @desc Utility per l'eliminazione di un gruppo
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: elimina_gr.php 262 2009-04-24 18:58:09Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */

require_once("../inc/conn.php");
require_once("../inc/layouts.php");
require_once("../inc/func.comuni.php");

proteggi(3);

	// CONFERMA LA CANCELLAZIONE
	if(isset($_GET['conferma_del']) && isset($_POST['gid']) && intval($_POST['gid']>0)){
	
		
		$gid = (int) $_POST['gid'];
		
		vmsql_begin($link);
		
		// Imposta tutti gli utenti di gruppo $gid apparteneti a 0
		$q_up = vmsql_query("UPDATE {$db1['frontend']}.utente SET gid=0 WHERE gid=$gid",$link);
		
		$q_del = vmsql_query("DELETE FROM {$db1['frontend']}.gruppo WHERE gid=$gid",$link);
		
		vmsql_commit($link);
		
		header("Location: menu_registri.php?msg=gruppo_eliminato");
		exit;
		
		
	}


	$files = array("sty/admin.css","sty/tabelle.css");

	echo openLayout1(_("Gestione Gruppi"),$files);
	
	echo "<div id=\"briciole\"><a href=\"index.php\">"._('home amministrazione')."</a> &raquo; <a href=\"menu_registri.php\">"._('menu gruppi e registri')."</a> &raquo; "._('elimina gruppo/registro')."</div>";
	
	echo "<h1>"._('Elimina gruppo/registro')."</h1>\n";
	
	################################
	#
	#	PRENDI DATI UTENTI E GRUPPO
	#
	
	if(is_numeric($_GET['gid'])){
		$GID = (int) $_GET['gid'];
	}
	else{
		
		openErrorGenerico(_("Il gruppo da eliminare non esiste"), true);
	}
	
	// n utenti
	$sql_u = "SELECT count(*) FROM {$db1['frontend']}.utente WHERE gid=$GID";
	$q_u = vmsql_query($sql_u,$link);
	list($n_utenti)=vmsql_fetch_row($q_u);
	
	
	
	
	// dati gruppo
	$sql_g = "SELECT * FROM {$db1['frontend']}.gruppo WHERE gid=$GID";
	$q_g = vmsql_query($sql_g,$link);
	$info_g = vmsql_fetch_assoc($q_g);
	
	$data_gruppo=date_encode($info_g['data_gruppo'],true,'string');
	
	// mostra form
	echo "<p><img src=\"../img/cancella_gruppo.gif\" alt=\""._('cancella_gruppo')."\" class=\"img-float\"/> 
			"._('Si vuole eliminare il gruppo/registro')." \"<strong>".$info_g['nome_gruppo']."</strong>\", 
			"._('creato in data')." ".$data_gruppo.".<br />
			"._("Attenzione, l'operazione non pu&ograve; essere annullata.")."</p>\n";
	
	if($n_utenti==0){
		echo "<p>"._('Non esistono utenti relativi a questo gruppo.')."</p>";
	}
	else{
		
		$esistono = ($n_utenti==1) ? sprintf(_("Esiste %s utente "),"<strong>$n_utenti</strong>") 
								   : sprintf(_("Esistono %s utenti "),"<strong>$n_utenti</strong>");
		
		echo "<p><strong>"._("Attenzione!")."</strong> $esistono "._('relativi a questo gruppo.')."<br />
		"._("Qualora si volesse procedere <strong>questi utenti saranno inseriti nel gruppo di default</strong>.")."<br />
		"._("Questo probabilmente modificher&agrave; i loro diritti, in quanto gli utenti coinvolti erediteranno i diritti impostati nel registro di default (il registro numero 0).")."<br />
		</p>";
	}
	
	echo "<form method=\"post\" action=\"".$_SERVER['PHP_SELF']."?conferma_del=$GID\">
		<input type=\"hidden\" name=\"gid\" value=\"$GID\" />
		<input type=\"submit\" name=\"conferma\" value=\""._('Conferma eliminazione')."\" />
		</form>
		";
	
	
	echo closeLayout1();
?>