<?php
/**
 * @desc Utility per l'esportazione dei dati delle tabelle in vari formati
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: export_data.php 262 2009-04-24 18:58:09Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */

include("../inc/conn.php");
include("../inc/layouts.php");
include("../inc/func.comuni.php");
include("../inc/func.frontend.php");

 proteggi(1);


if(isset($_GET['id_table']) && is_numeric($_GET['id_table'])){
	
	$id_tabella = (int) $_GET['id_table'];
	
	if($id_tabella==0 || !is_tabella_by_oid($id_tabella)){
		
		
		header("Location: ".$_SERVER['PHP_SELF']);
		exit;
	}
	
	require_once("../inc/func.export.php");
	
	switch($_GET['formato']){
		
		case 'csv':  tabella_csv($id_tabella, (bool) $_GET['raw'],$sep=',');
		break;
		
		case 'html': tabella_html($id_tabella, (bool) $_GET['raw']);
		break;
		
		case 'xls':  tabella_xls($id_tabella, (bool) $_GET['raw']);
		break;
		
		case 'ods':  tabella_ods($id_tabella, (bool) $_GET['raw']);
		break;
		
		default: header("Location: ".$_SERVER['PHP_SELF']);	exit;
		
	}
	
	exit;
}


 
 echo openLayout1(_("Esportazione Dati"), array("sty/admin.css"),'popup');
 
 if(!isset($_GET['idt'])){
 	echo "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> &raquo; "._("esportazione dati")."</div>\n";
 }
 
 echo "<h1>"._("Esportazione Dati")."</h1>\n";
 
 
 echo "<img src=\"../img/db_export.gif\" class=\"img-float\" alt=\""._("impostazioni registri")."\" />\n";

 
 
 echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"get\" style=\"margin:30px 0px 0px 90px\">\n";
 
 
 if(isset($_GET['idt'])){
 	$idt = intval(str_replace(_BASE64_PASSFRASE,"",base64_decode($_GET['idt'])));
 	
 	echo  "<input type=\"hidden\" name=\"id_table\" id=\"id_table\" value=\"$idt\" />\n";
 }
 else{
 
 
	 echo "\t\t<label for=\"id_table\"><strong>"._("Tabella da esportare:")." </strong></label>\n";
	 
	 $TABELLE=prendi_tabelle();
	 
	 echo "\t\t<select id=\"id_table\" name=\"id_table\">\n";
	 
	 for($i=0;$i<count($TABELLE);$i++){
	 	
	 	echo "\t\t\t<option value=\"{$TABELLE[$i]['id_table']}\">".$TABELLE[$i]['table_name']."</option>\n";
	 }
	 
	 echo "\t\t</select><br /><br />\n";
 
 }
 echo "\t\t<p><strong>"._("Formato:")."</strong></p>\n";
 
 echo "\t\t<blockquote>\n";
 echo "\t\t\t<input type=\"radio\" name=\"formato\" id=\"formato_csv\" value=\"csv\" checked=\"checked\"/><label for=\"formato_csv\">CSV (Comma Separate Value)</label>\n<br />";
 echo "\t\t\t<input type=\"radio\" name=\"formato\" id=\"formato_html\" value=\"html\" /><label for=\"formato_html\">HTML</label>\n<br />";
 echo "\t\t\t<input type=\"radio\" name=\"formato\" id=\"formato_ods\" value=\"ods\" /><label for=\"formato_ods\">ODS (Open Document Spreadsheet)</label>\n<br />";
 echo "\t\t\t<input type=\"radio\" name=\"formato\" id=\"formato_xls\" value=\"xls\" /><label for=\"formato_xls\">XLS (Excel)</label>\n<br />";
 
 echo "\t\t</blockquote><br />\n";
 
 
 
  echo "\t\t<p><strong>"._("Modalit&agrave; recupero dati:")."</strong></p>\n";
 
 echo "\t\t<blockquote>\n";
 echo "\t\t\t<input type=\"radio\" name=\"raw\" id=\"raw_1\" value=\"1\" checked=\"checked\"/><label for=\"raw_1\">"._("Dati come presenti in tabella")."</label>\n<br />";
 echo "\t\t\t<input type=\"radio\" name=\"raw\" id=\"raw_0\" value=\"0\" /><label for=\"raw_0\">"._("Dati con formattazione impostata nel registro del gruppo")."</label>\n<br />";
 
 echo "\t\t</blockquote>\n";
 
 echo "<br /><br />\n";
 
 echo "<input type=\"button\" onclick=\"submit();\" name=\"esporta\" value=\" "._("Esporta dati")." \" />\n";
 
 
 echo "</form>\n";
 
 
 
 
 echo closeLayout1();
 
?>