<?php
/**
 * @desc Utility per l'esportazione dell'SQL (DUMP)
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: export_sql.php 371 2009-05-05 13:49:47Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */


include("../inc/conn.php");
include("../inc/layouts.php");
include("../inc/func.comuni.php");

 proteggi(3);
 


	########################################################################
	#
	#
	#	ESPORTAZIONE REGISTRI
	
	$IS_UNIX = (eregi('WIN',$_ENV['OS'])) ? 0:1;
	
	if(isset($_POST['exp_dati'])){

			
		if($IS_UNIX){
			$zippa="| gzip -c ";
			$estensione_zip=".gz";
		}
		else {
			$zippa ="";
			$estensione_zip="";
		}
		
		
		// tipo di dati richiesti
		
		if($_GET['exp']=='registri'){
			$DB = $db1['frontend'];
			$opzioni_pg=' --schema=frontend ';
		}
		else{
			$DB = $db1['dbname'];
			$opzioni_pg=' --schema=public ';
		}
			
		// opzioni dati/schema
		
		if($_POST['schema_only']=='1'){
			$opzioni = "--no-data ";
			$opzioni_pg = '-s ';
		}

		else{
			$opzioni = "";
		}
		
			
		
			if($db1['dbtype']=='mysql'){
				
				$nome_file = _PATH_TMP."/$DB.sql{$estensione_zip}";	
			
				$bat= 	_PATH_MYSQLDUMP.
						" --add-drop-table --force ".
						"-u{$db1['user']} ".
					   	"-p{$db1['passw']} ".
					   	"-P {$db1['port']} ".
					   	"-h {$db1['host']} ".
					   	"$opzioni ".
					   	"$DB ".
					   	"$zippa ".
					   	">$nome_file";
			}
			elseif ($db1['dbtype']=='postgres'){
				
				$nome_file = _PATH_TMP."/{$db1['postgres_dbname']}.$DB.sql{$estensione_zip}";	
				
				$bat= 	"export PGPASSWORD=\"{$db1['passw']}\" ".
						"&& "._PATH_PG_DUMP." ".
						"-U{$db1['user']} ".
						"-p {$db1['port']} ".
						"-h {$db1['host']} ".
						"$opzioni_pg ".
						"{$db1['postgres_dbname']} ".
						" $zippa > $nome_file";
				
			}
				   	
			$exec = passthru($bat);
				   	
			

			if(is_file($nome_file)){
			   header('Pragma: anytextexeptno-cache', true);
			   header('Content-type: application/x-gzip');
			   header('Content-Transfer-Encoding: Binary');
			   header('Content-length: '.filesize($nome_file));
			   header('Content-disposition: attachment; filename='.basename($nome_file));
			   readfile($nome_file);
			   
			   unlink($nome_file);
			}
			else{
				die(_('Impossibile creare il file di dump.'));
			}
			
		
			
		exit;
	}
	
	
	#
	#
	########################################################################
	

 
 echo openLayout1(_("Esportazione Database"), array("sty/admin.css"));
 

 echo "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> &raquo; "._("amministrazione database")."</div>\n";

 echo "<h1>"._("Esportazione Database")."</h1>

 	<img src=\"../img/db_export.gif\" class=\"img-float\" alt=\""._("impostazioni registri")."\" />
 
 	<div class=\"box-db\">
		<h2>"._("Esportazione Database dati")." (<span class=\"var\">{$db1['dbname']}</span>)</h2>
		<form action=\"".$_SERVER['PHP_SELF']."?exp=dati\" method=\"post\">
		
			<br />
		
			<input type=\"radio\" name=\"schema_only\" id=\"schemaonly_1\" value=\"1\" checked=\"checked\"/><label for=\"schemaonly_1\">"._("Solo schema")."</label><br />
			<input type=\"radio\" name=\"schema_only\" id=\"schemaonly_2\" value=\"2\" /><label for=\"schemaonly_2\">"._("Dati e schema")."</label><br />
		
			<br />
			
			<input type=\"submit\" name=\"exp_dati\" value=\""._("Esporta")."\" />
			
		</form>
		
	</div>	
	
 
 	<div class=\"box-db\">
		<h2>"._("Esportazione Database Registri")." (<span class=\"var\">{$db1['frontend']}</span>)</h2>
			
		<form action=\"".$_SERVER['PHP_SELF']."?exp=registri\" method=\"post\">
		
			<br />
		
			<input type=\"radio\" name=\"schema_only\" id=\"schema_reg_only_1\" value=\"1\" checked=\"checked\"/><label for=\"schema_reg_only_1\">"._("Solo schema")."</label><br />
			<input type=\"radio\" name=\"schema_only\" id=\"schema_reg_only_2\" value=\"2\" /><label for=\"schema_reg_only_2\">"._("Dati e schema")."</label><br />
		
			<br />
			
			<input type=\"submit\" name=\"exp_dati\" value=\""._("Esporta")."\" />
			
		</form>
	</div>	\n";
 
 
 echo closeLayout1();
 
?>