<?php
/**
 * Sono qui presenti numerose funzioni per la gestione del registro di VFront. 
 * Il file viene incluso da /admin/gestione_tabelle_gruppi.php
 * 
 * @desc Libreria di funzioni per la gestione del registro di VFront
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: gestione_registro.inc.php 307 2009-04-27 14:52:24Z marciuz $
 * @see gestione_tabelle_gruppi.php
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */



require_once("../inc/conn.php");
require_once("../inc/func.comuni.php");
require_once("../inc/func.frontend.php");

proteggi(3);

	
	


/**
 * Funzione di inserimento di una tabella nel registro. 
 * Questa funzione scrive nelle tabelle registro_tab e registro_col
 * informazioni su una tabella del database, recuperate a sua volta dall'information_schema
 *
 * @param string $val Nome della tabella
 * @param int $gid Identificativo del gruppo
 * @return void
 */
function inserisci_registro($val,$gid=0){
	
	global $link,$db1;
	
		// Verifica che non ci siano gi� record per questo gruppo
		$test_gid=vmsql_test_id($link,"gid",$gid,"{$db1['frontend']}.registro_tab", "AND table_name='{$val['table_name']}'");
		
		if($test_gid){
			return null;
		}
	
	
		$val = str_replace("'","\\'",$val);
		
		$gid= (int) $gid;
		
		$sql_tab_dett= "INSERT INTO {$db1['frontend']}.registro_tab (
				gid,
				table_name, 
				table_type, 
				commento)
				VALUES 
				(".$gid.",".
				"'".$val['table_name']."',". 
				"'".$val['table_type']."',". 
				"'".$val['comment']."')";
				
		$q_dett=vmsql_query($sql_tab_dett,$link,true);
	
		$ID_TABLE = vmsql_insert_id($link,"{$db1['frontend']}.registro_tab",'id_table');
	
	
	
	
	#########################
	#
	#	Dettagli di tabella
	#
	
	if($db1['dbtype']=='postgres'){
		
		$sql="SELECT 
			column_name,
			ordinal_position,
		column_default,
		is_nullable,
		udt_name as column_type,
		character_maximum_length,
		data_type,
		CASE WHEN column_default LIKE 'nextval(%' THEN 'auto_increment' ELSE '' END AS extra,
		col_description(a.attrelid, a.attnum::integer) AS column_comment
		
		
		FROM information_schema.columns i, pg_attribute a, pg_class c, pg_namespace ns
		
		WHERE i.table_schema='{$db1['dbname']}'
		
		AND i.table_name='".$val['table_name']."'
		
		AND c.relname=i.table_name
		AND ns.oid=c.relnamespace
		AND a.attrelid = c.oid
		AND a.attname = i.column_name
		
		ORDER BY table_name ASC, ordinal_position ASC ";
	
	}
	else{
		
		$sql="SELECT 
		column_name,
		ordinal_position,
		column_default,
		is_nullable,
		column_type,
		character_maximum_length,
		data_type,
		extra,
		SUBSTRING_INDEX(column_comment,'; InnoDB',1) as column_comment
		
		FROM information_schema.columns
		
		WHERE table_schema='{$db1['dbname']}'
		
		AND table_name='".$val['table_name']."'
		
		ORDER BY table_name ASC, ordinal_position ASC ";
	}
	
	
	$q1=vmsql_query($sql,$link,true);
	
	$matrice1 = vmsql_fetch_assoc_all($q1);
	
	//print_r($matrice1);
	
	foreach ($matrice1 as $k=>$valori){
		
		$valori = str_replace("'","\\'",$valori);
		
		$gid = (int) $gid;
		
		$sql2= "INSERT INTO {$db1['frontend']}.registro_col (
				gid,
				id_table, 
				column_name,
				ordinal_position,
				column_default,
				is_nullable,
				column_type,
				character_maximum_length,
				data_type,
				extra,
				commento)
				VALUES 
				(".$gid.",".
				intval($ID_TABLE).",". 
				"'".$valori['column_name']."',".
				intval($valori['ordinal_position']).",".
				"'".addslashes(stripslashes($valori['column_default']))."',".
				"'".$valori['is_nullable']."',".
				"'".addslashes(stripslashes($valori['column_type']))."',".
				intval($valori['character_maximum_length']).",".
				"'".$valori['data_type']."',".
				"'".$valori['extra']."',".
				"'".$valori['column_comment']."')";
				
		$q2=vmsql_query($sql2,$link,true);
	}
}
	




/**
 * Funzione di clonazione registro. 
 * Prende le impostazioni del gruppo $gid_old (il gruppo default � 0)
 * e le applica al nuovo gruppo $gid_new
 *
 * @param int $gid_new ID del nuovo gruppo
 * @param int $gid_old ID del gruppo origine
 * @return bool Esito dell'operazione
 */
function clona_settaggio($gid_new,$gid_old=0,$solo_tabella=false){

	global $link,$db1;
	
	// Pulisco le tabelle temporanee
		
	vmsql_begin($link);

	
	// Se � una sola tabella da copiare...
	$vincolo_sola_tabella=($solo_tabella>0)? " AND id_table=".intval($solo_tabella)." " : "";
	
	
	
	// prendo i dati tabella
	
	$sql_tab1 = "SELECT id_table,
				visibile,
				in_insert,
				in_update,
				in_delete,
				in_export,
				in_import,
				data_modifica,
				orderby,
				table_name,
				table_type,
				commento,
				orderby_sort,
				permetti_allegati,
				permetti_allegati_ins,
				permetti_allegati_del,
				permetti_link,
				permetti_link_ins,
				permetti_link_del,
				view_pk,
				fonte_al


				FROM {$db1['frontend']}.registro_tab 
				WHERE gid=".intval($gid_old)."
				$vincolo_sola_tabella
				ORDER BY table_name";
	
	$q_tab1=vmsql_query($sql_tab1,$link);
	
	
	while($RS1=vmsql_fetch_assoc($q_tab1)){
	

		$RS1=pulisci_dom($RS1);
		
		// Preparo l'inserimento del master
		$sql_ins1=sprintf("INSERT INTO {$db1['frontend']}.registro_tab (gid,visibile,in_insert,in_duplica,in_update,in_delete,in_export,in_import,
															  data_modifica,orderby,table_name,table_type,commento,orderby_sort,
															  permetti_allegati,permetti_allegati_ins,permetti_allegati_del,permetti_link,permetti_link_ins,permetti_link_del,
															  view_pk,fonte_al)
						VALUES (%d,%d,%d,%d,%d,%d,%d,%d,
								%d,'%s','%s','%s','%s','%s',
								%d,%d,%d,%d,%d,%d,'%s','%s')",
						$gid_new,
						$RS1['visibile'],
						$RS1['in_insert'],
						$RS1['in_duplica'],
						$RS1['in_update'],
						$RS1['in_delete'],
						$RS1['in_export'],
						$RS1['in_import'],
						$RS1['data_modifica'],
						$RS1['orderby'],
						$RS1['table_name'],
						$RS1['table_type'],
						addslashes(stripslashes($RS1['commento'])),
						$RS1['orderby_sort'],
						$RS1['permetti_allegati'],
						$RS1['permetti_allegati_ins'],
						$RS1['permetti_allegati_del'],
						$RS1['permetti_link'],
						$RS1['permetti_link_ins'],
						$RS1['permetti_link_del'],
						$RS1['view_pk'],
						$RS1['fonte_al']
						
						);
						
		$q_ins1=vmsql_query($sql_ins1,$link);
						
		$ID_NEW_TABLE = vmsql_insert_id($link,"{$db1['frontend']}.registro_tab",'id_table');
				

		
		
		// Prendi i valori del vecchio gid
		$sql_col1 = "SELECT column_name,
							ordinal_position,
							column_default,
							is_nullable,
							column_type,
							character_maximum_length,
							data_type,
							extra,
							in_tipo,
							in_default,
							in_visibile,
							in_richiesto,
							in_suggest,
							in_table,
							in_ordine,
							jstest,
							alias_frontend,
							commento
							
					FROM {$db1['frontend']}.registro_col
					WHERE gid=".intval($gid_old)."
					AND id_table=".intval($RS1['id_table'])."
					ORDER BY column_name, ordinal_position
					
		";
		
		$q_col1 = vmsql_query($sql_col1,$link);
		
		while($RS2=vmsql_fetch_assoc($q_col1)){
			
			$RS2=pulisci_dom($RS2);
			
			// Inserisci i valori duplicati
			
				// Preparo l'inserimento del master
		$sql_ins1=sprintf("INSERT INTO {$db1['frontend']}.registro_col 
							(gid, id_table, column_name,
							ordinal_position, column_default, is_nullable,
							column_type, character_maximum_length, data_type,
							extra, in_tipo, in_default,
							in_visibile, in_richiesto, 
							in_suggest, in_table, in_ordine, jstest, alias_frontend, commento )
						VALUES (%d,%d,'%s',
						%d,'%s',%d,
						'%s',%d,'%s',
						'%s','%s','%s',
						%d,%d,
						%d,%d,%d,'%s','%s','%s')",
						$gid_new,
						$ID_NEW_TABLE,
						$RS2['column_name'],
						$RS2['ordinal_position'],
						addslashes(stripslashes($RS2['column_default'])),
						$RS2['is_nullable'],
						addslashes(stripslashes($RS2['column_type'])),
						$RS2['character_maximum_length'],
						$RS2['data_type'],
						$RS2['extra'],
						$RS2['in_tipo'],
						$RS2['in_default'],
						$RS2['in_visibile'],
						$RS2['in_richiesto'],
						$RS2['in_suggest'],
						$RS2['in_table'],
						$RS2['in_ordine'],
						$RS2['jstest'],
						addslashes(stripslashes($RS2['alias_frontend'])),
						addslashes(stripslashes($RS2['commento']))
						);
						
			$q_ins2 = vmsql_query($sql_ins1,$link);
						
		}
						
						
						
						
	}
	
	if(isset($GLOBALS['VMSQL_ERROR'])){
		
		vmsql_rollback($link);
		return false;
	}
		
	else {
		vmsql_commit($link);
		return true;
	}
		
	
}


/**
 * Dato un gid crea un registro tabelle per quel gruppo partendo da zero. 
 * Come inizializza registro ma non crea il record nel gruppo.
 * Restituisce vero|falso
 * @param int $gid Id del gruppo
 * @return bool Esito dell'operazione
 */
function genera_registro_vuoto($gid){
	
	global $link, $db1;
	
		// Inizio
			vmsql_begin($link);
	
			/*// Verifico l'esistenza del gruppo $gid
			$test_gid_0 = vmsql_test_id($link,'gid',$gid,'{$db1['frontend']}.gruppo');
			
			// se c'� manda errore
			if($test_gid_0){
				
				openErrorGenerico("Attenzione! Esiste gi� un gid con questo valore");
			}
			*/
			
			
			########################
			#
			# Def tabelle
			#
			
			if($db1['dbtype']=='postgres'){
			
				$sql_tab="SELECT table_name, table_type, obj_description(c.oid, 'pg_class'::name) AS comment 
						  FROM information_schema.tables , pg_catalog.pg_class AS c
						  WHERE TABLE_SCHEMA='{$db1['dbname']}'
						  AND (TABLE_TYPE='BASE TABLE' OR TABLE_TYPE='VIEW')
						  AND  table_name=c.relname
						  ORDER BY TABLE_NAME ASC
				";
			
			}
			else{
				
			$sql_tab="SELECT table_name, table_type, SUBSTRING_INDEX(table_comment,'; InnoDB',1) as comment
					  FROM information_schema.tables
					  WHERE TABLE_SCHEMA='{$db1['dbname']}'
					  AND (TABLE_TYPE='BASE TABLE' OR TABLE_TYPE='VIEW')
					  
					  ORDER BY TABLE_NAME ASC
			";
				
			}
			
			
			$q0=vmsql_query($sql_tab,$link);
			
			$matrice0 = vmsql_fetch_assoc_all($q0);
			
			foreach ($matrice0 as $k=>$val){
					
				inserisci_registro($val,$gid);
			}	
			
			if(isset($GLOBALS['VMSQL_ERROR'])){
				
				vmsql_rollback($link);
				return false;
			}
			else{
				
				vmsql_commit($link);
				return true;
			}
	
}






/**
 * Inizializzazione del registro. 
 * Viene creato il gid 0 e la prima copia del registro e viene eliminato il gruppo -1 
 * creato nell'installazione.
 * Restituisce vero se l'operazione va a buon fine, falso se fallisce.
 * @return bool Esito dell'operazione
 */
function inizializza_registro(){
	
	global $link, $db1;
	
		// Inizio
			vmsql_begin($link);
	
			
			// Verifico l'esistenza del gruppo 0
			
			$test_gid_0 = vmsql_test_id($link,'gid','0',"{$db1['frontend']}.gruppo");
			
			// se non c'� lo creo
			if(!$test_gid_0){
				$q_gruppo_0 = vmsql_query("INSERT INTO {$db1['frontend']}.gruppo (gid,nome_gruppo,descrizione_gruppo)
 											VALUES(0,'default','gruppo di default')",$link);
			}
			
			
			
			########################
			#
			# Def tabelle
			#
			
			if($db1['dbtype']=='postgres'){
				
				$sql_tab="SELECT table_name, table_type , obj_description(c.oid, 'pg_class'::name) AS comment 
					  FROM information_schema.tables, pg_catalog.pg_class AS c
					  WHERE table_schema='{$db1['dbname']}'
					  AND  table_name=c.relname
					  AND (table_type='BASE TABLE' OR table_type='VIEW')
					  ORDER BY table_name ASC
				";
				
			}else{
				
				$sql_tab="SELECT table_name, SUBSTRING_INDEX(table_comment,'; InnoDB',1) as comment, table_type
					  FROM information_schema.tables
					  WHERE TABLE_SCHEMA='{$db1['dbname']}'
					  AND (TABLE_TYPE='BASE TABLE' OR TABLE_TYPE='VIEW')
					  ORDER BY TABLE_NAME ASC
				";
				
			}
			
			
			
			
			$q0=vmsql_query($sql_tab,$link);
			
			$matrice0 = vmsql_fetch_assoc_all($q0);
			
			foreach ($matrice0 as $k=>$val){
					
				inserisci_registro($val,0);
			}	
			
			if(isset($GLOBALS['VMSQL_ERROR'])){
				
				vmsql_rollback($link);
				return false;
			}
			else{
				
				// metti l'utente 1 (admin) nel gruppo 0
				$q_ut=vmsql_query("UPDATE {$db1['frontend']}.utente SET gid=0 WHERE id_utente=1",$link);
				
				// aggiorna la sessione
				$_SESSION['user']['gid']=0;
				$_SESSION['gid']=0;
				
				// Elimina il gruppo temporaneo -1
				$q_del_g=vmsql_query("DELETE FROM {$db1['frontend']}.gruppo WHERE gid=-1 ",$link);
				
				vmsql_commit($link);
				
				return true;
			}
	
}


/**
 * Funzione di aggiornamento dei registri di VFront. 
 * Vengono confrontate le tabelle attualmente presenti in registro e quelle presenti in information_schema, 
 * inserite nel registro quelle nuove e cancellate quelle obsolete
 *
 */
function aggiorna_registri(){
	
	global $link, $db1;
	
	
			
	
			if($db1['dbtype']=="postgres"){
				
				$sql_nuove="SELECT t.table_name, t.table_type , obj_description(c.oid, 'pg_class'::name) AS comment
					  FROM information_schema.tables t
					  INNER JOIN pg_catalog.pg_class AS c ON t.table_name=c.relname
					  LEFT OUTER JOIN  {$db1['frontend']}.registro_tab r ON t.table_name=r.table_name
					  WHERE t.table_schema='{$db1['dbname']}'
					  AND (t.table_type='BASE TABLE' OR t.table_type='VIEW')
					  AND t.table_name NOT IN (SELECT r.table_name FROM {$db1['frontend']}.registro_tab r)
					  ";
				
			}
			else{
				
				$sql_nuove="SELECT t.table_name , SUBSTRING_INDEX(t.table_comment,'; InnoDB',1) as comment
					FROM information_schema.tables t 
					LEFT OUTER JOIN  {$db1['frontend']}.registro_tab r ON t.table_name=r.table_name
					WHERE t.table_schema='{$db1['dbname']}'
					AND (t.table_type='BASE TABLE' OR t.table_type='VIEW')
					AND t.table_name NOT IN (SELECT r.table_name FROM {$db1['frontend']}.registro_tab r)";
			}
	
			// Prendi tabelle attualmente esistenti non presenti nel registro:
			$q_nuove=vmsql_query($sql_nuove,$link);
					
			
					
			$mat_nuove_tabelle=vmsql_fetch_assoc_all($q_nuove);
			
			if(is_array($mat_nuove_tabelle)){
			
				foreach($mat_nuove_tabelle as $k=>$val){
					
					inserisci_registro($val);
				}
			}
			
			// Elimina le tabelle presenti  nel registro e non pi� nel database
			
			vmsql_begin($link);
			
			$q_vecchie=vmsql_query(
					"SELECT r.id_table, r.table_name
					FROM {$db1['frontend']}.registro_tab r 
					WHERE r.table_name NOT IN (
						SELECT t.TABLE_NAME FROM information_schema.tables t 
						WHERE t.TABLE_SCHEMA='{$db1['dbname']}' AND (t.TABLE_TYPE='BASE TABLE' OR t.TABLE_TYPE='VIEW')",
					$link);
					
			while($RS_del=vmsql_fetch_row($q_vecchie)){
					
				// Elimina da registro_col
				$q_del_col = vmsql_query("DELETE FROM {$db1['frontend']}.registro_col WHERE id_table=".intval($RS_del[0]),$link);
				
				// Elimina da registro_tab
				$q_del_col = vmsql_query("DELETE FROM {$db1['frontend']}.registro_tab WHERE id_table=".intval($RS_del[0]),$link);
				
			}
			
			if(isset($GLOBALS['VMSQL_ERROR']) && $GLOBALS['VMSQL_ERROR']===true){
				vmsql_rollback($link);
			}
			else{
				vmsql_commit($link);
			}
			
			
		
	
	// -- fine caso aggiorna
}




/**
 * Inizializzazione (creazione) della sottomaschera. 
 * Viene inserita in registro la nuova sottomaschera e le sue caratteristiche di dettaglio.
 *
 * @param int $oid_parent ID della tabella padre (la maschera di cui questa sar� sottomaschera)
 * @param string $tabella_sub Tabella che svolger� il ruolo di sottomaschera
 * @return bool Esito dell'operazione
 */
function inizializza_sottomaschera($oid_parent,$tabella_sub){
	
	global $db1, $link;
	
	vmsql_begin($link);
	
	// Inserimento dati minimi del master
	$sql_ins_sub = "INSERT INTO ".$db1['frontend'].".registro_submask (id_table,nome_tabella) 
						VALUES ('$oid_parent','$tabella_sub')";
		
	$q_ins_sub=vmsql_query($sql_ins_sub,$link);
	
	if(vmsql_affected_rows($link,$q_ins_sub)==1){
		
		// inserimento del dettaglio
		$id_submask = vmsql_insert_id($link, $db1['frontend'].".registro_submask" ,'id_submask');
		
		
			// prendi info della tabella
		
			#########################
			#
			#	Dettagli di tabella
			#
			
			
			//POSTGRES
			if($db1['dbtype']=='postgres'){
				
				
				$sql="SELECT 
				column_name,
				ordinal_position,
				column_default,
				is_nullable,
				character_maximum_length,
				data_type,
				CASE WHEN column_default LIKE 'nextval(%' THEN 'auto_increment' ELSE '' END AS extra,
				col_description(a.attrelid, a.attnum::integer) AS column_comment
				
				FROM information_schema.columns i, pg_attribute a, pg_class c, pg_namespace ns
				
				WHERE table_schema='{$db1['dbname']}'
				
				AND table_name='".$tabella_sub."'
				
				AND c.relname=i.table_name
				AND ns.oid=c.relnamespace
				AND a.attrelid = c.oid
				AND a.attname = i.column_name
				
				ORDER BY table_name ASC, ordinal_position ASC ";
				
			}
			
			//MYSQL
			else{
				
			$sql="SELECT 
				column_name,
				ordinal_position,
			column_default,
			is_nullable,
			column_type,
			character_maximum_length,
			data_type,
			extra,
			SUBSTRING_INDEX(column_comment,'InnoDB',1) as column_comment
			
			FROM information_schema.columns
			
			WHERE table_schema='{$db1['dbname']}'
			
			AND table_name='".$tabella_sub."'
			
			ORDER BY table_name ASC, ordinal_position ASC ";
			
			}
			
			
			
			
			$q1=vmsql_query($sql,$link,true);
			
			$matrice1 = vmsql_fetch_assoc_all($q1);
			
			//print_r($matrice1);
			
			foreach ($matrice1 as $k=>$valori){
				
				$valori = str_replace("'","\\'",$valori);
				
				$gid = (int) $gid;
				
				$sql2= "INSERT INTO {$db1['frontend']}.registro_submask_col (
						id_submask, 
						column_name, 
						ordinal_position, 
						column_default, 
						is_nullable, 
						column_type, 
						character_maximum_length, 
						data_type, 
						extra, 
						commento)
						VALUES 
						(".intval($id_submask).",". 
						"'".$valori['column_name']."',".
						"'".$valori['ordinal_position']."',".
						"'".addslashes(stripslashes($valori['column_default']))."',".
						"'".$valori['is_nullable']."',".
						"'".$valori['column_type']."',".
						intval($valori['character_maximum_length']).",".
						"'".$valori['data_type']."',".
						"'".$valori['extra']."',".
						"'".addslashes(stripslashes($valori['column_comment']))."')";
						
				$q2=vmsql_query($sql2,$link,true);
			}
			
			
		
	}
	else{
		vmsql_rollback($link);
		return false;
	}
	
	
	vmsql_commit($link);
	
	return true;
}





/**
 * Funzione di clonazione delle sottomaschere. 
 * Questa � un'utiliti per copiare una sottomaschera di un gruppo per un altro gruppo
 * 
 * @param int $gid_new ID del gruppo destinazione
 * @param int $gid_old ID del gruppo origine
 * @param bool $solo_id_table 
 * @return bool Esito dell'operazione
 */
function clona_sottomaschere($gid_new,$gid_old,$solo_id_table=0){
	
	global $link, $db1;
	
	
		
	$clausola_id_table = ($solo_id_table>0) ? "AND t.id_table=".intval($solo_id_table) : "";
	
	// prendi le tabelle che hanno sottomaschere da clonare
	
	$q0 =vmsql_query("SELECT s.id_submask, s.id_table ,t.table_name
					FROM ".$db1['frontend'].".registro_submask s, ".$db1['frontend'].".registro_tab t
					WHERE t.gid=$gid_old
					AND s.id_table=t.id_table
					$clausola_id_table
					ORDER BY t.table_name",$link);
	
	if(vmsql_num_rows($q0)==0){
		
		return 0; // si ferma qui.
	}
			
	list($old_id_submask,$old_id_table, $old_table_name) =vmsql_fetch_row_all($q0,true);
	
	// ora prende l'array delle tabelle del nuovo gid
	
	for($j=0;$j<count($old_table_name);$j++){
		
		$new_id_table[] = name2oid($old_table_name[$j],$gid_new);
		
	}
	
	
	# CICLO CLONAZIONE SUBMASK MASTER
	
	# INIZIO
	vmsql_begin($link);
	
	
	for($i=0;$i<count($old_id_submask);$i++){
		
		// PRENDI UNA SOTTOMASCHERA
		
		$q1 =vmsql_query("SELECT id_submask,
								id_table,
								sub_select,
								sub_insert,
								sub_update,
								sub_delete,
								nome_tabella,
								nome_frontend,
								campo_pk_parent,
								campo_fk_sub,
								orderby_sub,
								orderby_sub_sort,
								data_modifica,
								max_records,
								tipo_vista

					FROM ".$db1['frontend'].".registro_submask
					WHERE id_submask=".$old_id_submask[$i]."
					",$link);
		
		$RS1=vmsql_fetch_assoc($q1);
		
		
		// ---> PREPARA LA QUERY DI INSERIMENTO
		$sql_ins1 =sprintf("
		INSERT INTO ".$db1['frontend'].".registro_submask
		
		(id_table,	sub_select,	sub_insert,	sub_update,	sub_delete,	nome_tabella,nome_frontend,
		campo_pk_parent,campo_fk_sub, orderby_sub, orderby_sub_sort, data_modifica, max_records,tipo_vista)
		
		VALUES (%d,%d,%d,%d,%d,'%s','%s',
				'%s','%s','%s','%s',%d,%d,'%s')",
			$new_id_table[$i],
			$RS1['sub_select'],
			$RS1['sub_insert'],
			$RS1['sub_update'],
			$RS1['sub_delete'],
			$RS1['nome_tabella'],
			addslashes($RS1['nome_frontend']),
			$RS1['campo_pk_parent'],
			$RS1['campo_fk_sub'],
			$RS1['orderby_sub'],
			$RS1['orderby_sub_sort'],
			time(),
			$RS1['max_records'],
			$RS1['tipo_vista']
			);
			
		// INSERISCI IL MASTER 
		
		$q_ins1 = vmsql_query($sql_ins1,$link);
		
		if(vmsql_affected_rows($link,$q_ins1)!=1){
			
			vmsql_rollback($link);
			openErrorGenerico(_("Errore nella clonazione delle sottomaschere"),true);
		}
		
		
			// recupera l'id inserito.
			
			$new_id_submask = vmsql_insert_id($link, $db1['frontend'].".registro_submask",'id_submask');
			
			// REcupera i dati del dettaglio
			
			$q2 =vmsql_query("SELECT *
					FROM ".$db1['frontend'].".registro_submask_col
					WHERE id_submask=".$old_id_submask[$i]."
					",$link);
		
			while($RS2=vmsql_fetch_assoc($q2)){
				
				
				// Prepara la query di inserimento
				
				$sql_ins2=sprintf("INSERT INTO ".$db1['frontend'].".registro_submask_col
					
					(id_submask,  column_name,	ordinal_position, column_default, is_nullable,
					column_type, character_maximum_length,	data_type,	extra, in_tipo,
					in_default,	in_visibile, in_richiesto, alias_frontend,	commento)
					
					VALUES
					
					(%d,'%s',%d,'%s','%s',
					'%s','%s','%s','%s','%s',
					'%s',%d,%d,'%s','%s')
					",
				$new_id_submask,
				$RS2['column_name'],
				$RS2['ordinal_position'],
				addslashes(stripslashes($RS2['column_default'])),
				$RS2['is_nullable'],
				$RS2['column_type'],
				$RS2['character_maximum_length'],
				$RS2['data_type'],
				$RS2['extra'],
				$RS2['in_tipo'],
				addslashes($RS2['in_default']),
				$RS2['in_visibile'],
				$RS2['in_richiesto'],
				addslashes(stripslashes($RS2['alias_frontend'])),
				addslashes(stripslashes($RS2['commento']))
				);
				
				$q_ins2=vmsql_query($sql_ins2,$link);
				
				if(vmsql_affected_rows($link,$q_ins2)!=1){
			
					vmsql_rollback($link);
					openErrorGenerico(_("Errore nella clonazione delle sottomaschere"),true);
				}


				
			}
				

		
		
	}
	
	vmsql_commit($link);
	
	return true;
	
	
}



/**
 * Funzione di manutenzione dei registri. 
 * Copia le sottomaschere per le viste
 *
 * @param int $id_vista_new
 * @param int $id_tabella_old
 * @return bool
 */
function copia_sottomaschere_viste($id_vista_new,$id_tabella_old){
	
	global $link, $db1;
	
	

	# CICLO CLONAZIONE SUBMASK MASTER
	
	# INIZIO
	vmsql_begin($link);
	
	
	
	
		// PRENDI UNA SOTTOMASCHERA
		
		$q1 =vmsql_query("SELECT id_submask,
								id_table,
								sub_select,
								sub_insert,
								sub_update,
								sub_delete,
								nome_tabella,
								nome_frontend,
								campo_pk_parent,
								campo_fk_sub,
								orderby_sub,
								orderby_sub_sort,
								data_modifica,
								max_records,
								tipo_vista

					FROM ".$db1['frontend'].".registro_submask
					WHERE id_table=$id_tabella_old
					
					",$link);
		
		
		
		while($RS1=vmsql_fetch_assoc($q1)){
		
		
		
			
			
			// ---> PREPARA LA QUERY DI INSERIMENTO
			$sql_ins1 =sprintf("
			INSERT INTO ".$db1['frontend'].".registro_submask
			
			(id_table,	sub_select,	sub_insert,	sub_update,	sub_delete,	nome_tabella,nome_frontend,
			campo_pk_parent,campo_fk_sub, orderby_sub, orderby_sub_sort, data_modifica, max_records,tipo_vista)
			
			VALUES (%d,%d,%d,%d,%d,'%s','%s',
					'%s','%s','%s','%s',%d,%d,'%s')",
				$id_vista_new,
				$RS1['sub_select'],
				$RS1['sub_insert'],
				$RS1['sub_update'],
				$RS1['sub_delete'],
				$RS1['nome_tabella'],
				addslashes($RS1['nome_frontend']),
				$RS1['campo_pk_parent'],
				$RS1['campo_fk_sub'],
				$RS1['orderby_sub'],
				$RS1['orderby_sub_sort'],
				time(),
				$RS1['max_records'],
				$RS1['tipo_vista']
				);
				
			// INSERISCI IL MASTER 
			
			$q_ins1 = vmsql_query($sql_ins1,$link);
			
			if(vmsql_affected_rows($link,$q_ins1)!=1){
				
				vmsql_rollback($link);
				openErrorGenerico(_("Errore nella clonazione delle sottomaschere"),true);
			}
			
			
				// recupera l'id inserito.
				
				$new_id_submask = vmsql_insert_id($link,$db1['frontend'].".registro_submask", "id_submask");
				
				// REcupera i dati del dettaglio
				
				$q2 =vmsql_query("SELECT *
						FROM ".$db1['frontend'].".registro_submask_col
						WHERE id_submask=".$RS1['id_submask'],$link);
			
				while($RS2=vmsql_fetch_assoc($q2)){
					
					
					// Prepara la query di inserimento
					
					$sql_ins2=sprintf("INSERT INTO ".$db1['frontend'].".registro_submask_col
						
						(id_submask,  column_name,	ordinal_position, column_default, is_nullable,
						column_type, character_maximum_length,	data_type,	extra, in_tipo,
						in_default,	in_visibile, in_richiesto, alias_frontend,	commento)
						
						VALUES
						
						(%d,'%s',%d,'%s','%s',
						'%s','%s','%s','%s','%s',
						'%s',%d,%d,'%s','%s')
						",
					$new_id_submask,
					$RS2['column_name'],
					$RS2['ordinal_position'],
					addslashes(stripslashes($RS2['column_default'])),
					$RS2['is_nullable'],
					$RS2['column_type'],
					$RS2['character_maximum_length'],
					$RS2['data_type'],
					$RS2['extra'],
					$RS2['in_tipo'],
					addslashes($RS2['in_default']),
					$RS2['in_visibile'],
					$RS2['in_richiesto'],
					addslashes(stripslashes($RS2['alias_frontend'])),
					addslashes(stripslashes($RS2['commento']))
					);
					
					$q_ins2=vmsql_query($sql_ins2,$link);
					
					if(vmsql_affected_rows($link,$q_ins2)!=1){
				
						vmsql_rollback($link);
						openErrorGenerico(_("Errore nella clonazione delle sottomaschere"),true);
					}
	
	
					
				} // -fine while interno
				
		} // -fine while esterno

		
	
	
	vmsql_commit($link);
	
	return true;
	
	
}


/**
 * Funzionedi utility per le operazioni interne 
 * Copia le impostazioni dei campi di una tabella per un gruppo  
 * e le applica alla tabella per un altro gruppo
 *
 * @param int $id_table_fonte id_table della tabella fonte
 * @param int $id_table_destinazione id_table della tabella destinazione
 * @return bool Esito dell'operazione
 */
function copia_impostazione_campi($id_table_fonte,$id_table_destinazione){
	
	global $link,$db1;
	
	
	// Prendi i valori del vecchio gid
		$sql_col1 = "SELECT column_name,
							extra,
							in_tipo,
							in_default,
							in_visibile,
							in_richiesto,
							in_suggest,
							in_table,
							in_ordine,
							jstest,
							alias_frontend
							
					FROM {$db1['frontend']}.registro_col
					WHERE id_table=".intval($id_table_fonte)."
					ORDER BY column_name, ordinal_position
					
		";
		
		$q_col1 = vmsql_query($sql_col1,$link);
		
		vmsql_begin($link);
		
		while($RS2=vmsql_fetch_assoc($q_col1)){
			
			
			// prende l'id_reg corrispettivo
			
			$RS2=pulisci_dom($RS2);
			
			$q_reg=vmsql_query("SELECT id_reg FROM {$db1['frontend']}.registro_col 
								WHERE id_table=".intval($id_table_destinazione)."
								AND column_name='".$RS2['column_name']."'",$link);
			
			list($ID_REG)=vmsql_fetch_row($q_reg);
			
			// Prepara la query di aggiornamento
			
			$sql_up=sprintf("UPDATE {$db1['frontend']}.registro_col 
							SET 
							extra='%s',
							in_tipo='%s', 
							in_default='%s',
							in_visibile=%d, 
							in_richiesto=%d, 
							in_suggest=%d, 
							in_table=%d,
							in_ordine=%d,
							jstest='%s',
							alias_frontend='%s'
							
							WHERE id_reg=%d
							LIMIT 1
							",
							$RS2['extra'],
							$RS2['in_tipo'],
							$RS2['in_default'],
							$RS2['in_visibile'],
							$RS2['in_richiesto'],
							$RS2['in_suggest'],
							$RS2['in_table'],
							$RS2['in_ordine'],
							$RS2['jstest'],
							$RS2['alias_frontend'],
							$ID_REG);
							
			
						
			$res_up = vmsql_try($sql_up,$link,false);
			
			if(!$res_up){
				
				vmsql_rollback($link);
				openErrorGenerico(_("Errore nella copia di impostazione dei campi"),true);
			}
						
		}
		
	vmsql_commit($link);
	
	return true;
	
		
		
}




/**
 * Funzione di utilita' 
 * 
 * @param int $gid_new
 * @param int $gid_old
 * @param int $id_table_fonte
 * @param int $id_table_dest
 */
function copia_impostazione_sottomaschere($gid_new,$gid_old,$id_table_fonte,$id_table_dest){
	
	global $link,$db1;
	
	
	// Elimina eventuali vecchie sottomaschere
	
	$q_del_sub = vmsql_query("DELETE FROM {$db1['frontend']}.registro_submask WHERE id_table=".intval($id_table_dest),$link);
	
	$esito = clona_sottomaschere($gid_new,$gid_old,$id_table_fonte);
	
}


/**
 * Funzione di sincronizzazione dei campi del registro frontend. 
 * Si associa a aggiorna registri, ma opera a livello di confronto di campo.
 *
 * @see function aggiorna_registri
 * @param string $tabella
 * @param string $campo
 * @param string $tipo_aggiornamento (UPDATE | INSERT | DELETE)
 * @todo update and insert in subforms (sottomaschere)
 */
function aggiorna_campo($tabella,$campo,$tipo_aggiornamento="UPDATE"){
	
	global $link,$db1;
	
	if($tipo_aggiornamento=="UPDATE"){
		
		// prendi gli id dal frontend
		
		$sql_c="SELECT c.id_reg, c.id_table FROM {$db1['frontend']}.registro_col c, {$db1['frontend']}.registro_tab t
				WHERE c.id_table=t.id_table 
				AND t.table_name='$tabella'
				AND c.column_name='$campo'";
		
		$qc=vmsql_query($sql_c,$link);
		
		$mat_c=vmsql_fetch_assoc_all($qc);
		
		
		// prendi le info del campo dal information_schema
		$sql_i="SELECT * FROM information_schema.columns
				WHERE TABLE_SCHEMA='".$db1['dbname']."'
				AND TABLE_NAME='$tabella'
				AND COLUMN_NAME='$campo'";
		
		$qi=vmsql_query($sql_i,$link);
		
		$RSi=vmsql_fetch_assoc($qi);
		
		$RSi=pulisci_dom($RSi);
		
		// PREPARA l'update
		
		for($i=0;$i<count($RSi);$i++){
			
			
			// AGGIORNAMENTO MASCHERE
			
			if($db1['dbtype']=='postgres'){
				
				$max_length= (is_numeric($RSi['character_maximum_length'])) ? $RSi['character_maximum_length'] : 'NULL';
				
				$sql_up="UPDATE {$db1['frontend']}.registro_col
						 SET column_default='".$RSi['column_default']."',
						 is_nullable='".$RSi['is_nullable']."',
						 ordinal_position=".intval($RSi['ordinal_position']).",
						 column_type='".addslashes(stripslashes($RSi['udt_name']))."',
						 character_maximum_length=".$max_length.",
						 data_type='".$RSi['data_type']."',
						 extra='',
						 in_tipo = NULL,
						 in_default = NULL,
						 in_visibile=0,
						 in_richiesto=0,
						 in_table=0,
						 in_ordine=0,
						 jstest = NULL,
						 alias_frontend = '".$RSi['alias_frontend']."',
						 commento='".utf8_decode($RSi['column_comment'])."'
						 
						 WHERE id_table=".intval($mat_c[$i]['id_table'])."
						 AND id_reg=".intval($mat_c[$i]['id_reg'])."
						 
						";
			}
			else{
				
				$max_length= (is_numeric($RSi['CHARACTER_MAXIMUM_LENGTH'])) ? intval($RSi['CHARACTER_MAXIMUM_LENGTH']) : 'NULL';
				
					$sql_up="UPDATE {$db1['frontend']}.registro_col
						 SET column_default='".$RSi['COLUMN_DEFAULT']."',
						 is_nullable='".$RSi['IS_NULLABLE']."',
						 ordinal_position='".$RSi['ORDINAL_POSITION']."',
						 column_type='".addslashes(stripslashes($RSi['COLUMN_TYPE']))."',
						 character_maximum_length=".$max_length.",
						 data_type='".$RSi['DATA_TYPE']."',
						 extra='',
						 in_tipo = NULL,
						 in_default = NULL,
						 in_visibile=0,
						 in_richiesto=0,
						 in_table=0,
						 in_ordine=0,
						 jstest = NULL,
						 alias_frontend = '".$RSi['alias_frontend']."',
						 commento='".utf8_decode($RSi['COLUMN_COMMENT'])."'
						 
						 WHERE id_table=".intval($mat_c[$i]['id_table'])."
						 AND id_reg=".intval($mat_c[$i]['id_reg'])."
						 
						";
			}
			
			$q_up = vmsql_query($sql_up,$link);
			
			
		}
		
	}
	
	
	else if($tipo_aggiornamento=="INSERT"){
		
		
		// prendi le info del campo dal information_schema
		$sql_i="SELECT * FROM information_schema.columns
				WHERE TABLE_SCHEMA='".$db1['dbname']."'
				AND TABLE_NAME='$tabella'
				AND COLUMN_NAME='$campo'";
		$qi=vmsql_query($sql_i,$link);
		
		$RSi=vmsql_fetch_assoc($qi);
		
		// prendi gli ID table da coinvolgere
		
		$q_idt=vmsql_query("SELECT id_table,gid FROM {$db1['frontend']}.registro_tab
							WHERE table_name='$tabella'",$link);

		
		list($idtables,$gids)=vmsql_fetch_row_all($q_idt,true);
		
		
		// prepara la query
		
		for($i=0;$i<count($idtables);$i++){
		
			
			if($db1['dbtype']=='postgres'){
				
				$sql_in="INSERT INTO {$db1['frontend']}.registro_col
					
					(id_table,gid,column_name,
					column_default,is_nullable,ordinal_position,
					column_type,character_maximum_length,data_type,in_visibile,
					commento)
					
					VALUES
					
					(".$idtables[$i].", ".$gids[$i]." ,'$campo',
					'".addslashes(stripslashes($RSi['column_default']))."','".$RSi['is_nullable']."',".intval($RSi['ordinal_position']).",
					'".addslashes(stripslashes($RSi['column_type']))."',".intval($RSi['character_maximum_length']).",'".$RSi['data_type']."',0,
					'".addslashes(utf8_decode($RSi['column_comment']))."')
					
					";
			}

			else{
				$sql_in="INSERT INTO {$db1['frontend']}.registro_col
						
						(id_table,gid,column_name,
						column_default,is_nullable,ordinal_position,
						column_type,character_maximum_length,data_type,in_visibile,
						commento)
						
						VALUES
						
						(".$idtables[$i].", ".$gids[$i]." ,'$campo',
						'".addslashes(stripslashes($RSi['COLUMN_DEFAULT']))."','".$RSi['IS_NULLABLE']."','".$RSi['ORDINAL_POSITION']."',
						'".addslashes(stripslashes($RSi['COLUMN_TYPE']))."',".intval($RSi['CHARACTER_MAXIMUM_LENGTH']).",'".$RSi['DATA_TYPE']."',0,
						'".addslashes(utf8_decode($RSi['COLUMN_COMMENT']))."')
						
						";
			}
			
			
			$q_in = vmsql_query($sql_in,$link);
		}
	}
	
	
	else if($tipo_aggiornamento=="DELETE"){
		
		
		// AGGIORNAMENTO MASCHERE
		
		// prendi le colonne coinvolte
		
		$sql_del="SELECT c.id_reg FROM {$db1['frontend']}.registro_col c, {$db1['frontend']}.registro_tab t
				WHERE c.id_table=t.id_table 
				AND t.table_name='$tabella'
				AND c.column_name='$campo'";

		$q_del=vmsql_query($sql_del,$link);
		
		list($idregs) = vmsql_fetch_row_all($q_del,true);
		
		if(count($idregs)>0){
		
			$sql_del2="DELETE FROM {$db1['frontend']}.registro_col WHERE id_reg IN (".implode(",",$idregs).")";
		
			$q_del2 = vmsql_query($sql_del2,$link);
			
		}
		
		
		// AGGIORNAMENTO SOTTO MASCHERE
		
		$sql_del_sub="SELECT sc.id_reg_sub
				FROM {$db1['frontend']}.registro_submask_col sc
				INNER JOIN {$db1['frontend']}.registro_submask s ON sc.id_submask=s.id_submask 
				WHERE s.nome_tabella='$tabella'
				AND sc.column_name='$campo'";
		
		$q_del_sub=vmsql_query($sql_del_sub,$link);
		
		list($idregs_sub) = vmsql_fetch_row_all($q_del_sub,true);
		
		if(count($idregs_sub)>0){
		
			$sql_del3="DELETE FROM {$db1['frontend']}.registro_col WHERE id_reg IN (".implode(",",$idregs_sub).")";
		
			$q_del3 = vmsql_query($sql_del3,$link);
			
		}
	}
	
	
}


?>