<?php
/**
 * Sono qui presenti le procedure fondamentali per la gestione del registro di VFront.
 * Il file è organizzato per aree e svolge numerose funzioni
 * 
 * @desc File per la gestione del registro di VFront
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: gestione_tabelle_gruppi.php 384 2009-05-16 02:27:20Z marciuz $
 * @see gestione_registro.inc.php
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */



include("../inc/conn.php");
include("../inc/layouts.php");
include("../inc/func.comuni.php");
include("../inc/func.tratta_campo.php");
include("../inc/func.frontend.php");

proteggi(3);

if(isset($_GET['conf_sub'])){
	
	include("../inc/func.tratta_campo_submask.php");
}





###############################################################################################
#
#		Da qui mostra le impostazioni della tabella
#		Con richiamo di funzione esterna per ogna campo.
#
###############################################################################################











/**
 * Da qui � possibile accedere alle impostazioni delle tabelle e eseguire operazioni rapide
 * sulla loro configurazione
 * 
 * @desc Genera il menu delle tabelle
 * @param unknown_type $gid
 * @param unknown_type $order
 */
function tab_menu($gid=0,$order='table_name'){
	
	global $link,$db1;
	
	
	switch($order){
		case 0: $order = "table_name"; break;
		case 1: $order = "data_modifica"; break;
		case 2: $order = "visibile"; break;
		case 3: $order = "id_table"; break;
		case 4: $order = "commento"; break;
		case 5: $order = "in_insert"; break;
		case 6: $order = "in_update"; break;
		case 7: $order = "in_delete"; break;
		case 8: $order = "n_sottomaschere"; break;
		default: $order = 'table_name'; 
	}
	
	if(isset($_GET['sort'])){
		
		$sort = ($_GET['sort']=="d") ?  "DESC" : "ASC";
	}
	else{
		$sort = "ASC";
	}
	
	// Richiama tutte le tabelle dati
	$sql_tab = "SELECT t.table_name,  t.visibile,  t.in_insert,  t.in_update, 
				 t.in_delete,  t.data_modifica,   t.id_table,  t.commento , t.table_type
				, (SELECT count(*) FROM {$db1['frontend']}.registro_submask s WHERE s.id_table=t.id_table) as n_sottomaschere
				FROM {$db1['frontend']}.registro_tab t
				WHERE gid=$gid
				ORDER BY t.table_type,  $order $sort ";
	$q_tab= vmsql_query($sql_tab,$link);
	$matrice_tab = vmsql_fetch_assoc_all($q_tab);


	echo openLayout1(_("Amministrazione Tabelle"),array("sty/admin.css","js/mostra_nascondi_id.js"));

	
	
	echo "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> &raquo; <a href=\"menu_registri.php\">"._("menu gruppi/registri")."</a> &raquo; </div>";
	
	echo "<h1>"._("Regole Tabelle gruppo")." <span class=\"var\">$gid::".gid2nome_gruppo($gid)."</span></h1>\n";
	

	#############################################
	#
	#
	#	FUNZIONI RAPIDE
	#
	#
	
	echo "<div style=\"padding:5px 0 20px 0;\"><a href=\"javascript:;\" onclick=\"mostra_nascondi('tab-menu-rapide');\">"._("Funzioni rapide")."</a></div>\n";
	
	echo "
	
		<div id=\"tab-menu-rapide\"  style=\"display:none\">
			<fieldset style=\"padding:10px;margin:10px;width:85%;\">
				<legend>"._("Impostazioni rapide")."</legend>
				<p><strong>"._("Visibilit&agrave; (SELECT)")."</strong>
					<a href=\"?gid=$gid&amp;mass=visibile_all\">"._("Permetti a tutte le tabelle")."</a> | 
					<a href=\"?gid=$gid&amp;mass=visibile_none\">"._("Nega a tutte le tabelle")."</a></p>
				<p><strong>"._("Inserimento (INSERT)")."</strong>
				<a href=\"?gid=$gid&amp;mass=insert_all\">"._("Permetti in tutte le tabelle")."</a> | 
					<a href=\"?gid=$gid&amp;mass=insert_none\">"._("Nega in tutte le tabelle")."</a></p>
				<p><strong>"._("Modifica (UPDATE)")."</strong>
				<a href=\"?gid=$gid&amp;mass=update_all\">"._("Permetti in tutte le tabelle")."</a> | 
					<a href=\"?gid=$gid&amp;mass=update_none\">"._("Nega in tutte le tabelle")."</a></p>
				<p><strong>"._("Elimina (DELETE)")."</strong>
				<a href=\"?gid=$gid&amp;mass=delete_all\">"._("Permetti in tutte le tabelle")."</a> | 
					<a href=\"?gid=$gid&amp;mass=delete_none\">"._("Nega in tutte le tabelle")."</a>
				</p>
			</fieldset>
			<br/>
			<br/>
		</div>
		";
	
	
	
	
	echo "<table summary=\"tabelle db per utenti\" id=\"tab-tabelle\" >\n";
	
	$c=0;
	
	
	echo "\t<tr>\n";
	
	echo "\t\t<th>".table_sort(_('visibile'),2,_('Impostazione di visibili&agrave; della tabella'))."</th>\n";
	echo "\t\t<th>".table_sort(_('tabella'),0,_('Nome della tabella'))."</th>\n";
	echo "\t\t<th>".table_sort(_('ultimo settaggio'),1,_('Data dell\'ultima impostazione per questa tabella'))."</th>\n";
	echo "\t\t<th>".table_sort(_('sottomaschere'),8,_('numero di sottomaschere impostate per la tabella'))."</th>\n";
	echo "\t\t<th>".table_sort(_('commento'),4,_('Commento di tabella'))."</th>\n";
	echo "\t\t<th>".table_sort(_('insert'),5,_('Possibilit&agrave; di inserimento dati per questa tabella da parte di questo gruppo'))."</th>\n";
	echo "\t\t<th>".table_sort(_('update'),6,_('Possibilit&agrave; di modifica dei dati per questa tabella da parte di questo gruppo'))."</th>\n";
	echo "\t\t<th>".table_sort(_('delete'),7,_('Possibilit&agrave; di cancellazione dei dati per questa tabella da parte di questo gruppo'))."</th>\n";
	
	
	echo "\t</tr>\n";
	
	$inizia_vista=true;
	
	foreach($matrice_tab as $tab){
		
		$colore=(($c%2)==0) ? "c1":"c2";
		$c++;
		
		if($tab['data_modifica']>0) {
			$data_mod = date("Y-m-d H:i",$tab['data_modifica']);
			$color_href="";
			$title_href='';
		}
		else{
			$data_mod = "-";
			$color_href=" class=\"dafare\"";
			$title_href='title="'._("Questa tabella non &egrave; stata ancora configurata").'"';
		}
		
		 $n_sottomaschere = ($tab['n_sottomaschere']>0) ? "<strong>".$tab['n_sottomaschere']."</strong>" : "<span class=\"grigio\">".$tab['n_sottomaschere']."</span>";
		
		 
		 // SEPARATORE PER LE VISTE
		 
		 if($tab['table_type']=='VIEW' && $inizia_vista==true){
		 	
		 	echo "\t\t<tr class=\"separatore\" style=\"padding-top:50px;margin-top:10px;\">
		 		<td colspan=\"7\"><hr /><h2>"._("Viste sulle tabelle")."</h2></td>
		 		</tr>\n";
		 	
		 	$inizia_vista=false;
		 }
		 
		 
		 
		echo "\t\t<tr class=\"$colore\">
				<td>".high_si_no($tab['visibile'])."</td>
				
				<td><a $title_href $color_href href=\"".$_SERVER['PHP_SELF']."?det=".$tab['id_table']."&amp;gid=$gid\">".$tab['table_name']."</a></td>
				<td>".$data_mod."</td>
				<td>".$n_sottomaschere."</td>
				<td>".htmlentities($tab['commento'],ENT_QUOTES)."</td>
				<td>".high_si_no($tab['in_insert'])."</td>
				<td>".high_si_no($tab['in_update'])."</td>
				<td>".high_si_no($tab['in_delete'])."</td>
			</tr>\n";
	}
	
	echo "</table>\n";

	echo closeLayout1();

}






/**
 * Genera il menu delle sottomaschere
 *
 * @param int $oid
 * @param int $order
 */
function submask_menu($oid=0,$order='nome_tabella'){
	
	global $link,$db1;
	
	
	switch($order){
		case 0: $order = "nome_tabella"; break;
		case 1: $order = "data_modifica"; break;
		case 2: $order = "sub_select"; break;
		case 3: $order = "sub_insert"; break;
		case 4: $order = "sub_update"; break;
		case 5: $order = "sub_delete"; break;
		default: $order = 'nome_tabella'; 
	}
	
	if(isset($_GET['sort'])){
		
		$sort = ($_GET['sort']=="d") ?  "DESC" : "ASC";
	}
	else{
		$sort = "ASC";
	}
	
	// Richiama tutte le tabelle dati
	$sql_tab = "SELECT id_submask,sub_select,sub_insert,sub_update,sub_delete,nome_tabella,
					campo_pk_parent,campo_fk_sub,orderby_sub,orderby_sub_sort,data_modifica
				FROM {$db1['frontend']}.registro_submask
				WHERE id_table=$oid
				ORDER BY $order $sort ";
	$q_tab= vmsql_query($sql_tab,$link);
	$matrice_tab = vmsql_fetch_assoc_all($q_tab);


		
	echo "<h2>"._("Regole sottomaschere della tabella")." <span class=\"var\">".oid2name($oid)."</span></h2>\n";
	

	echo "<table summary=\"sottomaschere tabelle\" id=\"tab-sub-tabelle\" >\n";
	
	$c=0;
	
	
	echo "\t<tr>\n";
	
	echo "\t\t<th height=\"20\"><span class=\"help\" title=\""._("Impostazione di visibili&agrave; della tabella")."\">"._("visibile")."</span></th>\n";
	echo "\t\t<th><span class=\"help\" title=\""._("Nome della tabella")."\">"._("tabella")."</span></th>\n";
	echo "\t\t<th><span class=\"help\" title=\""._("Data dell'ultima impostazione per questa sottomaschera")."\">"._("ultimo settaggio")."</span></th>\n";
	echo "\t\t<th><span class=\"help\" title=\""._("Possibilit&agrave; di inserimento dati da questa sottomaschera da parte di questo gruppo")."\">"._("insert")."</span></th>\n";
	echo "\t\t<th><span class=\"help\" title=\""._("Possibilit&agrave; di modifica dei dati da questa sottomaschera da parte di questo gruppo")."\">"._("update")."</span></th>\n";
	echo "\t\t<th><span class=\"help\" title=\""._("Possibilit&agrave; di cancellazione dei dati da questa sottomaschera da parte di questo gruppo")."\">"._("delete")."</span></th>\n";
	echo "\t\t<th>&nbsp;</th>\n";
	
	echo "\t</tr>\n";
	
	
	foreach($matrice_tab as $tab){
		
		$colore=(($c%2)==0) ? "c1":"c2";
		$c++;
		
		if($tab['data_modifica']>0) {
			$data_mod = date("Y-m-d H:i",$tab['data_modifica']);
			$color_href="";
			$title_href='';
		}
		else{
			$data_mod = "-";
			$color_href=" class=\"dafare\"";
			$title_href='title="'._("Questa sottomaschera non &egrave; stata ancora configurata")."'";
		}
		
		echo "\t\t<tr class=\"$colore\">
				<td>".high_si_no($tab['sub_select'])."</td>
				
				<td><a $title_href $color_href href=\"".$_SERVER['PHP_SELF']."?det=$oid&amp;conf_sub=".$tab['id_submask']."&amp;a=3&amp;gid=".$_GET['gid']."\">".$tab['nome_tabella']."</a></td>
				<td>".$data_mod."</td>
				<td>".high_si_no($tab['sub_insert'])."</td>
				<td>".high_si_no($tab['sub_update'])."</td>
				<td>".high_si_no($tab['sub_delete'])."</td>
				<td><a href=\"javascript:;\" onclick=\"if(confirm('"._("Sei sicuro di eliminare questa sottomaschera e le sue impostazioni?\\nL\'operazione non puo\' essere annullata")."')){document.getElementById('id_submask').value='".$tab['id_submask']."';document.forms.elimina_submask.submit();}\">"._("Elimina")."</a></td>
			</tr>\n";
	}
	
	echo "</table>\n";
	
	echo "<form method=\"post\" action=\"".$_SERVER['PHP_SELF']."?elimina_submask\" id=\"elimina_submask\" name=\"elimina_submask\" style=\"display:none;\">
	
		<input type=\"hidden\" name=\"id_del_submask\" id=\"id_submask\" value=\"0\" />
		<input type=\"hidden\" name=\"oid\" value=\"$oid\" />
		<input type=\"hidden\" name=\"gid\" value=\"$gid\" />
		
		</form>
		";

	
}





/**
 * Mostra la linguetta di dettaglio dei campi per l'amministrazione delle tabelle
 * 
 * @desc Dettaglio per le tabelle
 * @param int $oid
 * @param int $gid
 */
function tab_dett($oid,$gid=0){
	
	global $link,$db1;
	
	
	$oid= (int) $oid;
	
	$gid= (int) $gid;
	
	
	# Vedi se � tabella o vista
	$q_tipo=vmsql_query("SELECT table_type FROM {$db1['frontend']}.registro_tab WHERE id_table=$oid",$link);
	list($tipo_tab) = vmsql_fetch_row($q_tipo);
	
	
	# Info tabella e PK
	
	if($tipo_tab=='VIEW'){
		
		$sql_tab = "SELECT rb.*, view_pk as campo_pk 
					FROM {$db1['frontend']}.registro_tab rb 
					WHERE rb.id_table=$oid
					";
		
	}else{
	
		$sql_tab = "SELECT rb.*, i.column_name as campo_pk 
					FROM {$db1['frontend']}.registro_tab rb 
					LEFT JOIN information_schema.key_column_usage i ON (i.table_name=rb.table_name AND i.table_schema='{$db1['dbname']}')
					
					WHERE rb.id_table=$oid
					";
	}
	
	
	$q_tab=vmsql_query($sql_tab,$link);
	
	$info=vmsql_fetch_assoc($q_tab);
	
	$info['campo_pk']=str_replace(array("(",")"),"",$info['campo_pk']);
	
	$array_pk=explode(",",$info['campo_pk']);
	foreach ($array_pk as $k=>$val){
		$array_pk[$k]=trim($val);
	}
	

	
	# Prende le FK
	# Individua i campi coinvolti in una relazione esterna e tabella.campo a cui � legato


	list($array_fk,$colref_fk)=prendi_FK($oid);
	
	
	# Inizia a prendere i campi
	
	
	$sql_cols = "SELECT  id_reg,
						id_table,
						column_name,
						column_default,
						is_nullable,
						data_type,
						character_maximum_length,
						column_type,
						extra,
						in_tipo,
						in_default,
						in_visibile,
						in_richiesto,
						in_suggest,
						in_table,
						jstest,
						commento,
						alias_frontend
						
						
						FROM {$db1['frontend']}.registro_col 
						WHERE id_table=$oid 
						ORDER BY ordinal_position";
	
	$q_cols=vmsql_query($sql_cols,$link);
	
	$matrice_col=vmsql_fetch_assoc_all($q_cols);
	
	$matrice_rev=vmsql_reverse_matrix($matrice_col);
	
	
	// INFO GENERALI PER LA TABELLA
	
	$def['visibile']= ($info['visibile']=="1" || $info['visibile']=="t") ? "checked=\"checked\" " : "";
	$def['in_insert']= ($info['in_insert']=="1" || $info['in_insert']=="t") ? "checked=\"checked\" " : "";
	$def['in_duplica']= ($info['in_duplica']=="1" || $info['in_duplica']=="t") ? "checked=\"checked\" " : "";
	$def['in_update']= ($info['in_update']=="1" || $info['in_update']=="t") ? "checked=\"checked\" " : "";
	$def['in_delete']= ($info['in_delete']=="1" || $info['in_delete']=="t") ? "checked=\"checked\" " : "";
	$def['in_export']= ($info['in_export']=="1" || $info['in_export']=="t") ? "checked=\"checked\" " : "";
	$def['in_import']= ($info['in_import']=="1" || $info['in_import']=="t") ? "checked=\"checked\" " : "";
	$def['permetti_allegati']= ($info['permetti_allegati']=="1" || $info['permetti_allegati']=="t" ) ? "checked=\"checked\" " : "";
	$def['permetti_allegati_display']= ($info['permetti_allegati']=="1" || $info['permetti_allegati']=="t") ? "" : "none";
	
	$def['permetti_link']= ($info['permetti_link']=="1" || $info['permetti_link']=="t") ? "checked=\"checked\" " : "";
	$def['permetti_link_display']= ($info['permetti_link']=="1" || $info['permetti_link']=="t") ? "" : "none";
	
	$def['permetti_allegati_ins']= ($info['permetti_allegati_ins']=="1" || $info['permetti_allegati_ins']=="t") ? "checked=\"checked\" " : "";
	$def['permetti_allegati_del']= ($info['permetti_allegati_del']=="1" || $info['permetti_allegati_del']=="t") ? "checked=\"checked\" " : "";
		
	$def['permetti_link_ins']= ($info['permetti_link_ins']=="1" || $info['permetti_link_ins']=="t") ? "checked=\"checked\" " : "";
	$def['permetti_link_del']= ($info['permetti_link_del']=="1" || $info['permetti_link_del']=="t") ? "checked=\"checked\" " : "";
	
	
	
	
	
	###############################################
	#
	#	Inizia a stampare
	#
	
	$files= array("sty/admin.css","js/mostra_hid.js","js/mostra_nascondi_id.js", 
					"js/test_query.js","sty/linguette.css","js/open_window.js","js/admin_orderby.js"); //,"js/test_campi.js"); 
	
	$files[]="js/scriptaculous/lib/prototype.js";
	$files[]="js/scriptaculous/src/scriptaculous.js";
	
	echo openLayout1(_("Amministrazione tabella"),$files);
	

	
	echo "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> &raquo; <a href=\"menu_registri.php\">".("menu gruppi/registri")."</a> &raquo; <a href=\"gestione_tabelle_gruppi.php?gid=$gid\">"._("impostazioni registro id")." $gid</a> &raquo; </div>\n";
	
	$see_now=($_SESSION['user']['livello']==3) ? " - <a href=\"../scheda.php?oid=$oid\" title=\"See now\">"._('Vedi')."</a>\n" : "\n";
	
	if($info['table_type']=='VIEW'){
		echo "\n<h1>"._("Impostazioni vista")." <span class=\"verde\">".$info['table_name']."</span> "._("per")." <span class=\"verde\">".$gid."</span><span class=\"grigio\">::</span><span class=\"verde\">".gid2nome_gruppo($gid)."</span> $see_now</h1>\n";
	}
	else{
		echo "\n<h1>"._("Impostazioni tabella")." <span class=\"var\">".$info['table_name']."</span> "._("per")." <span class=\"var\">".$gid."</span><span class=\"grigio\">::</span><span class=\"var\">".gid2nome_gruppo($gid)."</span> $see_now</h1>\n";
	}
	
	
	// Feedback
	if(isset($_GET['feed'])){
		switch($_GET['feed']){
			
			case 'ok_gen': $feed_str="<p class=\"feed-mod-ok\">"._("Impostazioni generali modificate correttamente")."</p>\n";
			break;
			
			case 'ok_gen_trasversale': $feed_str="<p class=\"feed-mod-ok\">"._("Impostazioni generali per tutti i gruppi modificate correttamente")."</p>\n";
			break;
			
			case 'ko_gen': $feed_str="<p class=\"feed-mod-ko\">"._("Errore nella modifica delle impostazioni generali")."</p>\n";
			break;			
			
			case 'ok_campi': $feed_str="<p class=\"feed-mod-ok\">"._("Impostazioni dei campi modificate correttamente")."</p>\n";
			break;
			
			case 'ko_campi': $feed_str="<p class=\"feed-mod-ko\">"._("Nessuna modifica delle impostazioni dei campi")."</p>\n";
			break;	
					
			case 'ok_sub_upd': $feed_str="<p class=\"feed-mod-ok\">"._("Impostazioni della sottomaschera modificate correttamente")."</p>\n";
			break;
			
			case 'ko_sub_upd': $feed_str="<p class=\"feed-mod-ko\">"._("Nessuna modifica delle impostazioni della sottomaschera")."</p>\n";
			break;
			
			default: $feed_str="";
		}
		
		echo $feed_str;
	}
		
	
	
	if(!isset($_GET['a']) || $_GET['a']=='1'){
		
		$attiva = 'tabella-gen';
		
		$classe_eti['gen']='attiva';
		$classe_eti['campi']='disattiva';
		$classe_eti['mask']='disattiva';
		$classe_eti['campisort']='disattiva';
			
		
	}
	else if($_GET['a']=='2'){
		
		$attiva = 'tabella-campi';
		
		$classe_eti['gen']='disattiva';
		$classe_eti['campi']='attiva';
		$classe_eti['mask']='disattiva';
		$classe_eti['campisort']='disattiva';
		
		
	}else if($_GET['a']=='3'){
		
		$attiva = 'tabella-sottomaschere';
		
		$classe_eti['gen']='disattiva';
		$classe_eti['campi']='disattiva';
		$classe_eti['mask']='attiva';
		$classe_eti['campisort']='disattiva';
	}
	else if($_GET['a']=='4'){
		
		$attiva = 'campi-sort';
		
		$classe_eti['gen']='disattiva';
		$classe_eti['campi']='disattiva';
		$classe_eti['mask']='disattiva';
		$classe_eti['campisort']='attiva';
	}
	
	
	
	?>
	
	<script type="text/javascript">
		// <!-- 
	
		var divs = new Array('tabella-gen','tabella-campi','campi-sort','tabella-sottomaschere');
	
		var attiva = '<?php echo $attiva;?>';
		
		function eti(ido){
			
			for (i=0;i<divs.length;i++){
				$(divs[i]).style.display='none';
				$('li-'+divs[i]).className='disattiva';
			}
			
			// attiva il selezionato
			$(ido).style.display='';
			$('li-'+ido).className='attiva';
			
		}
	
		// -->
	</script>
	
	<?php
	
	
	
	// Apre il box etichette
	
	// attiva disattiva
	
	
	
	echo 
	"<div id=\"box-etichette\">
		
		<ul class=\"eti-var-gr\">
			<li onclick=\"eti('tabella-gen');\" id=\"li-tabella-gen\" class=\"{$classe_eti['gen']}\" >"._("Impostazioni generali")."</li>
			<li onclick=\"eti('tabella-campi');\" id=\"li-tabella-campi\" class=\"{$classe_eti['campi']}\" >"._("Impostazioni campi")."</li>
			<li onclick=\"eti('campi-sort');\" id=\"li-campi-sort\" class=\"{$classe_eti['campisort']}\" >"._("Ordine campi")."</li>
			<li onclick=\"eti('tabella-sottomaschere');\" id=\"li-tabella-sottomaschere\" class=\"{$classe_eti['mask']}\" >"._("Impostazioni sottomaschere")."</li>
		</ul>
	</div>
		";
	
	
	
	// CAMPI TABELLA:
	list($campi_tabella) = prendi_colonne_frontend($oid,"column_name",false);
	
	
	##############################################################
	#
	#	 FORM IMPOSTAZIONI GENERALI
	#
	#
	#
	
	
	
	$st_gen = (!isset($_GET['a']) || $_GET['a']==1) ? "" : "display:none;"; 
	
	echo "
	
	<div class=\"tabella-gen\" id=\"tabella-gen\" style=\"$st_gen\" >
	
	<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\">\n";
	
	
	##########################################
	#
	#	ORDERBY BLOCK
	
	echo "
		<div id=\"orderby_tn\">\n";
	
	$array_orderby=explode(",",$info['orderby']);
	$array_orderby_sort=explode(",",$info['orderby_sort']);
	
	$c=0;
	
	do{
		
		$label_text = ($c==0) ? _("Ordina per:") : _("e poi per:");
		
		echo"
			<div id=\"orderby_tn{$c}\" >
			
				<label for=\"orderby{$c}\" id=\"lab_orderby{$c}\">".$label_text."</label>
				<select name=\"orderby[]\" id=\"orderby{$c}\" >
				";
			
				for($x=0;$x<count($matrice_rev['column_name']);$x++){
					
					$sel = ($matrice_rev['column_name'][$x]==$array_orderby[$c]) ? "selected=\"selected\"" : "";
					
					// se anche chiave primaria, scrivilo
					$pk = ($matrice_rev['column_name'][$x]==$info['campo_pk']) ? " (". _("chiave primaria") .")" : "";
					
					echo "\t\t<option value=\"".$matrice_rev['column_name'][$x]."\" $sel >".$matrice_rev['column_name'][$x]." $pk</option>\n";		
				}
				
			echo "
				</select>
				";
			
			$sel_sort['ASC'] = ($array_orderby_sort[$c]=='ASC') ? "selected=\"selected\"" : "";
			$sel_sort['DESC'] = ($array_orderby_sort[$c]=='DESC') ? "selected=\"selected\"" : "";
			
			$display_remove = ($c==0) ? "style=\"display:none\"" : "";
			
			echo "
			
				<select name=\"orderby_sort[]\" id=\"orderby_sort{$c}\" >
					<option value=\"ASC\" ".$sel_sort['ASC'].">"._("Ascendente")."</option>
					<option value=\"DESC\" ".$sel_sort['DESC'].">"._("Discendente")."</option>
				</select>
				<span class=\"fakelink\" onclick=\"$(this).up().remove()\" $display_remove >"._('Rimuovi')."</span>
			</div>"; 
			
		$c++;
			
	} while ($c<count($array_orderby));
	
	
	
	echo "</div>\n";	

	echo "<span class=\"fakelink\" onclick=\"add_orderby()\" >"._('Aggiungi ordinamento')."</span>\n";
	// fine blocco ORDERBY
			
			
		echo "
		
		<div class=\"info-campo\">"._("Campo secondo il quale saranno ordinati per default i dati della tabella")."</div>
		
		<input type=\"hidden\" name=\"visibile\" id=\"visibile-hid\" value=\"0\" />
		<input type=\"checkbox\" name=\"visibile\" id=\"visibile\" value=\"1\" ".$def['visibile']."/>
		<label for=\"visibile\">"._("Tabella visibile")."</label>
		<div class=\"info-campo\">"._("Imposta se la tabella deve essere visibile per questo gruppo")."</div>
		
		";
		
		if($info['table_type']=='VIEW'){
			
			
			/*echo "
			<input type=\"hidden\" name=\"in_insert\" id=\"in_insert-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"in_insert\" id=\"in_insert\" value=\"0\"  disabled=\"disabled\" />
			<label for=\"in_insert\">Inserisci record (INSERT)</label>
			<div class=\"info-campo\">Disabilitato in quanto vista</div>
			";*/
			echo "
			<input type=\"hidden\" name=\"in_insert\" id=\"in_insert-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"in_insert\" id=\"in_insert\" value=\"1\"  ".$def['in_insert']." />
			<label for=\"in_insert\">"._("Inserisci record (INSERT)")."</label>
			<div class=\"info-campo\">"._("Permetti a questo gruppo di inserire nuovi record")."</div>
			";
			
			// IMPOSTAZIONI PER LA MODIFICABILTA' DEI DATI NELLA VISTA (prese dalla definizione della vista stessa)
			$view_up=prendi_info_view($info['table_name'],'IS_UPDATABLE');
			
			if($view_up['IS_UPDATABLE']=='YES'){
				
				echo "
			
			<input type=\"hidden\" name=\"in_update\" id=\"in_update-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"in_update\" id=\"in_update\"  value=\"1\" ".$def['in_update']." />
			<label for=\"in_update\">"._("Modifica i record (UPDATE)")."</label>
			<div class=\"info-campo\">"._("Permetti a questo gruppo di modificare record esistenti")."</div>
			
				";
			}
			else{
				echo "
				
				<input type=\"hidden\" name=\"in_update\" id=\"in_update-hid\" value=\"0\" />
				<input type=\"checkbox\" name=\"in_update\" id=\"in_update\" value=\"0\"  disabled=\"disabled\" />
				<label for=\"in_update\">"._("Modifica i record (UPDATE)")."</label>
				<div class=\"info-campo\">"._("Disabilitato in quanto vista")."</div>
				
				";
			}
			
			
			// PRENDE LA DEFINIZIONE VISTA E CERACA JOIN PER IMPOSTARE IL DELETE SI|NO
			if($db1['dbtype']=='mysql'){
				
				$q_join=vmsql_query("SHOW CREATE VIEW ".$info['table_name'],$link);
				list($trash,$show_create)=vmsql_fetch_row($q_join);
			}
			
			else if ($db1['dbtype']=='postgres'){
				
				$q_join=vmsql_query("SELECT view_definition 
									FROM information_schema.views
									WHERE table_name='".$info['table_name']."'
									AND table_catalog='".$db1['postgres_dbname']."'
									AND table_schema='".$db1['dbname']."'",$link);
				list($show_create)=vmsql_fetch_row($q_join);
				
			}
			
			$JOIN=(eregi(' JOIN ',$show_create)) ? true:false;
				
				
			if($JOIN){
				echo "
				
				<input type=\"hidden\" name=\"in_delete\" id=\"in_delete-hid\" value=\"0\" />
				<input type=\"checkbox\" name=\"in_delete\" id=\"in_delete\" value=\"0\"  disabled=\"disabled\" />
				<label for=\"in_delete\">"._("Elimina i record (DELETE)")."</label>
				<div class=\"info-campo\">"._("Disabilitato in quanto vista con JOIN")."</div>
				";
			}
			else{
				
				echo "
				
				<input type=\"hidden\" name=\"in_delete\" id=\"in_delete-hid\" value=\"0\" />
				<input type=\"checkbox\" name=\"in_delete\" id=\"in_delete\" value=\"1\" ".$def['in_delete']." />
				<label for=\"in_delete\">"._("Elimina i record (DELETE)")."</label>
				<div class=\"info-campo\">"._("Permetti a questo gruppo di eliminare record")."</div>
				";
			}
		
		
		}
		// SE invece la tabella � una normale BASE TABLE
		else{
			
				echo "
			<input type=\"hidden\" name=\"in_insert\" id=\"in_insert-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"in_insert\" id=\"in_insert\" value=\"1\" ".$def['in_insert']." onclick=\"if(this.checked){\$('cont-duplica').style.display='';} else {\$('cont-duplica').style.display='none';}\" />
			<label for=\"in_insert\">"._("Inserisci record (INSERT)")."</label>
			<div class=\"info-campo\">"._("Permetti a questo gruppo di inserire nuovi record")."</div>
			";
				
			if($def['in_insert']=='') $style_duplica="display:none;";
				
			echo "
			<div id=\"cont-duplica\" style=\"margin-left:40px;$style_duplica\">
				<input type=\"hidden\" name=\"in_duplica\" id=\"in_duplica-hid\" value=\"0\" />
				<input type=\"checkbox\" name=\"in_duplica\" id=\"in_duplica\" value=\"1\" ".$def['in_duplica']."/>
				<label for=\"in_duplica\">"._("Duplica record (dipende da INSERT)")."</label>
				<div class=\"info-campo\">"._("Permetti a questo gruppo di creare nuovi record duplicando un record esistente")."</div>
			</div>
			";
			
			echo "
			<input type=\"hidden\" name=\"in_update\" id=\"in_update-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"in_update\" id=\"in_update\" value=\"1\" ".$def['in_update']."/>
			<label for=\"in_update\">"._("Modifica i record (UPDATE)")."</label>
			<div class=\"info-campo\">"._("Permetti a questo gruppo di modificare record esistenti")."</div>
			
			<input type=\"hidden\" name=\"in_delete\" id=\"in_delete-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"in_delete\" id=\"in_delete\" value=\"1\" ".$def['in_delete']."/>
			<label for=\"in_delete\">"._("Elimina i record (DELETE)")."</label>
			<div class=\"info-campo\">"._("Permetti a questo gruppo di eliminare i record")."</div>
			
			
			";
		}
		
		echo "
		
		<input type=\"hidden\" name=\"in_export\" id=\"in_export-hid\" value=\"0\" />
		<input type=\"checkbox\" name=\"in_export\" id=\"in_export\" value=\"1\" ".$def['in_export']."/>
		<label for=\"in_export\">"._("Permetti esportazione")."</label>
		<div class=\"info-campo\">"._("Permetti a questo l'esportazione dei dati in tabella")."</div>
		
		";
		
		
		echo "
		
		<input type=\"hidden\" name=\"in_import\" id=\"in_import-hid\" value=\"0\" />
		<input type=\"checkbox\" name=\"in_import\" id=\"in_import\" value=\"1\" ".$def['in_import']."/>
		<label for=\"in_import\">"._("Permetti importazione")."</label>
		<div class=\"info-campo\">"._("Permetti a questo l'importazione dei dati in tabella")."</div>
		
		";
		
		
		
		// IN CASO DI VISTA IMPOSTA ESPLICITAMENTE LA CHIAVE PRIMARIA DELLA TABELLA
		
		if($info['table_type']=='VIEW'){
			
			echo "<label for=\"view_pk\">"._("Imposta la chiave primaria")."</label> ";
			echo "<select id=\"view_pk\" name=\"view_pk\">\n";
	
	
			foreach($campi_tabella as $k=>$campo){
				
				$view_pk_sel = ($info['view_pk']==$campo)? "selected=\"selected\"": "";
				
				echo "<option value=\"$campo\" $view_pk_sel>".$campo."</option>\n";
				
			}
			
			echo "</select>
			<div class=\"info-campo\">"._("In quanto vista si rende necessario dichiarare espliticamente la chiave primaria")."</div>\n";
		}
		
		
		
		echo "
		
		<fieldset style=\"width:60%;margin-bottom:20px; padding:15px;\">
			<legend>"._("Allegati e link")."</legend>
		";
		
		
		// IN CASO DI VISTA IMPOSTA ESPLICITAMENTE LA FONTE PER ALLEGATI E LINK
		
		if($info['table_type']=='VIEW'){
			
			$tabelle_db=prendi_tabelle($_GET['gid']);
			echo "<select id=\"fonte_al\" name=\"fonte_al\">\n";
	
	
			foreach($tabelle_db as $k=>$tab){
				
				$view_fonte_sel = ($info['fonte_al']==$tab['table_name'])? "selected=\"selected\"": "";
				
				echo "<option value=\"{$tab['table_name']}\" $view_fonte_sel>".$tab['table_name']."</option>\n";
				
			}
			
			echo "</select>
			<div class=\"info-campo\">"._("In quanto vista si rende necessario dichiarare da quale tabella debbano essere letti/inseriti gli allegati e i link")."</div>\n";
		
		}
		
			
		echo "
			<input type=\"hidden\" name=\"permetti_allegati\" id=\"permetti_allegati-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"permetti_allegati\" id=\"permetti_allegati\" value=\"1\" ".$def['permetti_allegati']." onclick=\";if(this.checked){document.getElementById('opzioni_allegati').style.display='';}else{document.getElementById('opzioni_allegati').style.display='none';}\" />
			<label for=\"permetti_allegati\">"._("Tabella con allegati")."</label>
			<div class=\"info-campo\">"._("Permette di allegare dei file (documenti o immagini) ai record di questa tabella")."</div>
			
			
				<div id=\"opzioni_allegati\" style=\"display:{$def['permetti_allegati_display']}\">
					<input type=\"hidden\" name=\"permetti_allegati_ins\" id=\"permetti_allegati_ins-hid\" value=\"0\" />
					<input type=\"checkbox\" name=\"permetti_allegati_ins\" id=\"permetti_allegati_ins\" value=\"1\" ".$def['permetti_allegati_ins']."/>
					<label for=\"permetti_allegati_ins\">"._("Permetti inserimento nuovi allegati")."</label>
					
					<br />
					
					
					<input type=\"hidden\" name=\"permetti_allegati_del\" id=\"permetti_allegati_del-hid\" value=\"0\" />
					<input type=\"checkbox\" name=\"permetti_allegati_del\" id=\"permetti_allegati_del\" value=\"1\" ".$def['permetti_allegati_del']."/>
					<label for=\"permetti_allegati_del\">"._("Permetti eliminazione allegati")."</label>
					
				</div>
			
			
			
			<input type=\"hidden\" name=\"permetti_link\" id=\"permetti_link-hid\" value=\"0\" />
			<input type=\"checkbox\" name=\"permetti_link\" id=\"permetti_link\" value=\"1\" ".$def['permetti_link']." onclick=\";if(this.checked){document.getElementById('opzioni_link').style.display='';}else{document.getElementById('opzioni_link').style.display='none';}\"  />
			<label for=\"permetti_link\">"._("Tabella con link")."</label>
			<div class=\"info-campo\">"._("Permette di collegare dei link ai record di questa tabella")."</div>
			
				<div id=\"opzioni_link\" style=\"display:{$def['permetti_link_display']}\">
					<input type=\"hidden\" name=\"permetti_link_ins\" id=\"permetti_link_ins-hid\" value=\"0\" />
					<input type=\"checkbox\" name=\"permetti_link_ins\" id=\"permetti_link_ins\" value=\"1\" ".$def['permetti_link_ins']."/>
					<label for=\"permetti_link_ins\">"._("Permetti inserimento nuovi link")."</label>
					
					<br />
					
					
					<input type=\"hidden\" name=\"permetti_link_del\" id=\"permetti_link_del-hid\" value=\"0\" />
					<input type=\"checkbox\" name=\"permetti_link_del\" id=\"permetti_link_del\" value=\"1\" ".$def['permetti_link_del']."/>
					<label for=\"permetti_link_del\">"._("Permetti eliminazione link")."</label>
					
				</div>
			
		</fieldset>
		<br /><br />
		<input type=\"hidden\" name=\"oid\" value=\"$oid\" />
		<input type=\"hidden\" name=\"gid\" value=\"$gid\" />
		<input id=\"trasversale\" type=\"hidden\" name=\"trasversale_gen\" value=\"0\" />
		
		<input type=\"submit\" name=\"invia_gen\" value=\""._("Salva impostazione generale")."\" />
		
		&nbsp;&nbsp;&nbsp;
		
		<input type=\"button\" onclick=\"if(confirm('"._("Attenzione!\\nSi vuole veramente modificare in questo modo le impostazioni per tutti i gruppi?")."')){ document.getElementById('trasversale').value='1';submit();}\" name=\"invia_gen_trasversale\" value=\""._("Salva impostazione generale per tutti i gruppi")."\" />
	
	</form>
	
	</div>\n";
		
	//-- fine impostazioni generali
	
	
	
	
	######################################################################################
	#
	#	IMPOSTAZIONI CAMPI SORT
	#
	#
	
	
	$st_sub = (isset($_GET['a']) && $_GET['a']==4) ? "" : "display:none;"; 
	
	echo "<div class=\"campi-sort\" id=\"campi-sort\" style=\"$st_sub\">\n";
	
	
	echo "<h3>"._("Ordinamento dei campi")."</h3>\n";
	
	echo "<p>"._("Attraverso questa funzione &egrave; possibile cambiare l'ordine di presentazione dei campi della tabella nella vista a scheda. I campi in grigio sono quelli al momento impostati come invisibili.<br />Per modificare l'ordine dei campi prendere le etichette e trascinarle nella posizione desiderata")."</p>
	 <form name=\"ripristina\" method=\"post\" action=\"rpc.sortcampi.php?ripristina\" >
	 
	 <input type=\"hidden\" name=\"url\" value=\"".htmlentities($_SERVER['QUERY_STRING'])."\" />
	 <input type=\"hidden\" name=\"oid\" value=\"$oid\" />
	 <input type=\"button\" onclick=\"submit()\" value=\""._("Ripristina ordinamento di default")."\" name=\"ripristina1\" />
	 
	 </form>\n";
	
	
	/* OLD SETTINGS (only vertical)
	
	list($id_reg_sort,$campi_tabella_sort,$in_visibile_sort) = prendi_colonne_frontend($oid,"id_reg,column_name,in_visibile",false);
	
	
	echo "<p id=\"list-info\" >&nbsp;</p>";
	
	echo "<div><ul id=\"firstlist\" style=\"width:200px;\">\n";
	
	
	
	foreach($campi_tabella_sort as $k=>$campo){
		
		$classe_sort = ($in_visibile_sort[$k]=='1') ? "campi-float-blu":"campi-float-grigio";
		
		echo "<li id=\"item_{$id_reg_sort[$k]}\" class=\"$classe_sort\">".$campo."</li>\n";
		
	}
	
	echo "</ul></div>";
	
	
	echo "<script type=\"text/javascript\">
 // <![CDATA[
			Sortable.create('firstlist', 
							{onUpdate:function()
								{new Ajax.Updater('list-info', '".dirname($_SERVER['PHP_SELF'])."/rpc.sortcampi.php?det=$oid&gid=$gid', 
									{onComplete:function(request){}, 
									parameters:Sortable.serialize('firstlist'), 
									evalScripts:true, 
									asynchronous:true});
									setTimeout(\"$('list-info').innerHTML = '&nbsp;'; \", 3000 );
								}
							})
 // ]]>
	</script>";

	*/
	
	
	
	
	/* NEW SETTINGS (2 columns ) */
	
	

	list($id_reg_sort,
		 $campi_tabella_sort,
		 $in_visibile_sort,
		 $data_type,
		 $in_tipo,
		 $maxsize,
		 $in_line) = prendi_colonne_frontend($oid,"id_reg,
		 										   column_name,
		 										   in_visibile,
		 										   data_type,
		 										   in_tipo,
		 										   character_maximum_length,
		 										   in_line",true);
	
	
	$next=1;
	$i=0;
	$li=array(1=>array(),2=>array());
	
	foreach($campi_tabella_sort as $k=>$campo){
		
		$tipo = ($in_tipo[$i]=='' || $in_tipo[$i]==null) ? $data_type[$i] : $in_tipo[$i];
		
		$classe_sort = ($in_visibile_sort[$k]=='1') ? "campi-float-blu":"campi-float-grigio";
		
		if($in_line[$i]!=''){
			
			if(intval($in_line[$i])===0){
				$li[1][]=array($id_reg_sort[$i],$campi_tabella_sort[$i],$tipo);
				$li[2][]=null;
				$next=1;
			}
			else{
				
				if($next==1){
					$li[1][]=array($id_reg_sort[$i],$campi_tabella_sort[$i],$tipo);
					$next=2;
				}
				else{
					$li[2][]=array($id_reg_sort[$i],$campi_tabella_sort[$i],$tipo);
					$next=1;
				}
			}
		}
		else{
		
			if( (($tipo=='varchar' || $tipo=='char') && $maxsize>100)
				|| ($tipo=='text' || $tipo=='mediumtext' || $tipo=='longtext')
				|| ($tipo=='richtext')
				|| ($tipo=='select_from')
				|| ($in_visibile_sort[$i]==0)
				){
				
				$li[1][]=array($id_reg_sort[$i],$campi_tabella_sort[$i],$tipo);
				$li[2][]=null;
				$next=1;			
			}
			else{
				if($next==1){
					$li[1][]=array($id_reg_sort[$i],$campi_tabella_sort[$i],$tipo);
					$next=2;
				}
				else{
					$li[2][]=array($id_reg_sort[$i],$campi_tabella_sort[$i],$tipo);
					$next=1;
				}
			}
		}
		
		$i++;
	}
	
	
	echo "<p id=\"list-info\" >&nbsp;</p>";
	
	?>
		
	<div class="colonna-cont">
			<div class="colonna">
			<ul class="sortabledemo" id="firstlist">
			
			<?php 
			
			foreach ($li[1] as $l){
				
				echo "\t\t<li class=\"item\" id=\"li1_".$l[0]."\">
					<div class=\"handle\">".$l[1]."</div> ".$l[2]."
				</li>
				";
				
			}
			?>
			</ul>
		</div>
		<div class="colonna">
			<ul class="sortabledemo" id="secondlist">
				<?php 
			
				foreach ($li[2] as $l){
				
				if($l==null){ echo "\t\t<li class=\"item-null\" >&nbsp;</li>\n"; }
				else{
						
					echo "\t\t<li class=\"item\" id=\"li2_".$l[0]."\">
						<div class=\"handle\">".$l[1]."</div> ".$l[2]."
					</li>
					";	
				}
			}
			?>
			</ul>
		</div>
	</div>
	 
	 <script type="text/javascript">
	 // <![CDATA[
	 
	   Sortable.create("firstlist",
	   	    {dropOnEmpty:true,
		      containment:["firstlist","secondlist"],
		      constraint:false,
		      onUpdate:function(){
		     		new Ajax.Updater('list-info',"rpc.sortcampi.php?getsort",
		     			{
		     				method:'post',
		     				postBody: Sortable.serialize('firstlist')+"&"+Sortable.serialize('secondlist')+"&oid=<?php echo $oid;?>",
		     				evalScripts:true, 
		     				asynchronous:true
		     			});
		     			setTimeout("$('list-info').innerHTML = '&nbsp;'; ", 3000 );
		     		}
		      });
	      
	      
	   Sortable.create("secondlist",
	   	    {dropOnEmpty:true,
		      containment:["firstlist","secondlist"],
		      constraint:false,
		      onUpdate:function(){
		     		new Ajax.Updater('list-info',"rpc.sortcampi.php?getsort",
		     			{
		     				method:'post',
		     				postBody: Sortable.serialize('firstlist')+"&"+Sortable.serialize('secondlist')+"&oid=<?php echo $oid;?>",
		     				evalScripts:true, 
		     				asynchronous:true
		     			});
		     			setTimeout("$('list-info').innerHTML = '&nbsp;'; ", 3000 );
		     		}
		      });
	
	 // ]]>
	 </script>
 
 	<?php
	
	echo "</div>\n";
	
	
	
	//-- fine campi-sort
	
	
	##############################################################
	#
	#	 FORM IMPOSTAZIONI SOTTOMASCHERE
	#
	#
	#
	
	
	
	$sottomaschere = prendi_sottomaschere($oid,true);
	

	
	
	
	$st_sub = (isset($_GET['a']) && $_GET['a']==3) ? "" : "display:none;"; 
	
	echo "<div class=\"tabella-sottomaschere\" id=\"tabella-sottomaschere\" style=\"$st_sub\">\n";
	
	echo "<p><a href=\"javascript:;\" onclick=\"mostra_nascondi('nuova-sottomaschera');\">"._("Nuove sottomaschere")."</a></p>\n";
	
		echo "<div id=\"nuova-sottomaschera\" style=\"display:none;\">\n";
		
			echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\">
			
			
				 <select size=\"13\" multiple=\"multiple\" name=\"new_submask[]\">
				 ";
			
			$tabelle = prendi_tabelle($gid);
			
			for($i=0;$i<count($tabelle);$i++){
				
				// test sull'esuistanza delle sottomaschere
				$SUB_esiste = (isset($sottomaschere['nome_tabella']) && in_array($tabelle[$i]['table_name'],$sottomaschere['nome_tabella'])) ? true:false;
					
				if($tabelle[$i]['id_table']!=$oid && !$SUB_esiste)
					echo "\t\t\t<option value=\"".$tabelle[$i]['id_table']."\">".$tabelle[$i]['table_name']."</option>\n";
				
			}
			
			echo "
				 </select>
				
				 <input type=\"hidden\" name=\"oid\" value=\"$oid\" />
				 <input type=\"hidden\" name=\"gid\" value=\"$gid\" />
				 
				<br /><br />
				<input type=\"submit\" name=\"sottomaschere\" value=\""._("Crea nuove sottomaschere")."\" />
			</form>\n";
		

	
		echo "</div>\n";
		
		
		## COPIA LE SOTTOMASCHERE
		
		$mat_gruppi_sub = prendi_gruppi($_GET['gid']);
	
		if(count($mat_gruppi_sub)>0){
		
			echo "<form name=\"copia_sottomaschere\" action=\"".$_SERVER['PHP_SELF']."\" method=\"post\">\n";
		
			$sel_gruppi_sub="\t<select name=\"copia_sub_gid\" id=\"copia_sub_gid\" >\n";
			
			
			foreach ($mat_gruppi_sub as $k=>$ar){
				
				$sel_gruppi_sub.="\t\t<option value=\"".$ar['gid']."\">".$ar['gid']. " - ". $ar['nome_gruppo']."</option>\n";
			}
			
			$sel_gruppi_sub.="</select>";
			
			$confirm_cp_sub ="if(confirm('"._("Se si copiano le impostazioni delle sottomaschere da un altro gruppo le attuali verranno completamente sovrascritte. \\nL\'operazione non e\' ripristinabile. \\nSi vuole procedere?")."')){submit();}";
			echo "<input type=\"hidden\" name=\"copia_sottomaschere\" value=\"1\" />\n";
			echo "<input type=\"hidden\" name=\"det\" value=\"".$_GET['det']."\" />\n";
			echo "<input type=\"hidden\" name=\"gid\" value=\"".$_GET['gid']."\" />\n";
			echo _("Applica le impostazioni sottomaschere del gruppo:")." $sel_gruppi_sub  <input type=\"button\" onclick=\"$confirm_cp_sub\" name=\"copia\" value=\" "._("Applica")." \" />\n";
			
			echo "</form>\n";
			
			unset($mat_gruppi_sub);
			unset($confirm_cp_sub);
		}
		
		
	// sottomaschere esistenti:
	
	if(count($sottomaschere)==0){
		
		echo "<p><strong>"._("Non esistono sottomaschere per questa tabella/gruppo")."</strong></p>\n";
		
		
		
		if($info['table_type']=='VIEW'){
		
				
				$tabelle_elenco=prendi_tabelle(intval($_GET['gid']));
				
				
				
				echo "<form action=\"".$_SERVER['PHP_SELF']."?det=".$_GET['det']."&amp;gid=".$_GET['gid']."\" method=\"post\" >\n";
				
				echo _("Clona da tabella:")." <select name=\"id_tabella\">\n";
				
				for($i=0;$i<count($tabelle_elenco);$i++){
					
					echo "<option value=\"".$tabelle_elenco[$i]['id_table']."\">".$tabelle_elenco[$i]['table_name']."</option>\n";
				}
				
				echo "</select>\n";
				echo " <input type=\"hidden\" name=\"clona_sottomaschere_vista\" value=\"1\" />\n";
				echo " <input type=\"hidden\" name=\"id_vista\" value=\"".$_GET['det']."\" />\n";
				echo " <input type=\"button\" onclick=\"submit();\" name=\"clona_impostazioni\" value=\" "._("clona impostazioni")." \" />\n";
				
				echo "</form>\n";
		}
		
		
	}
	else{
		
		submask_menu($oid);
		
	}
		
	
	// Dettagli sottomaschera
	
	if(isset($_GET['conf_sub'])){
		
		// creca l'id della submaschera nei risultati
		$k_sub= array_search($_GET['conf_sub'],$sottomaschere['id_submask']);
		
		
		
		echo "<h3 style=\"margin-top:60px;border-bottom:1px solid #CCC;width:75%;\">"._("Impostazioni generali sottomaschera")." <span class=\"var\">".$sottomaschere['nome_tabella'][$k_sub]."</span></h3>\n";
		
		echo "<strong>"._("Collegamento tra le tabelle")."</strong>: \n";
		
		
		
		
		echo "<form name=\"sub_gen\" action=\"".$_SERVER['PHP_SELF']."?mod_sub_gen\" method=\"post\">\n";
		
		
		#######################################################################
		#
		#
		#	 riferimenti e FK
		
		// prendo le FK
		$rif_sub = prendi_FK($sottomaschere['nome_tabella'][$k_sub],intval($_GET['gid']));
		
		$rif_sub_k=null;
		
		// ce ne sono riferite alla tabella in oggetto?
		for($i=0;$i<count($rif_sub[1]);$i++){
			
			if(preg_match("/^{$info['table_name']}\.[\w]+/",$rif_sub[1][$i])){
				
				$rif_sub_k = $i;
			}
		}
		
		if(!is_null($rif_sub_k)){
			
			$parent_consigliata = substr( $rif_sub[1][$rif_sub_k] ,  strpos($rif_sub[1][$rif_sub_k],".")+1  );
			$this_consigliata = $rif_sub[0][$rif_sub_k];
		}
		
		
		
		echo $info['table_name'].".";
		
		echo "<select name=\"sub_gen[sub_pk_parent]\">\n";
		
		// PRENDI LE COLONNE
		
		list($colonne_parent) = prendi_colonne_frontend($oid,'column_name',false);
		
		list($colonne_this) = prendi_colonne_frontend($sottomaschere['nome_tabella'][$k_sub],'column_name',false,0);
		
		
		
		
		// TESTA LA VISIBILITA' DEL CAMPO
		
		$campo_attuale_fk= $sottomaschere['campo_pk_parent'][$k_sub];
		
		$PK_fk= prendi_PK_oid($oid);
		
		/*var_dump($PK_fk);
		var_dump($sottomaschere);*/
		
		if($campo_attuale_fk!=$PK_fk[0] && $campo_attuale_fk!=''){
			
			$sql_vis_fk="SELECT in_visibile FROM {$db1['frontend']}.registro_col 
						WHERE id_table='$oid' AND column_name='$campo_attuale_fk'";
			$q_vis_fk=vmsql_query($sql_vis_fk,$link);
			
			list($in_visibile_fk)=vmsql_fetch_row($q_vis_fk);
			
			$campo_fk_visibile = ($in_visibile_fk) ? true:false;
			
		}
		else{
			$campo_fk_visibile=true;
		}
		
		
		

		for($i=0;$i<count($colonne_parent);$i++){
			
			$aggiunta_sub_parent = ($parent_consigliata==$colonne_parent[$i]) ?	 " (consigliata)" : "";
			
			$sel_sub_parent = ($colonne_parent[$i]==$sottomaschere['campo_pk_parent'][$k_sub]) ? "selected=\"selected\"" :"";
			
			echo "\t\t<option value=\"".$colonne_parent[$i]."\" $sel_sub_parent>".$colonne_parent[$i].$aggiunta_sub_parent."</option>\n";
		}
		
		echo "</select>\n";
		
		
		
		echo " ---<strong>&gt;</strong> ".$sottomaschere['nome_tabella'][$k_sub].".";
		
		echo "<select name=\"sub_gen[sub_fk_this]\">\n";
		
		$OPT_SUB_THIS="";
		$OPT_SUB_THIS_ORDER="";
		
		for($j=0;$j<count($colonne_this);$j++){
			
			$aggiunta_sub_this = ($this_consigliata==$colonne_this[$j]) ?	 " (consigliata)" : "";
			
			$sel_sub_this = ($colonne_this[$j]==$sottomaschere['campo_fk_sub'][$k_sub]) ? "selected=\"selected\"" :"";
			
			$sel_sub_this_ord = ($colonne_this[$j]==$sottomaschere['orderby_sub'][$k_sub]) ? "selected=\"selected\"" :"";

			
			$OPT_SUB_THIS.= "\t\t<option value=\"".$colonne_this[$j]."\" $sel_sub_this>".$colonne_this[$j].$aggiunta_sub_this."</option>\n";
			$OPT_SUB_THIS_ORDER.= "\t\t<option value=\"".$colonne_this[$j]."\" $sel_sub_this_ord>".$colonne_this[$j]."</option>\n";
		}
		
		echo $OPT_SUB_THIS;
		
		echo "</select><div class=\"info-campo\">"._("Imposta il collegamento tra i record della tabella e i record della sottomaschera")."</div>\n";
		
		
		
		
		
		// MOSTRA AVVISO IN CASO DI CAMPO NON VISIBILE
		
		if(!$campo_fk_visibile){
			
			echo "<span style=\"color:red;font-weight:bold;\">
				"._("ATTENZIONE! Il campo della tabella padre non &egrave; chiave primaria e non &egrave; impostato come visibile!")." "._('Quando si imposta un campo che non sia la chiave primaria questo deve essere visibile. In questo caso il collegamento con la tabella non funzioner&agrave;<br />Impostare il campo come visibile (pu&ograve essere anche un campo nascosto) dalle Impostazioni Campi')."</span><br /><br />\n";
		}
		//---------------------------------------------
		
		
		
		
		
		
		$sub_select_check= ($sottomaschere['sub_select'][$k_sub]=='1') ? "checked=\"checked\"" : "";
		$sub_insert_check= ($sottomaschere['sub_insert'][$k_sub]=='1') ? "checked=\"checked\"" : "";
		$sub_update_check= ($sottomaschere['sub_update'][$k_sub]=='1') ? "checked=\"checked\"" : "";
		$sub_delete_check= ($sottomaschere['sub_delete'][$k_sub]=='1') ? "checked=\"checked\"" : "";
		$tipo_vista_check1= ($sottomaschere['tipo_vista'][$k_sub]=='tabella') ? "checked=\"checked\"" : "";
		$tipo_vista_check2= ($sottomaschere['tipo_vista'][$k_sub]=='scheda') ? "checked=\"checked\"" : "";
		
		$sel_orderby_sub_sort_ASC = ($sottomaschere['orderby_sub_sort'][$k_sub]=="ASC") ? "selected=\"selected\"" : "";
		$sel_orderby_sub_sort_DESC = ($sottomaschere['orderby_sub_sort'][$k_sub]=="DESC") ? "selected=\"selected\"" : "";
		
		// imposta un default su SCHEDA
		if($tipo_vista_check1=='' && $tipo_vista_check2=='') 
			$tipo_vista_check2="checked=\"checked\"";
		
		
		echo "
		
		<label for=\"nome_frontend\">"._("Nome della sottomaschera")."</label><br/> 
		<input type=\"text\" name=\"sub_gen[nome_frontend]\"  id=\"nome_frontend\" value=\"".$sottomaschere['nome_frontend'][$k_sub]."\" maxlength=\"240\" size=\"35\" />
		<div class=\"info-campo\">"._("Nome della sottomaschera che apparir&agrave; all'utente")."</div>
		";
		
		
		/*<label for=\"tipo_vista_1\">"._("Modalit&agrave; di visualizzazione dei dati")."</label><br/> 
		<input type=\"radio\" name=\"sub_gen[tipo_vista]\"  id=\"tipo_vista_1\"  value=\"scheda\" $tipo_vista_check2 /> "._("Schede")."
		<input type=\"radio\" name=\"sub_gen[tipo_vista]\"  id=\"tipo_vista_2\" value=\"tabella\" $tipo_vista_check1 /> "._("Tabella")."
		<div class=\"info-campo\">"._("Come mostrare i dati. La vista tabella si consiglia per sottomaschere con uno o massimo due campo di piccola dimensione")."</div>*/
		
		echo "<input type=\"hidden\" name=\"sub_gen[tipo_vista]\"  id=\"tipo_vista_1\"  value=\"scheda\" />\n";

		echo "
		<input type=\"hidden\" name=\"sub_gen[sub_select]\" value=\"0\" />
		<input type=\"checkbox\" name=\"sub_gen[sub_select]\" id=\"sub_select\" value=\"1\" $sub_select_check/>
		<label for=\"sub_select\">"._("Maschera visibile (SELECT)")."</label>
		<div class=\"info-campo\">"._("Imposta se la sottomaschera deve essere visibile per questo gruppo")."</div>
		
		<input type=\"hidden\" name=\"sub_gen[sub_insert]\" value=\"0\" />
		<input type=\"checkbox\" name=\"sub_gen[sub_insert]\" id=\"sub_insert\" value=\"1\" $sub_insert_check/>
		<label for=\"sub_insert\">"._("Diritti scrittura (INSERT)")."</label>
		<div class=\"info-campo\">"._("Imposta se &egrave; possibile inserire record attraverso la sottomaschera")."</div>
		
		<input type=\"hidden\" name=\"sub_gen[sub_update]\" value=\"0\" />
		<input type=\"checkbox\" name=\"sub_gen[sub_update]\" id=\"sub_update\" value=\"1\" $sub_update_check/>
		<label for=\"sub_update\">"._("Diritti modifica (UPDATE)")."</label>
		<div class=\"info-campo\">"._("Imposta se &egrave; possibile modificare record attraverso la sottomaschera")."</div>
		
		<input type=\"hidden\" name=\"sub_gen[sub_delete]\" value=\"0\" />
		<input type=\"checkbox\" name=\"sub_gen[sub_delete]\" id=\"sub_delete\" value=\"1\" $sub_delete_check/>
		<label for=\"sub_delete\">"._("Diritti eliminazione (DELETE)")."</label>
		<div class=\"info-campo\">"._("Imposta se &egrave; possibile cancellare record attraverso la sottomaschera")."</div>
		
		<label for=\"orderby_sub\">"._("Ordina record sottomaschera per:")."</label>
		<select id=\"orderby_sub\" name=\"sub_gen[orderby_sub]\">
			$OPT_SUB_THIS_ORDER
		</select>
		
		<select id=\"orderby_sub_sort\" name=\"sub_gen[orderby_sub_sort]\">
			<option value=\"ASC\" $sel_orderby_sub_sort_ASC>"._("Ascendente")."</option>
			<option value=\"DESC\" $sel_orderby_sub_sort_DESC>"._("Discendente")."</option>
		</select>		
		<div class=\"info-campo\">"._("Imposta l'ordinamento dei record della sottomaschera")."</div>
		
		
		
		<label for=\"max_records\">"._("Numero di record max per la sottomaschera")."</label><br/> 
		<input type=\"text\" name=\"sub_gen[max_records]\"  id=\"max_records\" value=\"".$sottomaschere['max_records'][$k_sub]."\" maxlength=\"3\" size=\"5\" />
		<div class=\"info-campo\">"._("Numero massimo di record per la sottomaschera. Si sconsiglia di tenere questo numero molto alto in quanto potrebbe causare un rallentamento nel caricamento della sottomaschera.")."</div>
		
		<input type=\"hidden\" name=\"sub_gen[id_submask]\" value=\"".$sottomaschere['id_submask'][$k_sub]."\" />
		<input type=\"hidden\" name=\"sub_gen[oid]\" value=\"".intval($_GET['det'])."\" />
		
		<input type=\"submit\" name=\"invia_sub_generali\" value=\""._("Salva impostazioni generali sottomaschera")."\" />
		
		";
		
		echo "</form>\n";
		
		
		
		
		
		
		
		###############################################################################################################
		#
		#	IMPOSTAZIONE CAMPI PER LA SOTTOMASCHERA
		#
		#
		#
		
		
		if($sottomaschere['data_modifica'][$k_sub]!=''){
		
			echo "<a name=\"submask_field\"></a>\n";
		
			echo "<h3 style=\"margin-top:60px;border-bottom:1px solid #CCC;width:75%;\">"._("Impostazioni per i campi della sottomaschera")." <span class=\"var\">".$sottomaschere['nome_tabella'][$k_sub]."</span></h3>\n";
		
		
			echo "\t<form method=\"post\" action=\"".$_SERVER['PHP_SELF']."?gid=".$_GET['gid']."&amp;mod_sub_campi\">\n";
	
		
		
			# Inizia a prendere i campi
			
			
			$sql_sub_cols = "SELECT  c.*
								
								FROM {$db1['frontend']}.registro_submask_col c, {$db1['frontend']}.registro_submask t
								WHERE t.nome_tabella='".$sottomaschere['nome_tabella'][$k_sub]."'
								AND t.id_table=$oid
								AND t.id_submask = c.id_submask
								ORDER BY c.ordinal_position";
			
			$q_sub_cols=vmsql_query($sql_sub_cols,$link);
			
			$matrice_sub_col=vmsql_fetch_assoc_all($q_sub_cols);
			
			$matrice_sub_rev=vmsql_reverse_matrix($matrice_sub_col);
			
			$array_sub_pk=prendi_all_PK($sottomaschere['nome_tabella'][$k_sub],0);
					   
			while(list($k,$array_sub_val)=each($matrice_sub_col)){
				
				
				if($array_sub_val['column_name']==$sottomaschere['campo_fk_sub'][$k_sub]){
					
					
					echo tratta_campo_submask($array_sub_val, $array_sub_pk, $rif_sub[0], $rif_sub[1],$sottomaschere['campo_pk_parent'][$k_sub],$oid);
					
			
				}
				else{
					echo tratta_campo_submask($array_sub_val, $array_sub_pk, $rif_sub[0], $rif_sub[1]);
				}
			}
			
			echo "\t\t<input type=\"hidden\" name=\"oid\" value=\"".intval($_GET['det'])."\" />\n";
			echo "\t\t<input type=\"hidden\" name=\"gid\" value=\"".intval($_GET['gid'])."\" />\n";
			
			echo "\t\t<input type=\"hidden\" name=\"id_submask\" value=\"".intval($_GET['conf_sub'])."\" />\n";
			
			echo "\t\t<input type=\"button\" name=\"invia_campi\" value=\""._("Salva impostazioni campi")."\" onclick=\"submit()\" />\n";
			
			echo "\t</form>\n";
			
		}
		
		
	}
	
	
	echo "</div>\n";
	
		
	//-- fine impostazioni sottomaschere
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	###############################################################################
	#
	# FORM campi
	#
	
	$st_campi = (isset($_GET['a']) && $_GET['a']==2) ? "" : "display:none;"; 
	
	echo "<div id=\"tabella-campi\" class=\"tabella-campi\" style=\"$st_campi\">\n";
	
	
	if(isset($_GET['feed']) && $_GET['feed']=='copia_ok'){
		
		echo "<p class=\"feed-mod-ok\">"._("Impostazioni campi copiate correttamente")."</p>\n";
		
	}
	
	// COPIA IMPOSTAZIONI DA ALTRO GRUPPO
	
	$mat_gruppi = prendi_gruppi($_GET['gid']);
	
		if(count($mat_gruppi)>0){
		
		echo "\t<form method=\"post\" action=\"".$_SERVER['PHP_SELF']."\" id=\"form_copia_campi\">\n"; 
		
		
		
		$sel_gruppi="\t<select name=\"copia_campi_gid\" id=\"copia_campi_gid\" >\n";
		
		
		foreach ($mat_gruppi as $k=>$ar){
			
			$sel_gruppi.="\t\t<option value=\"".$ar['gid']."\">".$ar['gid']. " - ". $ar['nome_gruppo']."</option>\n";
		}
		
		$sel_gruppi.="</select>";
		
		$confirm_cp ="if(confirm('"._("Se si copiano le impostazioni da un altro gruppo le attuali verranno completamente sovrascritte. \\nL\'operazione non e\' ripristinabile. \\nSi vuole procedere?")."')){submit();}";
		echo "<input type=\"hidden\" name=\"copia_campi\" value=\"1\" />\n";
		echo "<input type=\"hidden\" name=\"det\" value=\"".$_GET['det']."\" />\n";
		echo "<input type=\"hidden\" name=\"gid\" value=\"".$_GET['gid']."\" />\n";
		echo _("Applica le impostazioni campi dal gruppo:")." $sel_gruppi  <input type=\"button\" onclick=\"$confirm_cp\" name=\"copia\" value=\" Applica \" />\n";
		
		echo "</form>\n";
		
		unset($mat_gruppi);
	}
	
	//------------------------------------
	
	
	echo "\t<form method=\"post\" action=\"".$_SERVER['PHP_SELF']."\">\n";
	
	
					   
	while(list($k,$array_val)=each($matrice_col)){
		
		echo tratta_campo($array_val, $array_pk, $array_fk, $colref_fk);
	}
	
	echo "\t\t<input type=\"hidden\" name=\"oid\" value=\"$oid\" />\n";
	
	echo "\t\t<input type=\"hidden\" name=\"gid\" value=\"$gid\" />\n";
	
	echo "\t\t<input id=\"trasversale_campi\" type=\"hidden\" name=\"trasversale_campi\" value=\"0\" />\n";
	
	
	echo "\t\t<input type=\"hidden\" name=\"risposta_sql_all\" id=\"risposta_sql_all\" value=\"\" />\n";

	
	
	echo "\t\t<input type=\"button\" name=\"invia_campi\" value=\""._("Salva impostazioni campi")."\" onclick=\"submit();\" />\n "; //onclick=\"if(test_campi()=='1'){submit();}else{alert('Alcune impostazioni SQL sembrano errate, oppure si � lasciato vuoto un campo SQL. Prego verificare');}\" />
		
	echo "\t\t<input type=\"button\" onclick=\"if(confirm('"
	     ._("Attenzione! Si vuole veramente modificare in questo modo le impostazioni per tutti i gruppi?") 
	     ."')){ document.getElementById('trasversale').value='1';submit();}\" name=\"invia_gen_trasversale\" "
	     ."value=\"". _("Salva impostazione dei campi per tutti i gruppi") ."\" />\n";
	
	
	
	echo "\t</form>\n";
	
	echo "</div>\n";
	
	
	echo closeLayout1();
}




// ----------------------------------  FINE FUNZIONI  -----------------------------------------




















// --------------------------------- AZIONI ---------------------------------------------------












###################################################################################################
#
## INSERIMENTO INFO GENERALI DI TABELLA
#
if(isset($_POST['invia_gen']) || isset($_POST['trasversale_gen'])){
	
	
	$_dati_gen=pulisci_dom($_POST);
	
	$clausola_view_pk = (isset($_dati_gen['view_pk'])) ? "view_pk='".$_dati_gen['view_pk']."'," : "";
	$clausola_view_fonte_al = (isset($_dati_gen['fonte_al'])) ? "fonte_al='".$_dati_gen['fonte_al']."'," : "";
	
	
	$sql_gen="UPDATE {$db1['frontend']}.registro_tab 
				SET orderby='".implode(",",$_dati_gen['orderby'])."', 
					orderby_sort='".implode(",",$_dati_gen['orderby_sort'])."', 
					visibile=".intval($_dati_gen['visibile']).",
					in_insert=".intval($_dati_gen['in_insert']).",
					in_duplica=".intval($_dati_gen['in_duplica']).",
					in_update=".intval($_dati_gen['in_update']).",
					in_delete=".intval($_dati_gen['in_delete']).",
					in_export=".intval($_dati_gen['in_export']).",
					in_import=".intval($_dati_gen['in_import']).",
					permetti_allegati=".intval($_dati_gen['permetti_allegati']).",
					permetti_allegati_ins=".intval($_dati_gen['permetti_allegati_ins']).",
					permetti_allegati_del=".intval($_dati_gen['permetti_allegati_del']).",
					permetti_link=".intval($_dati_gen['permetti_link']).",
					permetti_link_ins=".intval($_dati_gen['permetti_link_ins']).",
					permetti_link_del=".intval($_dati_gen['permetti_link_del']).",
					$clausola_view_pk
					$clausola_view_fonte_al
					data_modifica=".time()."
				WHERE id_table=".intval($_dati_gen['oid']);
	
	if($_dati_gen['trasversale_gen']=='1'){
		
		$q_sub_trasv=vmsql_query("SELECT table_name FROM {$db1['frontend']}.registro_tab WHERE id_table=".intval($_dati_gen['oid']),$link);
		
		list($table_name)=vmsql_fetch_row($q_sub_trasv);
		
		$sql_gen.=" OR table_name='$table_name'";
	}
	

	
	$q_gen=vmsql_query($sql_gen,$link);
	
	if(vmsql_affected_rows($link,$q_gen)>0){
		if($_dati_gen['trasversale_gen']=='1'){
			
			header("Location: ".$_SERVER['PHP_SELF']."?gid=".$_dati_gen['gid']."&feed=ok_gen_trasversale&det=".$_dati_gen['oid']."&a=1");
		}
		else{
			
			header("Location: ".$_SERVER['PHP_SELF']."?gid=".$_dati_gen['gid']."&feed=ok_gen&det=".$_dati_gen['oid']."&a=1");
		}
	}
	else{
		header("Location: ".$_SERVER['PHP_SELF']."?gid=".$_dati_gen['gid']."&feed=ko_gen&det=".$_dati_gen['oid']."&a=1");
	}
	
	exit;
}



###################################################################################################
#
## COPIA IMPOSTAZIONI DEI CAMPI DA UN GUPPO AD UN ALTRO
#
if(isset($_POST['copia_campi'])){
	
	require_once("./gestione_registro.inc.php");
	
	// prendi id_tabella di destinazione
	$nome_tabella_fonte = oid2name($_POST['det']);
	$oid_tabella_fonte= name2oid($nome_tabella_fonte,$_POST['copia_campi_gid']);
	
	$esito_copia= copia_impostazione_campi($oid_tabella_fonte,$_POST['det']);
	
	if($esito_copia)
		header("Location: ".$_SERVER['PHP_SELF']."?det=".$_POST['det']."&gid=".$_POST['gid']."&a=2&feed=copia_ok");
	exit;
	
}




###################################################################################################
#
## COPIA IMPOSTAZIONI DELLE SOTTOMASCHERE DA UN GUPPO AD UN ALTRO
#
if(isset($_POST['copia_sottomaschere'])){
	
	require_once("./gestione_registro.inc.php");
	
	// prendi id_tabella di destinazione
	$nome_tabella_fonte = oid2name($_POST['det']);
	$oid_tabella_fonte= name2oid($nome_tabella_fonte,$_POST['copia_sub_gid']);
	
	copia_impostazione_sottomaschere($_POST['gid'],$_POST['copia_sub_gid'],$oid_tabella_fonte,$_POST['det']);
	
	header("Location: ".$_SERVER['PHP_SELF']."?det=".$_POST['det']."&gid=".$_POST['gid']."&a=3&feed=copia_ok");
	exit;
	
}





###################################################################################################
#
## CLONAZIONE IMPOSTAZIONI SOTTOMASCHERE DA TABELLA A VISTA AD ESSA RELATIVA
#
if(isset($_POST['clona_sottomaschere_vista'])){
	
	require_once("./gestione_registro.inc.php");
	
	$ID_TABELLA_ORIGINE= (int) $_POST['id_tabella'];
	$ID_VISTA_DESTINAZIONE= (int) $_POST['id_vista'];
	
	copia_sottomaschere_viste($ID_VISTA_DESTINAZIONE,$ID_TABELLA_ORIGINE);
	
	header("Location: ".$_SERVER['PHP_SELF']."?det=".$ID_VISTA_DESTINAZIONE."&gid=".$_GET['gid']."&a=3");
	exit;
	
}



###################################################################################################
#
## INSERIMENTO INFO SOTTOMASCHERE DI TABELLA
#
if(isset($_POST['sottomaschere'])){
	
	require_once("./gestione_registro.inc.php");
	
	
	$_dati_gen=pulisci_dom($_POST);
	
	$aff=0;
	
	for($i=0;$i<count($_dati_gen['new_submask']);$i++){
		
		$esito_inizializzazione_sub = inizializza_sottomaschera($_dati_gen['oid'], oid2name($_dati_gen['new_submask'][$i]));
	}
	
	
	
	if($esito_inizializzazione_sub){
		header("Location: ".$_SERVER['PHP_SELF']."?gid=".$_dati_gen['gid']."&feed=ok_new_sub&det=".$_dati_gen['oid']."&a=3");
	}
	else{
		header("Location: ".$_SERVER['PHP_SELF']."?gid=".$_dati_gen['gid']."&feed=ko_new_sub&det=".$_dati_gen['oid']."&a=3");
	}
	
	
	exit;
}


###################################################################################################
#
## INSERIMENTO INFO CAMPI DELLA  TABELLA
#

if(isset($_POST['campo'])){
	
	$gid=(int) $_POST['gid'];
	
	$campo=pulisci_dom($_POST['campo']);
	
	# contatore per le righe coinvolte
	$affected=0;
	
	foreach($campo as $k=>$val){
		$sql="UPDATE {$db1['frontend']}.registro_col 
			  SET in_visibile='".$val['in_visibile']."',
			  in_richiesto='".$val['in_richiesto']."',
			  in_suggest='".$val['in_suggest']."',
			  in_tipo='".$val['in_tipo']."',
			  in_table='".$val['in_table']."',
			  alias_frontend='".$val['alias_frontend']."'
				";
				
			if(isset($val['tipo_altro']) || isset($val['hid_enum'])){
				
				// Caso selezione tra valori indicati
				if($val['in_tipo']=="select"){
					$val['tipo_altro']=preg_replace("'\r'","",$val['tipo_altro']);
					$val['tipo_altro']=preg_replace("'\n'","[|]",$val['tipo_altro']);
				}
				elseif ($val['in_tipo']=="select_enum" ){
					$val['tipo_altro']=preg_replace("'\r'","",$val['hid_enum']);
					$val['tipo_altro']=preg_replace("','","[|]",$val['hid_enum']);
				}
				
				$altro=addslashes(stripslashes($val['tipo_altro']));
			}
			else{
				$altro="";
			}
			
			if($altro!=""){
			$sql.=", in_default='".$altro."'
			";
			}
			
			if(isset($val['extra']) && $val['in_tipo']=="hidden"){
				
				$sql.=", extra='".$val['extra']."' ";
			}
			
			
			$sql.=" WHERE id_reg=".intval($k);
		
//			echo $sql;
			
			$q_campi=vmsql_query($sql,$link,true);
			
			$affected+= vmsql_affected_rows($link,$q_campi);
			
		}
		
		
	
	
	if($affected>0){
		header("Location: ".$_SERVER['PHP_SELF']."?gid=$gid&feed=ok_campi&det=".intval($_POST['oid'])."&a=2");
	}
	else{
		header("Location: ".$_SERVER['PHP_SELF']."?gid=$gid&feed=ko_campi&det=".intval($_POST['oid'])."&a=2");
	}
		
	
	exit;
}

###############################################################################################
#
#		MODIFICA IMPOSTAZIONI GENERALI DELLA SOTTOMASCHERA
#
#

if(isset($_GET['mod_sub_gen']) && isset($_POST['sub_gen'])){
	
	
	$dati_gen_sub =	pulisci_dom($_POST['sub_gen']);
	
	$sql_update_sub = sprintf("UPDATE ".$db1['frontend'].".registro_submask 
					   SET sub_select=%d,
					    sub_insert=%d,
					    sub_update=%d,
					    sub_delete=%d,
					    nome_frontend='%s',
					    campo_pk_parent='%s',
					    campo_fk_sub='%s',
					    orderby_sub='%s',
					    orderby_sub_sort='%s',
					    max_records=%d,
					    data_modifica='%d',
					    tipo_vista='%s'
					   
					   WHERE id_submask=%d
										   
					   ",
						$dati_gen_sub['sub_select'],
						$dati_gen_sub['sub_insert'],
						$dati_gen_sub['sub_update'],
						$dati_gen_sub['sub_delete'],
						$dati_gen_sub['nome_frontend'],
						$dati_gen_sub['sub_pk_parent'],
						$dati_gen_sub['sub_fk_this'],
						$dati_gen_sub['orderby_sub'],
						$dati_gen_sub['orderby_sub_sort'],
						$dati_gen_sub['max_records'],
						time(),
						$dati_gen_sub['tipo_vista'],
						$dati_gen_sub['id_submask']);
						
	$q_sub_up=vmsql_query($sql_update_sub,$link);
	
	$aff_sub_upd=vmsql_affected_rows($link,$q_sub_up);
	
	if($aff_sub_upd>0){
		header("Location: ".$_SERVER['PHP_SELF']."?gid=$gid&feed=ok_sub_upd&det=".intval($dati_gen_sub['oid'])."&conf_sub=".intval($dati_gen_sub['id_submask'])."&a=3");
	}
	else{
		header("Location: ".$_SERVER['PHP_SELF']."?gid=$gid&feed=ko_sub_upd&det=".intval($dati_gen_sub['oid'])."&conf_sub=".intval($dati_gen_sub['id_submask'])."&a=3");
	}
	
	
	
	exit;
}


#############################################################
#
#	MODIFICA CAMPI DELLA SOTTOMASCHERA
#
#

if(isset($_GET['mod_sub_campi'])){
	
	
	$campo_sub=pulisci_dom($_POST['campo_sub']);
	
	
	$gid=(int) $_GET['gid'];
	
	$ID_SUBMASK = (int) $_POST['id_submask'];
	
	
	
	# contatore per le righe coinvolte
	$affected=0;
	
	vmsql_begin($link);
	
	foreach($campo_sub as $k=>$val){
		$sql="UPDATE {$db1['frontend']}.registro_submask_col
			  SET in_visibile='".$val['in_visibile']."',
			  in_richiesto='".$val['in_richiesto']."',
			  in_tipo='".$val['in_tipo']."',
			  alias_frontend='".$val['alias_frontend']."'
				";
				
			if(isset($val['tipo_altro'])){
				
				// Caso selezione tra valori indicati
				if($val['in_tipo']=="select"){
					$val['tipo_altro']=preg_replace("'\r'","",$val['tipo_altro']);
					$val['tipo_altro']=preg_replace("'\n'","[|]",$val['tipo_altro']);
				}
				
				$altro=addslashes(stripslashes($val['tipo_altro']));
			}
			elseif(isset($val['in_default'])){
				
				$altro=$val['in_default'];
			}
			else{
				$altro="";
			}
			
			if($altro!="")
			$sql.=", in_default='".$altro."'
			";
			
			$sql.=" WHERE id_reg_sub=".intval($k);
		
//			echo "\n\n$sql\n\n";
			
			$q_campi=vmsql_query($sql,$link,true);
			
			$affected+= vmsql_affected_rows($link,$q_campi);
		}
		
		
		
		
		if($affected>0){
			vmsql_commit($link);
			header("Location: ".$_SERVER['PHP_SELF']."?gid=$gid&feed=ok_sub_upd&det=".intval($_POST['oid'])."&conf_sub=".intval($_POST['id_submask'])."&a=3");
		}
		else{
			
			vmsql_rollback($link);
			header("Location: ".$_SERVER['PHP_SELF']."?gid=$gid&feed=ko_sub_upd&det=".intval($_POST['oid'])."&conf_sub=".intval($_POST['id_submask'])."&a=3");
		}
		
	
	exit;
	
	
}



# Funzioni di modifica di massa
if(isset($_GET['mass']) && is_numeric($_GET['gid'])){
	
	
	
	switch($_GET['mass']){
	
		case 'visibile_all': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET visibile=1 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
		case 'visibile_none': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET visibile=0 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
		case 'insert_all': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET in_insert=1 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
		case 'insert_none': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET in_insert=0 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
		case 'update_all': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET in_update=1 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
		case 'update_none': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET in_update=0 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
		case 'delete_all': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET in_delete=1 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
		case 'delete_none': 
			$q_mass=vmsql_query("UPDATE {$db1['frontend']}.registro_tab SET in_delete=0 WHERE gid=".intval($_GET['gid']),$link);
			$esito=vmsql_affected_rows($link,$q_mass);
		break;
	
	}
	
	if(isset($esito) && $esito>0){
		
		header("Location: ".$_SERVER['PHP_SELF']."?gid=".intval($_GET['gid'])."&feed=ok_mass");
		exit;
	}
	
}

// -- Fine funzioni modifica di massa

if(isset($_POST['id_del_submask'])){
	
	// elimina la sottomaschera
	
	$q=vmsql_query("DELETE FROM ".$db1['frontend'].".registro_submask WHERE id_submask=".intval($_POST['id_del_submask']),$link);
	
	header("Location: ".$_SERVER['PHP_SELF']."?det=".intval($_POST['oid'])."&gid=".intval($_POST['gid'])."&a=3");
	exit;
}





if(isset($_GET['det']) && (int) $_GET['det']>0){
	
	// mostra i dettagli della tabella
	$oid= (int) $_GET['det'];
	tab_dett($oid,$_GET['gid']);
}
else{
	
	$gid= (int) $_GET['gid'];
	
	// se � selezionato l'ordine
	if(isset($_GET['ord'])) {
		
		tab_menu($gid,intval($_GET['ord']));  
	}
	else{
		
		tab_menu($gid);  
	}
	
	// mostra la lista tabelle
	
}


?>