<?php
/**
 * Sono qui riportati i registri/gruppi e le operazioni eseguibili sugli stessi. 
 * 
 * @desc File di pagina dei registri
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: menu_registri.php 262 2009-04-24 18:58:09Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */


require_once("../inc/conn.php");
require_once("../inc/layouts.php");
require_once("../inc/func.comuni.php");

 proteggi(3);


	#######################################################
	#
	#	OPZIONE DI MODIFICA DEL GRUPPO
	#

	if(isset($_GET['modifica_gid']) && isset($_GET['gid'])){
		
		$files = array("sty/admin.css","sty/tabelle.css");
		
		$OUT = openLayout1(_("Gestione Gruppi"),$files);
	
		$OUT.= "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> "
			   ."&raquo; <a href=\"".basename($_SERVER['PHP_SELF'])."\">"._("menu gruppi e registri")."</a> &raquo; "._("modifica gruppo")."</div>";
	
		$OUT.= "<h1>"._("Modifica gruppo/registro")."</h1>\n";
		
		$OUT.="<img src=\"../img/registri.gif\" class=\"img-float\" alt=\""._("impostazioni registri")."\" />\n";
		
		echo $OUT;
		
		// Prendi i dati del gruppo registro
		
		$GID = intval($_GET['gid']);
		
		$qg = vmsql_query("SELECT *
					  FROM {$db1['frontend']}.gruppo g
				      WHERE gid=$GID",$link);
		
		if(vmsql_num_rows($qg)!=1){
			
			echo "<p><strong>"._("Attenzione!")."</strong> "._("Gruppo inesistente.")."<br/>";
		}
		else{
			$RS = vmsql_fetch_assoc($qg);
			
			// FEEDBACK NOME ERRATO
			if(isset($_GET['feed'])){
				
				if($_GET['feed']=='nome_ko')
					echo "<div class=\"feed-mod-ko\">"._("Attenzione!")." "._("Il nome deve contenere solo lettere, numeri ed il carattere underscore, senza spazi, n&eacute; accenti")."</div><br />";
				
				elseif($_GET['feed']=='mod_ok')
					echo "<div class=\"feed-mod-ok\">"._("Modifiche effettuate correttamente")."</div><br />";	
					
				elseif($_GET['feed']=='mod_ko')
					echo "<div class=\"feed-mod-ko\">"._("Nessuna modifica effettuata")."</div><br />";
				
			}
			
			
			echo "
			
		<form action=\"".$_SERVER['PHP_SELF']."?gid=$GID&amp;esegui_modifica\" method=\"post\">
			
			<label for=\"nome_g\" >"._("Nome gruppo (solo lettere, numeri e <em>underscore</em>) ")."</label><br />
			<input type=\"text\" name=\"nome_g\" id=\"nome_g\" value=\"".$RS['nome_gruppo']."\" />
			<br /><br />
			
			<label for=\"descrizione_g\" >"._("Descrizione gruppo")."</label><br />
			<input type=\"text\" name=\"descrizione_g\" id=\"descrizione_g\" value=\"".$RS['descrizione_gruppo']."\" size=\"80\" />
			<br /><br />
			
			<input type=\"hidden\" name=\"gid\" value=\"$GID\" />
			<input type=\"submit\" name=\"Modifica\" value=\" "._("Modifica")." \" />
			
		</form>
			
			";
		}
		echo closeLayout1();
		
		exit;
		
	}
	elseif(isset($_GET['esegui_modifica']) && isset($_POST['gid'])){
		
		$GID = intval($_POST['gid']);
		
		
		if(trim($_POST['nome_g'])!="" &&  !preg_match("'[\W]+'",trim($_POST['nome_g']))){
			
			$sql = "UPDATE ".$db1['frontend'].".gruppo SET nome_gruppo='".trim($_POST['nome_g'])."'
					, descrizione_gruppo='".addslashes(stripslashes(trim($_POST['descrizione_g'])))."' 
					WHERE gid=".$GID;
			
			$q=vmsql_query($sql,$link);
			
			if(vmsql_affected_rows($link,$q)==1){
				header("Location: ".$_SERVER['PHP_SELF']."?gid=".$GID."&modifica_gid&feed=mod_ok");
			}
			else{
				header("Location: ".$_SERVER['PHP_SELF']."?gid=".$GID."&modifica_gid&feed=mod_ko");
			}
			
		}
		else{
			header("Location: ".$_SERVER['PHP_SELF']."?gid=".$GID."&modifica_gid&feed=nome_ko");
			
		}
		
		exit;
		
	}




	$files = array("sty/admin.css","sty/tabelle.css");

	$OUT = openLayout1(_("Gestione Gruppi"),$files);
	
	$OUT.= "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> &raquo; "._("menu gruppi e registri")."</div>";
	
	$OUT.= "<h1>"._("Menu gruppi/registri")."</h1>\n";
	

	// Messaggio di feedback nel caso si stiano eliminando un gruppo
	if(isset($_GET['msg']) && $_GET['msg']=='gruppo_eliminato'){
		
		$OUT.= "<p class=\"feed-mod-ok\">"._("Record eliminato correttamente")."</p>\n";
	}
	
	$OUT.="<img src=\"../img/registri.gif\" class=\"img-float\" alt=\""._("impostazioni registri")."\" />\n";
	
	
	// test per inizializzare
	$q_init= vmsql_query("SELECT g.gid
					  FROM {$db1['frontend']}.gruppo g
				      WHERE g.gid=-1
				      ",$link);
	
	$num_init = vmsql_num_rows($q_init);
	
	
	
	if($num_init==1){
		
		
		// NON CI SONO GRUPPI.
		// Se � stato mandato il comando di inizializzazione esegui la procedura
		
		if(isset($_GET['initreg'])){
			include_once("./gestione_registro.inc.php");
			
			
			$init_reg = inizializza_registro();
			
			if($init_reg){
				header("Location: ".$_SERVER['PHP_SELF']."?feed=ok");
				exit;
			}
			else{
				header("Location: ".$_SERVER['PHP_SELF']."?feed=ko");
				exit;
			}
			
		}
		
		
		$OUT.= "<p>"._("Non esistono attualmente gruppi nel database.")."<br/>
		<a href=\"".$_SERVER['PHP_SELF']."?initreg\">"._("Inizializza il registro")."</a></p>\n";
	}
	
	else{
	
	
	// prendi i gruppi
	$qg = vmsql_query("SELECT g.gid, g.nome_gruppo, g.descrizione_gruppo, g.data_gruppo , count(u.gid) as n
					  FROM {$db1['frontend']}.gruppo g
				      LEFT JOIN  {$db1['frontend']}.utente u ON u.gid=g.gid
				      WHERE g.gid>=0
				      GROUP BY g.gid, g.nome_gruppo, g.descrizione_gruppo, g.data_gruppo
				      ORDER BY gid",$link);
	
	
	
	
		
		// se ci sono gruppi
		if(vmsql_num_rows($qg)>0){
			
			
			
			$OUT.= "<p><a href=\"nuovo_gruppo.php\">"._("Crea nuovo gruppo")."</a></p>\n";
			
			$matrice_gr = vmsql_fetch_assoc_all($qg);
			
			$OUT.= "<table class=\"tab-color\" summary=\"Tabella gruppi\">\n";
			
			$OUT.= "\t<tr>
				<th>gid</th>
				<th>"._("nome")."</th>
				<th>"._("descrizione")."</th>
				<th>"._("utenti")."</th>
				<th>"._("data modifica")."</th>
				<th>"._("impostazioni")."</th>
				<th class=\"arancio\">"._("modifica")."</th>
				<th class=\"arancio\">"._("elimina")."</th>
			</tr>\n";
			
			
			foreach($matrice_gr as $k=>$val){
				
				
				$OUT.= "\t<tr>\n";
				$OUT.= "\t\t<td>".$val['gid']."</td>\n";
				$OUT.= "\t\t<td>".$val['nome_gruppo']."</td>\n";
				$OUT.= "\t\t<td>".$val['descrizione_gruppo']."</td>\n";
				$OUT.= "\t\t<td>".$val['n']."</td>\n";
				$OUT.= "\t\t<td>".date_encode($val['data_gruppo'],true)."</td>\n";
				$OUT.= "\t\t<td><a href=\"gestione_tabelle_gruppi.php?gid=".$val['gid']."\">"._("amministra")."</a></td>\n";
				$OUT.= "\t\t<td><a href=\"".$_SERVER['PHP_SELF']."?modifica_gid=1&amp;gid=".$val['gid']."\">"._("modifica")."</a></td>\n";
				$OUT.= ($val['gid']!=0) ? "\t\t<td><a href=\"elimina_gr.php?gid=".$val['gid']."\">"._("elimina")."</a></td>\n" : "\t\t<td> - </td>\n";
				$OUT.= "\t</tr>\n";
			}
		
			$OUT.= "</table>\n";
			
		}
	
	}
	

		
		
		
		
	$OUT.= closeLayout1();


	echo $OUT;


?>