<?php
/**
 * Da questo script � possibile creare un nuovo gruppo.
 * I nuovi gruppi posso essere cloni di gruppi esistenti per la creazione.
 * Vengono comunque creati record nuvoi del tutto indipendenti dal gruppo origine per la clonazione.
 * 
 * @desc File di creazione di un nuovo gruppo
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: nuovo_gruppo.php 262 2009-04-24 18:58:09Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */


require_once("../inc/conn.php");
require_once("../inc/layouts.php");
require_once("../inc/func.comuni.php");

 proteggi(3);

	// Se � inviato
	if(isset($_POST['gid_old'])){
		
		$_var=pulisci_dom($_POST);
		
		// controlli:
		if(strlen($_var['nome_gr'])==0){
			$feed=_("Il nome per il gruppo &egrave; obbligatorio");
			header("Location: ".$_SERVER['PHP_SELF']."?feed=ko&msg=1");
			exit;
		}
		elseif(vmsql_test_id($link,'nome_gruppo',"'".addslashes(stripslashes($_var['nome_gr']))."'","{$db1['frontend']}.gruppo")){
			$feed=_("Esiste gi&agrave; un record con questo nome");
			header("Location: ".$_SERVER['PHP_SELF']."?feed=ko&msg=1");
			exit;
		}
		
		
		// fin qui tutto bene... procedi con la creazione del gruppo
		
			
			include_once("./gestione_registro.inc.php");
		
			vmsql_begin($link);
			
			// prendi il prossimo valore di gid:
			$q_gid = vmsql_query("SELECT MAX(gid)+1 FROM {$db1['frontend']}.gruppo",$link);
			
			list($NEW_GID) = vmsql_fetch_row($q_gid);
			
			// test sul numero di nuovo gruppo
			if(!is_numeric($NEW_GID)) openErrorGenerico(_("Errore su creazione del gruppo"),true);
		
			$sql_ins_gr1="INSERT INTO {$db1['frontend']}.gruppo (gid,nome_gruppo,descrizione_gruppo)
							VALUES ($NEW_GID,
									'".$_var['nome_gr']."',
									'".$_var['descrizione_gr']."')";
		
			// Passo1 crea il gruppo
			$q_ins1 = vmsql_query($sql_ins_gr1,$link);
			
			// Passo2 a seconda del tipo di clonazione fa cose diverse:
			
			if(intval($_var['gid_old'])=='-1'){
				
				// ricrea da zero la struttura (vero | falso)
				$esito_clonazione = genera_registro_vuoto($NEW_GID);
			}
			elseif(intval($_var['gid_old'])>=0){
				
				// clona la struttura (vero | falso)
				$esito_clonazione = clona_settaggio($NEW_GID,intval($_var['gid_old']));
				
				if($_var['anche_submask']=='1'){
					
					clona_sottomaschere($NEW_GID,intval($_var['gid_old']));
				}
				
			}
			
			if($esito_clonazione){
				header("Location: menu_registri.php?feed=ok&msg=1");
				exit;
			}
			else{
				header("Location: menu_registri.php?feed=ko&msg=0");
				exit;
			}
		
	}


	$files = array("sty/admin.css","sty/tabelle.css");

	echo openLayout1("Crea nuovo gruppo",$files);
	
	echo "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> "
	     ."&raquo; <a href=\"menu_registri.php\">"._("menu gruppi/registri")."</a> &raquo; "._("crea nuovo gruppo/registro")."</div>";
	
	echo "<h1>"._("Crea nuovo gruppo/registro")."</h1>\n";
	
	
	echo "
	<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\">
		<fieldset style=\"width:90%\" >
		
		
			<legend>"._("Impostazioni gruppo/registro")."</legend>
		
			<img src=\"../img/registri.gif\" class=\"img-float\" alt=\""._("impostazioni registri")."\" style=\"padding: 15px 20px 400px 15px;\" />
		
			<br />
			<label for=\"nome_gr\">"._("nome gruppo")."</label><br />
			<input type=\"text\" name=\"nome_gr\" id=\"nome_gr\" maxlength=\"50\" size=\"25\" /><br />
			<div class=\"desc-campo\">"._("il nome del gruppo di utenti. &Egrave; un campo obbligatorio e non sono ammesse duplicazioni di nome")."</div>
			<br /><br />
				
			
			<label for=\"descrizione_gr\">"._("descrizione del gruppo")."</label><br />
			<textarea name=\"descrizione_gr\" id=\"descrizione_gr\" cols=\"65\" rows=\"5\" ></textarea><br />
			<div class=\"desc-campo\">"._("la descrizione del gruppo di utenti. Utile per l'amministrazione.")."</div>
			<br /><br />
			
			<label for=\"gid_old\">"._("clona impostazioni del registro dal gruppo:")."</label><br />
			
			<select id=\"gid_old\" name=\"gid_old\">";
	
			// prendi i gruppi
			$qg = vmsql_query("SELECT gid, nome_gruppo FROM {$db1['frontend']}.gruppo ORDER BY gid",$link);
	
			while($RSgr= vmsql_fetch_assoc($qg)){
				
				echo "\t\t\t<option value=\"".$RSgr['gid']."\">".$RSgr['gid']." - ".$RSgr['nome_gruppo']."</option>\n";
			}
			
			echo "\t\t\t<option value=\"-1\">"._("crea un registro vuoto")."</option>\n";
			
			echo "\t\t</select><br />\n";
			
			echo "
			<div class=\"desc-campo\">"._("Per ogni gruppo sono impostati diritto di accesso alle tabelle e molto altro.")."<br />
			"._("Mediante questa opzione &egrave; possibile impostare i diritti del gruppo a partire da una impostazione preesistente.")."<br />
			"._("Tutte le impostazioni del nuovo gruppo saranno poi modificabili indipendentemente.")."</div>
			<br /><br />
			
			<input type=\"checkbox\" value=\"1\" id=\"anche_submask\" name=\"anche_submask\" checked=\"checked\" />
			<label for=\"anche_submask\">"._("clona sottomaschere")."</label><br />
			<div class=\"desc-campo\">"._("Se attivo permette di clonare anche le impostazioni delle sottomaschere del gruppo indicato")."</div>
			<br /><br />
			
			
			<input type=\"button\" name=\"crea\" value=\""._("Crea nuovo gruppo")."\" onclick=\"submit();\"/>
			<br /><br /> 
		</fieldset>
	</form>
	";
		
		
		
		
	echo closeLayout1();





?>