<?php
/**
* Update script
* Test and version upgrade
* 
* @package VFront
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 Mario Marcello Verona
* @version 0.95a $Id: update.php 410 2009-10-19 18:08:35Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
* @todo Verificare con utility se se operazioni sono eseguibili dall'autore, in caso contrario segnalare le operazioni da compiere
*/



require_once("../inc/conn.php");
require_once("../inc/layouts.php");
require_once("../inc/func.comuni.php");




function check_privileges($priv){
	
	global $link,$db1;
	
	$GRANTEE=addslashes("'".$db1['user']."'@'".$db1['host']."'");
	
	$sql="SELECT PRIVILEGE_TYPE FROM information_schema.SCHEMA_PRIVILEGES 
		  WHERE TABLE_SCHEMA='".$db1['frontend']."' AND GRANTEE='$GRANTEE'";
	
	$q=vmsql_query($sql,$link);
	
	if(vmsql_num_rows($q)==1){
		return true;
	}
	else{
		return false;
	}
	
}



##################################################
#
#	VERSION 0.95
#
#


// TEST VERSION < 0.95
function update_test_090(){
	
	global $link,$db1;
	
	$q_test=vmsql_query("SELECT CHARACTER_MAXIMUM_LENGTH 
						FROM information_schema.COLUMNS
						WHERE TABLE_SCHEMA = '{$db1['frontend']}'
						AND TABLE_NAME = 'registro_tab'
						AND COLUMN_NAME = 'orderby'",
						$link);
						
	if(vmsql_num_rows($q_test)==0){
		
		list($length)=vmsql_fetch_row($q_test);
		
		if($length<255){
			return true;
		}
		else{
			return false;
		}
	}
	else return false;
	
}

// EXEC VERSION < 0.95
function update_exec_090(){
	
	global $link,$db1;
	
	$sql_up[]="ALTER TABLE log CHANGE op op ENUM( 'insert', 'update', 'delete', 'select', 'sconosciuta', 'ripristino', 'duplicazione', 'import' ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL ;";
	
	$sql_up[]="ALTER TABLE registro_tab ADD in_import TINYINT( 1 ) UNSIGNED NULL AFTER in_export ;";

	$sql_up[]="ALTER TABLE registro_tab CHANGE orderby orderby VARCHAR( 255 ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL ;";
	
	$sql_up[]="ALTER TABLE registro_tab CHANGE orderby_sort orderby_sort VARCHAR( 255 ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT 'ASC';";
	
	$sql_up="ALTER TABLE stat ADD settings TEXT COMMENT 'Impostazioni avanzate del grafico';";
	
	return _update_exec('0.90',$sql_up);
}



// TEST VERSION 0.95
function update_test_095(){
	
	global $link,$db1;

	$q_test=vmsql_query("SELECT * FROM {$db1['frontend']}.variabili WHERE variabile='layout'",$link);
	
	if(vmsql_num_rows($q_test)==0){
		return true;
	}
	else return false;
}


// EXEC VERSION 0.95
function update_exec_095(){
	
	global $db1;

	$sql_up[]="INSERT INTO {$db1['frontend']}.variabili (variabile, gid, valore, descrizione, tipo_var) VALUES ('layout',0,'default','Color theme','string');";

	return _update_exec('0.95',$sql_up);
}









##################################################
#
#	VERSION 0.95a
#
#


// TEST VERSION 0.95a
function update_test_095a(){
	
	global $db1,$link;
	
	$q_test=vmsql_query("SELECT *
						FROM information_schema.COLUMNS
						WHERE TABLE_SCHEMA = '{$db1['frontend']}'
						AND TABLE_NAME = 'registro_col'
						AND COLUMN_NAME = 'in_line'",
						$link);
						
	if(vmsql_num_rows($q_test)==0){
		return true;
	}
	else return false;
}


// EXEC VERSION 0.95a
function update_exec_095a(){
	
	global $db1;

	$sql_up[]="ALTER TABLE {$db1['frontend']}.allegato  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.gruppo  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.link  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.log  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.recordlock  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.registro_col  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.registro_submask  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.registro_submask_col  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.registro_tab  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.utente  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.variabili  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.xml_rules  DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;";

	$sql_up[]="INSERT INTO {$db1['frontend']}.variabili (variabile, gid, valore, descrizione, tipo_var) VALUES ('alert_login_default',0,'1','Mostra agli utenti l\'avviso se sono presenti nel gruppo di default','bool');";
	$sql_up[]="INSERT INTO {$db1['frontend']}.variabili (variabile, gid, valore, descrizione, tipo_var) VALUES ('alert_config',0,'1','Mostra all\'admin l\'avviso in home page se è presente qualche errore nella configurazione','bool');";
	$sql_up[]="INSERT INTO {$db1['frontend']}. variabili (variabile, gid, valore, descrizione, tipo_var) VALUES ('show_comment_in_table', '0', '0', 'Mostra il commento della tabella nella maschera di inserimento dati', 'bool');";

	$sql_up[]="ALTER TABLE {$db1['frontend']}.registro_col ADD in_line TINYINT(1) NULL AFTER in_table;";

	return _update_exec('0.95a',$sql_up);
}




###########################################
#
#	VERSION 0.95b
#	// change in CONF
#




###########################################
#
#	VERSION 0.95c
#






// TEST VERSION 0.95c
function update_test_095c(){
	
	global $db1,$link;
	
	$q_test=vmsql_query("SELECT *
						FROM information_schema.COLUMNS
						WHERE TABLE_SCHEMA = '{$db1['frontend']}'
						AND TABLE_NAME = 'variabili'
						AND COLUMN_NAME = 'pubvar'",
						$link);
						
	if(vmsql_num_rows($q_test)==0){
		return true;
	}
	else return false;
}



// EXEC VERSION 0.95a
function update_exec_095c(){
	
	global $db1;
	
	$sql_up[]="ALTER TABLE {$db1['frontend']}.variabili ADD pubvar TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '1';";
	$sql_up[]="ALTER TABLE {$db1['frontend']}.variabili CHANGE valore valore TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ;";
	$sql_up[]="UPDATE {$db1['frontend']}.variabili SET pubvar=0 WHERE variabile='layout';";
	
	return _update_exec('0.95c',$sql_up);
	
}
























#######################################################################################à





function _update_exec($version,$sql_array){
	
	global $link,$db1;
	
	$string_out="\n--\n-- <strong>Update for $version</strong>\n--\n\n";
	
	if(!is_array($sql_array)) $sql_array=(array) $sql_array;
	
	$manual_make=array();
	
	foreach($sql_array as $sql){
		
		// GET SQL ACTION:
		$action=array();
		preg_match("|^ *([A-Z]+) |i",$sql,$action);
		
		if(count($action)>0){
			
			$sql_keyword=$action[1];
			$check=check_privileges($sql_keyword);
			
			if(!$check){
				
				$manual_make[]=$sql;
				continue;
			}
		}
		

		$test=vmsql_try($sql,$link,false);
		
		if($test){
			$string_out.=$sql."\n-- <span class=\"verde\">OK</span>\n\n";
		}
		else{
			$string_out.=$sql."\n-- <span class=\"rosso\">Error</span>\n\n";
		}
	}
	
	if(count($manual_make)>0){
		
		$string_out="<h2>Plese run this sql as root (or with user having the correct privileges on DB):</h2>\n";
		
		for($i=0;$i<count($manual_make);$i++){
			$string_out.=$manual_make[$i]."\n\n";
		}
	}
	
	return $string_out;
}





// Find updates
preg_match_all('|function (update_test_([\w]+))|im',join('',file(__FILE__)),$function);




if(count($function[0])>0){
	
	$updates=0;

	if(isset($_GET['test'])){
	
		for($i=0;$i<count($function[1]);$i++){
			if($function[1][$i]()){
	
				$updates++;
			}
		}
	}
	else{
		
		$OUT='';
		
		// Esegui la funzione TEST
		for($i=0;$i<count($function[1]);$i++){
			if($function[1][$i]()){
				
				$updates++;
	
				$func_exec='update_exec_'.$function[2][$i];
				if(function_exists($func_exec)){
	
					$OUT.=$func_exec();
				}
			}
		}
	}
}





proteggi(3);

echo openLayout1(_("VFront Update"),array("sty/admin.css"));

echo "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> &raquo; ".strtolower(_("VFront Update"))."</div>";
	
echo "<h1>"._("VFront Update")."</h1>";

if($updates==0){
	
	echo "<p>"._('Nessun aggiornamento da installare nel DB VFront')."</p>\n";
}
else{
	
	if(isset($_GET['test'])){
		echo "<p>".sprintf(_('Sono presenti %d aggiornamenti da installare.'),$updates)."</p>\n";
		if($updates>0){
			echo "<p><a href=\"".$_SERVER['PHP_SELF']."\">"._("Procedi con l'aggiornamento del database")."</a></p>\n";
		}
	}
	else{
		echo "<p>".sprintf(_('Sono stati trovati ed installati %d aggiornamenti.'),$updates)."</p>\n";
	}
}

if($OUT!=''){
	
	echo "<div id=\"boxsql\"><code>\n";
		
	echo nl2br($OUT);
	
	echo "</code></div>\n";
}


echo closeLayout1();







?>