<?php
/**
 * Attraverso lo script � eseguita una diagnostica dell'attuale stato della configurazione
 * di VFront. Sono presenti varie sezioni. L'esecuzione di questo script � appannaggio degli amministratori 
 * (livello 3).
 * 
 * @desc Informazioni sulla installazione corrente di VFront
 * @package VFront
 * @subpackage Administration
 * @author M.Marcello Verona
 * @copyright 2007 M.Marcello Verona
 * @version 0.95 $Id: vfront.info.php 378 2009-05-05 14:20:53Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */



require_once("../inc/conn.php");
require_once("../inc/layouts.php");
require_once("../inc/func.comuni.php");

proteggi(3);

echo openLayout1(_("Test impostazioni di VFront"),array("sty/admin.css"));

echo "<div id=\"briciole\"><a href=\"index.php\">"._("home amministrazione")."</a> &raquo; "._("test di impostazioni VFront")."</div>";
	
echo "<h1>"._("Impostazioni VFront")."</h1>";




$flog="# VFront Log: ".$_SERVER['SERVER_NAME']." - ".date("Y-m-d H:i:s")."\n";
$flog.="--------------------------------------------------------------------\n";














echo "<h2 class=\"title-vfrontinfo\">"._("Versione VFront")."</h2>";

// Versione VFRONT -----------------------------------------------------------------------------------------------

	// 
	$file_versione=join('',file('../vf_version.xml'));
	
	preg_match('|<version>([^<]+)</version>|',$file_versione,$version_vfront);


	
	echo "<span class=\"grigio\">"._("VFront Version:")."</span> ".
		 "<strong><span class=\"$classe\">".$version_vfront[1]."</span></strong>\n";
	echo "<div class=\"piccolo\">"._('Informazioni sugli aggiornamenti non ancora disponibili')."</div><br />\n";

	exec('svn info ..',$output,$ret);
	$output_svn=implode("\n",$output);
	
	if(preg_match('|Revision:(.*)|',$output_svn,$revision)){
		
		preg_match('|Last Changed Date:(.*)|',$output_svn,$last_changed_date);
		
		echo "<span class=\"grigio\">"._("VFront Subversion:")."</span> ".
			 "<strong><span class=\"$classe\">".$revision[1]."</span></strong> - ".$last_changed_date[1]."\n";
		echo "<div class=\"piccolo\">"._("VFront sta utilizzando SVN")."</div><br />\n";
	
	}
	else{
		
		preg_match('|\$Date:(.*)\$|',$file_versione,$date);
		preg_match('|\$Revision:(.*)\$|',$file_versione,$revision);
		
		echo "<span class=\"grigio\">"._("VFront Subversion:")."</span> ".
			 "<strong><span class=\"$classe\">".$revision[1]."</span></strong> - ".$date[1]."\n";
		echo "<div class=\"piccolo\">"._("VFront non sta utilizzando SVN")."</div><br />\n";
		
	}


	// info dal conf
	
	$nome_db = ($db1['dbtype']=='mysql') ? $db1['dbname'] : $db1['postgres_dbname'];
	
	echo "<span class=\"grigio\">"._("DB:")."</span> ".
		 "<strong><span class=\"$classe\">".$nome_db."</span></strong>\n";
	echo "<div class=\"piccolo\">"._('Database dati attualmente in uso')."</div><br />\n";

	// info dal conf
	
	echo "<span class=\"grigio\">"._("DB Rules:")."</span> ".
		 "<strong><span class=\"$classe\">".$db1['frontend']."</span></strong>\n";
	echo "<div class=\"piccolo\">"._('Database regole attualmente in uso')."</div><br />\n";
	

	// info dal conf
	$tipo_auth = ($conf_auth['tipo_external_auth']=='') ? "Interna" : $conf_auth['tipo_external_auth'];
	
	echo "<span class=\"grigio\">"._("Authentication type:")."</span> ".
		 "<strong><span class=\"$classe\">".$tipo_auth."</span></strong>\n";
	echo "<div class=\"piccolo\">"._('Tipologia di autenticazione')."</div><br />\n";


	

echo "<h2 class=\"title-vfrontinfo\">"._("Versione software")."</h2>";


// VERSIONE Apache ---------------------------------------------------------------------------------------------------

$classe = (ereg("^5*",$_SERVER["SERVER_SOFTWARE"])) ? "verde" : "arancio";

$flog.="ApacheVersion: ".$_SERVER["SERVER_SOFTWARE"]."\n";

echo "<span class=\"grigio\">"._("Apache Version").":</span> <strong><span class=\"$classe\">".$_SERVER["SERVER_SOFTWARE"]."</span></strong>\n";
echo "<div class=\"piccolo\">"._("VFront richiede una versione di Apache &gt;= 2.x")."</div><br />\n";


// VERSIONE PHP ---------------------------------------------------------------------------------------------------

$classe = (ereg("^5*",phpversion())) ? "verde" : "arancio";

$flog.="PHPVersion: ".phpversion()."\n";

echo "<span class=\"grigio\">"._("Versione PHP").":</span> <strong><span class=\"$classe\">".phpversion()."</span></strong>\n";
echo "<div class=\"piccolo\">"._("VFront richiede una versione di PHP &gt;= 5.x")."</div><br />\n";




// VERSIONE DATABASE ---------------------------------------------------------------------------------------------------

// MYSQL
$q=vmsql_query("SELECT VERSION()",$link);
list($db_version)=vmsql_fetch_row($q);


if($db1['dbtype']=='mysql'){
	
	$flog.="DB: MySQL\n";
	
	$classe = (ereg("^5.*",$db_version)) ? "verde" : "arancio";
	echo "<span class=\"grigio\">"._("Versione database:")."</span> <strong><span class=\"$classe\">".$db_version."</span></strong>\n";
	echo "<div class=\"piccolo\">"._("VFront richiede una versione di MySQL &gt;= 5.x")."</div><br />\n";
}
	
else if($db1['dbtype']=='postgres'){
	
	$flog.="DB: PostgreSQL\n";
	
	$classe = (ereg("8.*",$db_version)) ? "verde" : "arancio";
	echo "<span class=\"grigio\">"._("Versione database:")."</span> <strong><span class=\"$classe\">".$db_version."</span></strong>\n";
	echo "<div class=\"piccolo\">"._("VFront richiede una versione di Postgres &gt;= 8.x")."</div><br />\n";
}
	
$flog.="DBVersion: $db_version\n";


// VFRONT CONFIG

















// ESTENSIONI IMPORTANTI ---------------------------------------------------------------------------------------------------
$permessi_dirconf= substr(sprintf('%o', fileperms('../conf')), -4);
$permessi_fileconf= substr(sprintf('%o', fileperms("../conf/$CONF_FILE")), -4);
$file_modello=is_file("../conf/conf.vfront.php.dist");
$dir_install=is_dir("../_install");

echo "<h2 class=\"title-vfrontinfo\">"._("Impostazioni di sicurezza")."</h2>";

$write_dir_conf=(!is_writable('../conf')) ? "<span class=\"verde\">"._("NO")."</span>" : "<span class=\"rosso\">"._("SI")."</span>";
echo "<span class=\"grigio\">"._("Directory conf scrivibile:")."</span> <strong>$write_dir_conf ($permessi_dirconf)</strong>\n";
echo "<div class=\"piccolo\">"._("La directory conf non dovrebbe essere scrivibile da parte dell'utente web")."</div><br />\n";

$write_file_conf=(!is_writable("../conf/$CONF_FILE")) ? "<span class=\"verde\">"._("NO")."</span>" : "<span class=\"rosso\">"._("SI")."</span>";
echo "<span class=\"grigio\">"._("File di configurazione conf/$CONF_FILE scrivibile:")."</span> <strong>$write_file_conf ($permessi_fileconf)</strong>\n";
echo "<div class=\"piccolo\">"._("Il file di configurazione non dovrebbe essere scrivibile da parte dell'utente web")."</div><br />\n";

$presenza_file_modello=(!$file_modello) ? "<span class=\"verde\">"._("NO")."</span>" : "<span class=\"rosso\">"._("SI")."</span>";
echo "<span class=\"grigio\">"._("Presenza del file di installazione:")."</span> <strong>$presenza_file_modello</strong>\n";
echo "<div class=\"piccolo\">"._("Il file conf.vfront.php.dist dovrebbe essere rimosso")."</div><br />\n";

$presenza_dir_install=(!$dir_install) ? "<span class=\"verde\">"._("NO")."</span>" : "<span class=\"rosso\">"._("SI")."</span>";
echo "<span class=\"grigio\">"._("Presenza della directory di installazione:")."</span> <strong>$presenza_dir_install</strong>\n";
echo "<div class=\"piccolo\">"._("La directory di installazione <em>_install</em> dovrebbe essere rimossa")."</div><br />\n";





// ESTENSIONI IMPORTANTI ---------------------------------------------------------------------------------------------------
echo "<h2 class=\"title-vfrontinfo\">"._("Moduli PHP")."</h2>";

$ext=get_loaded_extensions();

$flog.="PHPLoadedExtensions: ".implode(",",$ext)."\n";

$l_mysqli=(in_array('mysqli',$ext)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Libreria MySQLi (MySQL Improved):")."</span> <strong>$l_mysqli</strong>\n";
echo "<div class=\"piccolo\">"._("VFront utilizza la libreria mysqli per collegarsi a MySQL, qualora si utilizzasse questo DB l'estensione <b>deve essere caricata</b>")."</div><br />\n";


$l_mysqli=(in_array('mysql',$ext)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Libreria MySQL:")."</span> <strong>$l_mysqli</strong>\n";
echo "<div class=\"piccolo\">"._("VFront utilizza preferibilmente la libreria mysqli. In alternava per collegarsi a MySQL, viene utilizzata la vecchia libreria php_mysql")."</div><br />\n";


$l_pgsql=(in_array('pgsql',$ext)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Libreria Postgres:")."</span> <strong>$l_pgsql</strong>\n";
echo "<div class=\"piccolo\">"._("Qualora si utilizzasse questo DB l'estensione <b>deve essere caricata</b>")."</div><br />\n";

$l_gd=(in_array('gd',$ext))   ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("GD Library:")."</span> <strong>$l_gd</strong>\n";
echo "<div class=\"piccolo\">"._("Le GD library sono utilizzate da Vfront per la creazione dei grafici delle statistiche")."</div><br />\n";

$l_xsl=(in_array('xsl',$ext)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Trasformazione XSL:")."</span> <strong>$l_xsl</strong>\n";
echo "<div class=\"piccolo\">".sprintf(_("Qualora il modulo non sia caricato si suggerisce di andare nel menu delle %s ed annullare la traformazione XSLT lato server"),
								"<a href=\"variabili.php\">"._("variabili")."</a>")
								."</div><br />\n";



// IMPOSTAZIONI IMPORTANTI ---------------------------------------------------------------------------------------------------
echo "<h2 class=\"title-vfrontinfo\">"._("Variabili PHP")."</h2>";

$php_ini_rg=(ini_get('register_globals')==0) ? "<span class=\"verde\">"._("OFF")."</span>" : "<span class=\"rosso\">"._("ON")."</span>";
echo "<span class=\"grigio\">"._("register_globals:")."</span> <strong>$php_ini_rg</strong>\n";
echo "<div class=\"piccolo\">"._("VFront richiede la disattivazione di register_globals. Si ricorda che la variabile &egrave; modificabile dal php.ini o dal httpd.conf")."</div><br />\n";





// IMPOSTAZIONI IMPORTANTI ---------------------------------------------------------------------------------------------------
echo "<h2 class=\"title-vfrontinfo\">"._("Moduli Apache")."</h2>";

$modules_apache=(array) @apache_get_modules();

$flog.="ApacheLoadedModules: ".implode(",",$modules_apache)."\n";

$apache_mod_rewrite=(in_array("mod_rewrite", $modules_apache)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Mod_rewrite:")."</span> <strong>$apache_mod_rewrite</strong>\n";
echo "<div class=\"piccolo\">"._("VFront richiede l'uso di mod_rewrite per diverse funzioni, come la generazione dei report")."</div><br />\n";




// USO DI PEAR ---------------------------------------------------------------------------------------------------
echo "<h2 class=\"title-vfrontinfo\">"._("Moduli PEAR")."</h2>";

$pear=(@include_once("PEAR.php")) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Inclusione di PEAR:")."</span> <strong>$pear</strong>\n";
echo "<div class=\"piccolo\">"._("PEAR viene utilizzato per la creazione dei grafici delle statistiche")."</div><br />\n";

$pear_img_graph=(@include_once("Image/Graph.php")) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Inclusione del modulo PEAR Image/Graph:")."</span> <strong>$pear_img_graph</strong>\n";
echo "<div class=\"piccolo\">"._("Modulo PEAR utilizzato per la creazione dei grafici delle statistiche")."</div><br />\n";


$pear_img_canvas=(@include_once("Image/Canvas.php")) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Inclusione del modulo PEAR Image/Canvas:")."</span> <strong>$pear_img_canvas</strong>\n";
echo "<div class=\"piccolo\">"._("Modulo PEAR utilizzato per la creazione dei grafici delle statistiche (dipendenza di Image/Graph.php)")."</div><br />\n";


$pear_img_color=(@include_once("Image/Color.php")) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("Inclusione del modulo PEAR Image/Color:")."</span> <strong>$pear_img_color</strong>\n";
echo "<div class=\"piccolo\">"._("Modulo PEAR utilizzato per la creazione dei grafici delle statistiche (dipendenza di Image/Graph.php)")."</div><br />\n";

// CARTELLE SCRIVIBILI O NO ---------------------------------------------------------------------------------------------------
echo "<h2 class=\"title-vfrontinfo\">"._("Impostazioni cartelle scrivibili")."</h2>";


	// TMP

	$is_tmp_write = (is_writable(_PATH_TMP)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
	$is_tmp_write_txt = (is_writable(_PATH_TMP)) ? _("La cartella temporanea impostata")." ( "._PATH_TMP." ) "._("&egrave; scrivibile da VFront.") 
						: _("La cartella temporanea impostata")." ( "._PATH_TMP." ) "._("non &egrave; scrivibile da VFront.<br />Modificare i diritti della cartella") ;
	
	
	echo "<span class=\"grigio\">"._("Cartella temporanea scrivibile:")."</span> <strong>$is_tmp_write</strong>\n";
	echo "<div class=\"piccolo\">$is_tmp_write_txt</div><br />\n";

	
	// HTML


	$is_html_write = (is_writable(_PATH_ATTACHMENT."/html")) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
	$is_html_write_txt = (is_writable(_PATH_ATTACHMENT."/html")) ? _("La cartella di lavoro impostata")." ( "._PATH_ATTACHMENT."/html"." ) "._("&egrave; scrivibile da VFront")
						: _("La cartella di lavoro impostata")." ( "._PATH_ATTACHMENT."/html"." ) "._("non &egrave; scrivibile da VFront.<br />Modificare i diritti della cartella") ;
	
	
	echo "<span class=\"grigio\">"._("Cartella di lavoro HTML scrivibile:")."</span> <strong>$is_html_write</strong>\n";
	echo "<div class=\"piccolo\">$is_html_write_txt</div><br />\n";



	


	// ATTACH
	
	$is_attach_write = (is_writable(_PATH_ATTACHMENT)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
	$is_attach_write_txt = (is_writable(_PATH_ATTACHMENT)) ? _("La cartella degli allegati impostata")." ( "._PATH_ATTACHMENT." ) "._("&egrave; scrivibile da VFront.") 
						: _("La cartella degli allegati impostata")." ( "._PATH_ATTACHMENT." ) "._("non &egrave; scrivibile da VFront.<br />Modificare i diritti della cartella");
	
	
	echo "<span class=\"grigio\">"._("Cartella degli allegati scrivibile:")."</span> <strong>$is_attach_write</strong>\n";
	echo "<div class=\"piccolo\">$is_attach_write_txt</div><br />\n";

	
	// TMP ATTACH
	
	$is_attach_tmp_write = (is_writable(_PATH_ATTACHMENT_TMP)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
	$is_attach_tmp_write_txt = (is_writable(_PATH_ATTACHMENT_TMP)) ? _("La cartella temporanea per gli allegati impostata")." ( "._PATH_ATTACHMENT_TMP." ) "._("&egrave; scrivibile da VFront.") 
						: _("La cartella temporanea per gli allegati impostata")." ( "._PATH_ATTACHMENT_TMP." ) "._("non &egrave; scrivibile da VFront.<br />Modificare i diritti della cartella") ;
	
	
	echo "<span class=\"grigio\">"._("Cartella temporanea per gli allegati scrivibile:")."</span> <strong>$is_attach_tmp_write</strong>\n";
	echo "<div class=\"piccolo\">$is_attach_tmp_write_txt</div><br />\n";
	
	
	// DOCS
	
	$is_helpdocs_write = (is_writable(_PATH_HELPDOCS)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
	$is_helpdocs_write_txt = (is_writable(_PATH_HELPDOCS)) ? _("La cartella impostata per i documenti utili")." ( "._PATH_HELPDOCS." ) "._("&egrave; scrivibile da VFront.") 
						: _("La cartella impostata per i documenti utili")." ( "._PATH_HELPDOCS." ) "._("non &egrave; scrivibile da VFront.<br />Modificare i diritti della cartella") ;
	
	
	echo "<span class=\"grigio\">"._("Cartella per i documenti utili scrivibile:")."</span> <strong>$is_helpdocs_write</strong>\n";
	echo "<div class=\"piccolo\">$is_helpdocs_write_txt</div><br />\n";	
	
	// XSL
	
	$is_xsl_write = (is_writable(_PATH_XSL)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
	$is_xsl_write_txt = (is_writable(_PATH_HELPDOCS)) ? _("La cartella impostata per i fogli di stile XSL")." ( "._PATH_XSL." ) "._("&egrave; scrivibile da VFront.")
						: _("La cartella impostata per i fogli di stile XSL")." ( "._PATH_XSL." ) "._("non &egrave; scrivibile da VFront.<br />Modificare i diritti della cartella");
	
	
	echo "<span class=\"grigio\">"._("Cartella per i fogli di stile XSL scrivibile:")."</span> <strong>$is_xsl_write</strong>\n";
	echo "<div class=\"piccolo\">$is_xsl_write_txt</div><br />\n";




// FOP ---------------------------------------------------------------------------------------------------
echo "<h2 class=\"title-vfrontinfo\">Apache FOP</h2>";

$FOP_en=(_FOP_ENABLED) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
echo "<span class=\"grigio\">"._("FOP attivato:")."</span> <strong>$FOP_en</strong>\n";
echo "<div class=\"piccolo\">"._("Apache FOP &egrave; utilizzato da VFront nella trasformazione XSLT (generazione PDF ed altri formati da XML)")."</div><br />\n";

if(_FOP_ENABLED){

	// EXEC FOP?
	
	$is_fop_exec = (is_executable(_PATH_FOP)) ? "<span class=\"verde\">"._("SI")."</span>" : "<span class=\"rosso\">"._("NO")."</span>";
	$is_fop_exec_txt = (is_executable(_PATH_FOP)) ? _("L'eseguibile FOP specificato nel file di configurazione")." ( "._PATH_FOP." ) "._("&egrave; eseguibile da VFront.") 
						: _("L'eseguibile FOP specificato nel file di configurazione")." ( "._PATH_FOP." ) "._("non &egrave; eseguibile da VFront.<br />Modificare i diritti del file");
	
	
	echo "<span class=\"grigio\">FOP "._("&egrave; eseguibile?")." </span> <strong>$is_fop_exec</strong>\n";
	echo "<div class=\"piccolo\">$is_fop_exec_txt</div><br />\n";
	
	
	
	
	// VERSIONE
	
	exec(_PATH_FOP." -v" ,$output,$ret);
	$output=preg_replace("'\n'"," ",implode("\n",$output));
	
	preg_match("'FOP.*?([0-9\.]+)'",$output,$found);
	
	if(isset($found[1])){
		echo "<span class=\"grigio\">"._("Versione")." FOP:</span> <strong>".$found[1]."</strong>\n";
		echo "<div class=\"piccolo\">"._("Apache FOP &egrave; utilizzato da VFront nella trasformazione XSLT")."</div><br />\n";
	}
}

echo closeLayout1();

?>