<?php
/**
 * @package VFront
 * @subpackage Authentication
 * @author Mario Marcello Verona <marcelloverona@gmail.com>
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: auth.db.php 262 2009-04-24 18:58:09Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 * @see auth
 */

	/**
	 * Funzione di autenticazione mediante l'uso di un database diverso da VFront 
	 * ma presente sullo stesso server
	 * Viene richiamata dalla classe {@link auth}
	 *
	 * @param string $user Username (email)
	 * @param string $passw Password
	 * @return array
	 */
	function auth_db($user, $passw){
		
		global $link, $db1, $conf_auth;
	
	
		$sql_auth=sprintf("SELECT * FROM {$conf_auth['db']['database']}.{$conf_auth['db']['tabella']} 
						   WHERE {$conf_auth['campo_email']}='%s' AND {$conf_auth['campo_password']}='%s'",
						trim(addslashes($user)),
						personal_hash_db(trim($passw))
						);
						
		$q_auth=vmsql_query($sql_auth,$link);
		
		
		if(vmsql_num_rows($q_auth)==1){
			
			$RS=vmsql_fetch_assoc($q_auth);
			
			return array('response'=>true,$RS);
		
		}
		else{
			
			return array('response'=>false);
		}
		
	}
	
	/**
	 * Funzione di hash o crypt personalizzata 
	 * richiama il tipo di codifica impostata nel file CONF 
	 * per le password in caso di autenticazione esterna tramite database
	 *
	 * @param string $passw
	 * @return string Stringa codificata con il metodo impostato in $conf_auth['password_crypt']
	 */
	function personal_hash_db($passw){
		
		global $conf_auth;
		
		if($conf_auth['password_crypt']=='md5'){
			
			return md5($passw);
		}
		else if($conf_auth['password_crypt']=='sha1'){
			
			return sha1($passw);
		}
		
		// ... altri metodi
		
		else{
			
			return $passw;
		}
	}

?>