<?php
/**
* Connessione al file di configurazione. 
* Questo file viene incluso in tutte le pagine di VFront e fa riferimento al file di configurazione.
* Per il corretto funzionamento dell'applicazione � necessario specificare manualmente il collegamento al
* path reale del file di configurazione.
* 
* @package VFront
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: conn.php 411 2009-11-11 12:37:12Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/





####################################################
#
#	COLLEGAMENTO AL FILE CONF
#

$CONF_FILE='conf.vfront.php';








############################################################################
#
#	Non modificare da qui in poi...
#
############################################################################


// Linux or windows ?
$dir_vfront= (substr(realpath(__FILE__),0,1)=='/')
	? str_replace("/inc/conn.php",'',realpath(__FILE__))
	: str_replace("\\inc\\conn.php",'',realpath(__FILE__));

$POSIZIONE_FILE_CONFIGURAZIONE=$dir_vfront.'/conf/'.$CONF_FILE;

if(!is_file($POSIZIONE_FILE_CONFIGURAZIONE)){
	
	header("Location: ./_install/");
	exit;
}

if(!@include_once($POSIZIONE_FILE_CONFIGURAZIONE)){
	echo "Impossibile includere il file di configurazione. Modificare le impostazioni del file inc/conn.php";
	exit;
}






// Impostazione della lingua 
$locale = (defined('FRONT_LANG')) ? FRONT_LANG : 'en_US';

// Impostazione della codifica
$encoding = (defined('FRONT_ENCODING')) ? FRONT_ENCODING : 'UTF-8';

$locale_dir = FRONT_REALPATH.'/locale'; // your .po and .mo files should be at $locale_dir/$locale/LC_MESSAGES/messages.{po,mo}

$domain = 'messages';


// sezione gettext
if(!function_exists('_')){
	
	require_once(FRONT_REALPATH.'/plugins/phpgettext/gettext.inc.php');
	
	// gettext setup
	T_setlocale(LC_MESSAGES, $locale);
	// Set the text domain as 'messages'
	bindtextdomain($domain, $locale_dir);
	// bind_textdomain_codeset is supported only in PHP 4.2.0+
	if (function_exists('bind_textdomain_codeset')) 
	  bind_textdomain_codeset($domain, $encoding);
	
	textdomain($domain);
}
else{
	
	putenv("LANGUAGE=$locale");
	putenv("LC_ALL=$locale");
	setlocale(LC_ALL, $locale, "$locale.utf8");
	bindtextdomain($domain,$locale_dir);
	textdomain($domain);
}









// DB connection

if($db1['dbtype']=='mysql'){
	
	if(function_exists('mysqli_connect')){
		require_once(FRONT_REALPATH."/inc/vmsql.mysqli.php");
	}
	else{
		require_once(FRONT_REALPATH."/inc/vmsql.mysqlold.php");
	}
}
elseif($db1['dbtype']=='postgres'){
	
	require_once(FRONT_REALPATH."/inc/vmsql.postgres.php");
}
else{
	
	die(_("Impossibile connettersi al database: selezionare un tipo di database!"));
}

$link = vmsql_connect($db1);
		











// Avvia la sessione
session_name("VFRONT_".preg_replace("|[\W]+|","_",_NOME_PROJ));
session_start();

include_once(FRONT_ROOT."/inc/func.var_frontend.php");

$_SESSION['VF_VARS']=var_frontend('session','session');

/**
 * Funzione di protezione delle pagine. 
 * Mediante questa funzione, richiamata in testa ad ogni pagina, � possibile proteggere il singolo script 
 * da accessi non autenticati.
 * Il parametro "Livello" indica il livello minimo necessario per eseguire lo script della pagina.
 *
 * @param int $livello Indica il livello di amministrazione per la pagina nel quale la funzione viene richiamata
 */
function proteggi($livello=1){
	
	if($livello>0){
	
		if(!isset($_SESSION['user']['livello'])){
			
			header("Location: ".FRONT_DOCROOT."/index.php?nolog=1&sessione_inesistente");
			exit;
		}
		elseif( $_SESSION['user']['livello'] < $livello ){
			header("Location: ".FRONT_DOCROOT."/index.php?nolog=2&sessione_insuff");
			exit;
		}
	}
}



?>