<?php
/**
* Libreria di funzioni comuni. 
* Si tratta di funzioni incluse in quasi tutti gli script e di uso comune in tutta l'applicazione VFront
* 
* @package VFront
* @subpackage Function-Libraries
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: func.comuni.php 297 2009-04-26 15:14:15Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/



/**
 * Pulisce da spazi bianchi, aggiunge gli slash e rimuove eventuali tags i campi inseriti. 
 * Viene utilizzata per ragioni di sicurezza in contesti di invio di dati da parte del client.
 *
 * @param array $post_dom
 * @return array
 */
function pulisci_dom($post_dom){
	
	if(!is_array($post_dom)){
		
		return false;
	}
	
	while(list($k,$val)=each($post_dom)){
		if(is_array($val)){
			while(list($kk,$valval)=each($val)){
				$_var[$k][$kk]=addslashes(stripslashes(strip_tags(trim($valval))));
			}
		}
		else{
			$_var[$k]=addslashes(stripslashes(strip_tags(trim($val))));
		}
	}
	
	return $_var;
}


/**
 * Dato un numerico indicante l'ID del gruppo viene restituito il nome dello stesso
 *
 * @param int $gid ID del gruppo 
 * @return string Nome del gruppo
 */
function gid2nome_gruppo($gid){
	
	global $link,$db1;
	
	$q=vmsql_query("SELECT nome_gruppo FROM {$db1['frontend']}.gruppo WHERE gid=".intval($gid),$link);
	list($nome_gr) = vmsql_fetch_row($q);
	
	return $nome_gr;
	
}



/**
 * Codifica la data in base al parametro di configurazione FRONT_DATE_FORMAT
 *
 * @param date $dataISO
 * @param bool $ora
 * @param string $special
 * @return string
 */
function date_encode($dataISO,$ora=false,$special=''){
	
	switch (FRONT_DATE_FORMAT){
		
		case 'ita': return dataITA($dataISO,$ora,$special);
		break;
		
		case 'eng': return dataENG($dataISO,$ora,$special);
		break;
		
		default: return ($ora) ? $dataISO : substr($dataISO,0,10);
	}
}


function date_decode($dataenc){
	
	if(FRONT_DATE_FORMAT) return $dataenc;
	
	$tk0=explode(" ",$dataenc);
	
	$d0=explode("/",$tk0[0]);
	
	$ora0=(isset($tk0[1])) ? " ".$tk0[1] : '';
	
	switch (FRONT_DATE_FORMAT){
		
		case 'ita': return $d0[2].$d0[1].$d0[0].$ora0;
		break;
		
		case 'eng': return $d0[2].$d0[0].$d0[1].$ora0;
		break;
		
		default: return $dataenc;
	}
}






/**
 * Estrae le parti di una data in formato internazionale e restituisce le parti della stessa in un array.
 * Fornisce inoltre un valore di chiave "ita" gi� pronto con la data in formato italiano.
 *
 * @param string $dataISO
 * @param bool $ora
 * @return array
 */
function dataISO2ITA($dataISO,$ora=false){
	
	$dataITA['d']=substr($dataISO,8,2);
	$dataITA['m']=substr($dataISO,5,2);
	$dataITA['Y']=substr($dataISO,0,4);
	$dataITA['ita']=$dataITA['d']."/".$dataITA['m']."/".$dataITA['Y'];
	
	if($ora){
		$dataITA['h']=substr($dataISO,11,2);
		$dataITA['i']=substr($dataISO,14,2);
		$dataITA['s']=substr($dataISO,17,2);
		$dataITA['ita_noh']=$dataITA['ita'];
		
		$dataITA['ita'].= " alle ".$dataITA['h'].":".$dataITA['i'];
	}
		
	return $dataITA;
}




/**
 * Funzione di trasformazione di data da formato internazionale a formato italiano o con data e la T. 
 * Richiama a sua volta la funzione dataISO2ITA()
 *
 * @param date $dataISO
 * @param bool $ora
 * @param string $special 'string' (mostra la data con la parola ALLE + $ora | 'ods' (caso speciale per l'esportazione open office)
 * @see function dataISO2ITA
 * @return string
 */
function dataITA($dataISO,$ora=false,$special=''){
	
	$d= dataISO2ITA($dataISO,$ora);
	if($ora){
		
		// caso open office export
		if($special=='ods')
			return $d['ita_noh']."T".$d['h'].$d['i'].$d['s'];
		else if($special=='string')
			return $d['ita'];
		else
			return $d['ita_noh']." ".$d['h'].":".$d['i'].":".$d['s'];
	}
	else{
		return $d['ita'];
	}
	
}




/**
 * Estrae le parti di una data in formato internazionale e restituisce le parti della stessa in un array.
 * Fornisce inoltre un valore di chiave "eng" pronto con la data in formato english.
 *
 * @param string $dataISO
 * @param bool $ora
 * @return array
 */
function dataISO2ENG($dataISO,$ora=false){
	
	$dataENG['d']=substr($dataISO,8,2);
	$dataENG['m']=substr($dataISO,5,2);
	$dataENG['Y']=substr($dataISO,0,4);
	$dataENG['eng']=$dataENG['m']."/".$dataENG['d']."/".$dataENG['Y'];
	
	if($ora){
		$dataENG['h']=substr($dataISO,11,2);
		$dataENG['i']=substr($dataISO,14,2);
		$dataENG['s']=substr($dataISO,17,2);
		$dataENG['eng_noh']=$dataENG['eng'];
		
		$dataENG['eng'].= " on ".$dataENG['h'].":".$dataENG['i'];
	}
		
	return $dataENG;
}




/**
 * Funzione di trasformazione di data da formato internazionale a formato english 
 * o con data e altre opzioni relative a $special
 * Richiama a sua volta la funzione dataISO2ENG()
 *
 * @param date $dataISO
 * @param bool $ora
 * @param string $special
 * @see function dataISO2ENG
 * @return string
 */
function dataENG($dataISO,$ora=false,$special=''){
	
	$d= dataISO2ENG($dataISO,$ora);
	if($ora){
		
		// caso open office export
		if($special=='ods')
			return $d['eng_noh']."T".$d['h'].$d['i'].$d['s'];
		else
			return $d['eng_noh']." ".$d['h'].":".$d['i'].":".$d['s'];
	}
	else{
		return $d['eng'];
	}
	
}


/**
 * Funzione interna per la determinazione dei campi coinvolti da una data query SQL
 *
 * @param string $sql
 * @return string
 */
function analisi_select_from($sql){
	
	global $link;
	
	if(!vmsql_try($sql,$link,true)){
		return false;
	}
	
	// parsing della query
	$campi = eregi_replace("SELECT",'',$sql);
	
	list($campi,$monnezza) = preg_split("'[\W]FROM[\W]'i",$campi);
		

//	$campi = trim(strtok($campi,'FROM'));
//	$campi = trim(strtok($campi,'from'));

	

	// quanti campi ci sono?
	if(ereg(',',$campi)){

		$ar_campi=explode(",",$campi);
		
		
		return array(trim($ar_campi[0]),trim($ar_campi[1]));
	}
	else{
		return array(trim($campi));
	}
	
}

/**
 * Utilit� che da un 1:0 restituisce "Si" o "No" con la classe CSS omonima
 *
 * @param int $int
 * @return string
 */
function high_si_no($int){

	return ($int) ? '<span class="si">'._("Si").'</span>' :  '<span class="no">'._("No").'</span>' ;
}

/**
 * Funzione per generare l'ordinamento delle tabelle secondo una colonna data
 *
 * @param string $etichetta
 * @param int $ord
 * @param string $desc
 */
function table_sort($etichetta,$ord,$desc=""){
	
	$getord= (isset($_GET['ord'])) ? (int) $_GET['ord'] : $ord;
	$sort = (isset($_GET['sort'])) ? $_GET['sort'] : 0;
	
	if($desc!=""){
		
		$title="title=\"$desc\"";		
	}
	else{
		$title="";
	}
	
	if(isset($_GET['ord']) && $ord==$_GET['ord']){
		
		$class="tab-ord";	
		if($sort=="d"){
				return "<a class=\"$class desc\" href=\"".$_SERVER['PHP_SELF']."?gid=".$_GET['gid']."&amp;ord=$ord&amp;sort=a\" $title>$etichetta</a>";
			}
			else {
			
				return "<a class=\"$class asc\" href=\"".$_SERVER['PHP_SELF']."?gid=".$_GET['gid']."&amp;ord=$ord&amp;sort=d\" $title>$etichetta</a>";;
		}
		
	}
	else{
		return "<a href=\"".$_SERVER['PHP_SELF']."?gid=".$_GET['gid']."&amp;ord=$ord&amp;sort=a\" $title>$etichetta</a>";	
	}
	
}

/**
 * Funzione che recupera l'ordinamento impostato in una tabella data
 *
 * @param string $tabella
 * @param int $gid
 * @return string
 */
function prendi_orderby($tabella,$gid=0){
	
	global $link,$db1;
	
	// Prendi il campo di ordinamento dalla tabella:
	$q_orderby = vmsql_query("SELECT orderby , orderby_sort FROM {$db1['frontend']}.registro_tab WHERE table_name='$tabella' AND gid=$gid ",$link);
	
	list($orderby,$orderby_sort) = vmsql_fetch_row($q_orderby);
	
	
	// se non � stato impostato un orderby prende la chiave primaria
	if($orderby==''){
		
		$orderby=prendi_PK($tabella);
	}
	
	
	
	// orderby e orderby_sort possono essere valori oppure liste separate da virgola
	$orderby_a=explode(",",$orderby);
	$orderby_sort_a=explode(",",$orderby_sort);
	
	$string_orderby='';
	
	for($i=0;$i<count($orderby_a);$i++){
		
		$orderby_sort_a_string=(isset($orderby_sort_a[$i]) && $orderby_sort_a[$i]!='') ? $orderby_sort_a[$i] : "ASC";
		
		$string_orderby.=$orderby_a[$i]." ".$orderby_sort_a_string.",";
	}
	
	return substr($string_orderby,0,-1);
}





/**
 * Funzione di debug. 
 * Scrive in un file di testo le query o il testo che viene passato con il parametro $sql
 * E' utile soprattutto in operazioni di tipo AJAX.
 *
 * @param string $sql
 * @param string $filename
 */
function rpc_debug($sql,$filename="./rpc.debug.txt"){
	
	global $RPC_DEBUG;
	
	if($RPC_DEBUG){
		
		if($fp=@fopen($filename,"a")){
			
			fwrite($fp,date("Y-m-d H:i:s")." --- ".str_replace(array("\n","\r")," ",$sql)."\n");
			fclose($fp);
		}
	}
}



/**
 * Funzione di scrittura del log delle operazioni compiute mediante le maschere di VFront
 * E' dipendente dal parametro $RPC_LOG, definito nel file di configurazione (default conf/conf.vfront.php)
 *
 * @param string $op 'select'|'insert'|'delete'|'update'|'ripristino'
 * @param string $tabella
 * @param int $uid
 * @param int $gid
 * @param string $info_pk
 * @param bool $storico
 * @param string $storico_pre
 * @param string $storico_post
 * @param string $info_browser
 * @return mixed
 */
function rpc_log($op,$tabella,$uid,$gid,$info_pk='',$storico=true,$storico_pre='',$storico_post='',$info_browser=''){
	
	global $RPC_LOG, $db1, $link;
	
	if($RPC_LOG){
		
		if(!in_array($op,array('select','insert','delete','update','ripristino','duplicazione','import'))){
			
			$op='sconosciuta';			
		}
		
		$gid= (int) $gid;
		$uid = (int) $uid;
		
		switch($op){
			
			case 'ripristino': 
			
					
			
					$id_record = $info_pk;
			
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,info_browser) 
						  VALUES ('$op','$tabella',$uid,$gid,'$id_record','$info_browser')";
					
					$test=vmsql_try($sql,$link,false);
			break;	
			
			case 'sconosciuta': 
			
					$id_record = $info_pk;
			
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,info_browser) 
						  VALUES ('$op','$tabella',$uid,$gid,'$id_record','$info_browser')";
					
					$test=vmsql_try($sql,$link,false);
			break;	
			
			case 'duplicazione': 
			
					$id_record = $info_pk;
			
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,info_browser,storico_post) 
						  VALUES ('$op','$tabella',$uid,$gid,'$id_record','$info_browser','$storico_post')";
					
					$test=vmsql_try($sql,$link,false);
			break;	
			
					
			case 'import': 
			case 'insert': 
			
				$id_record = $info_pk;
			
					if($storico){
						$storico_post=addslashes($storico_post);
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,storico_post,id_record,info_browser) 
						  VALUES ('$op','$tabella',$uid,$gid,'$storico_post','$id_record','$info_browser')";
					}else{
						
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,info_browser) 
						  VALUES ('$op','$tabella',$uid,$gid,'$id_record','$info_browser')";
					}
					
					$test=vmsql_try($sql,$link,false);
					$ID_LOG=vmsql_insert_id($link,"{$db1['frontend']}.log",'id_log');
			break;
			
			
			case 'delete':
					
					if($storico){
						
						$condizione='';
						$id='';
						
							foreach ($info_pk as $k=>$val){
								$val=addslashes(stripslashes(utf8_decode($val)));
								$condizione.=" $k='$val' AND";
								$id.=$val."|";
							}
							
							$condizione=substr($condizione,0,-3);
							$id=substr($id,0,-1);
						
						
						$q_storico_pre=vmsql_query("SELECT * FROM $tabella WHERE $condizione",$link);
						
						$RS_pre=vmsql_fetch_assoc($q_storico_pre);
						
						$storico_pre=addslashes(serialize($RS_pre));
						
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,storico_pre,info_browser) 
							  VALUES ('$op','$tabella',$uid,$gid,'$id','$storico_pre','$info_browser')";
					}
					else{

						$condizione='';
						$id='';
						
							foreach ($info_pk as $k=>$val){
								$val=addslashes(stripslashes(utf8_decode($val)));
								$condizione.=" $k='$val' AND";
								$id.=$val."|";
							}
							
							$condizione=substr($condizione,0,-3);
							$id=substr($id,0,-1);
				
						
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,info_browser) 
							  VALUES ('$op','$tabella',$uid,$gid,'$id','$info_browser')";
					}
					
					$test=vmsql_try($sql,$link,false);
					
					$ID_LOG=vmsql_insert_id($link,"{$db1['frontend']}.log",'id_log');
					
			break;
			
			
			case 'update':
					
					if($storico){
						
						$condizione='';
						$id='';
						
							foreach ($info_pk as $k=>$val){
								$val=addslashes(stripslashes(utf8_decode($val)));
								$condizione.=" $k='$val' AND";
								$id.=$val."|";
							}
							
							$condizione=substr($condizione,0,-3);
							$id=addslashes(substr($id,0,-1));
						
						
						$q_storico_pre=vmsql_query("SELECT * FROM $tabella WHERE $condizione",$link);
						
						$RS_pre=vmsql_fetch_assoc($q_storico_pre);
						
						$storico_pre=addslashes(serialize($RS_pre));
						$storico_post=addslashes($storico_post);
						
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,storico_pre,storico_post,info_browser) 
							  VALUES ('$op','$tabella',$uid,$gid,'$id','$storico_pre','$storico_post','$info_browser')";
						$test=vmsql_try($sql,$link,false);
						
						$ID_LOG=vmsql_insert_id($link,"{$db1['frontend']}.log",'id_log');
						
					}
					else{

						$condizione='';
						$id='';
						
							foreach ($info_pk as $k=>$val){
								$val=addslashes(stripslashes(utf8_decode($val)));
								$condizione.=" $k='$val' AND";
								$id.=$val."|";
							}
							
							$condizione=substr($condizione,0,-3);
							$id=substr($id,0,-1);
				
						
						$sql="INSERT INTO {$db1['frontend']}.log (op,tabella,uid,gid,id_record,info_browser) 
							  VALUES ('$op','$tabella',$uid,$gid,'$id','$info_browser')";
						
						$test=vmsql_try($sql,$link,false);
						
						$ID_LOG=vmsql_insert_id($link,"{$db1['frontend']}.log",'id_log');
						
					}
			break;
			
			
		}
		
		
	}
	else{
		rpc_debug("Operazione $op saltata");
	}
	
	return $ID_LOG;
}


/**
 * Funzione di ordinamento dei valori di una matrice 
 * secondo una colonna scelta in ordine ascendente o discendente
 * Funziona con una logica simile a l'SQL
 *
 * @param array $matrice La matrice data
 * @param string $campo Il nome del campo
 * @param string $tipo Metodo di ordinamento (ASC o DESC) 
 * @return array La nuova matrice ordinata
 */
function ordina_matrice($matrice,$campo,$tipo="ASC"){
	
	if(!is_array($matrice) || count($matrice)<2 ){
		return $matrice;
	}
	
	// Scorre la matrice
	foreach($matrice as $k=>$ar){
		$new[$k]=array($ar[$campo],$ar);
	}
	
	if($tipo=="DESC"){
		rsort($new);
	}else{
		sort($new);
	}
	
	$ordinata=array();
	
	while(list($k,$ar)=each($new)){
		
		$ordinata[$k]=$new[$k][1];
	}	
	
	return $ordinata;
	
}



/**
 * Testa se il permesso/i specificato in $perm � posseduto dall'utente
 *
 * @param mixed $perm permesso o array di permessi
 * @return bool
 */
function permesso($perm){
	
	// sempre e comunque gli amministratori possono accedere
	if($_SESSION['user']['livello']==3) return true;

	// DEBUG... per ora restituisce sempre vero...
//	return true;

	if(!is_array($_SESSION['user']['permessi'])) $_SESSION['user']['permessi']=array();
	
	if(is_string($perm)){
		
		return (in_array($perm,$_SESSION['user']['permessi'])) ? true:false;
	}
	elseif(is_array($perm)){
		
		foreach($perm as $p){
			if(!in_array($p,$_SESSION['user']['permessi'])) return false;
		}
		
		return true;
	}
}


?>