<?php
/**
* Libreria di funzioni legate all'esportazione dei dati.  
* 
* @package VFront
* @subpackage Function-Libraries
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: func.export.php 372 2009-05-05 13:55:55Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/


/**
 * Funzione per l'esportazione dei dati
 *
 * @param int $oid
 * @param bool $only_visibile
 * @return resource
 */
function __tabella_elaborata($oid,$only_visibile=true){
	
	global $link,$db1;
	
	$nome_tabella = oid2name($oid);
	
	$clausola_visibile = ($only_visibile) ? "AND c.in_visibile=1" : "";
	
	// PRENDI INFO Colonne della TABELLA
	$query2 = vmsql_query("SELECT c.column_name , c.data_type , c.character_maximum_length as maxsize, c.is_nullable, 
							c.in_tipo, c.in_default, t.orderby, t.orderby_sort
							FROM {$db1['frontend']}.registro_col c, {$db1['frontend']}.registro_tab t
							WHERE c.id_table=$oid 
							AND c.id_table=t.id_table
							$clausola_visibile
							ORDER BY c.ordinal_position",$link);
	
	$matrice_info = vmsql_fetch_assoc_all($query2);
	
	foreach($matrice_info as $k=>$info){
		
		if($k==0){
			$ORDERBY = ($info['orderby']!='') ? "ORDER BY ".$info['orderby']." ".$info['orderby_sort'] : "";
		}
		
		if($info['in_tipo']=="select_from"){	
			
			$test = preg_match("'SELECT ([\w]+) ?, ?(.+) +FROM +([\w]+).*?'ui",$info['in_default'],$campo_k);
			
			$campo_select= (preg_match("'\('",$campo_k[2])) ? $campo_k[2] : "t$k.{$campo_k[2]}";
			
			$campi.=" (SELECT $campo_select FROM {$campo_k[3]} t$k WHERE t$k.{$campo_k[1]}=t.{$info['column_name']}) as ".$info['column_name'].",";
			
		}
		else{
			
			$campi.=" t.".$info['column_name'].",";
		}
	}
	
	$campi=substr($campi,0,-1);
	
	$query_elab=vmsql_query("SELECT $campi FROM {$db1['dbname']}.$nome_tabella t $ORDERBY",$link);
	
	return $query_elab;
}











/**
 * Funzione di esportazione generica tabella in formato CSV
 *
 * @param int $oid_tabella
 * @param bool $raw
 * @param string $sep
 */
function tabella_csv($oid_tabella,$raw=true,$sep=','){
	
	global $link,$db1;
	
	$oid_tabella = (int) $oid_tabella;
	
	$nome_tabella = oid2name($oid_tabella);
	
	$nome_file_tmp=_PATH_TMP."/".md5($oid_tabella).".csv";
	
	
	// Prende la tabella in XML
	if($raw){
		
		$q=vmsql_query("SELECT * FROM ".$db1['dbname'].".$nome_tabella",$link);
	
	}
	else{
		$q=__tabella_elaborata($oid_tabella);
	}
	
	$RIGHE="";
	
	$i=0;
	
	while($RS=vmsql_fetch_assoc($q)){
		
		if($i==0){
			
			$campi=array_keys($RS);
			$fp=fopen($nome_file_tmp,'w');
			fwrite($fp,"\"".implode('"'.$sep.'"',$campi)."\"\n");
			fclose($fp);
			
		}
		
		$RIGA='';
		
		foreach($RS as $val){
			$RIGA.="\"".addslashes($val)."\"$sep";
		}
		
		$RIGA=stripslashes($RIGA);
		$RIGA=str_replace(array("\r\n","\n\r","\n","\r")," ",$RIGA);
		
		$fp=fopen($nome_file_tmp,'a');
		fwrite($fp,substr($RIGA,0,-1)."\n");
		fclose($fp);
		
		$i++;
	}
	
	
	$nome_tabella = oid2name($oid_tabella);
	
	  	//Begin writing headers
	header("Content-Type: application/csv-tab-delimited-table");
	header("Content-disposition: filename=$nome_tabella-".date("Ymd").".csv");
	print join('',file($nome_file_tmp));
	unlink($nome_file_tmp);
	exit;
	
}


/**
 * Funzione di trasfomazione di tabella in HTML
 *
 * @param int $oid_tabella
 * @param bool $raw
 * @param string $colore_th
 */
function tabella_html($oid_tabella,$raw=true,$colore_th=''){
	
  	//Begin writing headers
	print _table2html($oid_tabella,$raw,$colore_th);
	exit;
}



/**
 * Funzione interna di generazione della tabella HTML. 
 * Viene poi utilizzata da altre funzioni di questa libreria per generare l'output.
 *
 * @param int $oid_tabella
 * @param bool $raw
 * @param string $colore_th Espresso in RGB esadecimale. Ad es. #FF0000
 * @return string
 */
function _table2html($oid_tabella,$raw=true,$colore_th=''){
	
	global $link,$db1;
	
	$oid_tabella= (int) $oid_tabella;
			
	$nome_tabella = oid2name($oid_tabella);
	
	$nome_file_tmp=_PATH_TMP."/".md5($oid_tabella).".htm";
	
	// PREN DE LA QUERY
	if($raw){
		
		$q=vmsql_query("SELECT * FROM ".$db1['dbname'].".$nome_tabella",$link);
	}
	else{
		$q=__tabella_elaborata($oid_tabella);
	}
		

	
	
	$HTML=<<<HTML
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
  <head>
  <meta http-equiv="Content-type" content="text/html; charset=iso-8859-1">
  <title></title>
  </head>
  <body>
HTML;

	$i=0;
	$info_colore= ($colore_th=='') ? " bgcolor=\"#FF9900\"" : " bgcolor=\"$colore_th\"";
	$TR_TD="";
	
	$fp=fopen($nome_file_tmp,'w');
	
	while($RS=vmsql_fetch_assoc($q)){
		
		if($i==0){
			
			$campi=array_keys($RS);
			
			$TR_TH="<tr><th$info_colore>".implode("</th><th$info_colore>",$campi)."</th></tr>\n";
			
		}
		
		$TR_TD="<tr><td>".implode("</td><td>",$RS)."</td></tr>\n";
		
		fwrite($fp,$TR_TD);
		
		
		
		
		$i++;
	}
	
	fclose($fp);
	
return "
$HTML
<table border=\"1\" summary=\"$nome_tabella\">
		$TR_TH
		".join('',file($nome_file_tmp))."
</table>
</body>
</html>";
}








/**
 * Funzione di export excel mediante l'uso del pacchetto PEAR Spreadsheet_Excel_Writer
 *
 * @param int $oid_tabella
 * @param bool $raw
 * @param mixed $colore_th
 * @param mixed $font_color_th
 */
function _spreadsheet($oid_tabella,$raw=true,$colore_th=44,$font_color_th='black'){
	
	global $link,$db1;
	
	
	include_once('Spreadsheet/Excel/Writer.php');
	
	$clausola_visibile = (!$raw) ? "AND c.in_visibile=1" : "";
	
	// PRENDI INFO Colonne della TABELLA
	$query2 = vmsql_query("SELECT c.column_name , c.data_type , c.character_maximum_length as maxsize
						FROM {$db1['frontend']}.registro_col c, {$db1['frontend']}.registro_tab t
						WHERE c.id_table=$oid_tabella 
						AND c.id_table=t.id_table
						$clausola_visibile
						ORDER BY c.ordinal_position",$link);
	
	$matrice_info=vmsql_fetch_assoc_all($query2,true);
		
	$nome_tabella = oid2name($oid_tabella);
	
	// Prende la tabella in XML
	if($raw){
		
		$q=vmsql_query("SELECT * FROM ".$db1['dbname'].".$nome_tabella",$link);
	
	}
	else{
		$q=__tabella_elaborata($oid_tabella);
	}
	
	
	
	// larghezza cols default:
	$standard_col=12;
	$maxsize_col=30;
	if($colore_th=='') $colore_th=44 ;
	

	
	
	
	
	
	

	// Creating a workbook
	$workbook = new Spreadsheet_Excel_Writer();
	
	
	

	// sending HTTP headers
	$workbook->send($nome_tabella.'-'.date("Ymd").'.xls');


	// Stile cella
	$format0 =& $workbook->addFormat();
	$format0->setBorder(1);

	// stile intestazione
	$format1 =& $workbook->addFormat();
	$format1->setColor($font_color_th);
	$format1->setFgColor($colore_th);
	$format1->setBorderColor('grey');
	$format1->setBorder(1);
	$format1->setBold();
	$format1->setAlign('center');
	$format1->setTextWrap();


	$worksheet[0] =& $workbook->addWorksheet('table');

	

	$x=0;

	$y=0;

	
	
	// intestazioni
	foreach($matrice_info['column_name'] as $u=>$val_eti){
		
		
		// lunghezza colonna
		if(in_array($matrice_info['data_type'][$u],array('char','varchar'))){
			
			$n_cols=($matrice_info['maxsize'][$u]>$standard_col) ? $matrice_info['maxsize'][$u] : $standard_col;
			if($n_cols>$maxsize_col) $n_cols=$maxsize_col;
		}
		// lunghezza colonna
		else if(in_array($matrice_info['data_type'][$u],array('text','mediumtext','longtext'))){
			
			$n_cols=$maxsize_col;
		}
		else{
			// lunghezza chars eti
			if(strlen($val_eti)>=$standard_col) 
				$n_cols=strlen($val_eti)+3;
			
			else 
				$n_cols=$standard_col;
		}
		
		$worksheet[0]->setColumn($x,$x,$n_cols);
		
		$worksheet[0]->write(0, $x, $val_eti,$format1);
		
		$x++;
	}


	// giornate
	while ($RS=vmsql_fetch_row($q)) {
		
		$y++;
		$xx=0;

		// per ogni ulente esito della rilevazione
		for($i=0;$i<count($RS);$i++){

			$worksheet[0]->write($y, $xx, $RS[$i],$format0);

			$xx++;
		}
	}
	
	
	$workbook->close();

	exit;
	
}










#################################################################
#
#	EXCEL (html letto da excel)
#


/**
 * Genera una tabella XLS creando tabella HTML e mandando un header di excel
 *
 * @param int $oid_tabella
 * @param bool $raw
 * @param string $colore_th
 */
function tabella_xls($oid_tabella,$raw=true,$colore_th=''){
	
	global $link,$db1;
	
	$test_pear_pk=(include_once('Spreadsheet/Excel/Writer.php'));
	
	if($test_pear_pk){
		// Prende la tabella in XML
		$xls_out=_spreadsheet($oid_tabella,$raw,$colore_th);
	}
	else{
		// Prende la tabella in XML
		$xls_out=_table2html($oid_tabella,$raw,$colore_th);
	}
	
	$nome_tabella = oid2name($oid_tabella);
	$ctype="application/vnd.ms-excel";
	
  	//Begin writing headers
	header("Pragma: public");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: public");
	header("Content-Description: File Transfer");
  
	//Use the switch-generated Content-Type
	header("Content-Type: $ctype");
	
	//Force the download
	$header="Content-Disposition: attachment; filename=".$nome_tabella."-".date("Ymd").".xls;";
	header($header );
	print $xls_out;
	exit;
	
}



/**
 * Genera una tabella nello standard Open Document Spreadsheet (ad es. openOffice)
 *
 * @param int $oid_tabella
 * @param bool $raw
 * @param string $colore_th
 */
function tabella_ods($oid_tabella,$raw=true,$colore_th=''){
	
	global $link,$db1;
	
	$id_tabella = (int) $oid_tabella;
	
	// PRENDI LE IMPOSTAZIONI DEI CAMPI DELLA TABELLA
	
	$q0=vmsql_query("SELECT column_name,data_type FROM {$db1['frontend']}.registro_col WHERE id_table=$id_tabella ORDER BY ordinal_position",$link);
	
	while($RS0=vmsql_fetch_row($q0)){
		$tipo_campo[$RS0[0]]=$RS0[1];
	}
	
	$nome_tabella = oid2name($id_tabella);
	
	if($raw){
		$q=vmsql_query("SELECT * FROM ".$db1['dbname'].".$nome_tabella",$link);
	}
	else{
		$q=__tabella_elaborata($id_tabella);
	}
	
	
	
	
	
	// Cancella se esiste già il file
	@unlink(_PATH_TMP.'/content.xml');
	
	
	// prendi il file content.xml
	$cont=join('',file(FRONT_REALPATH."/plugins/ods/content.xml"));
	
	// array contenuto;
	$ar_cont=explode('<!-- contenuto -->',$cont);
	
	
	
	$XML_INT='';
	$XML_CONT='';
	
	$i=0;
	$ultima_scrittura=0;
	
	
	while($RS=vmsql_fetch_assoc($q)){
		
		// prima riga, scrive le intestazioni
		
		$XML_CONT.='<table:table-row table:style-name="ro1">';
		
		foreach($RS as $lab=>$val){
			
			if($i==0){
				
				$XML_INT.="
					<table:table-cell table:style-name=\"ce1\" office:value-type=\"string\">
						<text:p>{$lab}</text:p>
					</table:table-cell>";
				
					

				
			}
				
			$XML_CONT.=_ods_type($tipo_campo,$lab,$val);
			
		}
		
		
			
		
		$XML_CONT.='</table:table-row>';
		
		
		// scrittura prima volta:
		
		if($i==0){
			
			
			$apertura_XML='
					<table:table table:name="'.$nome_tabella.'" table:style-name="ta1" table:print="false">
						<table:table-column table:style-name="co1" table:number-columns-repeated="'.($i+1).'" table:default-cell-style-name="Default"/>
						<table:table-row table:style-name="ro1">
						'.$XML_INT.'
						</table:table-row>
						';
			
			// Scrittura inizio di tabella
			if($fp=@fopen(_PATH_TMP.'/content.xml','a')){
				fwrite($fp,$ar_cont[0]);
				fwrite($fp,$apertura_XML);
			}
			
		}
		
		// scrivo la roba in ciclo ogni 10 record
		if($i%20==0){
			if($fp=@fopen(_PATH_TMP.'/content.xml','a')){
				fwrite($fp,$XML_CONT);
				fclose($fp);
				
				$ultima_scrittura=$i;
				
				unset($XML_CONT);
			}
		}
		
		
		$i++;
	}
	
	// ultima scrittura fuori dal ciclo (per i record esclusi dal multiplo...)
	
	if($i>$ultima_scrittura){
			if($fp=@fopen(_PATH_TMP.'/content.xml','a')){
				fwrite($fp,$XML_CONT);
				fclose($fp);
				
				unset($XML_CONT);
			}
	}
	
		
	
	
	$chiusura_XML=	'\t</table:table>';
	
		
		
	
		
	
	
	// chiudi il nuovo file
	if($fp=@fopen(_PATH_TMP.'/content.xml','a')){
		fwrite($fp,$chiusura_XML);
		fwrite($fp,$ar_cont[1]);
		fclose($fp);
	}
	else {
		openErrorGenerico(_("Errore: impossibile scrivere sul filesystem."),false,_('Non &egrave; stato possibile generare il file per impostazioni di diritti di scrittura del server.')."<br />"._("Se il problema si verificasse sistematicamente contattare l\'amministratore di sistema"));
		exit;
	}
	
	
	// METODO PHP
	// CREA IL PACCHETTO
	
	require_once(FRONT_REALPATH."/inc/EasyZIP.class.php");
	
	$zip = new EasyZIP();
	
	$zip->addFile("content.xml",_PATH_TMP."/");
	$zip->addDir(FRONT_REALPATH."/plugins/ods","Configurations2");
	$zip->addDir(FRONT_REALPATH."/plugins/ods","META-INF");
	$zip->addDir(FRONT_REALPATH."/plugins/ods","Pictures");
	$zip->addFile("meta.xml",FRONT_REALPATH."/plugins/ods/");
	$zip->addFile("settings.xml",FRONT_REALPATH."/plugins/ods/");
	$zip->addFile("styles.xml",FRONT_REALPATH."/plugins/ods/");
	$zip->addFile("mimetype",FRONT_REALPATH."/plugins/ods/");

	
	$tmp_ods=_PATH_TMP.'/'.md5(time()).".ods";
	
	$zip->zipFile($tmp_ods);
	
	
	
	
	$ctype="application/vnd.oasis.opendocument.spreadsheet";
	
  	
	if(is_file($tmp_ods)){
		
		
		//Begin writing headers
		header("Pragma: public");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Cache-Control: public");
		header("Content-Description: File Transfer");
	  
		//Use the switch-generated Content-Type
		header("Content-Type: $ctype");
		
		//Force the download
		$header="Content-Disposition: attachment; filename=".$nome_tabella."-".date("Ymd").".ods;";
		header($header);
		
		print join('',file($tmp_ods));
	
	}
	else{
		
		openErrorGenerico(_("Errore: impossibile scrivere sul filesystem."),false,_('Non &egrave; stato possibile generare il file per impostazioni di diritti di scrittura del server.').'<br />'._("Se il problema si verificasse sistematicamente contattare l\'amministratore di sistema"));
		exit;
		
	}
	
	unlink(_PATH_TMP."/content.xml");
	unlink($tmp_ods);
	exit;
	
	
}





/**
 * Funzione interna usata nella generazione di foglio di calcolo OpenDocument.
 * Questa funzione � richiamata dalla funzione {@see tabella_ods}
 *
 * @param array $array_tipo_campo
 * @param string $nome_campo
 * @param mixed $value
 * @see function tabella_ods
 * @return string Il frammento di XML per il campo scelto
 */
function _ods_type($array_tipo_campo,$nome_campo,$value){
	
	switch($array_tipo_campo[$nome_campo]){
		
		case 'int':
		case 'float':
		case 'double': 
		return '
					<table:table-cell office:value-type="float" office:value="'.$value.'">
						<text:p>'.$value.'</text:p>
					</table:table-cell>';
		break;
		
		
		
		
		case 'date' :
		return '
					<table:table-cell office:value-type="date" office:date-value="'.$value.'">
						<text:p>'.date_encode($value,false).'</text:p>
					</table:table-cell>';
		break;
		
		
		
		
		
		case 'timestamp':
		case 'datetime':
		return '
					<table:table-cell office:value-type="date" office:date-value="'.$value.'">
						<text:p>'.date_encode($value,true,'ods').'</text:p>
					</table:table-cell>';
		
		
		
		
		default : // varie string
					$value=str_replace(array("\n","\r"),"",$value);
					$value=htmlspecialchars(utf8_encode($value));
					
		return '
					<table:table-cell office:value-type="string">
						<text:p>'.$value.'</text:p>
					</table:table-cell>';
		
		
	}
	
}

?>