<?php
/**
* Libreria di funzioni di gestione del database di regole di VFront. 
* Sono qui scritte le funzioni di gestione dei registri 
* e di utilit� per la lettura e scrittura delle tabelle di sistema
* 
* @package VFront
* @subpackage Function-Libraries
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: func.frontend.php 405 2009-10-18 15:29:56Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/

/**
 * Da l'oid di tabella restituisce il nome della stessa
 * 
 * @param int $oid
 * @param bool $solo_visibili
 * @return string
 */
function oid2name($oid=0,$solo_visibili=false){
	
	global $link,$db1;
	
	$oid= (int) $oid;
	
	if($oid>0){
		
		$sql_vis = ($solo_visibili) ? "AND visibile=1" : "";
		
		$q=vmsql_query("SELECT table_name 
						FROM {$db1['frontend']}.registro_tab
						WHERE id_table=$oid
						$sql_vis
						LIMIT 1",$link);
		
		if(vmsql_num_rows($q)==1){
		
			list($nome_tabella) = vmsql_fetch_row($q);
		
			return $nome_tabella;
		}
		else{
			
			return 0;
		}
	}
	else{
	
		return 0;	
	}
}



/**
 * Da nome tabella e gruppo restituisce l'id tabella (oid)
 *
 * @param string $name
 * @param int $gid
 * @return int
 */
function name2oid($name,$gid=0){
	
	global $link,$db1;
	
	$gid= (int) $gid;
	
		
		$q=vmsql_query("SELECT id_table 
						FROM {$db1['frontend']}.registro_tab
						WHERE table_name='$name'
						AND gid=$gid
						LIMIT 1",$link);
		
		if(vmsql_num_rows($q)==1){
		
			list($oid) = vmsql_fetch_row($q);
		
			return $oid;
		}
		else{
			
			return 0;
		}
}

/**
 * Prendi le tabelle presenti nel registro
 *
 * @param bool $solo_visibili
 * @return array
 */
function prendi_tabelle($gid=0,$solo_visibili=false){
	
	global $link,$db1;
	
		
		$sql_vis = ($solo_visibili) ? "AND visibile=1" : "";
		
		$gid= (int) $gid;
		
		$q=vmsql_query("SELECT id_table, table_name 
						FROM {$db1['frontend']}.registro_tab
						WHERE gid=$gid
						$sql_vis
						ORDER BY table_name",$link);
		
		if(vmsql_num_rows($q)>0){
		
			return vmsql_fetch_assoc_all($q);
		}
		else{
			return array();
		}
}



/**
 * Prendi le informazioni sui campi di una data tabella dal nome oppure dall'oid per un dato gruppo
 *
 * @param mixed $table_name Nome della tabella
 * @param string $campi Campi della tabella che si vogliono recuperare, separati da virgola (se pi� di uno)
 * @param bool $solo_visibili Prende solo le tabelle visibili (diritto SELECT) dal gruppo specificato
 * @param int $gid Gruppo secondo il quale recuperare le informazioni sulle tabelle. Se non specificato � il gruppo in sessione
 * @return matrix Matrice di risultati SQL
 */
function prendi_colonne_frontend($table_name,$campi="*",$solo_visibili=true,$gid="session"){
	
	global $link,$db1;
	
	$sql_vis = ($solo_visibili) ? "AND in_visibile=1" : "";
	
	// e' oid?
	if(is_numeric($table_name)){
		
		$oid=intval($table_name);
		
		$clausola_ID = "AND t.id_table=$oid";
		
	}
	// allora � nome tabella.. c'� bisogno pure del GID
	else{
	
		if($gid=="session"){
			$gid= (int) $_SESSION['gid'];
		}
		else{
			$gid= (int) $gid;
		}
		
		$clausola_ID = "AND t.table_name='$table_name'
						AND t.gid=$gid	";
	}
	
	
	
	$q_info = vmsql_query("SELECT $campi
						FROM {$db1['frontend']}.registro_col c, {$db1['frontend']}.registro_tab t
						WHERE c.id_table=t.id_table
						$clausola_ID
						$sql_vis
						ORDER BY c.in_ordine, c.ordinal_position",$link);


	$matrice = vmsql_fetch_row_all($q_info,true);
	
	return $matrice;
}






/**
 * Funzione di test per verificare l'esistenza di una tabella 
 *
 * @param string $tabella
 * @return bool
 */
function is_tabella($tabella){
	
	global $link,$db1;
	
	$q=vmsql_query("SELECT id_table FROM {$db1['frontend']}.registro_tab WHERE table_name='$tabella' ",$link);
	
	return (vmsql_num_rows($q)>0) ? true:false;
	
}



/**
 * Funzione di test per verificare l'esistenza di una tabella attraverso l'oid
 *
 * @param int $oid
 * @return bool
 */
function is_tabella_by_oid($oid,$only_visibile=false){
	
	global $link,$db1;
	
	$only_vis = ($only_visibile) ? ' AND visibile=1' : '';
	
	$q=vmsql_query("SELECT id_table FROM {$db1['frontend']}.registro_tab WHERE id_table=".intval($oid) . $only_vis,$link);
	
	return (vmsql_num_rows($q)>0) ? true:false;
	
}

/**
 * Funzione di test per verificare l'esistenza di un campo di tabella 
 *
 * @param string $campo
 * @return bool
 */
function is_campo($campo){
	
	global $link,$db1;
	
	$q=vmsql_query("SELECT column_name FROM {$db1['frontend']}.registro_col WHERE column_name='$campo' ",$link);
	
	return (vmsql_num_rows($q)>0) ? true:false;
	
}


/**
 * Data una tabella ed un opzionale campo, restituisce le tabelle che sono ad essa collegate e dipendenti
 * tramite un'analisi dei campi chiavi esterne.
 *
 * @param string $tabella
 * @param string $campo
 * @return matrix
 */
function ref_campo($tabella,$campo=null){
	
	global $link,$db1;
	
	if($campo!=null){
		
		$sql_campo = ($db1['dbtype']=='postgres') ? "AND column_name='$campo' " : "AND REFERENCED_COLUMN_NAME='$campo' ";
	}
	else $sql_campo='';
	
	
	if($db1['dbtype']=='postgres') {
		
		$sql ="SELECT table_name, column_name 
				FROM information_schema.key_column_usage
				WHERE table_schema='".$db1['dbname']."'
				AND table_name='$tabella'
				$sql_campo
				ORDER BY table_name, column_name";
	
	}else{
		
		$sql ="SELECT TABLE_NAME, COLUMN_NAME 
				FROM information_schema.key_column_usage
				WHERE REFERENCED_TABLE_SCHEMA='".$db1['dbname']."'
				AND REFERENCED_TABLE_NAME='$tabella'
				$sql_campo
				ORDER BY TABLE_NAME, COLUMN_NAME";
	}
	
	
	$q=vmsql_query($sql,$link);
	
	$matrice_ref = vmsql_fetch_assoc_all($q);
	
	return $matrice_ref;
	
	
}



/**
 * Prende le FK 
 * Individua i campi coinvolti in una relazione esterna e tabella.campo a cui � legato
 * Funziona sia passando l'oid numerico che una stringa che rappresenta il nome di tabella + il gruppo
 *
 * @param mixed $tab
 * @param int $gid
 * @return array
 */
function prendi_FK($tab,$gid=0){
	
	global $link,$db1;	
	
	
	// se $tab � un numero � l'oid
	// altrimenti il nome tabella
	if(is_numeric($tab)){
		$clausola = "AND rb.id_table=$tab";
	}
	else{
		
		$clausola = "AND rb.table_name='$tab'
					AND rb.gid=$gid
					GROUP BY column_name,colref
					";
	}

	if($db1['dbtype']=='postgres'){
		
		$sql_fk = " SELECT column_name, ".concat_sintax("k.table_name ,'.', k.column_name", 'colref')."
			FROM information_schema.key_column_usage k, 
				information_schema.table_constraints c, 
				{$db1['frontend']}.registro_tab rb
			WHERE c.constraint_type='FOREIGN KEY'
			AND c.constraint_schema='{$db1['dbname']}'
			AND k.constraint_schema='{$db1['dbname']}'
			AND c.constraint_name=k.constraint_name
			AND rb.table_name=c.table_name
			$clausola
			
				";
		
	}
	else{
		
		$sql_fk = " SELECT column_name, ".concat_sintax("k.REFERENCED_TABLE_NAME ,'.', k.REFERENCED_COLUMN_NAME", 'colref')."
			FROM information_schema.key_column_usage k, 
				information_schema.table_constraints c, 
				{$db1['frontend']}.registro_tab rb
			WHERE c.constraint_type='FOREIGN KEY'
			AND c.constraint_schema='{$db1['dbname']}'
			AND k.constraint_schema='{$db1['dbname']}'
			AND c.constraint_name=k.constraint_name
			AND rb.table_name=c.table_name
			$clausola
			
				";
	}
	
	
	$q_fk=vmsql_query($sql_fk,$link);
	
	if(vmsql_num_rows($q_fk)==0){

		return array(array(),array());
	}
	else{
		 return vmsql_fetch_row_all($q_fk,true);
	}
	
}



/**
 * Sostituisce lato server alcune variabili specificate nell'impostazione dei campi da parte dell'amministratore 
 * e che possono essere inserite ad esempio nei campi hidden e restituisce il valore
 *
 * @param string $variabile
 * @return string
 */
function variabili_campi($variabile){
	
	$variabile=trim($variabile);
	
	switch ($variabile){
		
		case '%nick' : $out= (isset($_SESSION['user']['nick'])) ? $_SESSION['user']['nick'] : false; break;
		case '%email' : $out= (isset($_SESSION['user']['email'])) ? $_SESSION['user']['email'] : false; break;
		case '%gid' : $out= (isset($_SESSION['gid'])) ? $_SESSION['gid'] : false; break;
		case '%gruppo' : $out= (isset($_SESSION['gid'])) ? gid2nome_gruppo($_SESSION['gid']) : false; break;
		case '%nome' : 
		case '%name' : $out= (isset($_SESSION['user']['nome'])) ? $_SESSION['user']['nome'] : false; break;
		case '%cognome' : 
		case '%surname'	: $out= (isset($_SESSION['user']['cognome'])) ? $_SESSION['user']['cognome'] : false; break;
		case '%nomecognome' : 
		case '%namesurname' : $out= (isset($_SESSION['user']['nome']) && isset($_SESSION['user']['cognome'])) 
			 ? $_SESSION['user']['nome']." ".$_SESSION['user']['cognome'] : false; break;
		
		case '%nomecognome' : 
		case '%surnamename' : $out= (isset($_SESSION['user']['cognome']) && isset($_SESSION['user']['nome'])) 
			 ? $_SESSION['user']['cognome']." ".$_SESSION['user']['nome'] : false; break;
		
		case '%now' : $out= date('Y-m-d'); break;
		case '%timestamp' : $out= date('Y-m-d H:i:s'); break;
		
		default: $out=false;	
	}
	
	return ($out!=false && $out!='') ? $out : false;
	
}



/**
 * Funzione che, interrogando l'information_schema, recupera la chiava primaria di una tabella
 *
 * @param string $tabella
 * @param int $gid
 * @return string
 */
function prendi_PK($tabella,$gid='session'){
	
	global $link,$db1;
	
	if($gid=='session'){
		
		$gid = (int) $_SESSION['gid'];
	}
	else{
		$gid= (int) $gid;
	}
	
	// E' tabella o vista?
	$sql_tipo="SELECT table_type FROM {$db1['frontend']}.registro_tab 
						 WHERE table_name='$tabella' AND gid=$gid";
	$q_tipo=vmsql_query($sql_tipo,$link);
	list($tipo_tab)=vmsql_fetch_row($q_tipo);
	
	if($tipo_tab=='VIEW'){
		
		// Chiave primaria esplicita delle viste
		$sql_pk = "SELECT view_pk AS campo_pk 
				FROM {$db1['frontend']}.registro_tab rb 
				WHERE rb.table_name='$tabella'
				AND rb.gid=$gid
				";
		
	}
	else{
	
	// Chiave/i primarie
		if($db1['dbtype']=='postgres'){
			
			$sql_pk = "SELECT i.column_name as campo_pk 
				FROM {$db1['frontend']}.registro_tab rb 
				INNER JOIN information_schema.key_column_usage i ON (i.table_name=rb.table_name AND i.table_schema='{$db1['dbname']}')
				INNER JOIN information_schema.table_constraints c ON (c.table_name=rb.table_name AND c.table_schema='public' AND c.constraint_name=i.constraint_name)
				WHERE rb.table_name='$tabella'
				AND rb.gid=$gid
				AND c.constraint_type='PRIMARY KEY'
				";
			
		}
		
		else if($db1['dbtype']=='mysql'){
			$sql_pk = "SELECT i.column_name as campo_pk 
				FROM {$db1['frontend']}.registro_tab rb 
				LEFT JOIN information_schema.key_column_usage i ON (i.table_name=rb.table_name AND i.table_schema='{$db1['dbname']}')
				WHERE rb.table_name='$tabella'
				AND rb.gid=$gid
				AND CONSTRAINT_NAME='PRIMARY'
				";
		}
	}
	
	$q_pk=vmsql_query($sql_pk,$link);
	
	if(vmsql_num_rows($q_pk)==0) return null;
	
	list($campoPK)=vmsql_fetch_row($q_pk);
	
	return $campoPK;
}



/**
 * Funzione che recupera tutte le chiavi primarie di una tabella.
 * Funziona come prendi_PK() ma restituisce una o pi� chiavi sotto forma di array
 * Da utilizzare quando si presume che le PK possano essere pi� di una
 *
 * @param string $tabella
 * @param int $gid
 * @return array
 */
function prendi_all_PK($tabella,$gid='session'){
	
	global $link,$db1;
	
	if($gid=='session'){
		
		$gid = (int) $_SESSION['gid'];
	}
	else{
		$gid= (int) $gid;
	}
	
	// E' tabella o vista?
	$q_tipo=vmsql_query("SELECT table_type FROM {$db1['frontend']}.registro_tab 
						 WHERE table_name='$tabella' AND gid=$gid",$link);
	list($tipo_tab)=vmsql_fetch_row($q_tipo);
	
	
	
	if($tipo_tab=='VIEW'){
		
		// Chiave primaria esplicita delle viste
		$sql_pk = "SELECT view_pk AS campo_pk 
				FROM {$db1['frontend']}.registro_tab rb 
				WHERE rb.table_name='$tabella'
				AND rb.gid=$gid
				";
	}
	else{
	
		if($db1['dbtype']=='postgres'){
			
			$sql_pk = "SELECT i.column_name as campo_pk 
				FROM {$db1['frontend']}.registro_tab rb 
				INNER JOIN information_schema.key_column_usage i ON (i.table_name=rb.table_name AND i.table_schema='{$db1['dbname']}')
				INNER JOIN information_schema.table_constraints c ON (c.table_name=rb.table_name AND c.table_schema='public' AND c.constraint_name=i.constraint_name)
				WHERE rb.table_name='$tabella'
				AND rb.gid=$gid
				AND c.constraint_type='PRIMARY KEY'
				";
			rpc_debug($sql_pk);
			
		}
		
		else if($db1['dbtype']=='mysql'){
			$sql_pk = "SELECT i.column_name as campo_pk 
				FROM {$db1['frontend']}.registro_tab rb 
				LEFT JOIN information_schema.key_column_usage i ON (i.table_name=rb.table_name AND i.table_schema='{$db1['dbname']}')
				WHERE rb.table_name='$tabella'
				AND rb.gid=$gid
				AND CONSTRAINT_NAME='PRIMARY'
				";
		}
	}
	
	
	$q_pk=vmsql_query($sql_pk,$link);
	
	list($campoPK)=vmsql_fetch_row_all($q_pk,true);
	
	return $campoPK;
}



function prendi_all_PK_submask_oid($id_submask,$gid='session'){
	
	global $link,$db1;
	
	if($gid=='session'){
		
		$gid = (int) $_SESSION['gid'];
	}
	else{
		$gid= (int) $gid;
	}
	
	// Chiave/i primarie
	$sql_pk = "SELECT i.column_name as campo_pk 
				FROM {$db1['frontend']}.registro_submask rb 
				LEFT JOIN information_schema.key_column_usage i ON (i.table_name=rb.nome_tabella AND i.table_schema='{$db1['dbname']}')
				WHERE rb.id_submask='$id_submask'
				AND CONSTRAINT_NAME='PRIMARY'
				";
	
	$q_pk=vmsql_query($sql_pk,$link);
	
	list($campoPK)=vmsql_fetch_row_all($q_pk,true);
	
	return $campoPK;
}


/**
 * Prende la chiave primaria di una tabella in base all'OID (Id della tabella) passato
 *
 * @param int $oid
 * @param string $table_type "BASE TABLE" | "VIEW"
 * @return array
 */
function prendi_PK_oid($oid,$table_type='BASE TABLE'){
	
	global $link,$db1;
	
	$oid=(int) $oid;
	
	if($table_type=='VIEW'){
	
	// Chiave primaria esplicita delle viste
		$sql_pk = "SELECT view_pk AS campo_pk 
				FROM {$db1['frontend']}.registro_tab rb 
				WHERE rb.id_table=$oid
				";
	
	}
	else{
		
		// Chiave/i primarie
		if($db1['dbtype']=='postgres'){
				
				$sql_pk = "SELECT i.column_name as campo_pk 
					FROM {$db1['frontend']}.registro_tab rb 
					INNER JOIN information_schema.key_column_usage i ON (i.table_name=rb.table_name AND i.table_schema='{$db1['dbname']}')
					INNER JOIN information_schema.table_constraints c ON (c.table_name=rb.table_name AND c.table_schema='public' AND c.constraint_name=i.constraint_name)
					WHERE rb.id_table=$oid
					AND c.constraint_type='PRIMARY KEY'
					";
				
			}
			
		else if($db1['dbtype']=='mysql'){
				$sql_pk = "SELECT i.column_name as campo_pk 
					FROM {$db1['frontend']}.registro_tab rb 
					LEFT JOIN information_schema.key_column_usage i ON (i.table_name=rb.table_name AND i.table_schema='{$db1['dbname']}')
					WHERE rb.id_table=$oid
					AND CONSTRAINT_NAME='PRIMARY'
					";
		}
	}
	
	$q_pk=vmsql_query($sql_pk,$link);
	
	list($info_pk)=vmsql_fetch_row_all($q_pk,true);

	return $info_pk;
}


/**
 * Prende le sottomaschere impostate per una data maschera data l'ID (oid) del record
 *
 * @param int $oid
 * @param bool $reverse
 * @param bool $solo_visibili
 * @return array
 */
function prendi_sottomaschere($oid,$reverse=false,$solo_visibili=false){
	
	global $db1, $link;
	
	$clausola_solo_visibili = ($solo_visibili) ? "AND sub_select='1' " : "";
	
	$sql = "SELECT * FROM ".$db1['frontend'].".registro_submask
			WHERE id_table=$oid
			$clausola_solo_visibili
			ORDER BY nome_tabella
			";
	
	$q=vmsql_query($sql,$link);
	
	$matrice = (vmsql_num_rows($q)>0) ? vmsql_fetch_assoc_all($q,$reverse) : array();
	
	return $matrice;
	
}


function prendi_info_view($view_name,$cols="*"){
	
	global $link,$db1;
	
	$q=vmsql_query("SELECT $cols FROM information_schema.views 
					WHERE TABLE_SCHEMA='{$db1['dbname']}'
					AND TABLE_NAME='$view_name'",$link);
	
	return (vmsql_num_rows($q)==1) ? vmsql_fetch_assoc($q) : array();
}



/**
 * Restituisce unamatrice bidimensionale (gid=>nome_gruppo) dei gruppi presenti in DB VFront
 * Utile per (ad esempio) mostrare una tendina
 * Si possono escludere dei gruppi mediante il parametro $escludi_gid
 *
 * @param mixed $escludi_gid
 * @return array
 */
function prendi_gruppi($escludi_gid=''){
	
	global $link, $db1;
	
	
	$mat_gruppi=array();
	
	if($escludi_gid!=''){
		
		$clausola_esclusione=" WHERE gid!=".intval($escludi_gid);
	}
	
	$q_g=vmsql_query("SELECT gid, nome_gruppo FROM ".$db1['frontend'].".gruppo $clausola_esclusione ORDER BY gid",$link);
	
	if(vmsql_num_rows($q_g)>0)	$mat_gruppi=vmsql_fetch_assoc_all($q_g);
	
	return $mat_gruppi;
}


function prendi_K_relazione_sub($id_table){
	
	global $link, $db1;
	
	$sql="SELECT campo_pk_parent, campo_fk_sub FROM {$db1['frontend']}.registro_submask WHERE id_table=".intval($id_table);
	$q=vmsql_query($sql,$link);
	
	return (vmsql_num_rows($q)>0) ? vmsql_fetch_row_all($q) : array();
}




/**
 * Recupera i file allegati associati ad un dato record di una data tabella
 * presenti nella tabella "allegato" sotto forma di matrice
 *
 * @param string $tabella
 * @param mixed $valore_id
 * @return array
 */
function prendi_allegati($tabella,$valore_id){
	
	global $link,$db1;
	
	$sql="SELECT * FROM "._TABELLA_ALLEGATO." WHERE tipoentita='$tabella' AND codiceentita='$valore_id'";
	$q=vmsql_query($sql,$link);
	
	if(vmsql_num_rows($q)>0){
		
		return vmsql_fetch_assoc_all($q);
	}
	else{
		
		return array();
	}
	
}



/**
 * Recupera i link associati al record di una data tabella 
 * dalla tabella "Link" sotto forma di matrice
 *
 * @param string $tabella
 * @param mixed $valore_id
 * @return array
 */
function prendi_link($tabella,$valore_id){
	
	global $link,$db1;
	
	$sql="SELECT * FROM "._TABELLA_LINK." WHERE tipoentita='$tabella' AND codiceentita='$valore_id'";
	$q=vmsql_query($sql,$link);
	
	if(vmsql_num_rows($q)>0){
		
		return vmsql_fetch_assoc_all($q);
	}
	else{
		
		return array();
	}
	
}


/**
 * Cancella dal DB e dal filesystem un allegato
 *
 * @param int $id_allegato
 * @return bool
 */
function elimina_allegato($id_allegato=null){
	
	global $link,$db1;
	
	// elimino dal file system
	$test= @unlink(_PATH_ATTACHMENT."/".$id_allegato.".dat");
	
	if($test){
		
		$q=vmsql_query("DELETE FROM "._TABELLA_ALLEGATO." WHERE codiceallegato='$id_allegato' ",$link);
		
		return true;
		
	}else return false;
	
}


/**
 * Imposta la sintassi SQL di LIMIT e OFFSET in base al tipo di database utilizzato
 * Questa funzione si rende necessaria a causa della diversa sintassi di mysql e postgresql
 *
 * @param int $limit
 * @param int $offset
 * @return string
 */
function limit_sintax($limit,$offset=''){
	
	global $db1;
	
	$str='';
	
	if($db1['dbtype']=='postgres'){
		
		$str.= "LIMIT $limit";
		
		if($offset!='') $str.=" OFFSET $offset";
	}
	elseif($db1['dbtype']=='mysql'){
		
		if($offset!='') $str.="LIMIT $offset,$limit";
		else $str.="LIMIT $limit";
	}
	
	return $str;
}


/**
 * Imposta la sintassi SQL di concatenazione stringhe
 * Questa funzione si rende necessaria a causa della diversa sintassi di mysql e postgresql
 *
 * @param string $arguments
 * @param string $as
 * @return string
 */
function concat_sintax($arguments='',$as=''){
	
	global $db1;
	
	if($db1['dbtype']=='postgres'){
		
		$str=str_replace(","," || ",$arguments);
		
		
	}
	elseif($db1['dbtype']=='mysql'){
		
		$str="CONCAT($arguments)";
		
	}
	
	if($as!='') $str.=" AS $as";
	
	return $str;
}

/**
 * Funzione per la determinazione del tipo di campo
 * Utile soprattutto per PostgreSQL
 *
 * @param mixed $tabella_o_gid
 * @param string $campo
 * @return bool
 */
function campo_is_numeric($tabella_o_gid,$campo){
	
	global $link,$db1;
	
	if(is_numeric($tabella_o_gid)){
		
		$id_table=$tabella_o_gid;
	}
	else{
		
		$id_table=name2oid($tabella_o_gid,$_SESSION['gid']);
	}
	
	
	$sql="SELECT column_type FROM {$db1['frontend']}.registro_col 
					WHERE id_table=$id_table AND column_name='$campo'";
	rpc_debug($sql);
	$q=vmsql_query($sql,$link);
	
	if(vmsql_num_rows($q)>0){
		list($tipo)=vmsql_fetch_row($q);
		
		if(ereg("int",$tipo) || ereg("double",$tipo) || ereg("float",$tipo)) return true;
		else return false;
	}
	else return false;
}



/**
 * Check if the field is a autoincrement
 *
 * @param string $table
 * @param string $field
 * @return bool
 */
function is_autoincrement($table,$field){
	
	global $link, $db1;
	
	if($db1['dbtype']=='postgres'){
		
		$sql="SELECT column_default 
			FROM information_schema.columns 
			WHERE table_catalog='{$db1['dbname']}'
			AND table_name='$table'
			AND column_name='$field'
			";
		$q=vmsql_query($sql,$link);
		
		list($res)=vmsql_fetch_row($q);
		
		return (ereg('nextval\(',$res)) ? true:false;
		
	}
	else{
	
		$sql="SELECT EXTRA 
			FROM information_schema.columns 
			WHERE TABLE_SCHEMA='{$db1['dbname']}'
			AND TABLE_NAME='$table'
			AND COLUMN_NAME='$field'
			";
		$q=vmsql_query($sql,$link);
		
		list($res)=vmsql_fetch_row($q);
		
		return ($res=='auto_increment') ? true:false;
	
	}
	
}

function allegato_filesize($id_allegato){
	
	return formatBytes(filesize(_PATH_ATTACHMENT."/".$id_allegato.".dat"));
}


function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
  
    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);
  
    $bytes /= pow(1024, $pow);
  
    return round($bytes, $precision) . ' ' . $units[$pow];
} 

?>