<?php
/**
* Libreria di funzioni per la gestione dei campi in area di amministrazione. 
* Si tratta delle funzioni che generano le scelte possibili per le impostazioni dei campi,
* viste le caratteristiche dei campi definiti in database.
* 
* @package VFront
* @subpackage Function-Libraries
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: func.tratta_campo.php 262 2009-04-24 18:58:09Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/


/**
 * Utilit� che imposta se un option di una select debba essere selezionato
 *
 * @param string $tipo Valore dell'option nella tendina
 * @param string $def Valore definito
 * @return string 
 */
function selected_def($tipo,$def){
	
	return ($tipo==$def) ? "selected=\"selected\"" : "";	
}


/**
 * Funzione che attribuisce i tipi possibili di campo per una tabella
 * E' utilizzata nell'amministrazione dei registri/gruppi
 *
 * @param array $ar_campo
 * @param array $pk Campo/i chiave/i primaria
 * @param array $fk Campo/i chiave esterna
 * @param string $colref_fk Colonne di riferimento nella relazione delle chiavi esterne
 * @return void
 */
function tratta_campo($ar_campo,$pk,$fk,$colref_fk=array()){
	
	global $link,$gid;
	
	
	// estrai i valori come variabili
	extract($ar_campo);
	
	

	/*
	id_reg
	table_oid
	column_name
	column_default
	is_nullable
	data_type
	character_maximum_length
	column_type
	extra
	in_tipo
	in_default
	in_visibile
	in_richiesto
	alias_frontend
	commento
    */
	
	
	// caratteristiche di default per la visibilit�
	$campo_visibile=true;
	$campo_visibile_disabled=false;
	$select_tipo_disable = false;
	$column_default = (strlen($column_default)>0) ? $column_default : "<em class=\"na\">"._("non specificato")."</em>";
	$max_length= (ereg('char',$data_type)) ? "(".$character_maximum_length ." "._("caratteri").")" : "";
	
	// Impostazioni campo obbligatorio
	if(is_null($in_richiesto) || $in_richiesto==""){
		$in_richiesto = (trim($is_nullable)=="NO") ? true:false;
		// se l'impostazione deriva dal database ed � richiesto imponi la scelta
		$campo_richiesto_disabled= $in_richiesto;
	}
	else{
		$in_richiesto = ($in_richiesto=="1" || $in_richiesto=='t') ? true:false;
		// se l'impostazione deriva del l'utente lascia la scelta
		$campo_richiesto_disabled= false;
	}
	
	
	// Impostazioni campo visibile
	if($in_visibile=='1' || $in_visibile=='t'){
		$campo_visibile=true;
	}
	elseif($in_visibile=='0' || $in_visibile=='f'){
		$campo_visibile=false;
	}
	
	
	
	// Impostazioni del campo suggest
	if($in_suggest=='1' || $in_suggest=='t'){
		$campo_suggest=true;
	}
	elseif($in_suggest=='0' || $in_suggest=='f'){
		$campo_suggest=false;
	}
	
	
	// Impostazioni del campo suggest
	$campo_in_table= ($in_table=='1' || $in_table=='t'  ) ?	true:false;
	
	
	// A seconda del tipo di campo fa delle proposte:
	
	$sel=array_flip(array('int','float','double','char','password','text','mediumtext','date','datetime','bool','bit','hidden','select','select_from','onlyread'));
	
	
	switch ($data_type){
		
		case 'tinyint'  :
		case 'smallint' : $options = (ereg("tinyint\(1\)",$column_type)) ? "\t\t\t<option value=\"bool\" ".selected_def('bool',$in_tipo).">"._("booleano (vero|falso)")."</option>
									<option value=\"int\" ".selected_def('int',$in_tipo).">"._("numero intero")."</option>\n" 
									:
									"\t\t\t<option value=\"int\" ".selected_def('int',$in_tipo).">"._("numero intero")."</option>\n" ;
		break;
		case 'int' : 	
		case 'integer' : 
		case 'biginteger' :
		case 'bigint' :	
							$options = "\t\t\t<option value=\"int\" ".selected_def('int',$in_tipo).">"._("numero intero")."</option>\n";
		break;
		
		case 'float' : 
		case 'double':		
		case 'double precision':		
		case 'real':		
		case 'numeric':		
		case 'decimal':		
		case 'money':		
							$options = "\t\t\t<option value=\"float\" ".selected_def('float',$in_tipo).">"._("numero con virgola")."</option>\n";
		break;
		
		case 'varchar' : 
		case 'char' : 	
		case 'character' : 	
		case 'character varying' : 	
		case 'varbinary' : 	
		case 'bpchar' : 	$options = "\t\t\t<option value=\"char\" ".selected_def('char',$in_tipo).">"._("testo libero corto")."</option>\n";
							$options.= "\t\t\t<option value=\"password\" ".selected_def('password',$in_tipo).">"._("password")."</option>\n";
		break;
		
		case 'mediumtext' : 
		case 'blob' : 
		case 'longtext' :
		case 'text' :$options = "\t\t\t<option value=\"text\" ".selected_def('text',$in_tipo).">"._("testo libero lungo")."</option>
								  <option value=\"char\" ".selected_def('char',$in_tipo).">"._("testo libero corto")."</option>
								  <option value=\"richtext\" ".selected_def('richtext',$in_tipo).">"._("testo formattato HTML")."</option>
								  \n";
		break;
		
		case 'date' : $options = "\t\t\t<option value=\"date\" ".selected_def('date',$in_tipo).">"._("data formattata")."</option>\n";
		break;
		
		case 'datetime' : 
		case 'timestamp without time zone' : 
		case 'timestamp' : 			$options = "\t\t\t<option value=\"datetime\" ".selected_def('datetime',$in_tipo).">"._("data ed ora formattata")."</option>
									<option value=\"date\" ".selected_def('date',$in_tipo).">"._("data formattata")."</option>\n";
		break;
		
		case 'time' : $options = "\t\t\t<option value=\"time\" ".selected_def('time',$in_tipo).">"._("orario formattato")."</option>\n";
		break;
		
		case 'bool' : 
		case 'boolean' : 
		case 'bit' : $options = "\t\t\t<option value=\"bool\" ".selected_def('bool',$in_tipo).">"._("booleano (vero|falso)")."</option>\n";
		break;
		
		case 'enum':  $options = "\t\t\t<option value=\"select_enum\" ".selected_def('select_enum',$in_tipo).">"._("Lista predefinita")."</option>\n";
		break;
		
		default: $options="";
	}
	
	
	
	
	$aggiunta_options="
				<option value=\"hidden\" ".selected_def('hidden',$in_tipo).">"._("nascosto")."</option>
				<option value=\"select\" ".selected_def('select',$in_tipo).">"._("valori definiti")."</option>
				<option value=\"select_from\" ".selected_def('select_from',$in_tipo).">"._("valori definiti da tabella")."</option>
				<option value=\"onlyread\" ".selected_def('onlyread',$in_tipo).">"._("visibile in sola lettura")."</option>
		";

	
	
	
	
	

					   
	/* Impostazioni nel caso di valore autoincrement:
	Imposta il campo come bloccato	ed invisibile in fase di insert	*/
	if($extra=="auto_increment"){
		$campo_visibile = false;
		$campo_visibile_disabled = true;
		$campo_richiesto_disabled = true;
		$select_tipo_disable = true;
		$campo_search = false;
		$campo_suggest = false;
	}
	
	
	
	
	//TODO: da mettere le indicazioni di chiave primaria, 
	// 		cos� che se il valore non � autoincrement sia comunque richiesto un inserimento
	
	$obbligatorio = ($is_nullable=="YES") ? 
					_('NO') 
					: 
					_('SI');
	
	$commento = (strlen(trim($commento))>0) ? "<br /><em class=\"commento\">".htmlentities($commento,ENT_QUOTES)."</em>": "";
	
	
	
	// Immagine delle chiavette per le chiavi primarie
	if(in_array($column_name,$pk)){
		$img_campo=" campopk";
	}
	else{
		$img_campo=" camponorm";
	}
	
	
	if(in_array($column_name,$fk)){
		
		if($img_campo==" campopk"){
			$img_campo=" campopkfk";
		}
		else{
			$img_campo=" campofk";
			
		}
		
		
		###############
		#
		#	Prende le informazioni sulla chiave esterna
		#	Questa informazione � utile per chi configura la tabella al fine 
		#	di impostare la query esterna per recuperare i dati
		#
		
		
		// Cerca la chiave della FK
		$k_fk = array_search($column_name,$fk);
		
		$info_fk = " - "._("chiave esterna")." (rif:<strong>".$colref_fk[$k_fk]."</strong>)";
	}
	else{
		$info_fk="";
	}


	
	
	// Gestione search | suggest
	
	
	
	
	
	$OUT= "\t<div class=\"campo\">
				<div class=\"campo-head\">
					<div class=\"campo-alias\"><label for=\"alias_frontend_$id_reg\" >"._('nome da mostrare').": </label>
						<input id=\"alias_frontend_$id_reg\" size=\"22\" maxlength=\"100\" name=\"campo[$id_reg][alias_frontend]\" value=\"".stripslashes($alias_frontend)."\" />
					</div>
					<strong class=\"var\">".$column_name."</strong> - $data_type ".$max_length." ".$info_fk."
					$commento
				
				</div>
				
				";
	
	
	if($_SESSION['VF_VARS']['js_test']){
	
		if($jstest!='' && $jstest!=null){
			
			$jstest_pezzi=explode("|",$jstest);
			
			$attuale_jstest=$jstest_pezzi[1];
		}else{
			$attuale_jstest='';
		}
		
		$testo_js_control = _("Controlli avanzati");
		$testo_js_control .= ($attuale_jstest!='') ? " <strong>(".$attuale_jstest.")</strong>" : "";
		
		$OUT.="<div style=\"float:right;width:170px;text-align:right\" class=\"campo-controlli\">
		
				<br /><span id=\"controlli_$id_reg\" class=\"fakelink\" onclick=\"openWindow('adv_js_control.php?id_reg=".$id_reg."', 'controlli_js', 65)\">$testo_js_control</span>
				</div>
		";
	}
				
	$OUT.="\t\t<div class=\"campo-body$img_campo\">
				
					<br/>"._("obbligatorio")."(sql): <strong>$obbligatorio</strong>
					<br/>"._("default")."(sql): <strong>$column_default</strong>\n";
		
		// inizia la parte form
		
		// Disabilitazioni checkbox
		$att_dis_visibile=($campo_visibile_disabled) ? "disabled=\"disabled\"" : "";
		$att_dis_richiesto=($campo_richiesto_disabled) ? "disabled=\"disabled\"" : "";
		$att_dis_select = ($select_tipo_disable) ? "disabled=\"disabled\"" : "";
		
		
		// vero|falso dei checkbox
		$att_visibile_checked=($campo_visibile) ? "checked=\"checked\"" : "";
		$att_richiesto_checked=($in_richiesto) ? "checked=\"checked\"" : "";
		
				
	
		$valore_visibile=($campo_visibile_disabled) ? 0:1;
		$valore_obbligatorio=($att_dis_richiesto) ? 1:0;
		
		$OUT.="\t\t<input type=\"hidden\" name=\"campo[$id_reg][in_visibile]\" id=\"in_visibile_hid_$id_reg\" value=\"0\" />\n";
		$OUT.="\t\t<br/><label for=\"in_visibile_$id_reg\">"._("campo visibile")."</label>
		\t\t\t<input type=\"checkbox\" name=\"campo[$id_reg][in_visibile]\" id=\"in_visibile_$id_reg\" value=\"1\" $att_dis_visibile $att_visibile_checked  />\n";
				
		$OUT.="\t\t<input type=\"hidden\" name=\"campo[$id_reg][in_richiesto]\" id=\"in_richiesto_hid_$id_reg\" value=\"0\" />\n";
		$OUT.="\t\t<br/><label for=\"in_richiesto_$id_reg\">"._("campo obbligatorio")."</label>
		\t\t\t<input type=\"checkbox\" name=\"campo[$id_reg][in_richiesto]\" id=\"in_richiesto_$id_reg\" value=\"1\" $att_richiesto_checked $att_dis_richiesto/>\n";
	
		
		// Campi search
		
				
		$valore_search=($campo_search) ? 1:0;
		$att_valore_search=($campo_search) ? "checked=\"checked\"" : "";
		
		$valore_suggest=($campo_suggest) ? 1:0;
		$att_valore_suggest=($campo_suggest) ? "checked=\"checked\"" : "";
		
		$valore_table=($campo_in_table) ? 1:0;
		$att_valore_table=($campo_in_table) ? "checked=\"checked\"" : "";
	
		
		// campo con suggerimenti di ricerca
		
		$OUT.="\t\t<input type=\"hidden\" name=\"campo[$id_reg][in_suggest]\" id=\"in_suggest_hid_$id_reg\" value=\"0\" />\n";
		$OUT.="\t\t<br/><label for=\"in_suggest_$id_reg\">"._("imposta i suggerimenti")."</label>
		\t\t\t<input type=\"checkbox\" name=\"campo[$id_reg][in_suggest]\" id=\"in_suggest_$id_reg\" value=\"1\" $att_valore_suggest />\n";
		
	
		// campo in_table: cosa mostrare nella vista tabella
		
		$OUT.="\t\t<input type=\"hidden\" name=\"campo[$id_reg][in_table]\" id=\"in_table_hid_$id_reg\" value=\"0\" />\n";
		$OUT.="\t\t<br/><label for=\"in_table_$id_reg\">"._("visibile in vista tabella")."</label>
		\t\t\t<input type=\"checkbox\" name=\"campo[$id_reg][in_table]\" id=\"in_table_$id_reg\" value=\"1\" $att_valore_table />\n";
		
		
		$OUT.="\t\t<br/><label for=\"in_tipo_$id_reg\">"._("Tipo di input")."</label> 
			<select name=\"campo[$id_reg][in_tipo]\" id=\"in_tipo_$id_reg\" onchange=\"mostra_hid(this.value,$id_reg)\" $att_dis_select>\n";
		
	//			$selected = ($in_tipo==$k) ? "selected=\"selected\" " : "";
			
		$OUT.= $options.$aggiunta_options;
		
		$OUT.="\t\t</select>\n";
		
		
		
		
		$OUT.="\t\t<div id=\"hid_$id_reg\" >\n";
		
		
		
		// TIPO SELECT 
		$value_select = ($in_tipo=='select')? str_replace("[|]","\n",$in_default) : "";
		$style_select = ($in_tipo=='select')? "" : "display:none;";
		$disabled_select = ($in_tipo=='select')? "" : "disabled=\"disabled\"";
		
		$OUT.="
			
			<div id=\"default-select-$id_reg\" style=\"$style_select\">
				<label class=\"var\">"._("Inserire, uno per riga, i valori possibili per la selezione")." - <a href=\"javascript:;\" onclick=\"openWindow('help.select.php',60,40)\">"._('Regole')."</a></label>
				<br/>
				<textarea name=\"campo[$id_reg][tipo_altro]\" cols=\"50\" rows=\"7\" $disabled_select>$value_select</textarea>
			</div>\n";
			
		
		// TIPO PASSWORD 
		$style_password = ($in_tipo=='password')? "" : "display:none;";
		$val_password_0 = ($in_tipo=='password' && ($in_default=='' || $in_default=='null'))? "checked=\"checked\"" : "";
		$val_password_1 = ($in_tipo=='password' && $in_default=='md5')? "checked=\"checked\"" : "";
		$val_password_2 = ($in_tipo=='password' && $in_default=='sha1')? "checked=\"checked\"" : "";
		
		$OUT.="
			
			<div id=\"default-password-$id_reg\" style=\"$style_password\">
				<label class=\"var\">"._("Inserire il tipo di codifica da operare sulla password")."</label>
				<br />
				<input type=\"radio\" name=\"campo[$id_reg][tipo_altro]\" value=\"null\" $val_password_0 /> "._('Nessuna codifica')." <br />
				<input type=\"radio\" name=\"campo[$id_reg][tipo_altro]\" value=\"md5\" $val_password_1 /> "._('Hash MD5')."<br />
				<input type=\"radio\" name=\"campo[$id_reg][tipo_altro]\" value=\"sha1\" $val_password_2 /> "._('Hash SHA1')."
			</div>\n";
			
		
		// TIPO select_from 
		$value_select_from = ($in_tipo=='select_from')? $in_default : "";
		$style_select_from = ($in_tipo=='select_from')? "" : "display:none;";
		$disabled_select_from = ($in_tipo=='select_from')? "" : "disabled=\"disabled\"";
		
		$OUT.="
			<div id=\"default-selectfrom-$id_reg\" style=\"$style_select_from\">
				
				<label class=\"var\">"._("Inserire l'SQL che richiama i valori per questo campo")."</label>
				<input type=\"button\" value=\""._("Editor")."\" onclick=\"openWindow('query_editor.php?gid={$_GET['gid']}&amp;id_campo=$id_reg&amp;id_table=$id_table','query_editor','50');\" />				
				<input type=\"button\" value=\""._("Test")."\" onclick=\"try_query(document.getElementById('tipo_altro_".$id_reg."').value,".$id_reg.")\" />				
				<span id=\"feed_altro_".$id_reg."\" class=\"feed_altro\">&nbsp;</span>
				<br/><textarea name=\"campo[".$id_reg."][tipo_altro]\" id=\"tipo_altro_".$id_reg."\" cols=\"50\" rows=\"7\" $disabled_select_from >$value_select_from</textarea>
			</div>";
		
		
		// Tipo ENUM (select_enum)
		
		if($data_type=='enum'){
			
			$style_select_enum = ($in_tipo=='select_enum')? "" : "display:none;";
			
			$tipo_str=str_replace("enum(",'',substr(trim($column_type),0,-1));
			$tipo_str=str_replace("'",'',$tipo_str);
			$tipo_str_show=str_replace(",","\n",$tipo_str);
		
			$OUT.="
			<div id=\"enum-$id_reg\" style=\"$style_select_enum\">
				
				<br/>
				<textarea name=\"campo[$id_reg][tipo_altro]\" cols=\"50\" rows=\"7\" disabled=\"disabled\">$tipo_str_show</textarea>
				<input type=\"hidden\" name=\"campo[$id_reg][hid_enum]\" value=\"".addslashes($tipo_str)."\" />
			</div>\n";
		
		}
		
		
		
		// Tipo Hidden
		$value_hidden = ($in_tipo=='hidden')? $in_default : "";
		$style_hidden = ($in_tipo=='hidden')? "" : "display:none;";
		$disabled_hidden = ($in_tipo=='hidden')? "" : "disabled=\"disabled\"";
		$sovrascrivi_extra= ($in_tipo=='hidden' && $extra=='1') ? "checked=\"checked\"" : "";
		
	
			
		$OUT.="
			<div id=\"default-hidden-$id_reg\" style=\"$style_hidden\">
				<br />
				<label class=\"var\">"._("Inserire il valore di default del campo nascosto")." - <a href=\"javascript:;\" onclick=\"openWindow('help.variabili_hidden.php',60,40)\">"._('vedi le variabili')."</a></label>
				<br/><input type=\"text\" name=\"campo[$id_reg][tipo_altro]\" $disabled_hidden value=\"$value_hidden\" />	
				<br /><br />
				<input type=\"hidden\" name=\"campo[$id_reg][extra]\" value=\"0\" />	
				<input type=\"checkbox\" name=\"campo[$id_reg][extra]\" value=\"1\" id=\"extra_".$id_reg."\" $sovrascrivi_extra />	
				<label for=\"extra_".$id_reg."\">"._("Sovrascrivi con il valore di default anche in caso di modifica del record")."</label>
			</div>
		
		</div>\n";
		
		
		
		
	$OUT.="	
	
		
		
		</div>
	
	</div>\n\n";
	
	
	
	return $OUT;
}

?>