<?php
/**
* Libreria di funzioni per la creazione del layout di pagina dell'applicazione. 
* 
* @package VFront
* @subpackage Function-Libraries
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: layouts.php 371 2009-05-05 13:49:47Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/


/**
 * Scrive l'HTML di apertura di una pagina
 *
 * @param string $title Il titolo della pagina mostrato nel tag TITLE
 * @param array $files Un array di files da includere. Possono essere javascript o css, la funzione li smister� automaticamente
 * @param string $tipo Pu� essere ad esempio "sottomaschera". In tal caso il layout apparir� differente.
 * @return string HTML 
 */
function openLayout1($title,$files=array(),$tipo=''){

	global $pagina,$tipo_nav,$link;

	$GLOBALS['layout_APERTO']=1;
	
	$css = array();
	$js  = array();
	
// SMISTA I FILES CSS E JS MANDATI ALLA FUNZIONE	
	foreach($files as $file){

		if(substr($file,-4,4)==".css"){
			$css[]=$file;
		}
		elseif(substr($file,-3,3)==".js" || ereg("\.js\??",$file)){
			$js[]=$file;
		}
	
	}
	
	
$THEME=(isset($_SESSION['VF_VARS']['layout']) && is_dir(FRONT_ROOT."/themes/".$_SESSION['VF_VARS']['layout']."/"))
	   ? $_SESSION['VF_VARS']['layout'] : 'default';

	
	
	
$OUT= "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"it\">
<head>
<title>$title</title>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".FRONT_ENCODING."\" />
<link rel=\"shortcut icon\" href=\"".FRONT_DOCROOT."/themes/$THEME/favicon.gif\" type=\"image/x-icon\" />
<style type=\"text/css\" media=\"all\">
";

	# DEFAULT CSS
		$OUT.= "@import \"".FRONT_DOCROOT."/sty/base.css\";\n";
		
	# THEMES
		$OUT.= "@import \"".FRONT_DOCROOT."/themes/".$THEME."/".$THEME.".css\";\n";
		
		
		if($tipo=="sottomaschera"){
			
			$OUT.= "@import \"".FRONT_DOCROOT."/sty/sottomaschera.css\";\n";
		}
	

	# CSS
	foreach($css as $css){
		$OUT.= "@import \"".FRONT_DOCROOT."/$css\";\n";
	}
	
$OUT.= "</style>\n";


	$OUT.="<script type=\"text/javascript\" src=\"".FRONT_DOCROOT."/js/lang/vfront-".strtolower(substr(FRONT_LANG,0,2)).".js\"></script>\n";
	# JS
	if(count($js)>0){
		
		$cache_js=0;
		
		###########################
		// cache js
		
		if($cache_js==1){
			
			$cache_js_hash=md5(implode("",$js));
			
			$cache_js_path=_PATH_TMP."/".$cache_js_hash.".js";
			$cache_js_path_abs=_PATH_TMP_HTTP."/".$cache_js_hash.".js";
			
			if(is_file($cache_js_path)){
				
				$OUT.= "<script type=\"text/javascript\" src=\"$cache_js_path_abs\" ></script>\n";
			}
			else{
				
				// create the file
				$fpjs=fopen($cache_js_path,'a');
				
				foreach($js as $jsf){
					
					list($jsf)=explode("?",$jsf);
					
					fwrite($fpjs,join("",file(FRONT_ROOT."/".$jsf))."\n");
				}
				fclose($fpjs);
				
				$OUT.= "<script type=\"text/javascript\" src=\"$cache_js_path_abs\" ></script>\n";
			}
			
		
		} # end cache js
		else{
			
			foreach($js as $js){
				$OUT.= "<script type=\"text/javascript\" src=\"".FRONT_DOCROOT."/$js\" ></script>\n";
			}
			
		}
	
		
	}



$OUT.= "
</head>";




		
		
// LAYOUT 
	$OUT.= "<body>";
	
	
	if($tipo!="sottomaschera" && $tipo!='popup'){

		$OUTMENU =(isset($_SESSION['user']['livello'])) ?  menu($_SESSION['user']['livello']) : "";
		
		$OUT.="<div id=\"header\"><span>&nbsp;</span>".$OUTMENU."</div>\n";
	
	}
	else{
		
		$OUT.="<div id=\"header\"><span>&nbsp;</span></div>\n";
	}

	
	
	
	
$OUT.= "<div id=\"contenuto\">
	<!--CONTENUTO-->
	";

	

	return $OUT;
}





/**
 * Scrive l'HTML di chiusura di una pagina
 *
 * @param mixed $back
 * @return string HTML 
 */
function closeLayout1($back=""){
	
	$OUTPUT_CLOSE="<!-- Fine contenuto-->
	</div>";
	

	if(isset($_SESSION['user'])){
		
		if(!function_exists('gid2nome_gruppo')){
			require(FRONT_REALPATH."/inc/func.comuni.php");
		}
		
		$nome_visualizzato= ($_SESSION['user']['nome']." ".$_SESSION['user']['cognome']!=' ') ? $_SESSION['user']['nome']." ".$_SESSION['user']['cognome'] : $_SESSION['user']['email'];
		
		$OUTPUT_CLOSE.="<div id=\"identita\">"._("Hai fatto l'accesso come")." <br /><a href=\"".FRONT_DOCROOT."/dati_personali.php\">".$nome_visualizzato."</a> ("._('gruppo').":".gid2nome_gruppo($_SESSION['gid']).")</div>\n";
	}
	
	if($back!=""){
		$OUTPUT_CLOSE.="<div id=\"back-dx\">&nbsp;</div>\n";
	
	}
	
	
	if($GLOBALS['DEBUG_SQL_SHOW_QUERY']===true){
		
		$LISTA_SQL = str_replace(array("\n","\t")," ",implode("<br /><br />",$GLOBALS['DEBUG_SQL_STRING']));
		
		$OUTPUT_CLOSE.= "
		<script type=\"text/javascript\">
		
			/* <![CDATA[ */
			
			var xdebug = window.open('', 'xdebug', 'width=800,height=600,toolbar=yes, location=no,status=yes,menubar=no,scrollbars=yes,resizable=yes'); 
			with (xdebug.document) {
			  open('text/html', 'replace');
			  write(\"<html><head><title>VFront DEBUG</title></head><body><code>".str_replace("&lt;br /&gt;","<br />",htmlentities(addslashes($LISTA_SQL),ENT_QUOTES))."</code></body></html>\");
			  close();
			}
			
			/* ]]> */
		
		</script>\n";
	}
	
	$OUTPUT_CLOSE.="\n</body>\n</html>";
	
	return $OUTPUT_CLOSE;
}

/**
 * Scrive l'HTML di chiusura di una pagina
 *
 * @return string HTML 
 */
function closeLayout2(){
	
	return "\n</div>\n</body>\n</html>";
	
}


/**
 * Scrive l'HTML di chiusura di una pagina
 *
 * @param int $livello Livello di amministrazione dell'utente che ha fatto login
 * @return string HTML 
 */
function menu($livello=0){
	
	$MENU=array();
	
/*	
	if($livello>0){
		$MENU[]="<a href=\"statistiche.php\">Statistiche</a>";
		
	}
*/	
	if($livello>1 && ereg('/admin',$_SERVER['PHP_SELF'])){
		$MENU[]="<a href=\"".FRONT_DOCROOT."/\">"._('Home')."</a>";	
	}	


	if($livello>1){
		$MENU[]="<a href=\"".FRONT_DOCROOT."/admin/\">"._('Amministrazione')."</a>";	
	}
	
	
	$MENU[]="<a href=\"".FRONT_DOCROOT."/index.php?logout\">"._('Esci')."</a>";
	
	return "<ul><li>".implode("</li><li>", $MENU)."</li></ul>";
	
}



/**
 * Funzione di gestione a video degli errori. 
 * Se lo script in azione va in errore � possibile interrompere lo script e generare l'apertura
 * di un errore visibile su pagina.
 * La funzione mostra un errore generico a video e manda un'email all'amministratore ed 
 * allo sviluppatore con il dettaglio dell'errore.
 *
 * @param string $tipo_query
 * @param string $messaggio_completo
 */
function openError($tipo_query, $messaggio_completo){
	
	
	// Elimina l'output generato nel contenuto di pagina e vai oltre...
	if(isset($GLOBALS['layout_APERTO']) && $GLOBALS['layout_APERTO']==1)
	ob_clean();	
	
	// manda una email per il debug
	mail(_SYS_ADMIN_MAIL.","._DEV_MAIL,"["._NOME_PROJ." DB] "._('Errore DB in')." $tipo_query",$messaggio_completo);
	
	echo openLayout1(_("Problemi di interrogazione al database"));
	echo "<h1 class=\"var\">"._('Problemi di interrogazione al database')."</h1>\n";
	
	echo "<p>"._("L'operazione ha generato un'anomalia.")."<br />
	"._("Se l'evento si verificasse sistematicamente contattare")." 
	<a href=\"mailto:"._SYS_ADMIN_MAIL."\">"._("l'amministratore di sistema")."</a>.<br />
	"._("Ci scusiamo per il disagio.")."</p>
	<p><a href=\"index.php\">"._("Torna alla home")."</a></p>\n";
	
	echo closeLayout1();
	
	exit;
	
}



/**
 * Funzione che richiama un errore esplicitamante
 * Pu� essere richiamata nel codice dove si voglia.
 * In caso di condizioni critiche si pu� scegliere di mandare una email all'amministratore di sistema (di default=true)
 * E' possibile inoltre impostare un testo specifico, in caso contrario verr� stampato il messaggio di default
 *
 * @param string $messaggio
 * @param bool $email
 * @param string $testo_custom
 */
function openErrorGenerico($messaggio,$email=true, $testo_custom=""){
	
	
	// Elimina l'output generato nel contenuto di pagina e vai oltre...
	if(isset($GLOBALS['layout_APERTO']) && $GLOBALS['layout_APERTO']==1)
	ob_clean();	
	
	if($email){
		$testo=sprintf(_("Il %s si &egrave; verificato il problema"),date("d/m/Y \a\l\l\e H:i:s")).": $messaggio\n".
			   _("sul server ").$_SERVER['HTTP_HOST']." (".$_SERVER['REMOTE_ADDR'].")\n";
		
		// manda una email per il debug
		mail(_SYS_ADMIN_MAIL.","._DEV_MAIL,"["._NOME_PROJ." Error] $messaggio",$testo);
	}
	
	echo openLayout1($messaggio, array("sty/base.css"));
	echo "<h1 class=\"var\">$messaggio</h1>\n";
	
	if($testo_custom==""){
		echo "<p>"._("L'operazione ha generato un'anomalia.")."<br />
		"._("Se l'evento si verificasse sistematicamente contattare")." 
		<a href=\"mailto:"._SYS_ADMIN_MAIL."\">"._("l'amministratore di sistema")."</a>.<br />
		"._("Ci scusiamo per il disagio.")."</p>
		<p><a href=\"index.php\">"._("Torna alla home")."</a></p>\n";
	}
	else{
		
		echo "<p>".$testo_custom."</p>
		<p><a href=\"".FRONT_DOCROOT."/index.php\">"._("Torna alla home")."</a></p>\n";
	}
	
	
	
	echo closeLayout1();
	
	exit;
	
}
?>