<?php
/**
* Alias per vmsql.mysqli.php
* 
* @package VFront
* @subpackage DB-Libraries
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: vmsql.mysqlold.php 407 2009-10-18 15:41:20Z marciuz $
* @see vmsql.mysqli.php
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/







/**
 * @desc DB Connection 
 * @param array $array_db
 * @return resource
 */
function vmsql_connect($array_db){
	
	$link_db = @mysql_connect($array_db['host'].":".$array_db['port'],
							  $array_db['user'],
							  $array_db['passw']); // or die(_("Impossibile connettersi a MySQL"));
							  
	@mysql_select_db($array_db['dbname'],$link_db) or die(_("Database not exists"));
	
	return $link_db;
	
}


/**
 * @desc Esegue una query $sql
 * @param string $sql
 * @param object $link_db
 * @param bool $transazione 
 * @return object 
 */
function vmsql_query($sql,$link_db,$transazione=false){

	$obj = @mysql_query($sql,$link_db) or vmsql_error($sql,mysql_error($link_db),$transazione,$link_db);
	
	if($GLOBALS['DEBUG_SQL']){
		$getmicro=microtime(true);
		$GLOBALS['DEBUG_SQL_STRING'][] = round((microtime(true) - $getmicro),3) . " --- ". $sql;
	}
	
	return $obj;
	
}



/**
 * Esegue una query $sql  e restisce vero|falso a seconda dell'esito 
 * il secure_mode (di default) permette l'uso di sole query SELECT.
 * Se l'sql contiene errori la funzione restituisce false, ma l'esecuzione prosegue.
 *
 * @param string $sql Query SQL da testare
 * @param object $link_db Link al database
 * @param bool $secure_mode Imposta il secure mode per le query, invalidando tutte le query con comandi pericolosi
 * @param bool $prendi_errorn prende il numero di errore come output (al posto di 0)
 * @return bool Esito della query
 */
function vmsql_try($sql,$link_db,$secure_mode=true,$prendi_errorn=false){
	
	$sql=trim(str_replace(array("\n","\r")," ",$sql));
	
	if($secure_mode){
		// piccolo accorgimento per la sicurezza...
		if(!preg_match("'^SELECT 'i",$sql)) return 0;	
		$sql2=preg_replace("'([\W](UPDATE)|(DELETE)|(INSERT)|(DROP)|(ALTER)|(UNION)|(TRUNCATE)[\W])'ui","",$sql);
		if($sql2!=$sql){
			return -1;
		}
	}
	
	if(is_resource($link_db)){
		$res = @mysql_query($sql,$link_db);
		if($res) @mysql_free_result($res);
		
	}
	
	// se si vuole intercettare l'eventuale codice errore
	if($prendi_errorn){
		$errn = @mysql_errno($link_db);
		
		if($errn>0){
			$fp=@fopen("./rpc.debug.txt","a");
			fwrite($fp,date("Y-m-d H:i:s")." --- $errn ---".@mysql_error($link_db)."\n");
			fclose($fp);
			return $errn;
		}
	}
	
	return ($res) ? 1:0;
}



/**
 * @return array
 * @param resource $res
 * @desc Funzione di fetch_row
*/
function vmsql_fetch_row(&$res){

	if(is_resource($res)){

		$RS= @mysql_fetch_row($res);
		if($RS) return $RS;
		else return false;

	}


}

/**
 * @return array
 * @param resource $res
 * @desc Funzione di fetch_assoc
*/
function vmsql_fetch_assoc(&$res){

	if(is_resource($res)){

		$RS= @mysql_fetch_assoc($res);
		if($RS) return $RS;
		else return false;

	}


}


/**
 * @return array
 * @param resource $res
 * @desc Funzione di fetch_array
*/
function vmsql_fetch_array(&$res){

	if(is_resource($res)){

		$RS= @mysql_fetch_array($res);
		if($RS) return $RS;
		else return false;

	}


}






function vmsql_num_rows(&$res){

	if(is_resource($res)){
		return @mysql_num_rows($res);
		
	}
}


/**
 * @return int
 * @param resource $res
 * @desc Funzione di insert ID che restituisce l'ultimo ID autoincrement inserito (MySQL)
*/
function vmsql_insert_id($link){

	
	if(is_resource($link)){
		return @mysql_insert_id($link);
		
	}

}



/**
 * @return int
 * @param resource $link
 * @desc Funzione affected rows
*/
function vmsql_affected_rows($link){

	
	if(is_resource($link)){
		return @mysql_affected_rows($link);
		
	}

}



function vmsql_list_tables($dbname){	
	
	return @mysql_list_tables($dbname);

}



function vmsql_num_fields($dbname){	
	
	return @mysql_num_fields($dbname);

}


function vmsql_fetch_field($dbname){	
	
	return @mysql_fetch_field($dbname);

}


/**
 * @desc Funzione di free_result
 * @return void
 * @param string $result
*/
function vmsql_free_result($result){
	
	mysql_free_result($result);
}






#########################################################################################
#
#
#	FUNZIONI DI ELABORAZIONE
#


/**
 *  Recupera informazioni dal file e dalla query ed apre la funzione openError del file design/layouts.php dove cancella il buffer e manda a video l'errore codificato
 * 
 * @return void
 * @param string $sql
 * @param string $message
 * @desc Handler degli errori per le query. 
*/
function vmsql_error($sql, $message, $transazione=false, $link_db=false){
	

	global $file_DB_error_log;
	
	$GLOBALS['VMSQL_ERROR']=true;
	
	if($transazione){
		vmsql_rollback($link_db);
	}
	
	// se � impostato il DEBUG si ferma qui.
	if($GLOBALS['DEBUG_SQL']) return vmsql_error_debug($sql,$message);
	
	
	// prende il tipo query (SELECT , INSERT, UPDATE, DELETE) se il tipo � diverso ahi ahi
	$tipo_query = substr(trim($sql), 0 , strpos(trim($sql)," "));
	
	
	// restituisci la query che ha dato errore
	$sql_una_linea = str_replace(array("\n","\t")," ",$sql);
	$sql_una_linea = trim(preg_replace("'[ ]+'"," ",$sql_una_linea));
	
	
	// Scrittura del file di errore

	
	$dascrivere= date("Y-m-d H:i:s")."\t"
				. realpath(basename($_SERVER['PHP_SELF'])) . "\t"
				. $_SERVER['HTTP_HOST']. " (".$_SERVER['SERVER_ADDR']. ")\t"
				. $_SESSION['sessid'] . "\t"
				. "Errore in ".$tipo_query . "\t"
				. $linea_err . "\t"
				. $message . "\t"
				. $sql_una_linea. "\n";
	
	
	$fp=fopen($file_DB_error_log,"a");
	fwrite($fp,$dascrivere);
	fclose($fp);
	
	
	if(!function_exists('openError')){
	
		include_once(FRONT_REALPATH."/inc/layouts.php");
	
	}
	// richiamo la funzione openError
	openError($tipo_query, str_replace("\t","\n",$dascrivere));
	exit;
	
}
	

function vmsql_error_debug($sql){
	
	echo "Errore su:\n<br/><pre>".$sql."</pre>";
}




/**
 * @return  matrix
 * @param matrix $matrix
 * @desc restituisce una traslata della matrice partendo da indici numerici
*/
function vmsql_reverse_matrix($matrix){

	if(!is_array($matrix)) return false;
	
	$keys = array_keys($matrix[0]);
	
	for($i=0;$i<count($matrix);$i++){
		
		for($j=0;$j<count($keys);$j++)	$rev[$keys[$j]][$i] = $matrix[$i][$keys[$j]];
	}
	
	return $rev;
}




/**
 * @return array (matrice)
 * @param resource $res
 * @desc Funzione utility di fetch_assoc che restituisce tutta la matrice dei risultati
*/
function vmsql_fetch_assoc_all(&$res, $reverse=false){

	if(is_resource($res)){
		
		$matrice=array();

		while($RS= vmsql_fetch_assoc($res)) $matrice[]=$RS;
		
		vmsql_free_result($res);
		
		if($reverse) 
			return vmsql_reverse_matrix($matrice);
		
		else
			return $matrice;
		
	}
}




/**
 * @return resource
 * @param resource $res
 * @desc Funzione utility di fetch_row che restituisce tutta la matrice dei risultati
*/
function vmsql_fetch_row_all(&$res,$reverse=false){

	if(is_resource($res)){

		while($RS= vmsql_fetch_row($res)) $matrice[]=$RS;
		
		vmsql_free_result($res);
		
		if($reverse) 
			return vmsql_reverse_matrix($matrice);
					
		else
			return $matrice;
		
	}
}




/**
 * @desc Funzione di transazione che corrisponde ad un BEGIN
 * @param resource $link_db
 */
function vmsql_begin($link_db){
	
	vmsql_query("BEGIN",$link_db);
}

/**
 * @desc Funzione di transazione di ROLLBACK
 * @param resource $link_db
 */
function vmsql_rollback($link_db){
	
	vmsql_query("ROLLBACK",$link_db);
}


/**
 * @desc Funzione di transazione di COMMIT
 * @param resource $link_db
 */
function vmsql_commit($link_db){
	
	vmsql_query("COMMIT",$link_db);
}


/**
 * Funzione di utilità 
 * Testa l'esistenza di un $valore (di solito l'ID) nel $campo di una $tabella, 
 * con eventuali clausole $and
 *
 * @param resource $link_db
 * @param string $campo
 * @param mixed $valore_id
 * @param string $tabella
 * @param string $and
 * @return bool
 */
function vmsql_test_id($link_db,$campo,$valore_id,$tabella,$and="",$secure_test=false){
	
	$sql= "SELECT * FROM $tabella WHERE $campo=$valore_id $and";
	
	if($secure_test){
		if(vmsql_try($sql,$link_db)){
			$q=vmsql_query($sql,$link_db);
			
			return (vmsql_num_rows($q)>0) ? true:false;
		}
		else return null;
	}
	else{
	
		$q=vmsql_query($sql,$link_db);
		return (vmsql_num_rows($q)>0) ? true:false;
	}
}





/**
 * @desc Esegue diverse query $sql (forzata per mysql e sperimentale)
 * @param string $sql
 * @param object $link_db
 * @return object 
 */
function vmsql_multi_query($sql_multi,$link_db){
	
	$sql_array=explode(";",$sql_multi);
	
	foreach ($sql_array as $sql){
		
		$obj[] = @mysql_query($sql,$link_db) or vmsql_error($sql,mysql_error($link_db),false,$link_db);
		
		if($GLOBALS['DEBUG_SQL']){
			$getmicro=microtime(true);
			$GLOBALS['DEBUG_SQL_STRING'][] = round((microtime(true) - $getmicro),3) . " --- ". $sql;
		}
	}
	
	return $obj;
	
}


/**
 * Funzione di fetch row in caso di multiple query (forzata per mysql e sperimentale)
 *
 * @param resource $res
 * @param resource $link
 * @return array
 */
function vmsql_fetch_row_multi(&$res,$link){
	
	
	$output=array();
	$res =(!is_array($res)) ? $res=array() : $res;

	foreach ($res as $result){
        /* store first result set */
            while ($row = mysql_fetch_row($result)) {
               $output[]=$row;
            }
       
    }

    return $output;
}

?>