<?php
/**
* LIBRERIA SQL per PostgreSQL con gestione errori ed altre utility
* 
* @package VFront
* @subpackage DB-Libraries
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: vmsql.postgres.php 407 2009-10-18 15:41:20Z marciuz $
* @see vmsql.mysqli.php
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/




/**
 * @desc DB Connection 
 * @param array $array_db
 * @return resource
*/
function vmsql_connect($array_db){
	
	$link_db = @pg_connect("host={$array_db['host']} port={$array_db['port']} dbname={$array_db['postgres_dbname']} user={$array_db['user']} password={$array_db['passw']}")  
	; //or die(_("Impossibile connettersi a PostgreSQL"));
	
	return $link_db;
	
}




/**
 * @desc Esegue una query $sql
 * @param string $sql
 * @param resource $link_db
 * @param bool $transazione 
 * @return object 
 */
function vmsql_query($sql,$link_db,$transazione=false){
	
	if($GLOBALS['DEBUG_SQL']) $GLOBALS['DEBUG_SQL_STRING'][] = $sql;

	if(is_resource($link_db)){
		
		$resource = @pg_query($link_db,$sql) or vmsql_error($sql,pg_errormessage($link_db),$transazione,$link_db);
	}
	else vmsql_error($sql,"Link al DB non disponibile",$link_db);
	
	if(is_resource($resource)) {
		if($transazione) vmsql_commit($link_db);
		return $resource;
	}
	else{
		if($transazione) vmsql_rollback($link_db);
		return false;
	}


}


/**
 * Esegue una query $sql e restisce vero|falso a seconda dell'esito 
 * il secure_mode (di default) permette l'uso di sole query SELECT
 *
 * @param string $sql
 * @param object $link_db
 * @param bool $secure_mode
 * @return bool
 */
function vmsql_try($sql,$link_db,$secure_mode=true){ //,$prendi_errorn=false){
	
		
	$sql=trim(str_replace(array("\n","\r")," ",$sql));
	
	if($secure_mode){
		// piccolo accorgimento per la sicurezza...
		if(!preg_match("'^SELECT 'i",$sql)) return 0;	
		$sql2=preg_replace("'([\W](UPDATE)|(DELETE)|(INSERT)|(DROP)|(ALTER)|(UNION)|(TRUNCATE)[\W])'ui","",$sql);
		if($sql2!=$sql){
			return -1;
		}
	}
	if(is_resource($link_db)){
		$resource = @pg_query($link_db,$sql);
	}
	
	/*// se si vuole intercettare l'eventuale codice errore
	if($prendi_errorn){
		$errn = pg_last_error($link_db);
		
		if($errn==''){
			$fp=@fopen("./rpc.debug.txt","a");
			fwrite($fp,date("Y-m-d H:i:s")." --- $errn ---".@pg_last_error($link_db)."\n");
			fclose($fp);
			return $errn;
		}
	}*/
	
	
	return (is_resource($resource)) ? 1:0;
}


/**
 * @return array
 * @param resource $res
 * @desc Funzione di fetch_row
*/
function vmsql_fetch_row(&$res){

	if(is_resource($res)){

		$RS= @pg_fetch_row($res);
		if($RS) return $RS;
		else return false;

	}


}

/**
 * @return array
 * @param resource $res
 * @desc Funzione di fetch_assoc
*/
function vmsql_fetch_assoc(&$res){

	if(is_resource($res)){

		$RS= @pg_fetch_assoc($res);
		if($RS) return $RS;
		else return false;

	}


}


/**
 * @return array
 * @param resource $res
 * @desc Funzione di fetch_array
*/
function vmsql_fetch_array(&$res){

	if(is_resource($res)){

		$RS= @pg_fetch_array($res);
		if($RS) return $RS;
		else return false;

	}


}


/**
 * @desc Funzione di num_rows
 * @return array
 * @param resource $res
*/
function vmsql_num_rows(&$res){

	if(is_resource($res)){
		return @pg_num_rows($res);
		
	}
}


/**
 * @return int
 * @param resource $res
 * @desc Funzione di insert ID che restituisce l'ultimo ID autoincrement inserito (Postgres)
*/
function vmsql_insert_id($link,$tablename,$fieldname){

	
	$result=@pg_query($link, "SELECT last_value FROM {$tablename}_{$fieldname}_seq");
		if ($result) {
			$arr = @pg_fetch_row($result,0);
			pg_freeresult($result);
			if (isset($arr[0])) return $arr[0];
		
		}
	return false;

}



/**
 * @return int
 * @param resource $link
 * @desc Funzione affected rows
*/
function vmsql_affected_rows($link,$query){

	
	if(is_resource($query)){
		return @pg_affected_rows($query);
		
	}

}




/**
 * @desc Funzione di num_fields
 * @return int
 * @param string $dbname
*/
function vmsql_num_fields($dbname){	
	
	return @pg_num_fields($dbname);

}










#########################################################################################
#
#
#	FUNZIONI DI ELABORAZIONE
#






/**
 * @return array (matrice)
 * @param resource $res
 * @desc Funzione utility di fetch_assoc che restituisce tutta la matrice dei risultati
*/
function vmsql_fetch_assoc_all(&$res, $reverse=false){

	$matrice=array();
	
	if(is_resource($res)){

		while($RS= vmsql_fetch_assoc($res)) $matrice[]=$RS;
		
		if($reverse) 
			return vmsql_reverse_matrix($matrice);
		
		else
			return $matrice;
		
	}
}




/**
 * @return  matrix
 * @param matrix $matrix
 * @desc restituisce una traslata della matrice partendo da indici numerici
*/
function vmsql_reverse_matrix($matrix){

	if(!is_array($matrix)) return false;
	
	$keys = array_keys($matrix[0]);
	
	for($i=0;$i<count($matrix);$i++){
		
		for($j=0;$j<count($keys);$j++)	$rev[$keys[$j]][$i] = $matrix[$i][$keys[$j]];
	}
	
	return $rev;
}


/**
 * @return resource
 * @param resource $res
 * @desc Funzione utility di fetch_row che restituisce tutta la matrice dei risultati
*/
function vmsql_fetch_row_all(&$res,$reverse=false){

	if(is_resource($res)){

		while($RS= vmsql_fetch_row($res)) $matrice[]=$RS;
		
		if($reverse) 
			return vmsql_reverse_matrix($matrice);
					
		else
			return $matrice;
		
	}
}


/**
 * Funzione che recupera le informazioni sui campi di una tabella data
 *
 * @param string $tabella
 * @param resource $link_db
 * @return array
 */
function vmsql_fields($tabella,$link_db){
	
	$res = vmsql_query("SELECT * FROM $tabella LIMIT 1",$link_db);
    $i = @pg_num_fields($res);
    for ($j = 0; $j < $i; $j++) {
       $fieldname = @pg_field_name($res, $j);
       $tab_fields[$fieldname]=@pg_field_type($res, $j);
    }
    
    return $tab_fields;
}


/**
 * Recupera informazioni dal file e dalla query ed apre la funzione 
 * openError del file design/layouts.php dove cancella il buffer e manda a video l'errore codificato
 * 
 * @return void
 * @param string $sql
 * @param string $message
 * @desc Handler degli errori per le query. 
*/
function vmsql_error($sql, $message, $transazione=false, $link_db=false){
	

	global $file_DB_error_log;
	
	$GLOBALS['VMSQL_ERROR']=true;
	
	if($transazione){
		vmsql_rollback($link_db);
	}
	
	if($GLOBALS['DEBUG_SQL']) return vmsql_error_debug($sql,$message);
	
	
	// prende il tipo query (SELECT , INSERT, UPDATE, DELETE) se il tipo � diverso ahi ahi
	$tipo_query = substr(trim($sql), 0 , strpos(trim($sql)," "));
	
	
	// restituisci la query che ha dato errore
	$sql_una_linea = str_replace(array("\n","\t")," ",$sql);
	$sql_una_linea = trim(preg_replace("'[ ]+'"," ",$sql_una_linea));
	
	
	// Scrittura del file di errore

	
	$dascrivere= date("Y-m-d H:i:s")."\t"
				. realpath(basename($_SERVER['PHP_SELF'])) . "\t"
				. $_SERVER['HTTP_HOST']. " (".$_SERVER['SERVER_ADDR']. ")\t"
				. $_SESSION['sessid'] . "\t"
				. "Errore in ".$tipo_query . "\t"
				. $linea_err . "\t"
				. $message . "\t"
				. $sql_una_linea. "\n";
	
	
	$fp=fopen($file_DB_error_log,"a");
	fwrite($fp,$dascrivere);
	fclose($fp);
	
	
	if(!function_exists('openError')){
	
		include_once(FRONT_REALPATH."/inc/layouts.php");
	
	}
	// richiamo la funzione openError
	openError($tipo_query, str_replace("\t","\n",$dascrivere));
	exit;
	
}
	
/**
 * Questa funzione viene eseguita da {@link vmsql_query} qualora il debug sia attivato
 * @desc Funzione che restituisce a video l'SQL che ha generato l'errore
 * @param unknown_type $sql
 * @param unknown_type $message
 */
function vmsql_error_debug($sql,$message=""){
	
	
	
	echo "<pre>Errore su: ".$sql."\n".$message."</pre>";
}







// FUNZIONI DI TRANSAZIONE

/**
 * @desc Funzione di transazione che corrisponde ad un BEGIN
 * @param resource $link_db
 */
function vmsql_begin($link_db){
	
	$q=vmsql_query("BEGIN",$link_db);	
}


/**
 * @desc Funzione di transazione di ROLLBACK
 * @param resource $link_db
 */
function vmsql_rollback($link_db){
	
	$q=vmsql_query("ROLLBACK",$link_db);	
}


/**
 * @desc Funzione di transazione di COMMIT
 * @param resource $link_db
 */
function vmsql_commit($link_db){
	
	$q=vmsql_query("COMMIT",$link_db);	
}





/**
 * Funzione di utilit� 
 * Testa l'esistenza di un $valore (di solito l'ID) nel $campo di una $tabella, 
 * con eventuali clausole $and
 *
 * @param resource $link_db
 * @param string $campo
 * @param mixed $valore_id
 * @param string $tabella
 * @param string $and
 * @return bool
 */
function vmsql_test_id($link_db,$campo,$valore_id,$tabella,$and="",$secure_test=false){
	
	$sql= "SELECT * FROM $tabella WHERE $campo=$valore_id $and";
	
	if($secure_test){
		if(vmsql_try($sql,$link_db)){
			$q=vmsql_query($sql,$link_db);
			
			return (vmsql_num_rows($q)>0) ? true:false;
		}
		else return null;
	}
	else{
	
		$q=vmsql_query($sql,$link_db);
		return (vmsql_num_rows($q)>0) ? true:false;
	}
}


?>