<?php
########################################################################
#
#	 This file is part of VFront.
#
#    VFront is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    VFront is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


/**
* File di index di VFront.
* Questo file viene richiamato per fare il login e|o come Home per l'utente
* Il file di index mostra il login qualora non ci fosse una sessione valida.
* 
* @package VFront
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2008 Mario Marcello Verona
* @version 0.95 $Id: index.php 394 2009-08-11 11:07:06Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/



require_once("./inc/conn.php");
require_once("./inc/layouts.php");
require_once("./inc/func.comuni.php");



$INPUTS="";



if(isset($_GET['login'])){
	
	require("./inc/auth.php");
	
	$_dati = pulisci_dom($_POST);
	
	$LOGIN = new auth($_dati['nick'],$_dati['passw']);
	
	exit;
}
elseif(isset($_GET['logout'])){
	
	$_SESSION=array();
	
	header("Location: ".FRONT_DOCROOT."/index.php");

	exit;
}
elseif(isset($_GET['nolog'])){
	
	$_SESSION=array();
	
	// reload global vars
	$_SESSION['VF_VARS']=var_frontend('session','session');
	
	mostra_login();

	exit;
}
elseif (isset($_SESSION['user']) && is_array($_SESSION['user'])){
	

	mostra_loggato();
	
	
}
else{

	mostra_login();
}




##########################################################################################################














/**
 * Questa funzione genera la pagina di login nel caso il file index sia stato richiamato senza 
 * la presenza di una sessione valida.
 * Pu� presentare il link per il recupero della password se l'opzione � stata definita tra le variabili
 * di VFront e se l'autenticazione non avviene mediante strumenti esterni.
 *
 */
function mostra_login(){
	
	global $conf_auth;
	
	// MODULO PRINCIPALE
	
	$apertura= str_replace("<body>","<body onload=\"document.getElementById('nick').focus();\">",openLayout1(_NOME_PROJ));
	echo $apertura;
	
	if(isset($_GET['nolog'])){
		echo "<div id=\"nologin\"><p>"._('Errore di nome utente o password, prego verificare')."</p></div>\n";
	}
	
	
	
	if(isset($_SESSION['VF_VARS']['recupero_password']) 
	      && $_SESSION['VF_VARS']['recupero_password']==1 
	      && $conf_auth['tipo_external_auth']==null){
		
		$PASSW_RECOVER="<p><a href=\"password_recover.php\">"._('Ho dimenticato la password')."</a></p>";
	}
	else{
		$PASSW_RECOVER='';
	}
	
	$access_label= ($conf_auth['tipo_external_auth']=='' || ($conf_auth['campo_nick']==$conf_auth['campo_mail'])) 
				? _('E-mail')
				: _('Nome utente');
	
	echo "
		<div id=\"login\" align=\"center\">
			<form method=\"post\" action=\"".$_SERVER['PHP_SELF']."?login\" >
				<fieldset>
	
					<legend>"._('Accesso al sistema')."</legend>
					<p>		
						<label for=\"nick\">".$access_label."</label><br />
						<input type=\"text\" name=\"nick\" size=\"30\" maxlength=\"200\" id=\"nick\" /><br />
					</p>
					<p>
						<label for=\"passw\">"._('Password')."</label><br />
						<input type=\"password\" name=\"passw\" size=\"30\" maxlength=\"100\" id=\"passw\" /><br />
					</p>
					<p><input type=\"submit\" name=\"accedi\" value=\"  "._('Accedi')."  \" id=\"accedi\" /></p>
					$PASSW_RECOVER
				</fieldset>
	
			</form>
		</div>
	";
	
	
	
	
	echo closeLayout1();
	
	exit;
}






/**
 * Funzione che genera il codice per produrre la home page.
 * Qualora non ci fosse una sessione valida viene invece creata la pagina di login,
 * mediante la funzione mostra_login()
 * @see function mostra_login
 *
 */
function mostra_loggato(){
	
	global $link,$db1;
	
	proteggi(1);
	
	$files=array("js/scriptaculous/lib/prototype.js",
				 "js/scriptaculous/src/scriptaculous.js",
				 "js/home.js");
	
	echo openLayout1(_NOME_PROJ,$files);
		

	
	echo "<h1 style=\"padding-left:4px;\">"._('Menu principale')."</h1>\n";
	
	if($_SESSION['gid']==0 && (isset($_SESSION['VF_VARS']['alert_login_default']) && $_SESSION['VF_VARS']['alert_login_default']==1)){
		
		echo "<div class=\"info\"><strong>"._('Attenzione!')."</strong><br />
		"._('Si sta facendo un login mediante il <strong>gruppo predefinito')."</strong>.
		"._("Se si &egrave; fatto il login per la prima volta, questo &egrave; normale; &egrave; necessario contattare il proprio referente informatico per farsi attribuire i diritti d'uso corretti.")."</div>\n";
	
	}
	
	
	// TEst configurazione
	if($_SESSION['user']['livello']>=2){
		
		// prendi il test
		$testvfront=@join('',@file('./conf/.testvfront'));
		
		if($testvfront=='1' && $_SESSION['VF_VARS']['alert_config']==1){
		
			echo "<div class=\"alertbox\" id=\"alert_config\"><strong>"._('Attenzione!')."</strong><br />\n";
			echo sprintf(_('Ci sono alcuni problemi nella configurazione di VFront che possono pregiudicare il corretto funzionamento dell\'applicazione. Vedi la %s'),'<a href="admin/vfront.info.php">'._('pagina di diagnostica').'</a>');
			echo " - \n";
			echo "<span id=\"hide_alert_config\" class=\"fakelink\" onclick=\"$('alert_config').fade();\">"._('Non mostrare pi&ugrave; questo messaggio')."</span> ".
			"(".sprintf(_('potrai sempre ripristinarlo dalla pagina %s'),"<a href=\"admin/admin/variabili.php\">"._('variabili')."</a>").")";
			echo "</div>\n";
		
		}
	
	}

######################################################################################################################
	
	// RECUPERO LE TABELLE
	$sql_tab="SELECT * 
			  FROM {$db1['frontend']}.registro_tab 
			  WHERE gid='".$_SESSION['gid']."'
			  AND visibile=1
			  AND table_type='BASE TABLE'
			  ORDER BY table_name
			  ";
	$q_tab = vmsql_query($sql_tab,$link);
	
	$matrice_tab = vmsql_fetch_assoc_all($q_tab);
	
	
	// RECUPERO LE VISTE
	$sql_view="SELECT * 
			  FROM {$db1['frontend']}.registro_tab 
			  WHERE gid='".$_SESSION['gid']."'
			  AND visibile=1
			  AND table_type='VIEW'
			  ORDER BY table_name
			  ";
	$q_view = vmsql_query($sql_view,$link);
	
	$matrice_view = vmsql_fetch_assoc_all($q_view);
	
	
	$LI1 = "";
		
		for($i=0;$i<count($matrice_tab);$i++){
			
			$comment1 = preg_replace("/;? ?InnoDB.*|/ui","",$matrice_tab[$i]['commento']);
			
			$LI1.= "
			<li>
				<a href=\"scheda.php?oid=".$matrice_tab[$i]['id_table']."\">".$matrice_tab[$i]['table_name']."</a>
				<div class=\"desc-tab\">".htmlentities(utf8_decode($comment1),ENT_QUOTES)."</div>
			</li>\n";
		}
		
	$LI2 = "";
		
		for($i=0;$i<count($matrice_view);$i++){
			
			$LI2.= "
			<li>
				<a href=\"scheda.php?oid=".$matrice_view[$i]['id_table']."\">".$matrice_view[$i]['table_name']."</a>
				<div class=\"desc-tab\">&nbsp;</div>
			</li>\n";
		}
		
######################################################################################################################

	

	if($LI1==''){
		
		if($_SESSION['user']['livello']==3){
			
			$q_test=vmsql_query("SELECT id_table FROM ".$db1['frontend'].".registro_tab LIMIT 1",$link);
			if(vmsql_num_rows($q_test)==0){
				
				$inizializza=" <a href=\"admin/menu_registri.php?initreg\">"._("Inizializza il registro")."</a></p>\n";
			}
			else $inizializza='';
		}
		else{
			$inizializza='';
		}
		
		$LI1="<li>"._('Al momento non sono presenti tabelle disponibili').$inizializza."</li>";
	}
	
	
	
	if(file_exists("./usr/add_index.php")){
		
		include("./usr/add_index.php");

		if(function_exists('add_index_top')){
			echo add_index_top();
		}
	}
	
	
	
	echo "
		<div id=\"box-tabelle\" class=\"box-home\">
		
			<div class=\"box-home-txt\">
				<h2>"._('Tabelle disponibili')."</h2>
				<ul class=\"lista-tabelle\">
					$LI1
				</ul>
			</div>
		</div>	
			";
			
	if(count($matrice_view)>0){
	
		echo "
			<div id=\"box-viste\" class=\"box-home\">
			
				<div class=\"box-home-txt\">
					<h2>"._('Viste sui dati')."</h2>
					<ul class=\"lista-tabelle\">
						$LI2
					</ul>
				</div>
			</div>	
				";
	}
	
	echo "
	<p style=\"clear:both;\">&nbsp;</p>
		<div id=\"box-info\" class=\"box-home\">
	
			<div class=\"box-home-txt\">
				<h2>"._('Informazioni e domande frequenti')."</h2>
				<p><a href=\"helpdocs.php\">"._('Documenti utili')."</a></p>
				<p><a href=\"credits.php\">"._('Crediti')."</a></p>
			</div>
	
		</div>
			
		<p style=\"clear:both;\">&nbsp;</p>
		";
		
	
	
	echo closeLayout1();
	
	
}



?>