<?php
/**
* File per la gestione della password smarrita. 
* Questa pagina viene utilizzata per gestire la password, generandone una nuova casuale.
* 
* @package VFront
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: password_recover.php 264 2009-04-24 18:59:37Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/


require_once("./inc/conn.php");
require_once("./inc/layouts.php");
require_once("./inc/func.comuni.php");

/**
 * @desc Funzione di generazione di password (pseudo)casuale
 * @return string Nuova password per gli utenti
 */
function genera_password(){
	
	$consonanti=array("b","c","d","f","g","h","j","k","l","m","n","p","q","r","s","t","v","w","y","x","z");
	
	$vocali=array("a","e","i","o","u");
	
	$PWD='';
	
	for($i=0;$i<4;$i++){
		$c=rand(0,(count($consonanti)-1));
		
		$v=rand(0,4);
		
		$PWD.=$consonanti[$c];
		$PWD.=$vocali[$v];
		
		if(strlen($PWD)==4) $PWD.="-";
	}
	
	return $PWD;
}



if(isset($_POST['email'])){
	
	$_dati=pulisci_dom($_POST);
	
	// verifica che la email esista
	$q=vmsql_query("SELECT * from {$db1['frontend']}.utente WHERE email='".$_dati['email']."'",$link);
	
	
	// se c'� l'email ed il codice di sicurezza � giusto...
	if(vmsql_num_rows($q)==1 && ($_SESSION['image_random_value']==md5($_dati['secure_txt']))){
		
		
		unset($_SESSION['image_random_value']);
		
		// vai avanti
		
		$RS=vmsql_fetch_assoc($q);
		
		$new_pass= genera_password();
		
		$q_up=vmsql_query("UPDATE {$db1['frontend']}.utente SET passwd='".md5($new_pass)."' WHERE id_utente=".intval($RS['id_utente']),$link);
		
		if(vmsql_affected_rows($link,$q_up)==1){
			header("Location: ".$_SERVER['PHP_SELF']."?feed=ok");
			
			
			// -------------------------------------------------------------
			// manda l'email -----------------------------------------------
			
			include_once("./plugins/phpmailer/class.phpmailer.php");
			
			$mail = new PHPMailer();

			$mail->Subject="[VFront] "._("Modifica Password");
			$mail->Body=sprintf(_("Tu o qualcuno per te ha richiesto il %s la modifica della tua password.\nLa tua nuova password &egrave;"),date_encode(date("Y-m-d H:i"),true))." :\n$new_pass\n";
			$mail->From=$conf_mail['MAIL_SENDER'];
			$mail->FromName="VFront";
			

			// se � configurato come invio da SMTP esplicitato
			if($conf_mail['SMTP_AUTH']==true){
				
				$mail->Mailer='smtp';
		
				$mail->Host=$conf_mail['SMTP'];
		
				$mail->SMTPAuth=$conf_mail['SMTP_AUTH'];
		
				// Se � impostata l'autenticazione SMTP
				$mail->Username=$conf_mail['SMTP_AUTH_USER'];
				$mail->Password=$conf_mail['SMTP_AUTH_PASSW'];
		
			}
			
			$mail->AddAddress($_dati['email']);
			$mail->Send();
			
			// -------------------------------------------------------------
			// -------------------------------------------------------------
			
			
		}
		else{
			header("Location: ".$_SERVER['PHP_SELF']."?feed=ko");
		}
	}
	
	else{
		
			header("Location: ".$_SERVER['PHP_SELF']."?feed=n");		
	}
	
	exit;
}


echo openLayout1(_("Recupero password"));


echo "<h1>"._("Recupero password smarrita")."</h1>\n";

if(isset($_GET['feed'])){
	
	if($_GET['feed']=='ok'){
		
		echo "<h2 class=\"verde\">"._("Password modificata correttamente!")."</h2>\n";
		echo "<p>"._("Ora puoi controllare la posta per accedere con la tua nuova password")."</p>\n";
		echo "<p><a href=\"index.php\">"._("Torna al login")."</p>\n";
	}
	elseif($_GET['feed']=='n'){
		
		echo "<h2 class=\"var\">".("Errore nella modifica della password!")."</h2>\n";
		echo "<p><a href=\"index.php\">"._("Torna al login")."</p>\n";
	}
	else{
		
		echo "<h2 class=\"var\">".("Errore nella modifica della password!")."</h2>\n";
		echo "<p><a href=\"index.php\">"._("Torna al login")."</p>\n";
	}
	
	
}
else{

	echo "<p>"._("Hai perso la password?<br /> Inserisci la tua email ed una nuova password sar&agrave; spedita al tuo indirizzo")."</p>\n";
	
	echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\" >
	
		<label for=\"email\">"._("Email").":</label><br />
		<input type=\"text\" name=\"email\" id=\"email\" size=\"45\" maxlength=\"200\" value=\"\" />
		
		<br />
		<br />
		<label for=\"secure_txt\">"._("Codice di sicurezza:")."</label><br />
		<img src=\"img_rand.php\" alt=\""._("codice di sicurezza")."\" /> 
		<input type=\"text\" name=\"secure_txt\" id=\"secure_txt\" size=\"10\" maxlength=\"10\" value=\"\" />
		<br />
		<br />
		<input type=\"submit\" name=\"invia\" id=\"invia\" value=\""._("Inviami una nuova password")."\" />
		</form>\n";

}


echo closeLayout1();

?>