<?php
/**
* Script per la ricerca via RPC di allegati e link. 
* Lo script viene eseguito dalla pagina {@link scheda.php} e cerca allegati e link
* per il record attualmente visualizzato nella maschera.
* 
* @package VFront
* @subpackage RPC
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: rpc.allegati_link.php 264 2009-04-24 18:59:37Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/

require("./inc/conn.php");
require("./inc/func.comuni.php");

proteggi(1);


/**
 * Ricerca di allegati. 
 * Data tabella e valore della Primary Key viene restituito il numero di allegati trovati.
 *
 * @param tabella $tabella Tabella nella quale effettuare la ricerca
 * @param id|string $valore_id Valore del campo Primary Key per cui cercare allegati
 * @return int Numero di allegati trovati per ID e Tabella considerati
 */
function cerca_allegati($tabella,$valore_id){
	
	global $link,$db1;
	
	$sql="SELECT count(*) FROM "._TABELLA_ALLEGATO." WHERE tipoentita='$tabella' AND codiceentita='$valore_id'";
	$q=vmsql_query($sql,$link);
	list($n_allegati)=vmsql_fetch_row($q);
	
	return (int) $n_allegati;
	
}



/**
 * Ricerca di link di un record. 
 * Data tabella e valore della Primary Key viene restituito il numero di link trovati.
 *
 * @param tabella $tabella Tabella nella quale effettuare la ricerca
 * @param id|string $valore_id Valore del campo Primary Key per cui cercare link
 * @return int Numero di link trovati per ID e Tabella considerati
 */
function cerca_link($tabella,$valore_id){
	
	global $link,$db1;
	
	$sql="SELECT count(*) FROM "._TABELLA_LINK." WHERE tipoentita='$tabella' AND codiceentita='$valore_id'";
//	rpc_debug($sql);
	$q=vmsql_query($sql,$link);
	list($n_link)=vmsql_fetch_row($q);
	
	return (int) $n_link;
	
}



$allegati_trovati = cerca_allegati($_GET['action'],$_GET['id']);
$link_trovati = cerca_link($_GET['action'],$_GET['id']);

echo $allegati_trovati.",".$link_trovati;
?>