<?php
/**
* File RPC per le chiamate AJAX della scheda. 
* Questo file viene chiamato da funzioni javascript per eseguire le normali operazioni
* sulla tabella, come inserimento, modifica, cancellazione e selezione dei record.
* Se esiste una chimata post viene incluso il file {@link func.rpc_query.php}
* con le funzioni di interazione con il database
* 
* @package VFront
* @subpackage RPC
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: rpc.php 264 2009-04-24 18:59:37Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/


require("./inc/conn.php");
require("./inc/func.comuni.php");
require("./inc/func.frontend.php");
require("./inc/func.browser_detection.php");


proteggi(1);


$info_browser=implode(" ",browser_detection());
$info_browser=addslashes(stripslashes($info_browser));

$_GET['action']= preg_replace("|[^0-9a-z_-]+|i","",$_GET['action']);


if(count($_POST)>0){

	//	$fp=fopen("test.txt","w");

	require_once("./inc/func.rpc_query.php");


	
	// UPDATE--------------------------------
	
	if($_GET['post']=='update'){

		// Prepara l'SQL
		$sql_update = rpc_query_update($_POST['dati'],$_POST['pk'],$_GET['action']);

		
		// INSERISCO IL LOG E PRENDO L'ID
		$last_id_log=rpc_log('update',$_GET['action'],$_SESSION['user']['uid'],$_SESSION['gid'],$_POST['pk'],true,'',$sql_update,$info_browser); 
		
		
		// Esegui la modifica
		$q_update=vmsql_query($sql_update,$link);
		
		// se OK
		if(vmsql_affected_rows($link,$q_update)==1){
			
			echo 1;
		}
		// se KO cancella la riga di log
		else{
			
			vmsql_query("DELETE FROM {$db1['frontend']}.log WHERE id_log=".intval($last_id_log),$link);
			
			echo 0;
		}

	}
	
	
	
	// INSERT--------------------------------
	
	else if($_GET['post']=='new'){
		$sql_insert= rpc_query_insert($_POST['dati'],$_GET['action']);
		
		$result=vmsql_try($sql_insert,$link,false,true);
				
		// manda l'id appena inserito
		if($result==1){
			
			$PK_tab = prendi_PK($_GET['action']);
			
			if(is_autoincrement($_GET['action'],$PK_tab)){
				$last_id= vmsql_insert_id($link,$_GET['action'], $PK_tab);
			}
			else{
				$last_id=$_POST['dati'][$PK_tab];
			}
			
			
			rpc_log('insert',$_GET['action'],$_SESSION['user']['uid'],$_SESSION['gid'],$last_id,true,'',$sql_insert,$info_browser);
			
			echo $last_id;
		}
		else{
			echo "Err@".$result;
		}
	}
	
	
	
	// DELETE--------------------------------
	
	else if($_GET['post']=='delete'){
		$sql_delete = rpc_query_delete($_POST['pk'],$_GET['action']);
		
		rpc_log('delete',$_GET['action'],$_SESSION['user']['uid'],$_SESSION['gid'],$_POST['pk'],true,'','',$info_browser);
		
		$result=vmsql_try($sql_delete,$link,false,true);
		
		if($result){
			
			// eliminazione link e allegati se ci sono
			rpc_delete_attach($_GET['action'],implode("",$_POST['pk']));
			rpc_delete_link($_GET['action'],implode("",$_POST['pk']));
			
		}
		
		echo $result;
	}
	
	
	
	
	// SEARCH--------------------------------
	
	else if($_GET['post']=='cerca'){
		$risultati_ricerca = rpc_query_search($_POST['dati'],$_GET['action']);

		echo (is_array($risultati_ricerca)) ? implode("|",$risultati_ricerca) : "";
	}

	
	
	
	
	// DUPLICA --------------------------------
		
	else if($_GET['post']=='duplica'){
		$risultati_duplicazione = rpc_query_insert_duplicato($_POST['pk'],$_GET['action'],$_GET['oid_sub'],$_GET['da'],$_GET['dl']);
		
		$last_id= vmsql_insert_id($link,$_GET['action'], prendi_PK($_GET['action']));
		
		list($campo_id,$valore_id)=each($_POST['pk']);
		
		rpc_log('duplicazione',$_GET['action'],$_SESSION['user']['uid'],$_SESSION['gid'],$last_id,true,'','DUPLICAZIONE '.$_GET['action'].":".$valore_id,$info_browser);
		
		echo $risultati_duplicazione;

	}
	


}else{


	if(isset($_GET['c'])) {

		require("./inc/func.xmlize.php");

		$tabella = $_GET['action'];
		$PK = prendi_PK($tabella);
		$orderby = prendi_orderby($tabella,intval($_SESSION['gid']));
		
		//aggiungi l'ID all'order by 
		$orderby_doppio=$orderby.",$PK ASC ";
		
		


		// CASO RISULTATO DI RICERCA-------------------------------------------------------
		// SE c'è l'id in GET prendi calcola a che punto dell'elenco si è arrivati
		if(isset($_GET['id']) && intval($_GET['id'])>0){

			$ID_COUNTER=intval($_GET['id']);

			# CASE MYSQL
			if($db1['dbtype']=='mysql'){
			
				$sql_mysql="SET @N=-1;SELECT numero FROM (SELECT @N := @N +1 AS numero, $PK 
													  FROM $tabella t ORDER BY $orderby_doppio)
								  as temp WHERE $PK=$ID_COUNTER";

				$sql_calcola=$sql_mysql;
				
				$qq=vmsql_multi_query($sql_mysql,$link);
				
				$array_res=vmsql_fetch_row_multi($qq,$link);
				
				$offset=$array_res[0][0];
				
			}
			# CASE POSTGRES (da MIGLIORARE L'EFFICIENZA!)
			else{
				
				$sql_pg="SELECT $PK FROM $tabella t ORDER BY $orderby_doppio";
				
				$q_pg=vmsql_query($sql_pg,$link);
				
				$i=0;
				
				while($RS=vmsql_fetch_row($q_pg)){
					
					if($RS[0]==$ID_COUNTER){
						
						$offset= $i;
						break;
					}
					
					$i++;
				}
			} // end postgresql
		}
		else{
			$offset= (int) $_GET['c'];
		}


		list($tot_records) = vmsql_fetch_row(vmsql_query("SELECT count(*) FROM $tabella",$link));

		if(is_numeric($_GET['c'])){
			$XML = xmlize("SELECT * FROM $tabella ORDER BY $orderby_doppio ".limit_sintax(1,$offset),null,true,$offset,$tot_records);
		}
		elseif($_GET['c']=='all'){
			$XML = xmlize("SELECT * FROM $tabella ORDER BY $orderby_doppio ",null,true,false,$tot_records);
			
		}

		header("Content-Type: text/xml");
		echo $XML;



	}
	
}





?>