<?php
/**
* Generatore della maschera per tabelle e viste.
* Questo file rappresenta il cuore dell'applicazione VFront: attraverso questo file vengono 
* generate le maschere per utilizzare il database, mediante permessi e regole definite nei registri 
* di VFront.
* E' un file complesso che genera HTML e codice dinamico Javascript.
* Si appoggia a numerose librerie php e Javascript: il file principale che viene utilizzato
* a lato client � ./js/proto-scheda.js
* 
* @package VFront
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: scheda2.php 415 2009-11-11 18:17:39Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/

require_once("./inc/conn.php");
require_once("./inc/layouts.php");
require_once("./inc/func.comuni.php");
require_once("./inc/func.frontend.php");
require_once("./inc/func.hash_iframe.php");
require_once("./inc/func.browser_detection.php");

proteggi(1);


$info_browser=browser_detection('full');


/**
 * Funzione per la definizione di larghezza del campo
 *
 * @param string $nome
 * @param string $xg_tipo
 * @return int
 */
function campo_len($nome,$xg_tipo){
	
	$lentxt=strlen($nome)*8;
	
	if($xg_tipo=="timestamp"){
		$lentxt=120;
	}
	
	return $lentxt;
}


/**
 * Creazione del pulsante per le sottomaschere
 *
 * @param array $sm
 */
function pulsante_sottomaschera($sm){
	
	$nome_front= (trim($sm['nome_frontend'])!="") ? $sm['nome_frontend']:$sm['nome_tabella'];
	
	echo "<input class=\"pulsante-submask\" type=\"button\" name=\"sm[".$sm['nome_tabella']."]\"  id=\"sm_".$sm['nome_tabella']."\" value=\"$nome_front\" "
		 ."onclick=\"apri_submask(".$sm['id_table'].",".$sm['id_submask'].");\" />\n";
	
	
	
}



#####################################################################
#
#	PRENDI LE IMPOSTAZIONI DA FRONTEND
#
#

$oid = (int) $_GET['oid'];

//if($oid==0) $oid=776;

$gid = $_SESSION['gid'];

$query1 = vmsql_query("SELECT * from {$db1['frontend']}.registro_tab 
						WHERE id_table=$oid 
						AND visibile=1",$link);

$data_tab=(vmsql_num_rows($query1)==1) ? vmsql_fetch_assoc($query1) : array();

$nome_tab=$data_tab['table_name'];



if(count($data_tab)>0){

	
	// Colonne della TABELLA
	$query2 = vmsql_query("SELECT id_reg, column_name , data_type , character_maximum_length as maxsize, is_nullable, 
							in_richiesto, in_suggest, in_tipo, in_default, commento, extra, jstest, alias_frontend
							FROM {$db1['frontend']}.registro_col 
							WHERE id_table=$oid 
							AND gid=$gid 
							AND in_visibile=1
							ORDER BY in_ordine,ordinal_position",$link);
	
	list($id_reg, $data_col, $data_type, $maxsize, $is_nullable, $in_richiesto, 
		$in_suggest, $in_tipo, $in_default, $commento,$extra,$jstest,$alias_frontend) = vmsql_fetch_row_all($query2,true);
	
	// Massimo risultato
	list($MAX)=vmsql_fetch_row(vmsql_query("SELECT count(*) FROM ".$data_tab['table_name'],$link));

	
	$info_pk=prendi_PK_oid($oid,$data_tab['table_type']);
	
	
	// Colonne della TABELLA per la vista tabellare
	$query3 = vmsql_query("SELECT column_name , data_type , character_maximum_length as maxsize, 
							in_tipo, in_default, alias_frontend
							FROM {$db1['frontend']}.registro_col 
							WHERE id_table=$oid 
							AND gid=$gid 
							AND in_table=1
							ORDER BY ordinal_position",$link);
	
	list($x_column_name, $x_data_type, $x_maxsize, $x_in_tipo, $x_in_default) = vmsql_fetch_row_all($query3,true);
	
	
}
else{
	exit;
}

	############################################################################
	#
	#	CONTATORE x JAVASCRIPT
	#
	#

	// SE c'� l'id in GET prendi calcola a che punto dell'elenco si � arrivati
	if(isset($_GET['id']) && intval($_GET['id'])>0){
		
		// Prendi il moe del campo orderby ed il vaolre relativo all'id	
			
		$sql_calcola_sub = "SELECT ".$data_tab['orderby']." 
							FROM ".$data_tab['table_name']." WHERE ".$info_pk[0]."='".$_GET['id']."'";
		
		$sql_calcola = "SELECT count(*) FROM ".$data_tab['table_name']." 
							WHERE ".$data_tab['orderby']."<($sql_calcola_sub)";
		
		rpc_debug($sql_calcola);
		
		$query_calcola = vmsql_query($sql_calcola,$link);
						
		list($counter)=vmsql_fetch_row($query_calcola);
		
	}
	else if(isset($_GET['counter']) && intval($_GET['counter'])>0){
		
		// Contatore attuale:
		$counter=intval($_GET['counter']);
	}
	else{
		$counter=0;
	}

	#
	#
	############################################################################
	
	
	
	
	
	
	
	$FORM = "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\" id=\"singleform\" name=\"singleform\">\n";
	
	$FORM_0 ="";
	$FORM_1 ="";


	
	
	
	
	
	
	
	
	
	
	
#########################################
#
# 	Ciclo sui CAMPI


// Variabili da impostare prima del ciclo.

$riga_aperta=false;

$campi_req="";
$campi_suggest="";
$in_insert_tab="";
$id_table_ref="";
$FCK_EDITOR_VARS="";
$carica_calendario= false;
$n_tendine_attese=0;
$carica_md5=false;
$carica_sha1=false;
$rules=array();
$id_tendine=array();

for($i=0;$i<count($data_col);$i++){
	
	// variabili da impostare dentro il ciclo.	
	
	$label=true;
		
	$riga_singola=false;
	
	$size=0;
	
	
	
	$href_nuovo_record="";
	
	if($_SESSION['VF_VARS']['js_test']){

		if($jstest[$i]!='') $rules[]=trim($jstest[$i]);
		
	}
	
	

	
	// SE IMPOSTATO, sovrascrivo il tipo sovraimposto a quello di default
	
 	$data_type[$i] = ($in_tipo[$i]=='' || $in_tipo[$i]==null) ? $data_type[$i] : $in_tipo[$i];
	
	
	// Impostazioni del campo
	
	// INT  ----------------------------------------------------------------------------------------------------------------
	
	if(($data_type[$i]=='int' || $data_type[$i]=='tinyint' || $data_type[$i]=='mediumint' || $data_type[$i]=='float' || $data_type[$i]=='double')){
		
		$size=10;
		$input="<input onkeypress=\"mod(this.id);\"  onchange=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" value=\"\" size=\"$size\" readonly=\"readonly\" type=\"text\" />";
	}
	
	
	
	
	// VARCHAR ---------------------------------------------------------------------------------------------------------------
	elseif($data_type[$i]=='varchar' || $data_type[$i]=='char'){
		
		if($maxsize[$i]>100){
			if($maxsize[$i]<=80) $size=$maxsize[$i];
			else $size=135;
			$riga_singola=true;
		}
		else $size=59;
		
		$input="<input onkeypress=\"mod(this.id);\" onchange=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" value=\"\" size=\"$size\" readonly=\"readonly\" type=\"text\" />";
			   
			   
		// IMPOSTAZIONI SUGGEST PER LA RICERCA -----------------------
		
		if($in_suggest[$i]=="1"){
		
			$input.=<<<SUGGEST
			<div id="suggest-{$data_col[$i]}" class="campo-update" style="display:none;border:1px solid black;background-color:white;"></div>
					<script type="text/javascript" language="javascript" charset="iso-8859-1">
						new Ajax.Autocompleter('dati_{$data_col[$i]}','suggest-{$data_col[$i]}','rpc.suggest.php?t={$data_tab['table_name']}',{});
					</script>
			
SUGGEST;
		
		}
		
		
		//--  Fine suggest
			   
	}
	
	
	// TEXTAREA -----------------------------------------------------------------------------------------------
	
	elseif($data_type[$i]=='text' || $data_type[$i]=='mediumtext'){
		
			$riga_singola=true;
			
			$input="<textarea onkeypress=\"mod(this.id);\" onchange=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
				   "id=\"dati_".$data_col[$i]."\" cols=\"132\" rows=\"9\" readonly=\"readonly\" ></textarea>";
				   
	}
	
	
	// BOOL -----------------------------------------------------------------------------------------------
	
	elseif($data_type[$i]=='bool'){
		
			$riga_singola=false;
			
			if($db1['dbtype']=='postgres'){
				$input="<input type=\"checkbox\" onclick=\"this.value=(this.value=='f' || this.value=='')?'t':'f'; mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
				   "id=\"dati_".$data_col[$i]."\" disabled=\"disabled\" style=\"margin-left:0;\" value=\"0\" />";
			}
			else{
				$input="<input type=\"checkbox\" onclick=\"this.value=(this.value==0 || this.value=='')?1:0; mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
				   "id=\"dati_".$data_col[$i]."\" disabled=\"disabled\" style=\"margin-left:0;\" value=\"0\" />";
			}
	}
	
	// PASSWORD -----------------------------------------------------------------------------------------------
	
	elseif($data_type[$i]=='password'){
		
			$riga_singola=true;
			
			// se c'� almeno una codifica MD5 carica il file JS
			if($carica_md5 || $in_default[$i]=='md5') $carica_md5=true;
			if($carica_sha1 || $in_default[$i]=='sha1') $carica_sha1=true;
			
			
		$input="<input onkeypress=\"mod(this.id);\" onchange=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" value=\"\" size=\"59\" readonly=\"readonly\" type=\"password\" title=\"$in_default[$i]\" />";
				   
	}
	
	
	// Tipo richtext: FCKEDITOR -------------------------------------------------------------------------------
	elseif($data_type[$i]=='richtext'){
		
			$riga_singola=true;
		
				include_once("./plugins/FCKeditor/fckeditor.php");
				
				$nome_dir= (dirname($_SERVER['PHP_SELF'])=='/') ? "" : dirname($_SERVER['PHP_SELF']);
				$oFCKeditor = new FCKeditor('dati_'.$data_col[$i]);
				$oFCKeditor->BasePath = $nome_dir."/plugins/FCKeditor/";
				$oFCKeditor->ToolbarSet = 'Custom';
				$oFCKeditor->Height = '290';
				$oFCKeditor->Width = '600';
				$oFCKeditor->Value = '';
				$input = $oFCKeditor->CreateHtml() ."<br />";
				
	
				$FCK_EDITOR_VARS.=$data_col[$i].",";
	
	}
	
	
	
	// tipo speciale hidden   -------------------------------------------------------------------------------
	elseif($data_type[$i]=='hidden'){
		
		$label=false;
		
		$valore_hidden=false;
		
		
		if(isset($in_default[$i])){
			$valore_hidden = $in_default[$i];
			// stringa  per il default
		}
		else{
			$valore_hidden="";
			$str_hidden_default="";
		}

		$str_hidden_default="<span style=\"display:none\" id=\"hd_dati_".$data_col[$i]."\" >$valore_hidden</span>\n";
	
		
		if($extra[$i]=='1'){ // sovrascrittura in modifica
			$classe_hidden=' class="nomodify"';
		}
		else{ // scrittura solo in insert
			$classe_hidden="";
		}
		
		
		
		$input="
		$str_hidden_default
		<input name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" $classe_hidden value=\"".utf8_encode($valore_hidden)."\" type=\"hidden\" />";
	}
	
	
	// tipo speciale SELECT -------------------------------------------------------------------------------
	elseif($data_type[$i]=='select'){
		
		$valori=array();
		
		$input="<select onchange=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" disabled=\"disabled\" >\n";
			   
		
			   
		$valori = explode("[|]",$in_default[$i]);
		
		foreach($valori as $k=>$val){
			
			// se sono stati messi i separatori chiave, valore
			if(ereg('=',$val)){
				list($kk,$val)=explode("=",$val);
			}
			else $kk=$val;
			
			$input.="\t\t<option value=\"$kk\">$val</option>\n";
		}
		
		$input.="</select>\n";
		
	}
	
	
	
	// tipo speciale SELECT FROM -------------------------------------------------------------------------------
	elseif($data_type[$i]=='select_from'){
		
		$valori=array();
		
		$riga_singola=true;
		
		
		$input="<select onchange=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" disabled=\"disabled\" >\n";
		
		$input.="</select>\n";
		
		$n_tendine_attese++;
		
		$id_tendine[]=$id_reg[$i];
		
	}
	
	
	//- FINE SELECT_FROM 
	
	
	
	// DATA ---------------------------------------------------------------------------------------------------------------
	
	elseif($data_type[$i]=='date' && $_SESSION['VF_VARS']['usa_calendari']==1){
	
		$carica_calendario = true;
		
		$input="<input onkeypress=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" value=\"\" size=\"$size\" readonly=\"readonly\" type=\"text\" />";
		
			   
				// Pulsante calendario
		
		$input.=" <img src=\"img/cal_small.gif\" id=\"trigger__dati_".$data_col[$i]."\"
     class=\"calendarietto\" 
     title=\"Date selector\"
     alt=\"Date selector\"
     onmouseover=\"this.style.background='red';\"
     onmouseout=\"this.style.background=''\" />";
			   
	$input.=<<<CAL
		
   <script type="text/javascript">
   
   /* <![CDATA[ */
  
   Calendar.setup({
        inputField     :    "dati_{$data_col[$i]}",   // id of the input field
        button	       :    "trigger__dati_{$data_col[$i]}",   // id of the img field
        firstDay	   :    1,
        ifFormat       :    "%Y-%m-%d",       // format of the input field
        showsTime      :    false,
        timeFormat     :    "24", 
        disableFunc    :    caldis,
        onUpdate       :    catcalc
    });    
    
    /* ]]> */

    </script>

CAL;
		   
			   
	}
	
	
	// DATAORA ---------------------------------------------------------------------------------------------------------------
	
	elseif(($data_type[$i]=='datetime' || $data_type[$i]=='timestamp') && $_SESSION['VF_VARS']['usa_calendari']==1){
	
		$carica_calendario = true;
		
		$input="<input onkeypress=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" value=\"\" size=\"$size\" readonly=\"readonly\" type=\"text\" />";
		
			   
				// Pulsante calendario
		
		$input.=" <img src=\"img/cal_small.gif\" id=\"trigger__dati_".$data_col[$i]."\"
     class=\"calendarietto\" 
     title=\"Date selector\"
     alt=\"Date selector\"
     onmouseover=\"this.style.background='red';\"
     onmouseout=\"this.style.background=''\" onclick=\"get_trigger_cal$i();\" />";
			   
	$input.=<<<CAL
		
   <script type="text/javascript">
   
   /* <![CDATA[ */
    
  
	   	
	MyCal_$i = Calendar.setup({
		        inputField     :    "dati_{$data_col[$i]}",   // id of the input field
		        button	       :    "trigger__dati_{$data_col[$i]}" ,   // id of the img field
		        firstDay	   :    1,
		        ifFormat       :    "%Y-%m-%d %H:%M",       // format of the input field
		        showsTime      :    true,
		        timeFormat     :    "24",
		        disableFunc    :    caldis,
		        onUpdate       :    catcalc
		    });   
	   	
	 
   
    
    
    /* ]]> */

    </script>

CAL;
		   

	}
	
	
	
	// Caso sola lettura (ONLYREAD)
	
	elseif($data_type[$i]=='onlyread'){
		
		$input="<span class=\"onlyread-field\" id=\"dati_".$data_col[$i]."\">&nbsp;</span>\n";
	}
	
	// Caso sconosciuto  (default) -------------------------------------------------------------------------------
	
	else {
		$size=30;
		$label=true;
		$input="<input onkeypress=\"mod(this.id);\" class=\"off\" name=\"dati[".$data_col[$i]."]\" ".
			   "id=\"dati_".$data_col[$i]."\" value=\"\" size=\"$size\" readonly=\"readonly\" type=\"text\" />";
	}
	
	
	
	
	
//-- FIne impostazione dei campi	
	
	
	

















	
	// Impostazioni di campi obbligatori
	if($is_nullable[$i]=="NO" || $in_richiesto[$i]=="1"){
		$obbligatorio = "<span class=\"red\">*</span>";
		// metto in array che usero' ne javascript
		$campi_req.="'".$data_col[$i]."',";
	}
	else{
		$obbligatorio="";
	}
	
	
	// Se � tendina dinamica metti un span di feedback
		
	$span_feed = ($data_type[$i]=='select_from') 
		? " <span id=\"feed_".$data_col[$i]."\" class=\"feed-tendina\">"
		  ."<img src=\"img/refresh1.gif\" alt=\"caricamento\" /> "._("Caricamento in corso...")."</span>" : "";
		  
	$showed_name= (trim($alias_frontend[$i])=='') ? $data_col[$i] : htmlentities(trim($alias_frontend[$i]),ENT_QUOTES);
	
	$str_label = ($label) ? "<label for=\"dati_".$data_col[$i]."\" title=\"".htmlentities($commento[$i],ENT_QUOTES)."\">".$showed_name . $obbligatorio . $span_feed . $href_nuovo_record ."</label>" : "";
	
	
	
	
	
	
	
	
	
	
		
	
	if($riga_singola){
		
		$FORM_0.="
			<div class=\"row-s\">
			{$str_label}{$input}
			</div>
			";
		
		$riga_aperta=false;
	}
	else{
		
		if($riga_aperta){
			
			$FORM_0.="
			<div class=\"row-d2\">
				{$str_label}{$input}
			</div><br class=\"sep\" />
			";
			$riga_aperta=false;
		}
		else{
			
			$FORM_0.="
			<div class=\"row-d1\">
				{$str_label}{$input}
			</div>
			";
			
			$riga_aperta=true;
		}
		
		
		
		
	}
		
	
} // -- fine ciclo sui campi


// tolgo la virgola
$campi_req=substr($campi_req,0,-1);
$campi_suggest=substr($campi_suggest,0,-1);







	############################################
	#
	#	Impostazioni per xgrid
	#
	
	$maxlen = array();
	
	
	$xg_campi='';
	$xg_misure='';
	$xg_tipo='';
	$xg_sort='';
	$xg_align='';
	
	for($i=0;$i<count($x_column_name);$i++){
		
		$lentxt=campo_len($x_column_name[$i],$x_data_type[$i]);
		
		$xg_campi.=$x_column_name[$i].", ";
		
		// Impostazioni lunghezza campi
		if(!isset($maxlen[$x_column_name[$i]]) || $maxlen[$x_column_name[$i]]<$lentxt) {
			
			if(($x_data_type[$i]=='varchar' 
				|| $x_data_type[$i]=='text' 
				|| $x_data_type[$i]=='mediumtext' 
				 )
				 && $lentxt<200){
				$maxlen[$x_column_name[$i]]= 140;
			}
			else{
				$maxlen[$x_column_name[$i]]= $lentxt;
			}
		}
		
		$xg_misure.=$maxlen[$x_column_name[$i]].",";
		$xg_tipo.="ro,";
		$xg_sort.=($x_data_type[$i]=="int") ? "int,":"str,";
		$xg_align.=($x_data_type[$i]=="int") ? "right,":"left,";
	
		
									
	}
	#
	#
	#############################################



// tolgo la virgola dai campi xgrid
$xg_campi = substr($xg_campi,0,-2);
$xg_misure= substr($xg_misure,0,-1);
$xg_tipo= substr($xg_tipo,0,-1);
$xg_sort= substr($xg_sort,0,-1);
$xg_align= substr($xg_align,0,-1);



# Hidden per le chiavi primarie
for($k=0;$k<count($info_pk);$k++){
	
	$FORM_0.="\t\t<input type=\"hidden\" name=\"pk[".$info_pk[$k]."]\" id=\"pk_".$info_pk[$k]."\" value=\"\" />\n";
	
}




$FORM.="<div>$FORM_0</div>\n";

$FORM.="</form>";



#############################################################################################################
#
#	INIZIA L'APERTURA DEL LAYOUT
#
#############################################################################################################



	$files=array(
				 
				 "js/scriptaculous/lib/prototype.js",
				 "js/proto-scheda2.js",
				 "js/scriptaculous/src/scriptaculous.js?load=effects,controls",
				 "sty/scheda.css");
				 
		$files[]="js/dhtmlxGrid/css/my_dhtml.css";
		$files[]="js/dhtmlxGrid/js/dhtmlXCommon.js";
		$files[]="js/dhtmlxGrid/js/dhtmlXGrid.js";
		$files[]="js/dhtmlxGrid/js/dhtmlXGridCell.js";
		$files[]="js/tinydhtmlHistory.js";
		$files[]="js/mostra_nascondi_id.js";
		
				 

		
	// SE ci sono campi data , datetime o timestamp, prendi il calendario
	if($carica_calendario){
		$files[]="js/jscalendar/calendar.js";
		$files[]="js/jscalendar/lang/calendar-it.js";
		$files[]="js/jscalendar/calendar-setup.js";
		$files[]="sty/jscalendar/calendar-win2k-cold-1.css";
	}
		
	
	if($carica_md5){
		
		$files[]="js/md5.js";
	}
	
	if($carica_sha1){
		
		$files[]="js/sha1.js";
	}
			 
	
	if(count($rules)>0){
		
		$files[]="js/yav/yav-config-it.js";
		$files[]="js/yav/yav.js";
	}
	

	$LAYOUT = openLayout1(_("Scheda")." ".$data_tab['table_name'],$files);
	
	if($_SESSION['VF_VARS']['shortcut_tastiera_attivi']==1)
		$LAYOUT = str_replace("<body>","<body onload=\"\" onkeydown=\"hotKeys(event);\">",$LAYOUT);
	else 
		$LAYOUT = str_replace("<body>","<body onload=\"\">",$LAYOUT);

	$usaHistory = (isset($_SESSION['VF_VARS']['usa_history']) && $_SESSION['VF_VARS']['usa_history']==1) ? "true":"false";
	
	
	// VARIABILI RELATIVE ALL'FCKEDITOR
	if(strlen($FCK_EDITOR_VARS)>0){
		
		$add_fck= "var fck_attivo=true;";
		$vars_fck= "var fck_vars=new Array('".str_replace(",","','",substr($FCK_EDITOR_VARS,0,-1))."');";
		$fck_pronti="var fck_pronti=0;";
		$oFCK="var oFCK=new Array();";
	}
	else{
		$add_fck="var fck_attivo=false;"; 
		$vars_fck="var fck_vars=new Array();";
		$fck_pronti="";
		$oFCK="";
	}
	
	
	$alias_tabella = ($data_tab['table_type']=='VIEW' && isset($data_tab['fonte_al']) && $data_tab['fonte_al']!='')
					? $data_tab['fonte_al'] : $data_tab['table_name'];
					
	if(!isset($_GET['parent_field'])) $_GET['parent_field']='';
	if(!isset($_GET['parent_table'])) $_GET['parent_table']='';
	
	
	
	// PRENDI LE SOTTOMASCHERE
	$submasks = prendi_sottomaschere($oid,false,true);
	
	
	
	$lista_submask="";
	$alias_submask="";
	$array_fk_parent=array();
	$array_id_submask=array();
	
	for($i=0;$i<count($submasks);$i++){
		$lista_submask.="'".$submasks[$i]['nome_tabella']."',";
		$nome_front= (trim($submasks[$i]['nome_frontend'])!="") ? $submasks[$i]['nome_frontend']:$submasks[$i]['nome_tabella'];
		$alias_submask.="'".$nome_front."',";
		$array_id_submask[]=$submasks[$i]['id_submask'];
		$array_fk_parent[]='fkparent['.$submasks[$i]['id_submask'].']=\''.$submasks[$i]['campo_pk_parent']."';";
	}	
	$lista_submask= (strlen($lista_submask)>0) ? substr($lista_submask,0,-1): $lista_submask;
	$alias_submask= (strlen($alias_submask)>0) ? substr($alias_submask,0,-1): $alias_submask;
	
	
	
	$pathRelativo = (dirname($_SERVER['PHP_SELF'])=='/') ? "" : dirname($_SERVER['PHP_SELF']);
	
	$jstest_js = ($_SESSION['VF_VARS']['js_test']==1 && count($rules)>0) ? 'true':'false';
	
	$permetti_link = ($data_tab['permetti_link'] == 1 || $data_tab['permetti_link']=='t') ? 1:0;
	
	$permetti_allegati = ($data_tab['permetti_allegati'] == 1 || $data_tab['permetti_allegati']=='t') ? 1:0;
	
	// identifico il db per checkbox ed altro
	$PGdb= ($db1['dbtype']=='postgres') ? "true":"false";
	
	$js_manuale = "
	<script type=\"text/javascript\">
	
	// <!-- 

		var counter = $counter;
		
		var max=$MAX;
		
		var modifiche_attive=false;
		
		var ricerca = false;
		
		var campi_mod= new Array();
		
		var tipo_salva = false;
		
		var passoVeloce = {$_SESSION['VF_VARS']['passo_avanzamento_veloce']};
		
		var campiReq = new Array($campi_req);
		
		var campiSuggest = new Array($campi_suggest);
		
		var record_bloccato=false;
		
		var tabella = '{$data_tab['table_name']}';
		
		var tabella_alias='{$alias_tabella}';
		
		var idRecord=0;
		
		var localIDRecord=0;
		
		var focusScheda=true;
		
		var initGrid = false;
		
		var nuovoRecord = false;
		
		var modificaRecord = false;
		
		var usaHistory = $usaHistory; 
		
		var infoBrows = new Array('".implode("','",$info_browser)."');
		
		var haveParent = (window.opener==null) ? false:true;
		
		var parentField = '".preg_replace("'[\W]'",'',$_GET['parent_field'])."';
		
		var parentTable = '".preg_replace("'[\W]'",'',$_GET['parent_table'])."';

		var permettiLink =$permetti_link;
		
		var permettiAllegati =$permetti_allegati;
		
		var nTendine=0; var tendineAttese=$n_tendine_attese; var tendine= new Array(".implode(",",$id_tendine).");
		
		var initScheda=false;
		
		var pathRelativo='".$pathRelativo."';
		
		$add_fck $vars_fck $fck_pronti $oFCK
	
		var sottomaschere = new Array($lista_submask);
		var sottomaschere_alias = new Array($alias_submask);
		var fkparent=new Array();
		".implode("\n\t\t",$array_fk_parent)."
		
		var jstest=$jstest_js;
		
		var PGdb=$PGdb;
		
		window.onload = history_initialize;
		";	
		
	
	if($carica_calendario){
		
		$js_manuale.="
		
		 function caldis(cal){
		 	return (nuovoRecord || modificaRecord) ? false:true;
		 }
				
		 function catcalc(cal) {

		 	if(nuovoRecord || modificaRecord){
		 		mod(cal.params.inputField.id);
		 	}
   		}
    	";
		
		
//		$js_manuale.=$CALENDARI;
		
	}
		
	
	if($_SESSION['VF_VARS']['js_test']){
		
		$js_manuale.="\n\t\t var rules=new Array();\n";
		
		for($i=0;$i<count($rules);$i++)
		
			$js_manuale.="\t\trules[$i]='".addslashes($rules[$i])."';\n";
		
	}
	
	
	// Scorciatoie da tastiera, condizionate dalle variabili
	
 if($_SESSION['VF_VARS']['shortcut_tastiera_attivi']==1){
	
	$js_manuale.=<<<JSman
		
		var keyActions = new Array ();
		
		
		keyActions [0] = {character:  39, // freccia dx + shift - record avanti veloce
		                  actionType: "code", 
		                  param:      "if(!modifiche_attive && !ricerca && (counter+passoVeloce)<max){sndReq(tabella ,'next10',true);reloadGrid();}",
						  mod:		  "CTRL+SHIFT" 	};
		                  
		keyActions [1] = {character:  37, // freccia sx + shift - record indietro veloce
		                  actionType: "code", 
		                  param:      "if(!modifiche_attive && !ricerca && (counter-passoVeloce)>0){sndReq(tabella,'prev10',true);reloadGrid();}",
		  				  mod:		  "CTRL+SHIFT" 	};
		
		keyActions [2] = {character:  38, // freccia su - vai al primo record
		                  actionType: "code", 
		                  param:      "if(!modifiche_attive && !ricerca){sndReq(tabella ,'min',true);reloadGrid();}",
		                  mod:		  "CTRL" 	}; 
		                                 
		keyActions [3] = {character:  40, // freccia gi� - vai all'ultimo record
		                  actionType: "code", 
		                  param:      "if(!modifiche_attive && !ricerca){sndReq(tabella ,'max',true);reloadGrid();}",
		                  mod:		  "CTRL" 	};
		                  
		keyActions [4] = {character:  39, // freccia dx - record avanti
		                  actionType: "code", 
		                  param:      "if(!modifiche_attive && !ricerca){sndReq(tabella ,'next',true);}",
						  mod:		  "CTRL" 	};
		                  
		keyActions [5] = {character:  37, // freccia sx - record indietro
		                  actionType: "code", 
		                  param:      "if(!modifiche_attive && !ricerca){sndReq(tabella ,'prev',true);}",
		  				  mod:		  "CTRL" 	}; 
		                                                 
		keyActions [6] = {character:  82, // R - Cerca
		                  actionType: "code", 
		                  param:      "cerca()",
		 				  mod:		  "ALT" 	};
		 				  
		keyActions [7] = {character:  13, // invio in modalit� ricerca
		                  actionType: "code", 
		                  param:      "if(ricerca){cerca()}",
		  				  mod:		  "CTRL" 	};    				  
		 				  
		keyActions [8] = {character:  65, // A - Annulla
		                  actionType: "code", 
		                  param:      "annulla()",
		 				  mod:		  "ALT" 	};

JSman;

	

	// contatore per l'array JS keyActions 
	$contatore_key=9;
	

	if($data_tab['in_insert']==1){ 
	
		
	
		$js_manuale.="
		
		keyActions [$contatore_key] = {character:  78, // N - Nuovo record
		                  actionType: \"code\", 
		                  param:      \"nuovo_record()\",
		 				  mod:		  \"ALT\" 	};
		 	";			  

		$contatore_key++;
		
		
		if($data_tab['in_duplica']==1){ 
			
			$js_manuale.="
			
			keyActions [$contatore_key] = {character:  68, // D - Duplica il record
			                  actionType: \"code\", 
			                  param:      \"$('popup-duplica').style.display='';\",
			 		  mod:		  \"ALT\" 	};
			 	";			  
	
			$contatore_key++;
		}

	}		

	
	if($data_tab['in_update']==1){ 
	
		
	
		$js_manuale.="
		
		keyActions [$contatore_key] = {character:  77, // M - Modifica
			                  actionType: \"code\", 
			                  param:      \"if(!modifiche_attive && !nuovoRecord){modifica();}\",
			 				  mod:		  \"ALT\" 	};
			 				  ";
		 				  


		$contatore_key++;

	}	
			


	if($data_tab['in_update']==1 || $data_tab['in_insert']==1){ 
	
		
	
		$js_manuale.="
		
		keyActions [$contatore_key] = {character:  83, // S - Salva
		                  actionType: \"code\", 
		                  param:      \"if(modifiche_attive){salva()}\",
		  				  mod:		  \"ALT\" 	}; 
		 				  
		";
		
		$contatore_key++;

	}	


	if($data_tab['in_delete']==1){ 
	
		
	
		$js_manuale.="
		
		keyActions [$contatore_key] = {character:  69, // E - Elimina
		                  actionType: \"code\", 
		                  param:      \"elimina()\",
		  				  mod:		  \"ALT\" 	};
		";
		
		$contatore_key++;

	}

	if($permetti_link){ 
	
		
	
		$js_manuale.="
		
		keyActions [$contatore_key] = {character:  76, // L - Apri i link
		                  actionType: \"code\", 
		                  param:      \"openWindow('add.link.php?t='+tabella_alias+'&id='+localIDRecord,'Link',80);\",
		  				  mod:		  \"ALT\" 	};
		";
		
		$contatore_key++;

	}
	
	if($permetti_allegati){ 
	
		
	
		$js_manuale.="
		
		keyActions [$contatore_key] = {character:  71, // G - Apri gli allegati
		                  actionType: \"code\", 
		                  param:      \"openWindow('add.attach.php?t='+tabella_alias+'&id='+localIDRecord,'Allegati',70);\",
		  				  mod:		  \"ALT\" 	};
		";
		
		$contatore_key++;

	}

	
 } // End of user defined array


	
	
	$js_manuale.="
			
	// -->
	</script>
	";
	
	$LAYOUT = str_replace("</head>",$js_manuale."</head>",$LAYOUT);
	
	echo $LAYOUT;


	$matrice_riferimenti = ref_campo($nome_tab);
	
?>
<!--[if IE]>
<style>

#singleform input, #singleform textarea{
	margin-left:-12px;
}

#loader-scheda{
	padding:0px 24px 12px 0px;
	height:2400px;
}


</style>

<![endif]-->

<div id="loader-scheda0">
		<div id="loader-scheda"></div>
	
		<div id="pop-loader-contenitore" align="center">
			<div id="pop-loader-scheda" >
				<?php echo _("Caricamento in corso...");?><br /><br />
				<img src="img/refresh1.gif" alt="Loading" height="25" width="25" />
			</div>
		</div>
</div>

<div id="feedback">
	<span id="risposta"></span>
</div>

<?php echo "<div id=\"briciole\"><a href=\"index.php\">home</a> &raquo; "
		  ._("scheda tabella"). " ". $data_tab['table_name']."</div>";
		  
		  
//		  echo "<script> alert('".implode("|",$info_browser)."'); </script>\n";

		$classe_h1 = ($data_tab['table_type']=='VIEW')? "verde":"var";
		  


	echo "<h1>". _('Tabella')." <span class=\"$classe_h1\">".$data_tab['table_name']."</span></h1>\n";

?>

<div><span id="numeri"></span>&nbsp;&nbsp;<span id="refresh">&nbsp;</span></div>



<div id="pulsanti">

	<input title="<?php echo _("primo record");?>" type="button" id="p_primo" name="p_primo" value="   |&lt;   " onclick="sndReq('<?php echo $data_tab['table_name'];?>','min',true);reloadGrid();" accesskey="7" />
	<input title="<?php echo sprintf(_("indietro di %s record"),$_SESSION['VF_VARS']['passo_avanzamento_veloce']);?>" type="button" id="p_prev10" name="p_indietro10" value="   &lt;&lt;   " onclick="sndReq('<?php echo $data_tab['table_name'];?>','prev10',true);reloadGrid();" accesskey="1" />
	<input title="<?php echo _("indietro");?>" type="button" id="p_prev" name="p_indietro" value="   &lt;   " onclick="sndReq('<?php echo $data_tab['table_name'];?>','prev',true);" accesskey="4" />
	<input title="<?php echo _("avanti");?>" type="button" id="p_next" name="p_avanti" value="   &gt;   " onclick="sndReq('<?php echo $data_tab['table_name'];?>','next',true);" accesskey="6"/>
	<input title="<?php echo sprintf(_("avanti di %s record"),$_SESSION['VF_VARS']['passo_avanzamento_veloce']);?>"  type="button" id="p_next10" name="p_avanti10" value="   &gt;&gt;   " onclick="sndReq('<?php echo $data_tab['table_name'];?>','next10',true);reloadGrid();" accesskey="3"  />	
	<input title="<?php echo _("ultimo record");?>" type="button" id="p_ultimo" name="p_ultimo" value="   &gt;|   " onclick="sndReq('<?php echo $data_tab['table_name'];?>','max',true);reloadGrid();" accesskey="9" />
	
	<!--<input accesskey="k" type="button" id="p_TEST" name="p_TEST" value=" TEST XML " onclick="debug_xml();" />-->
	<?php if ($data_tab['in_export']==1) {  ?> <input accesskey="x" type="button" id="p_export" name="p_export" value=" <?php echo _("Esporta dati");?> " onclick="openWindow('admin/export_data.php?idt=<?php echo base64_encode($oid._BASE64_PASSFRASE);?>','esportazione_dati',65);" /> <?php } ?>
	<!--<input type="button" id="p_TEST2" name="p_TEST2" value=" DEBUG Var " onclick="debug_var();" />-->
</div> 





<div id="scheda1">
	
	<div id="pulsanti-azioni">
		
		<?php if($data_tab['in_insert']==1){ 
		echo '<input title="'._('Nuovo record').'" type="button" id="p_insert" name="insert" value=" '._('Nuovo').' " onclick="nuovo_record();" accesskey="n" />'."\n";
		 } else echo "<input type=\"hidden\" id=\"p_insert\" />\n"; ?>
		
		<?php if($data_tab['in_update']==1){ 
		echo '<input title="'._('Modifica il record').'" type="button" id="p_update" name="update" value=" '._('Modifica').' " onclick="modifica();" accesskey="m" />'."\n";
		 } else echo "<input type=\"hidden\" id=\"p_update\" />\n";?>
		
		<?php if($data_tab['in_insert']==1 || $data_tab['in_update']){ 
		echo '<input title="'._('Annulla').'" type="button" id="p_annulla" name="annulla" value=" '._('Annulla').' " onclick="annulla();" accesskey="a" />'."\n";
		 } else echo "<input type=\"hidden\" id=\"p_annulla\" />\n";?>
		
		<?php if($data_tab['in_insert']==1 || $data_tab['in_update']){ 
		echo '<input title="'._('Salva il record').'" type="button" id="p_save" name="save" value=" '._('Salva').' " onclick="salva();" accesskey="s" />'."\n";
		 } else echo "<input type=\"hidden\" id=\"p_save\" />\n";?>	
		
		<?php if($data_tab['in_delete']==1){ 
		echo '<input title="'._('Elimina il record').'" type="button" id="p_delete" name="delete" value=" '._('Elimina').' " onclick="elimina();" accesskey="e" />'."\n";
		 } else echo "<input type=\"hidden\" id=\"p_delete\" />\n";?>
		
		<?php if($data_tab['in_insert']==1 && $data_tab['in_duplica']==1){ 
		echo '<input title="'._('Duplica il record').'" type="button" id="p_duplica" name="duplica" value="'._('Duplica').'" onclick="$(\'popup-duplica\').style.display=\'\';" />'."\n";
		 } else echo "<input type=\"hidden\" id=\"p_duplica\" />\n"; ?>
		
		<?php 
			// Pulsante ricerca
			echo '<input title="'._('Modalit&agrave; ricerca').'" type="button" id="p_cerca" name="cerca" value=" '._('Ricerca').' " onclick="cerca();" accesskey="r" />'."\n";
		 ?>
		
	</div>
	
	
	
	<div id="pulsanti-submask">
	
		<?php
		
				
		
		for($i=0;$i<count($submasks);$i++){
			
			
			echo pulsante_sottomaschera($submasks[$i]);
		}
		
		
		
		
		
		?>
	
	
	</div>
	
	
	<?php echo $FORM;?>
	
	<div id="tipo-vista2">
		<table border="0" summary="<?php echo _('impostazioni vista');?>" class="switch-vista">
			<tr> 
				<td><img src="img/vista_scheda_h.gif" alt="<?php echo _('vista scheda');?>" class="noborder" /></td>
				<td><a href="javascript:;" onclick="switch_vista();"><img src="img/vista_tab.gif" alt="<?php echo _('vista tabella');?>" class="noborder" /></a></td>
			</tr>
			<tr> 
				<td><?php echo _('vista scheda');?></td>
				<td><a href="javascript:;" onclick="switch_vista();"><?php echo _('vista tabella');?></a></td>
			</tr>
		</table>
	
	</div>
	
	
	<?php
	
	
	
	if(is_file("./scheda.allegati_link.php") && (isset($data_tab['pemetti_allegati']) || isset($data_tab['permetti_link'])))
	{
		require_once("./scheda.allegati_link.php");
	}
		
	
	
		

	
	
	?>
	
</div>

<?php 



// DIV PER LA DUPLICAZIONE


 if($data_tab['in_duplica']==1){
 	
 	
?>

<div id="popup-duplica"
	style="position:absolute;
				width:26px;
				height:164px;
				top:20%;
				left:33%;
				width:340px;
				height:350px;
				background-color:#EFF6FF;
				border:2px solid #33CCFF;
				padding:20px;
				z-index:200;
				overflow: auto;
				display:none;"
	>
	<div class="chiudi-box"><span class="fakelink" onclick="mostra_nascondi('popup-duplica');"><?php echo _('Chiudi');?> [X]</span></div>

	<p><strong><?php echo _('Seleziona le sottomaschere da duplicare:');?></strong></p>
	
	<?php

$array_alias=explode("','",$alias_submask);

for($i=0;$i<count($array_id_submask);$i++){
	
	echo "<input type=\"checkbox\" name=\"sotto__".$array_id_submask[$i]."\" value=\"1\" /> ".str_replace("'","",$array_alias[$i])." <br />\n";
	
}


	echo "<br /><hr />\n";
	
	echo "<p><strong>"._('Duplica altri oggetti:')."</strong></p>\n";
	
	echo "<input type=\"checkbox\" name=\"duplica_allegati\" value=\"1\" /> "._('Duplica allegati')."<br /><br />\n";
	echo "<input type=\"checkbox\" name=\"duplica_link\" value=\"1\" /> "._('Duplica link')."<br />\n";

	echo "<br /><hr />\n";
	
	echo "<br /><input type=\"button\" onclick=\"prepara_duplica()\" name=\"duplicatore\" value=\" "._('Duplica')." \" />\n";
	echo " <input type=\"button\" onclick=\"mostra_nascondi('popup-duplica')\" name=\"annulla_duplica\" value=\" "._('Annulla')." \" />\n";

	echo "</div>\n";
	
 }


?>

<?php if($_SESSION['VF_VARS']['shortcut_tastiera_attivi']==1 && $_SESSION['VF_VARS']['shortcut_tastiera_popup']){ ?>

	<div id="popup-hotkeys"
		style="position:absolute;
				width:26px;
				height:164px;
				top:100px;
				right:0;
				border:0;
				padding:0;
				cursor:pointer;
				float:left;
				padding:10px 0 0 0;"
		><img src="img/scorciatoie.gif" alt="<?php echo _('Scorciatoie da tastiera');?>" width="24" height="152" style="" onclick="mostra_nascondi('box-scorciatoie');" />
		
		</div>
		
		<?php
		
		echo "
		
			<div id=\"box-scorciatoie\" 
				 style=\"display:none;\">
				<div class=\"chiudi-box\"><span class=\"fakelink\" onclick=\"mostra_nascondi('box-scorciatoie');\">"._('Chiudi')." [X]</span></div>
				 <p><strong><em>"._('Navigazione tra i record')."</em></strong></p>
				<dl>
					<dt>"._('CTRL + freccia destra')."</dt>
					<dd>"._('Avanza di 1 record')."</dd>
					
					<dt>"._('CTRL + freccia sinistra')."</dt>
					<dd>"._('Torna indietro di 1 record')."</dd>
					
					<dt>"._('CTRL + MAIUSC + freccia destra')."</dt>
					<dd>".sprintf(_('Avanza di %s record'),$_SESSION['VF_VARS']['passo_avanzamento_veloce'])."</dd>
					
					<dt>"._('CTRL + MAIUSC + freccia sinistra')."</dt>
					<dd>".sprintf(_('Torna indietro di %s record'),$_SESSION['VF_VARS']['passo_avanzamento_veloce'])."</dd>
					
					<dt>"._('CTRL + freccia gi&ugrave;')."</dt>
					<dd>"._("Vai all'ultimo record")."</dd>
					
					<dt>"._('CTRL + freccia su')."</dt>
					<dd>"._('Vai al primo record')."</dd>
				</dl>
				<hr />
				<p><strong><em>"._('Azioni')."</em></strong></p>
				<dl>
					<dt>"._('CTRL + ALT + N')."</dt>
					<dd>"._('Nuovo record')."</dd>
					
					<dt>"._('CTRL + ALT + M')."</dt>
					<dd>"._('Modifica')."</dd>
					
					<dt>"._('CTRL + ALT + S')."</dt>
					<dd>"._('Salva')."</dd>
					
					<dt>"._('CTRL + ALT + A')."</dt>
					<dd>"._('Annulla')."</dd>
					
					<dt>"._('CTRL + ALT + E')."</dt>
					<dd>"._('Elimina il record')."</dd>
					
					<dt>"._('CTRL + ALT + D')."</dt>
					<dd>"._('Duplica il record')."</dd>
					
					<dt>"._('CTRL + ALT + R')."</dt>
					<dd>"._('Cerca')."</dd>
					
					<dt>"._('CTRL + Invio (in modalit&agrave; ricerca)')."</dt>
					<dd>"._('Invia ricerca')."</dd>
					
				</dl>
				<hr />
				<p><strong><em>"._('Allegati e link')."</em></strong></p>
				<dl>
					<dt>"._('CTRL + ALT + G')."</dt>
					<dd>"._('Apri gli allegati (se presenti nella maschera)')."</dd>
					
					<dt>"._('CTRL + ALT + L')."</dt>
					<dd>"._('Apri i link (se presenti nella maschera)')."</dd>
				</dl>
				
			</div>
			";
 	}

 	?>
 	
 	
<div id="scheda-tabella" style="display:none;">


	<div style="background-color:whitesmoke;
				width:100%;
				border:1px solid;
				border-color:lightgrey;
				padding:2px;"
	>
		<div  id="gridbox"  style="height:<?php echo (isset($_SESSION['VF_VARS']['altezza_iframe_tabella'])) ? $_SESSION['VF_VARS']['altezza_iframe_tabella'] : 350;?>px;width:100%;" ></div>
	</div>	
	

 
 <script type="text/javascript" >  
	
 // <!--
 
 	var jsOid = <?php echo $oid;?>;
 
 	var x = null;
 	
 	function doOnRowSelected(idRiga){
	 	if(idRiga==x){

	 		idRecord=Number(idRiga);
			sndReq('<?php echo $nome_tab;?>','id',false);
			switch_vista();
			$('risposta').text='';
			
	 	}
	 	x=idRiga;
	 }
	 
	 function caricaGrid(){
	 	
	 	if(!initGrid){
	 	
	 	mygrid = new dhtmlXGridObject('gridbox'); 
		 // or 
		 //mygrid = new dhtmlXGridObject(); 
		 //mygrid.attachToObject(document.body) 
		 mygrid.imgURL = "js/dhtmlxGrid/imgs/"; 
		 mygrid.setHeader("#,<?php echo $xg_campi;?>"); 
		 mygrid.setInitWidths("40,<?php echo $xg_misure;?>") ;
		 mygrid.setColAlign("center,<?php echo $xg_align;?>") ;
		 mygrid.setColTypes("ro,<?php echo $xg_tipo;?>"); 
		 mygrid.setColSorting("int,<?php echo $xg_sort;?>") ;
		 mygrid.setColumnColor("#d5f1ff")
	//	 mygrid.setMultiLine(false)
		 
		 mygrid.setOnRowSelectHandler(doOnRowSelected);
		 
		 <?php echo "//".implode(', ',$maxlen);?>
		 
 		/*

 		// Impostazioni LiveGrid
 		
 		mygrid.enableBuffering(100);
		 mygrid.setXMLAutoLoading("rpc.xmlgrid.php?t=<?php echo $nome_tab;?>",100);//to load additional data from server
		*/
 		
		 mygrid.enableMultiline(false);
		 mygrid.init(); 
		 mygrid.enableMultiline(false);
		 	
		 <?php $paginazione = (isset($_SESSION['VF_VARS']['n_record_tabella'])) ? $_SESSION['VF_VARS']['n_record_tabella']:20;?>
	 	
	 	togli=(counter%<?php echo $paginazione;?>);
		nextData= counter-togli;
		 
		 mygrid.loadXML(pathRelativo+"/rpc.xmlgrid.php?t=<?php echo $nome_tab;?>&gid=<?php echo $gid;?>&of="+nextData+"&hash="+Math.random()); 
		 
		 initGrid=true;
	 	}
	 	else{
	 		
	 		reloadGrid();
	 	}
	 
	 }
	 
	 function reloadGrid(){
	 	
	 	
	 	if(!focusScheda){
	 	
	 		togli=(counter%<?php echo $paginazione;?>);
		 	nextData= counter-togli;
	 	 	mygrid.clearAll(); 
		 	mygrid.loadXML(pathRelativo+"/rpc.xmlgrid.php?t=<?php echo $nome_tab;?>&of="+nextData+"&hash="+Math.random()); 
	 	}
	 }
	 
	 function mostra_risultati_ricerca(ids_ricerca){
	 	
	 	switch_vista();
	 	if(!initGrid){
	 		caricaGrid();
	 	}
	 	mygrid.clearAll(); 
	 	mygrid.loadXML(pathRelativo+"/rpc.xmlgrid.php?t=<?php echo $nome_tab;?>&q="+ids_ricerca+"&hash="+Math.random()); 
	 	
	 	
	 }
	 
	 
	 // Inizializza la tabella
	//	 caricaGrid();
	
	// -->
	 
 </script>
 
 	<div id="tipo-vista1">
		<table border="0" summary="<?php echo _('impostazioni vista');?>" class="switch-vista">
			<tr> 
				<td><a href="javascript:;" onclick="switch_vista();"><img src="img/vista_scheda.gif" alt="vista scheda" class="noborder" /></a></td>
				<td><img src="img/vista_tab_h.gif" alt="vista tabella" class="noborder" /></td>
			</tr>
			<tr> 
				<td><a href="javascript:;" onclick="switch_vista();"><?php echo _('vista scheda');?></a></td>
				<td><?php echo _('vista tabella');?></td>
			</tr>
		</table>
	</div>

</div>


<script type="text/javascript">
	tendine.each(function (ireg){get_json_tendina(ireg);});	
	inizializza_pulsanti_modifica();
</script>
<?php echo closeLayout1(); ?>