<?php
require("./inc/conn.php");
require("./inc/layouts.php");
require("./inc/func.comuni.php");
require("./inc/func.frontend.php");


function search_all($s, $only_visible=true, $exact=false, $max_res_x_tab=10){
	
	global $link;
	
	
	
	if($s=='') return null;
	
	
	$tab=prendi_tabelle($_SESSION['gid'],$only_visible);
	
	$stat['n_tabelle']=count($tab);
	$stat['n_campi']=0;
	
	$cols=array();
	
	foreach($tab as $t){
		list($cols[$t['table_name']])=prendi_colonne_frontend($t['table_name'],"column_name",$only_visible,$_SESSION['gid']);
	}
	
	
	$sql_all=array();
	
	// Ricerca
	foreach($cols as $tabella=>$campo){
		
		$sql=array();
		
					
		$stat['n_campi']+=count($campo);
		
		for($i=0;$i<count($campo);$i++){
			
			if($exact){
				$sql[]=" SELECT '$tabella' as tabella, '{$campo[$i]}' as campo, count(*) as n FROM $tabella WHERE {$campo[$i]}='$s' \n";
			}
			else{
				$sql[]=" SELECT '$tabella' as tabella, '{$campo[$i]}' as campo, count(*) as n FROM $tabella WHERE {$campo[$i]} LIKE '%$s%' \n";
			}
		}
		
		$sql_all[]=implode(" UNION \n",$sql);
	}
	
	
	$sql_final= "SELECT * FROM (".implode(" UNION ",$sql_all).") AS tt HAVING n>0";
	
	$t0=microtime(true);
	
	$q=vmsql_query($sql_final,$link);
	
	$t1=microtime(true);

	$n=vmsql_num_rows($q);
	
	if($n>0){
		
		$mat=vmsql_fetch_assoc_all($q);
	}
	else{
		$mat=null;
	}
	
	$stat['t']=($t1-$t0);
	
	return array($mat,$stat);
	
	
}



$ss=(isset($_GET['s'])) ? trim(stripslashes($_GET['s'])) : "";

$exact=(isset($_GET['e']) && $_GET['e']==1) ? 1:0;

$files=array("sty/tabelle.css","sty/admin.css","js/confirm_delete.js");	


echo openLayout1(_("Documenti Utili"),$files);


echo "<div id=\"briciole\"><a href=\"index.php\">home</a> &raquo; "._('documenti utili')."</div>\n";

echo "<h1>"._('Ricerca globale')."</h1>\n";

echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"get\">
	<p><label for=\"s\">"._('Cerca in tutto il database').":</label> 
	<input type=\"text\" size=\"80\" id=\"s\" name=\"s\" value=\"$ss\" />
	<input type=\"submit\" value=\""._('Cerca')."\" /></p>
	</form>\n";

 
if(isset($_GET['s'])){
	
 $s=trim(addslashes(stripslashes($_GET['s'])));

 $only_visibile = ($_SESSION['user']['livello']<3) ? true:false;
// $only_visibile = true;
 
 list($res,$stat) = search_all($s,$only_visibile,false);
 
 
 if($res!=null){
 	
 	echo "<div id=\"risultati\">
 		<p>"
 		.sprintf(_('La parola %s &egrave; stata trovata in %s campi/tabelle:'),
 		"<strong>$ss</strong>","<strong>".count($res)."</strong>").
 		"</p>\n";
 		
 		echo "<table class=\"tab-color\" summary=\"res\" border=\"1\">";
 		echo "<tr>
 			<th>"._('tabella')."</th>
 			<th>"._('campo')."</th>
 			<th>"._('occorrenze')."</th>
 			<th>"._('vedi')."</th>
 			</tr>\n";
 	
 	foreach($res as $val){
 		
 		echo "<tr>\n";
 		
 		foreach($val as $v){
 			echo "<td>".$v."</td>\n";
 		}
 		
 		$oid= name2oid($val['tabella'],$_SESSION['gid']);
 		
 		if(is_tabella_by_oid($oid,true)){
 			
 			if(!$exact){
 				$sqs='*'.$s.'*';
 			}
 			else{
 				$sqs=$s;
 			}
 			
 			echo "<td><a href=\"./scheda.php?oid=".$oid."&amp;qs=".urlencode("dati[".$val['campo']."]")."=".$sqs."\">"._('vedi_risultati')."</a></td>\n";
 		}
 		else{
 			echo "<td> - </td>\n";
 		}
 		
 		
 		
 		echo "</tr>\n";
 	}
 	
 	echo "</table></div>\n";
 	
 }
 elseif ($s==''){
 	
 	print  "<p>"._('Non si &egrave; cercato nulla!')."</p>\n";
 }
 else{
 	
 	print  "<p>".sprintf(_('Nessun risultato per la parola %s'),"<strong>".$ss."</strong>")."</p>\n";
 }
 
}

if($s!=''){
echo "<p class=\"grigio piccolo\">"
	.sprintf(_('Ricerca effettuata su %d tabelle, %d campi in %01.4f secondi'),$stat['n_tabelle'],$stat['n_campi'],$stat['t'])
	."</p>\n";
}


echo closeLayout1();


?>