<?php
/**
* Da questo file è possibile leggere e creare nuove statistiche. 
* Le statistiche sul DB sono eseguite per mezzo di query registrate in database nella tabella stats 
* 
* @desc File di menu per le statistiche sul database
* @package VFront
* @subpackage Stats
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: index.php 263 2009-04-24 18:58:18Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/


require("../inc/conn.php");
require("../inc/layouts.php");
require("../inc/func.comuni.php");
require("../inc/func.frontend.php");

proteggi(2);

$files=array("sty/admin.css");

echo openLayout1(_("Statistiche Database"),$files);

 echo "<div id=\"briciole\"><a href=\"../admin/index.php\">"._("home amministrazione")."</a> &raquo; "._("statistiche database")."</div>\n";
 
 echo "<br /><img src=\"../img/statistiche.gif\" alt=\""._("statistiche")."\" class=\"img-float\" />\n";
 
 echo "<h1>Statistiche Database</h1>\n";
  

 	// SEZIONE FEEDBACK
 	
 	if(isset($_GET['feed'])){
		switch($_GET['feed']){
			
			case 'okdel': $feed_str="<p class=\"feed-mod-ok\">"._("Statistica eliminata correttamente")."</p>\n";
			break;
			
			case 'kodel': $feed_str="<p class=\"feed-mod-ko\">"._("Errore nella eliminazione della statistica!")."</p>\n";
			break;
			
			case 'konew': $feed_str="<p class=\"feed-mod-ko\">"._("Errore nella creazione della statistica!")."</p>\n";
			break;
			
			case 'komod': $feed_str="<p class=\"feed-mod-ko\">"._("Errore nella modifica della statistica!")."</p>\n";
			break;
			
			case 'okmod': $feed_str="<p class=\"feed-mod-ok\">"._("Statistica modificata correttamente")."</p>\n";
			break;
			
		}
		
 	}
 	
 	else $feed_str='';
 

 	echo $feed_str;
 
 	echo "<p><a href=\"stat.personal.php?new\">"._("Crea una nuova statistica")."</a></p>\n";

	echo "<ul>
		<li><a href=\"stat.count_table.php\">"._("Dati popolamento tabelle")."</a></li>
	</ul>";
	
	
	
	
	// PRENDI LE STAT PERSONALIZZATE
	
	$sql = "SELECT s.id_stat, s.nome_stat , s.autore, s.data_stat, ".concat_sintax("u.nome, ' ', u.cognome", 'nomecognome')."
			FROM {$db1['frontend']}.stat s, {$db1['frontend']}.utente u
			WHERE s.autore=u.id_utente
			AND (auth_stat=1
				OR (auth_stat=2 AND u.gid=".intval($_SESSION['gid']).")
				OR (auth_stat=3 AND u.id_utente=".intval($_SESSION['user']['uid']).")
				)
			ORDER BY data_stat DESC";
	
	$q=vmsql_query($sql,$link);
	
	$stat_pers=array();
	
	while($RS=vmsql_fetch_assoc($q)){
		
		// se � proprietario o amministratore pu� modificare o cancellare la statistica
		$aggiunta_mod_del = (($_SESSION['user']['uid']==$RS['autore']) || $_SESSION['user']['livello']==3) ? 
							" - <a href=\"stat.personal.php?modifica=".$RS['id_stat']."\">modifica</a> - <a href=\"stat.personal.php?elimina=".$RS['id_stat']."\" class=\"rosso\">"._("elimina")."</a>" : "";
		
		$stat_pers[]="<li><a href=\"stat.personal.php?id_s=".$RS['id_stat']."\">".$RS['nome_stat']."</a> (".$RS['nomecognome'].", ".date_encode($RS['data_stat']).") $aggiunta_mod_del</li>\n";
	}
	

	if(count($stat_pers)>0){
		
		echo "<ul style=\"margin-left:40px;\">\n".implode("",$stat_pers)."</ul>\n";
		
	}






echo closeLayout1();


?>