<?php
/**
* @desc Statistica di default sul popolamento delle tabelle del database
* @package VFront
* @subpackage Stats
* @author Mario Marcello Verona <marcelloverona@gmail.com>
* @copyright 2007-2009 M.Marcello Verona
* @version 0.95 $Id: stat.count_table.php 371 2009-05-05 13:49:47Z marciuz $
* @license http://www.gnu.org/licenses/gpl.html GNU Public License
*/


require_once("../inc/conn.php");
require_once("../inc/layouts.php");
require_once("../inc/func.stat.php");
require_once("./stat.graph.php");

// PRENDI TUTTE LE TABELLE e le viste

$sql_tab="SELECT t1.table_name, t1.table_type 
	 FROM {$db1['frontend']}.registro_tab t1
	 WHERE t1.gid=0 
	 ORDER BY t1.table_type, t1.table_name";

$q_tab = vmsql_query($sql_tab,$link);


# PARAMETRI 
$i=0;
$v=0;
$scala=0;
$scala_vista=0;
$nome_file_img='tab_count';
$nome_file_viste_img='view_count';
$tabella=array();
$vista=array();

while($RS=vmsql_fetch_assoc($q_tab)){
	
	if($RS['table_type']=='BASE TABLE'){

		$tabella[$i]=$RS['table_name'];
		
		$q_count=vmsql_query("SELECT count(*) FROM ".$RS['table_name'],$link);
		
		list($count_tabella[$i])=vmsql_fetch_row($q_count);
		
		$scala = ($count_tabella[$i]>$scala) ? $count_tabella[$i]:$scala;
		
		$i++;
	}
	else{
		
		$vista[$v]=$RS['table_name'];
		
		$q_count_v=vmsql_query("SELECT count(*) FROM ".$RS['table_name'],$link);
		
		list($count_vista[$v])=vmsql_fetch_row($q_count_v);
		
		$scala_vista = ($count_vista[$v]>$scala) ? $count_vista[$v]:$scala_vista;
		
		$v++;
	}
	
	
	
}

// OUT

$OUT="";



// GRAFICO E TABELLA PER LE TABELLE

if(count($tabella)>0){
	
	
		$scala = $scala*1.1;
		$stima_altezza_t = round(count($tabella)*22.5,0);
		$altezza_grafico_t = (($stima_altezza_t)<280) ? 280:$stima_altezza_t;
		
		$grafico = barre($count_tabella,$tabella,$scala,_('Popolamento tabelle'),$nome_file_img,540,$altezza_grafico_t,array('red','orange'),165,'%d','ivory');
		
		
		
		// SCRIVE UNA TABELLA:
		
		$OUT.="<table summary=\"cont\" class=\"tab-cont\">\n<tr>";
		
		if($grafico){
			
			$OUT.= "<td><img src=\""._PATH_TMP_HTTP."/$nome_file_img.png\" alt=\"test\"   class=\"img-stat\" /></td>\n";
		}
		
		
		$OUT.= "<td>".stat_tabella($tabella,$count_tabella) . "</td>";
		
		$OUT.="</tr></table>\n";


}





// GRAFICO E TABELLA PER LE VISTE

if(count($vista)>0){

		$scala_v = $scala*1.1;
		$stima_altezza_v = round(count($vista)*22.5,0);
		$altezza_grafico_v = (($stima_altezza_v)<220) ? 220:$stima_altezza_v;
		
		$grafico2 = barre($count_vista,$vista,$scala_v,_('Popolamento viste'),$nome_file_viste_img,540,$altezza_grafico_v,array('green','yellowgreen'),165,'%d','ivory');
		
		
		
		
		$OUT.="<table summary=\"cont\"  class=\"tab-cont\">\n<tr>";
		
		
		
		if($grafico2){
			
			$OUT.=  "<td><img src=\""._PATH_TMP_HTTP."/$nome_file_viste_img.png\" alt=\""._("dati popolamento")."\" class=\"img-stat\" /></td>\n";
		}
		
		
		$OUT.= "<td>".stat_tabella($vista,$count_vista) . "</td>";
		
		$OUT.="</tr></table>\n";

}


$files=array("sty/stat.css");

echo openLayout1(_("Dati popolamento tabelle"),$files);

echo "<div id=\"briciole\"><a href=\"../admin/index.php\">"._("home amministrazione")."</a> &raquo; <a href=\"index.php\">"._("statistiche")."</a> &raquo; "._("popolamento tabelle")." </div>\n";
echo "<h1>"._("Dati popolamento tabelle")."</h1>\n";

echo $OUT;


echo closeLayout1();



?>