<?php
/**
 * Mediante questo file si possono creare, modificare e cancellare nuove statistiche sul database.
 * Le statistiche sono impostata come query e sono registrate nella tabella di registro "stats"
 * 
 * @desc File di gestione delle statistiche impostate dall'utente.
 * @package VFront
 * @subpackage Stats
 * @author Mario Marcello Verona <marcelloverona@gmail.com>
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: stat.personal.php 406 2009-10-18 15:39:03Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License
 */


require_once("../inc/conn.php");
require_once("../inc/layouts.php");
require_once("../inc/func.comuni.php");
require_once("../inc/func.frontend.php");
require_once("../inc/func.stat.php");
require_once("./stat.graph.php");

proteggi(2);




############################################
#
#	REGISTRA NUOVA
#

if(isset($_GET['crea']) && count($_POST)>0){
	
	$_dati = pulisci_dom($_POST);
	
	
	$sql=sprintf("INSERT INTO {$db1['frontend']}.stat 
				  (nome_stat, desc_stat, def_stat, auth_stat , autore, tipo_graph)
				  VALUES
				  ('%s','%s','%s',%d,%d,'%s')",
				  $_dati['nome_stat'],
				  $_dati['desc_stat'],
				  $_dati['def_stat'],
				  $_dati['auth_stat'],
				  $_SESSION['user']['uid'],
				  $_dati['tipo_graph']);
				  
	$q=vmsql_query($sql,$link);
	
	if(vmsql_affected_rows($link,$q)==1){
		
		$id=vmsql_insert_id($link,$db1['frontend'].".stat",'id_stat');
		
		header("Location: ".$_SERVER['PHP_SELF']."?id_s=$id");
		
	}
	else{
		
		header("Location: index.php?feed=konew");
	}
				 
	
	exit;
	
}








############################################
#
#	APPLICA MODIFICA 
#

if(isset($_GET['applica_mod']) && count($_POST)>0){
	
	$_dati = pulisci_dom($_POST);
	
	
	$sql=sprintf("UPDATE {$db1['frontend']}.stat 
				  SET nome_stat='%s', desc_stat='%s', def_stat='%s', auth_stat=%d , tipo_graph='%s'
				  WHERE id_stat=%d
				  LIMIT 1
				  ",
				  $_dati['nome_stat'],
				  $_dati['desc_stat'],
				  $_dati['def_stat'],
				  $_dati['auth_stat'],
				  $_dati['tipo_graph'],
				  $_dati['id_stat']);
				  
	$q=vmsql_query($sql,$link);
	
	if(vmsql_affected_rows($link,$q)==1){
		
		header("Location: index.php?feed=okmod");
		
	}
	else{
		
		header("Location: index.php?feed=komod");
	}
				 
	
	exit;
	
}









############################################
#
#	APPLICA ELIMINA
#

if(isset($_POST['elimina_stat']) && intval($_POST['elimina_stat'])>0){
	
	$_dati = pulisci_dom($_POST);
	
	
	$sql=sprintf("DELETE FROM  {$db1['frontend']}.stat 
				  WHERE id_stat=%d
				  LIMIT 1
				  ",
				  $_dati['elimina_stat']);
				  
	$q=vmsql_query($sql,$link);
	
	if(vmsql_affected_rows($link,$q)==1){
		
		header("Location: index.php?feed=okdel");
		
	}
	else{
		
		header("Location: ".$_SERVER['PHP_SELF']."?feed=kodel");
	}
				 
	
	exit;
	
}















####################################################
#
#	CREA UNA NUOVA STATISTICA
#
#

if(isset($_GET['new']) || isset($_GET['modifica'])){
	
	
	// Caso modifica
	if(isset($_GET['modifica'])){
		
		// prendi i dati
		$q=vmsql_query("SELECT nome_stat, desc_stat, def_stat, autore, auth_stat, tipo_graph 
						FROM {$db1['frontend']}.stat WHERE id_stat=".intval($_GET['modifica']),$link);
		
		$RS=vmsql_fetch_assoc($q);
		
		
		// Verifica il diritto di modifica!
		if($RS['autore']!=$_SESSION['user']['uid'] && $_SESSION['user']['livello']<3){
			
			header("Location: ".$_SERVER['PHP_SELF']."?errore=noauth");
			exit;
		}
		
		$azione='applica_mod';
		$titolo=_('Modifica statistica');
		$titolo2=$titolo." <span class=\"var\">".$RS['nome_stat']."</span>";
		
		$txt_button=_("Modifica statistica");
		
	}
	else{
		
		// valori predefiniti
		
		$RS=array('nome_stat'=>'', 
				  'desc_stat'=>'',
				  'def_stat'=>'',
				  'auth_stat'=>1,
				  'autore'=>'',
				  'tipo_graph'=>'barre');
				  
				  
		$azione='crea';
		
		$titolo=$titolo2=_("Crea nuova statistica");
		
		$txt_button=_("Registra nuova statistica");
	}
	
	
	
	$chk_auth[1] = ($RS['auth_stat']==1) ? "checked=\"checked\"" : "";
	$chk_auth[2] = ($RS['auth_stat']==2) ? "checked=\"checked\"" : "";
	$chk_auth[3] = ($RS['auth_stat']==3) ? "checked=\"checked\"" : "";
	
	$chk_tipo_graph[1] = ($RS['tipo_graph']=='barre') ? "checked=\"checked\"" : "";
	$chk_tipo_graph[2] = ($RS['tipo_graph']=='torta') ? "checked=\"checked\"" : "";
	
	
	
	
	
	
	
	$files=array('js/test_query.js','js/yav/yav.js','js/yav/yav-config-it.js');
	
	echo openLayout1($titolo,$files);
	
	echo "<div id=\"briciole\"><a href=\"../admin/index.php\">"._("home amministrazione")."</a> &raquo; "
	    ."<a href=\"index.php\">"._("statistiche")."</a> &raquo; ".strtolower($titolo)."</div>\n";
	
	echo "<h1>$titolo2</h1>\n";
	
	echo "<script type=\"text/javascript\">
	
	var rules=new Array();
	
	rules[0]='nome_stat|required|"._("Il nome per la statistica e\' obbligatorio")."';
	rules[1]='def_stat|required|"._("Nessuna definizione SQL per la statistica")."';
	
	</script>\n";
	
	
	echo "<form name=\"f1\" action=\"".$_SERVER['PHP_SELF']."?$azione\" method=\"post\" onsubmit=\"return performCheck('f1', rules, 'classic');\" >\n";
	
	echo "<fieldset style=\"width:70%; padding:20px;\">\n";
	echo "<legend style=\"font-weigth:bold\">"._("Parametri nuova statistica")."</legend>\n";
	
	
	$input_modifica = (isset($_GET['modifica'])) ? "<input type=\"hidden\" name=\"id_stat\" value=\"".intval($_GET['modifica'])."\" />\n" : "";

	
	echo "
	
		<label for=\"nome_stat\">"._("Nome statistica:")."</label><br />
		<input type=\"text\" id=\"nome_stat\" name=\"nome_stat\" size=\"40\" maxlength=\"240\" value=\"".$RS['nome_stat']."\" />
		<div class=\"info-campo\" >"._("Nome della statistica personalizzata")."</div>
		
		<label for=\"desc_stat\">"._("Descrizione statistica:")."</label><br />
		<textarea id=\"desc_stat\" name=\"desc_stat\" cols=\"50\" rows=\"4\" >".$RS['desc_stat']."</textarea>
		<div class=\"info-campo\" >"._("Descrizione della statistica personalizzata")."</div>
		
		<br />
		
		<p>"._("Tipo di accesso per la nuova statistica:")."</p>
		<input type=\"radio\" id=\"auth_stat1\" name=\"auth_stat\" value=\"1\" ".$chk_auth[1]." /> <label for=\"auth_stat1\">"._("Pubblica")."</label><br />
		<input type=\"radio\" id=\"auth_stat2\" name=\"auth_stat\" value=\"2\" ".$chk_auth[2]." /> <label for=\"auth_stat2\">"._("Accessibile solo al mio gruppo")."</label><br />
		<input type=\"radio\" id=\"auth_stat3\" name=\"auth_stat\" value=\"3\" ".$chk_auth[3]." /> <label for=\"auth_stat3\">"._("Accessibile solo a me")."</label><br />
		
		<br /><br />
		
		<p>"._("Tipo di grafico desiderato:")."</p>
		<input type=\"radio\" id=\"graph_type1\" name=\"tipo_graph\" value=\"barre\" ".$chk_tipo_graph[1]." /> <label for=\"graph_type1\">"._("A barre")."</label><br />
		<input type=\"radio\" id=\"graph_type2\" name=\"tipo_graph\" value=\"torta\" ".$chk_tipo_graph[2]." /> <label for=\"graph_type2\">"._("A torta")."</label><br />
		
		<br /><br />
		
		
		<label for=\"def_stat\">"._("Definizione statistica:")."</label> 
			<input value=\""._("Test")."\" onclick=\"try_query(document.getElementById('def_stat').value,2)\" type=\"button\" />
			<span id=\"feed_altro_2\" class=\"feed_altro\">&nbsp;</span>
			<br />
		<textarea  id=\"def_stat\" name=\"def_stat\" cols=\"60\" rows=\"7\" >".$RS['def_stat']."</textarea>
		<div class=\"info-campo\" >"._("Query per la definizione della statistica")."</div>
				
		$input_modifica
		
		<input type=\"submit\"  name=\"invia\" value=\"  $txt_button  \" />\n";
	
	
	echo "</fieldset>\n";
	
	echo "</form>\n";
	
	echo closeLayout1();
	
	exit;
	
}










#####################################################
#
#	MOSTRA UNA STATISTICA DA ID
#
#####################################################



if(isset($_GET['id_s'])){
	
	$errore=false;
		
	$ID_STAT= (int) $_GET['id_s'];
	
	$sql="SELECT s.nome_stat, s.desc_stat, s.def_stat, s.auth_stat , s.autore, s.tipo_graph, s.data_stat, u.gid
		  FROM {$db1['frontend']}.stat s, {$db1['frontend']}.utente u 
		  WHERE id_stat=$ID_STAT
		  AND u.id_utente=s.autore";
	
	$q=vmsql_query($sql,$link);

	$RS=vmsql_fetch_assoc($q);


	if(vmsql_num_rows($q)==0){
			
			$errore='norecord';
	}
	
	
	
	// Controllo di propriet� validi per i non admin
	
	
	
	if($_SESSION['user']['livello']<3){
	
		if($RS['auth_stat']==2 && $RS['gid']!=$_SESSION['gid']){
			
			$errore='nogid';
		}
		
		if($RS['auth_stat']==3 && $RS['autore']!=$_SESSION['user']['uid']) {
			
			$errore='nouser';
		}
	
	}
	
	
	// testo la query
	$test_q1=vmsql_try($RS['def_stat'],$link);
	
	if($test_q1==0){
		
		$errore='noquery';
	}
	else if($test_q1==-1){
		$errore='danger';
	}
	else{
	
	
		// Non ci sono errori fino a qui, vai avanti
		
		$q_stat=vmsql_query($RS['def_stat'],$link);
		
		list($etichette, $frequenze)=vmsql_fetch_row_all($q_stat,true);
		
		
		// se non ci sono dati
		if(count($etichette)==0 || count($frequenze)==0){
			
			$errore='nodata';
		}
	}
	
	
	
	// se non ci sono errori
	if($errore===false){
	
		// prendo la frequenza pi� grande per la scala
		$duplicato_freq=$frequenze;	
		rsort($duplicato_freq);
		$scala=$duplicato_freq[0]*1.1;
		
		$scala = ($scala<5) ? 5: $scala;
		
		$stima_altezza = round(count($frequenze)*22.5,0);
		
		$stima_altezza = ($stima_altezza<300) ? 300: $stima_altezza;
		
		$nome_file_tmp = 'img_pers';
		
		// Grafico a barre
		if($RS['tipo_graph']=='barre'){
			
			$grafico=barre($frequenze,$etichette,$scala,$RS['nome_stat'],$nome_file_tmp,550,$stima_altezza);
		}
		
		// Grafico a torta
		else if($RS['tipo_graph']=='torta'){
			
			$grafico=torta($frequenze,$etichette,$RS['nome_stat'],$nome_file_tmp);
		}
		
		
		
		
		if($grafico){
	
			$OUT='';
			
			// SCRIVE UNA TABELLA:
			
			$OUT.="<table summary=\"cont\" class=\"tab-cont\">\n<tr>";
			
			if($grafico){
				
				$OUT.= "<td><img src=\""._PATH_TMP_HTTP."/$nome_file_tmp.png?".time()."\" alt=\"test\"   class=\"img-stat\" /></td>\n";
			}
			
			if($RS['tipo_graph']=='torta'){
				$OUT.= "<td>".stat_tabella($etichette,$frequenze,array("valore","n"),true) . "</td>";
			}
			else{
				$OUT.= "<td>".stat_tabella($etichette,$frequenze,array("valore","n")) . "</td>";
			}
			
			$OUT.="</tr></table>\n";
			
		}
		
		
		$nome_stat_html=htmlentities(stripslashes($RS['nome_stat']),ENT_QUOTES);
		
		$files=array("sty/stat.css");
		
		// prendi autore
		$q_a=vmsql_query("SELECT ".concat_sintax("nome, ' ' , cognome")." FROM {$db1['frontend']}.utente WHERE id_utente=".intval($RS['autore']),$link);
		
		list($nome_autore) = vmsql_fetch_row($q_a);
		
		echo openLayout1("Statistica ".$RS['nome_stat'],$files);
		
		echo "<div id=\"briciole\"><a href=\"../admin/index.php\">"._("home amministrazione")."</a> &raquo; "
		    ."<a href=\"index.php\">"._("statistiche")."</a> &raquo; ".$nome_stat_html." </div>\n";
		echo "<h1>$nome_stat_html</h1>\n";
		
		echo "<div style=\"padding:10px; background-color:#FFF2CF;width:40em;margin:3px 3px 16px 3px;border:1px solid #444;\">\n";
		
		echo "<p><b>"._("Descrizione")."</b>: ".htmlentities($RS['desc_stat'],ENT_QUOTES,FRONT_ENCODING)."</p>";
		echo "<p><b>"._("Autore")."</b>: ".$nome_autore."</p>";
		echo "<p><b>"._("Data definizione")."</b>: ".date_encode($RS['data_stat'])."</p>";
		
		echo "</div>\n";
		
		echo $OUT;
		
		echo closeLayout1();
	}
	
	else{
		
		$files=array("sty/stat.css");
		
		echo openLayout1(_("Statistica")." ".$RS['nome_stat'],$files);
		
		echo "<div id=\"briciole\"><a href=\"../admin/index.php\">"._("home amministrazione")."</a> &raquo; "
		    ."<a href=\"index.php\">"._("statistiche")."</a> &raquo; ".$nome_stat_html." </div>\n";
		echo "<h1>"._("Impossibile visualizzare i dati")."</h1>\n";
		
		switch($errore){
			
			case 'nogid' : echo "<p><strong>"._("Attenzione!")."</strong> "._("Si sta provando ad accedere ad una statistica aperta solo ad un gruppo di utenti del quale tu non fai parte.")."</p>\n";
			break;
			
			case 'nouser' : echo "<p><strong>"._("Attenzione!")."</strong> "._("Si sta provando ad accedere ad una statistica personale della quale tu non sei autore.")."</p>\n";
			break;
			
			case 'noquery' : echo "<p><strong>"._("Attenzione!")."</strong> "._("Si sta provando ad accedere ad una statistica che sembra avere un errore nell'SQL. Prego rivedere la definizione della query")."</p>\n";
			break;
			
			case 'nodata' : echo "<p>"._("Non ci sono dati per questa statistica")."</p>\n";
			break;
			
			case 'danger' : echo "<p>"._("La query contiene parole chiave SQL potenzialmente pericolose e non &egrave; stata eseguita")."</p>\n";
			break;
			
			case 'norecord' : echo "<p><strong>"._("Attenzione!")."</strong> "._("Si sta interrogando una statistica inesistente")."</p>\n";
			break;
			
			default : echo "<p><strong>"._("Attenzione!")."</strong> "._("C'&egrave; un errore generico nella visualizzazione della statistica")."</p>\n";
			
		}
		
			
		
		echo closeLayout1();
		
	}
	
	
	
}


if(isset($_GET['elimina'])){
	
		$ID_STAT= (int) $_GET['elimina'];
	
		$sql="SELECT s.nome_stat, s.desc_stat, s.def_stat, s.auth_stat , s.autore, s.tipo_graph, s.data_stat, u.gid, ".concat_sintax("u.nome, ' ' , u.cognome", 'nomecognome')."
			  FROM {$db1['frontend']}.stat s, {$db1['frontend']}.utente u 
			  WHERE id_stat=$ID_STAT
			  AND u.id_utente=s.autore";
		
		$q=vmsql_query($sql,$link);
	
		$RS=vmsql_fetch_assoc($q);
	
		echo openLayout1(_("Statistica")." ".$RS['nome_stat']);
		
		echo "<div id=\"briciole\"><a href=\"../admin/index.php\">"._("home amministrazione")."</a> &raquo; "
		    ."<a href=\"index.php\">"._("statistiche")."</a> &raquo; "._("elimina statistica")." </div>\n";
		
		echo "<h1>"._("Elimina statistica")."</h1>\n";
		
		echo "<div style=\"padding:10px; background-color:#FFF2CF;width:40em;margin:3px 3px 16px 3px;border:1px solid #444;\">\n";
		
		echo "<p><b>ID</b>: $ID_STAT</p>";
		echo "<p><b>"._("Descrizione")."</b>: ".htmlentities($RS['desc_stat'],ENT_QUOTES,FRONT_ENCODING)."</p>";
		echo "<p><b>"._("Autore")."</b>: ".$RS['nomecognome']."</p>";
		echo "<p><b>"._("Tipo grafico")."</b>: ".$RS['tipo_graph']."</p>";
		echo "<p><b>"._("Data definizione")."</b>: ".date_encode($RS['data_stat'])."</p>";
		
		echo "</div>\n";
		
		
		echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\" >\n";
		
		// info statistica...
		
		echo "<p><strong>"._("Attenzione!")."</strong> "._("Vuoi veramente eliminare la statistica? L'operazione &egrave; irreversibile.")."</p>\n";
		
		echo "<input type=\"hidden\" name=\"elimina_stat\" value=\"".intval($_GET['elimina'])."\" />\n";
		echo "<input type=\"submit\" name=\"esegui_elimina_stat\" value=\""._("Elimina statistica")."\" />\n";
		
		echo "&nbsp; "._("oppure")." &nbsp; <a href=\"index.php\">"._("torna indietro")."</a>";
		
		echo "</form>\n";
		
		
		echo closeLayout1();
	
	
}


?>