<?php
/**
 * Questo file gestisce i diritti e la sicurezza per l'esecuzione di Apache FOP.
 * 
 * @desc Esegue Apache FOP
 * @package VFront
 * @subpackage VFront_XML
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: fop_exec.php 371 2009-05-05 13:49:47Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 * @todo Mettere le estensioni possibili di FOP nelle variabili di ambiente, Verificare l'apertura dei report query_based
 */

require("../inc/conn.php");

/**
 * Funzione che lancia l'eseguibile FOP e manda a video il file generato. 
 * Il parametro $debug se impostato TRUE, mostra il codice di ritorno della shell e non manda in stream il file
 *
 * @param string $input_fo Eventuale file FO (non usato)
 * @param string $input_xml File di input XML
 * @param string $input_xsl File di input XSL
 * @param string $output_file Nome per il file di output
 * @param string $tipo Tipo di file da generare (default: pdf)
 * @param bool $debug Parametro di debug: se attivo non viene generato il file ma l'output di FOP
 */
function fop_exec($input_fo='',$input_xml='',$input_xsl='',$output_file='',$tipo='pdf',$debug=false){
	
	global $types;
	
	if(!_FOP_ENABLED){
		
		die(_("FOP non attivato!<br />Modificare il file di configurazione per utilizzare l'eseguibile FOP"));
	}
	
	if($input_fo=='' && ($input_xml=='' && $input_xsl=='')){
		
		die(_("Files input non specificati"));
	}
	
	if(!is_file(_PATH_FOP)){
	
		die(_("File fop inesistente"));
	}
	
	if(!is_executable(_PATH_FOP)){
		
		die(_("File fop non eseguibile"));
	}
	
	if(in_array($tipo,$types)){
	
		$str_exec=_PATH_FOP
		." -xml ".$input_xml
		." -xsl ".$input_xsl
		." -$tipo ".$output_file;
		
		exec($str_exec
		,$output
		,$ret);
	}
	else{
		
		die(_('Tipo di output non supportato'));
	}
	
	
	// SEZIONE DEBUG
	$output=implode("\n",$output);
	
	if($debug){
		print "<pre>";
		echo $str_exec;
		echo "\n";
		var_dump($output);
		print "\n";
		var_dump($ret);
		print "</pre>";
	}
	elseif($ret==0){
		header("Content-type: application/$tipo");
		$pezzi=explode("/",$output_file);
		header ("Content-Disposition: inline; filename=".$pezzi[(count($pezzi)-1)]);
		print join('',file($output_file));
		unlink($output_file);
	}
	
}





	
$tabella = preg_replace("'[^a-z0-9_]'i","",$_GET['action']);

// SICUREZZA ---------------------------------------------




	//Cerca le regole in DB// cerca i diritti
	$q=vmsql_query("SELECT * FROM {$db1['frontend']}.xml_rules WHERE tabella='$tabella' ORDER BY lastData DESC LIMIT 1",$link);
	
	if(vmsql_num_rows($q)==0){
		echo "<h1>"._("Accesso vietato")."</h1>\n"; exit;
	}
	else $RS_rules=vmsql_fetch_assoc($q);
	
	
	if($RS_rules['xslfo']=='-1'){
		
		echo "<h1>"._("File non previsto")."</h1>\n"; exit;
	}
	
	
	if($RS_rules['accesso']=='PUBLIC'){
		
		// non fa niente e continua con lo script
	}
	elseif($RS_rules['accesso']=='FRONTEND'){
		proteggi(1);
	}
	elseif($RS_rules['accesso']=='GROUP'){
		
		$gruppi=explode(",",$RS_rules['accesso_gruppo']);
		
		if(is_array($gruppi) && in_array($_SESSION['gid'],$gruppi)){
			
			// va avanti
		}
		else{
			echo "<h1>"._("Accesso vietato")."</h1>\n"; exit;
		}
	}
	else{ // RESTRICT o altro...
		
		echo "<h1>"._("Accesso vietato")."</h1>\n"; exit;
	}
	
	
	
	
	
	
// ---------------------------------------------------------
	
#################
#
#	TODO: gestire l'accesso con i diritti...
#	
#
	
if(isset($_GET['c'])){
	
	$file_xml_web= FRONT_DOCROOT."/xml/$tabella/".$_GET['c']."/XML";

}
else if(isset($_GET['id'])){
	
	$file_xml_web= FRONT_DOCROOT."/xml/$tabella/id/".intval($_GET['id'])."/XML";

}
else{
	
	$file_xml_web= FRONT_DOCROOT."/xml/$tabella/all/XML";
}

$file_xml=_PATH_TMP."/".$tabella.".xml";

copy($file_xml_web,$file_xml);


// FILE XSL 

if($RS_rules['xslfo']==''){

	include("./fo.php");
	
	$file_xsl= _PATH_TMP."/$tabella.xslt";
	
}
else{
	
	$file_xsl=_PATH_XSL."/".$RS_rules['xslfo'];
}

// TIPI SUPPORTATI
$types=array('pdf','rtf','ps','txt','tiff','png','pcl','apf','svg');

// tipo di documento
$tipo_richiesto=trim(strtolower($_GET['type']));

if(in_array($tipo_richiesto,$types)){
	
	$TYPE_DOC=$tipo_richiesto;
}
else{
	
	$TYPE_DOC='pdf';
}


$file_output= _PATH_TMP."/".date("Ymd")."_".$tabella.".".strtolower($TYPE_DOC);

fop_exec('',$file_xml,$file_xsl,$file_output,$TYPE_DOC ,false);


?>