<?php
/**
 * File che getisce la creazione dinamica e lo stream dell'XML di VFront
 * Viene utilizzato anche per generare report HTML e PDF, se associato a fogli di stile
 * Il file non � richiamato direttamente ma mediante riscrittura degli URL
 * da parte del file .htaccess presente nella stessa cartella
 * 
 * @desc Output XML
 * @package VFront
 * @subpackage VFront_XML
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: xml.php 414 2009-11-11 18:17:27Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */


require("../inc/conn.php");
require("../inc/layouts.php");
require("../inc/func.comuni.php");
require("../inc/func.frontend.php");
require("../inc/func.xmlize.php");


/**
 * Funzione per recuperare le impostazioni del gruppo attuale per la tabella in oggetto
 * Restituisce SQL con eventuali subquery
 *
 * @param string $nome_tabella
 * @param bool $only_visibile
 * @return string (sql)
 */
function campi_elaborati($nome_tabella,$only_visibile=true){
	
	global $link,$db1;

	$oid=name2oid($nome_tabella,intval($_SESSION['gid']));
	
	$clausola_visibile = ($only_visibile) ? "AND c.in_visibile=1" : "";
	
	// PRENDI INFO Colonne della TABELLA
	$query2 = vmsql_query("SELECT c.column_name , c.data_type , c.character_maximum_length as maxsize, c.is_nullable, 
							c.in_tipo, c.in_default, t.orderby, t.orderby_sort
							FROM {$db1['frontend']}.registro_col c, {$db1['frontend']}.registro_tab t
							WHERE c.id_table=$oid 
							AND c.id_table=t.id_table
							$clausola_visibile
							ORDER BY c.ordinal_position",$link);
	
	$matrice_info = vmsql_fetch_assoc_all($query2);
	
	foreach($matrice_info as $k=>$info){
		
		if($k==0){
			$ORDERBY = ($info['orderby']!='') ? "ORDER BY ".$info['orderby']." ".$info['orderby_sort'] : "";
		}
		
		if($info['in_tipo']=="select_from"){	
			
		//	$reg_exp = "'SELECT ([\w]+) ?, ?([\w]+) +FROM +([\w]+).*?'i";
			$reg_exp = "|SELECT ([\w.]+) ?, ?([\w.() ,' -]+) +FROM +([\w]+).*?|i";
			
			$test = preg_match($reg_exp,$info['in_default'],$campo_k);
		
			$campi.=" (SELECT t$k.{$campo_k[2]} FROM {$campo_k[3]} t$k WHERE t$k.{$campo_k[1]}=t.{$info['column_name']}) as ".$info['column_name'].",";
		}
		else{
			
			$campi.=" t.".$info['column_name'].",";
		}
	}
	
	$campi=substr($campi,0,-1);
		
	return $campi;
}





	// query based?
	$QB = (isset($_GET['querybased']) && $_GET['querybased']=='@') ? 1:0;






	if($QB){
		
		$nome_report = preg_replace("'[^a-z0-9_-]'i","",$_GET['action']);
	}
	else{
		$tabella = preg_replace("'[^a-z0-9_]'i","",$_GET['action']);
	}
		
	
	
	########################################
	#
	#	DIRITTI XML
	#
	########################################
	
	
	if($QB){
		
		// cerca i diritti come report tabella
		$q=vmsql_query("SELECT * FROM {$db1['frontend']}.xml_rules WHERE nome_report='$nome_report' ORDER BY lastData DESC LIMIT 1",$link);
	}
	else{
		// cerca i diritti come report tabella
		$q=vmsql_query("SELECT * FROM {$db1['frontend']}.xml_rules WHERE tabella='$tabella' ORDER BY lastData DESC LIMIT 1",$link);
		
	}
		
	if(vmsql_num_rows($q)==0){
		echo "<h1>Accesso vietato</h1>\n"; exit;
	}
	else $RS_rules=vmsql_fetch_assoc($q);
	
	if($RS_rules['accesso']=='PUBLIC'){
		
		// non fa niente e continua con lo script
	}
	elseif($RS_rules['accesso']=='FRONTEND'){
		proteggi(1);
	}
	elseif($RS_rules['accesso']=='GROUP'){
		
		$gruppi=explode(",",$RS_rules['accesso_gruppo']);
		
		if(is_array($gruppi) && in_array($_SESSION['gid'],$gruppi)){
			
			// va avanti
		}
		else{
			echo "<h1>"._("Accesso vietato")."</h1>\n"; exit;
		}
	}
	else{ // RESTRICT o altro...
		
		echo "<h1>"._("Accesso vietato")."</h1>\n"; exit;
	}
	
	
	
	
	
	
	
	if($QB){
		
		
		
	}
	else{
	
		$PK = prendi_PK($tabella,intval($_SESSION['gid']));
		
		
		$orderby = prendi_orderby($tabella,intval($_SESSION['gid']));
		
		if(trim($orderby)=='ASC') $orderby = 1;
		
		//aggiungi l'ID all'order by 
		$orderby_doppio=$orderby.", $PK ";
		
		$campo_orderby = str_replace(array(" ASC"," DESC"),"",$orderby);
		$operatore_orderby = ereg(' DESC',$orderby) ? " > " : " < ";
		
	
	
		// CASO RISULTATO DI RICERCA-------------------------------------------------------
		// SE c'� l'id in GET prendi calcola a che punto dell'elenco si � arrivati
		if(isset($_GET['id']) && intval($_GET['id'])>0){
	
	
	
			// Prendi il moe del campo orderby ed il vaolre relativo all'id
	
			$sql_calcola_sub = "SELECT s.$campo_orderby 
									FROM $tabella s WHERE s.".$PK."='".$_GET['id']."'";
	
			$sql_calcola = "SELECT count(*) FROM ".$_GET['action']." t
									WHERE t.$campo_orderby $operatore_orderby ($sql_calcola_sub) OR t.$campo_orderby IS NULL";
	
			rpc_debug($sql_calcola);
	
			$query_calcola = vmsql_query($sql_calcola,$link);
	
			list($offset)=vmsql_fetch_row($query_calcola);
	
		}
		else{
			$offset= (int) $_GET['c'];
		}
	
	
		list($tot_records) = vmsql_fetch_row(vmsql_query("SELECT count(*) FROM $tabella",$link));
	
		// OPZIONE PER AVERE I CAMPI ROW
		// i campi row sono quelli non elaborati, in caso contrario mostra i campi richiesti in tabella con le subquery
		if($RAW){
			
			$campi_tabella="*";
			
		}
		else{
			
			$campi_tabella = campi_elaborati($tabella,true);
			$tabella = $tabella . " t ";
		}
		
	} // report basato su tabella
	
	
	
	
	
	
	
	
	
	
	// foglio di stile personalizzato
	if($RS_rules['xsl']!='' && is_file(_PATH_XSL."/".$RS_rules['xsl'])){
		
		$xsl=  (isset($_GET['type']) && $_GET['type']=='XML') ? "" : _PATH_WEB_XSL."/".$RS_rules['xsl'];
	}
	// default
	else{
		
		// caso querybased
		$chiocciola = ($QB) ? "@":"";
		
		$xsl = (isset($_GET['type']) && $_GET['type']=='XML') ? "" : FRONT_DOCROOT."/xml/".$chiocciola.$_GET['action']."/stile.xml";
	}
	
	
	
	// DTD
	$dtd = FRONT_DOCROOT."/xml/dtd/1/".$_GET['action'].".dtd";
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	########################################################################################
	#
	#
	#	GENERAZIONE DELLA PAGINA DI RIEPILOGO
	#
	#
	
	
	if(isset($_GET['riepilogo'])){
		
		
		if($QB){
			
			$test_query_custom = vmsql_try(stripslashes($RS_rules['def_query']),$link);
			
			if($test_query_custom){
			
				$q_conta=vmsql_query(stripslashes($RS_rules['def_query']),$link);
				$titolo_pag = _("Report");
				$n_record=vmsql_num_rows($q_conta);
			}
		}
		else{
			
			$q_conta=vmsql_query("SELECT count(*) FROM $tabella ",$link);
			$titolo_pag= _("Tabella");
			list($n_record)=vmsql_fetch_row($q_conta);
		}
		
		
		
		
		
		
		$tab= preg_replace("'[^a-z0-9_]'i","",$_GET['action']);
		
		
		
		echo openLayout1($titolo_pag." ".$tab);
		
		echo "<h1>$titolo_pag ".$tab."</h1>\n";
		
		echo "<p><b>"._("Tutti i record:")."</b></p>\n";
		
		// se � query based metti una @ davanti al nome
		if($QB) $tab="@".$tab;
		
		echo "<a href=\"".FRONT_DOCROOT."/xml/$tab/all/XML\">XML ($n_record records)</a>\n";
		echo " | <a href=\"".FRONT_DOCROOT."/xml/$tab/all/\">HTML ($n_record records)</a>\n";
		
		
		$q_fo=vmsql_query("SELECT xslfo FROM {$db1['frontend']}.xml_rules WHERE tabella='$tab' ORDER BY lastData DESC",$link);
		
		list($xslfo)=vmsql_fetch_row($q_fo);
		
		if($xslfo!='-1' && _FOP_ENABLED){
			
			echo " | <a href=\"".FRONT_DOCROOT."/xml/$tab/all/PDF\">PDF ($n_record "._("records").")</a>\n";
		}
		else{
			
			// non fa nulla
		}
		
		
		
		echo "<p><b>"._("Viste con paginazione:")."</b></p>\n";
		
		$n_pag=50;
		
		
		echo "<p>Versione XML: ";
		$XML_PAG='';
		for($i=0;$i<ceil($n_record/50);$i++){
			$of=$i*$n_pag;
			$XML_PAG.= " <a href=\"".FRONT_DOCROOT."/xml/$tab/$of,$n_pag/XML\">". ($i+1) ."</a> |";
		}
		echo substr($XML_PAG,0,-2)."</p>\n";
		
		echo "<p>Versione HTML: ";
		$XML_PAG='';
		for($i=0;$i<ceil($n_record/50);$i++){
			$of=$i*$n_pag;
			$XML_PAG.= " <a href=\"".FRONT_DOCROOT."/xml/$tab/$of,$n_pag/\">". ($i+1) ."</a> |";
		}
		echo substr($XML_PAG,0,-2)."</p>\n";
		
		
		/*if($xslfo!='-1' && _FOP_ENABLED){
			echo "<p>Versione PDF: ";
			$XML_PAG='';
			for($i=0;$i<ceil($n_record/50);$i++){
				$of=$i*$n_pag;
				$XML_PAG.= " <a href=\"".FRONT_DOCROOT."/xml/$tab/$of,$n_pag/PDF\">". ($i+1) ."</a> |";
			}
			echo substr($XML_PAG,0,-2)."</p>\n";
		}*/
		
		echo closeLayout1();
		
		exit;
		
	}
	
	
	
	
	
	
	
	
	// GENERA L'XML...
	
	//generazione da query
	if($QB){
		
		$query_test=vmsql_try(stripslashes($RS_rules['def_query']),$link);
		
		if($query_test){
			
			if(preg_match("'([0-9]+),([0-9]+)'",$_GET['c'],$match)>0 && !eregi(" LIMIT",$RS_rules['def_query'])){
				
				$offset=intval($match[1]);
				$limit=intval($match[2]);
				
				$XML = xmlize(stripslashes($RS_rules['def_query'])." ".limit_sintax($limit,$offset),null,true,$offset,0,$xsl);
			}
			else if(is_numeric($_GET['c']) && !eregi(" LIMIT",$RS_rules['def_query'])){
				
				$offset= (int) $_GET['c'];
				
				$XML = xmlize(stripslashes($RS_rules['def_query'])." ".limit_sintax(1,$offset),null,true,$offset,0,$xsl);
			}
			else{
				
				$XML = xmlize(stripslashes($RS_rules['def_query']),null,true,0,0,$xsl);
			}
		}
	}
	
	// SINGOLO RECORD BASATO SULLA SERIE ORDINATA
	else if(is_numeric($_GET['c'])){
		$XML = xmlize("SELECT ".$campi_tabella." FROM $tabella  ORDER BY $orderby_doppio ".limit_sintax(1,$offset),null,true,$offset,$tot_records,$xsl,$dtd);
		
	}
	
	
	// INTERVALLO DI RECORD BASATO SULLA SERIE ORDINATA
	elseif(preg_match("'([0-9]+),([0-9]+)'",$_GET['c'],$match)>0){
		
		$offset=intval($match[1]);
		$limit=intval($match[2]);
		
		$XML = xmlize("SELECT ".$campi_tabella." FROM $tabella ORDER BY $orderby_doppio ".limit_sintax($limit,$offset),null,true,false,$tot_records,$xsl,$dtd);
	}
	
	
	// TUTTI I RECORD 
	elseif($_GET['c']=='all'){
		
		$XML = xmlize("SELECT ".$campi_tabella." FROM $tabella ORDER BY $orderby_doppio ",null,true,false,$tot_records,$xsl);
	}
	
	
	// RECORD PER SINGOLO ID (DA CAMPO PK)		
	elseif($_GET['id']>0){
		$XML = xmlize("SELECT ".$campi_tabella." FROM $tabella WHERE $PK=".intval($_GET['id'])." ORDER BY $orderby_doppio ",null,true,false,$tot_records,$xsl,$dtd);
	}

	
	// TRASFORMAZIONE XSLT - Lato client o lato server?
	
	
	
	if($_GET['type']=='XML'){
		header("Content-Type: text/xml");
		echo $XML;
	}
	else{
		
			
		if($_SESSION['VF_VARS']['server_xslt']=='1'){
			
			require_once("./xslparser.php");
			
			$file_xml=_PATH_TMP."/".md5(serialize($_SESSION)).".xml";
			$file_xsl=_PATH_TMP."/".md5(serialize($_SESSION)).".xsl";
			
			$fp=fopen($file_xml,"w");
			fwrite($fp,$XML);
			fclose($fp);
			
			copy($xsl,$file_xsl);
			
			print xslparser($file_xml,$file_xsl);
			
			unlink($file_xml);
			unlink($file_xsl);
		}
		else {
			header("Content-Type: text/xml");
			echo $XML;
		}
	}
	
		


?>