<?php
/**
 * Questo parser viene utilizzato qualora si imposti la variabile 
 * di trasformazione XSLT lato server come true nelle variabili globali.
 * 
 * @desc Parser XSLT lato server
 * @package VFront
 * @subpackage VFront_XML
 * @author M.Marcello Verona
 * @copyright 2007-2009 M.Marcello Verona
 * @version 0.95 $Id: xslparser.php 302 2009-04-27 10:28:53Z marciuz $
 * @license http://www.gnu.org/licenses/gpl.html GNU Public License 
 */

if (PHP_VERSION >= 5) {

	/**
     * Emula la vecchia funzione di parser XSLT
     *
     * @return XsltProcessor
     */
    function xslt_create() {
        return new XsltProcessor();
    }

    /**
     * Funzione che processa XML e XSL 
     *
     * @desc Parser XSLT
     * @param resource $xsltproc
     * @param unknown_type $xml_arg
     * @param unknown_type $xsl_arg
     * @param unknown_type $xslcontainer
     * @param unknown_type $args
     * @param unknown_type $params
     * @return unknown
     */
    function xslt_process($xsltproc,
                          $xml_arg,
                          $xsl_arg,
                          $xslcontainer = null,
                          $args = null,
                          $params = null) {
        // Start with preparing the arguments
        $xml_arg = str_replace('arg:', '', $xml_arg);
        $xsl_arg = str_replace('arg:', '', $xsl_arg);

        // Create instances of the DomDocument class
        $xml = new DomDocument;
        $xsl = new DomDocument;

        // Load the xml document and the xsl template
        $xml->loadXML($args[$xml_arg]);
        $xsl->loadXML($args[$xsl_arg]);

        // Load the xsl template
        $xsltproc->importStyleSheet($xsl);

        // Set parameters when defined
        if ($params) {
            foreach ($params as $param => $value) {
                $xsltproc->setParameter("", $param, $value);
            }
        }

        // Start the transformation
        $processed = $xsltproc->transformToXML($xml);

        // Put the result in a file when specified
        if ($xslcontainer) {
            return @file_put_contents($xslcontainer, $processed);
        } else {
            return $processed;
        }

    }

    /**
     * Libera le risorse utilizzate dal parser
     *
     * @param resource $xsltproc
     */
    function xslt_free($xsltproc) {
        unset($xsltproc);
    }
}


/**
 * Funzione di parser XSLT. 
 * Richiede l'apertura di file remoti (allor_fopen_url = TRUE )
 * 
 *
 * @param string $file_xml URL del file XML
 * @param string $file_xsl URL del file XSL
 * @return string HTML output
 */
function xslparser($file_xml,$file_xsl){

	$arguments = array(
	    '/_xml' => file_get_contents($file_xml),
	    '/_xsl' => file_get_contents($file_xsl)
	);
	
	$xsltproc = xslt_create();
	$html = xslt_process(
	    $xsltproc,
	    'arg:/_xml',
	    'arg:/_xsl',
	    null,
	    $arguments
	);

	xslt_free($xsltproc);
	
	return $html;

}





?> 