<?php

namespace api\user\controller;

use api\common\service\Apibase;
use think\Db;
use think\Validate;
use cmf\controller\RestBaseController;

class PublicController extends RestBaseController
{
    // 用户注册
    public function register()
    {
        $validate = new Validate([
            'username'          => 'require',
            'password'          => 'require',
            'verification_code' => 'require',
        ]);

        $validate->message([
            'username.require'          => '请输入手机号,邮箱!',
            'password.require'          => '请输入您的密码!',
            'verification_code.require' => '请输入数字验证码!'
        ]);

        $data = $this->request->param();
        if (!$validate->check($data)) {
            $this->error($validate->getError());
        }

        $user = [];

        $findUserWhere = [];

        if (Validate::is($data['username'], 'email')) {
            $user['user_email']          = $data['username'];
            $findUserWhere['user_email'] = $data['username'];
        } else {
            if (cmf_check_mobile($data['username'])) {
                $user['mobile']          = $data['username'];
                $findUserWhere['mobile'] = $data['username'];
            } else {
                $this->error("请输入正确的手机格式!");
            }
        }

        $errMsg = cmf_check_verification_code($data['username'], $data['verification_code']);
        if (!empty($errMsg)) {
            $this->error($errMsg);
        }

        $findUserCount = Db::name("user")->where($findUserWhere)->count();

        if ($findUserCount > 0) {
            $this->error("此账号已存在!");
        }
        $user['avatar'] = 'avatar.png';
        $user['signature'] = "暂无签名";
        $user['user_nickname'] = "用户" . strval(mt_rand(10000, 99999));
        $ip = $this->request->ip(0, true);
        $user['last_login_ip'] = $ip;
        $user['create_time'] = time();
        $user['user_status'] = 1;
        $user['user_type']   = 2;
        $user['user_pass']   = cmf_password($data['password']);


        $app_config = cmf_get_option('app_config');
        if (isset($app_config['close_reg']) && $app_config['close_reg'] == "1") {
            $this->error('已经关闭注册，敬请期待开放O(∩_∩)O');
        }
        if (isset($app_config['must_invite_code']) && $app_config['must_invite_code'] == "1") {
            if (isset($data['invitation_code']) && !empty($data['invitation_code'])) {
                $invitation_code = $data['invitation_code'];
                $parent_user = Db::name("user")->where(['invitation_code' => $invitation_code])->field('id')->find();
                if (empty($parent_user)) {
                    $this->error('请填写正确的邀请码');
                }
            } else {
                $this->error('请填写注册邀请码');
            }
        }


        $result = Db::name("user")->insert($user);

        if (empty($result)) {
            $this->error("注册失败,请重试!");
        }
        //生成邀请码,发放奖励
        $rst = Db::name('user')->getLastInsID();

        $new['invitation_code'] = Apibase::getRandomStr(6);

        if (isset($data['invitation_code']) && !empty($data['invitation_code'])) { //注册时填写邀请码，查询邀请码用户
            $invitation_code = $data['invitation_code'];
            $parent_user = Db::name("user")->where(['invitation_code' => $invitation_code])->field('id,user_login,user_status,parent_user_id,parent_tree')->find();
            if (!empty($parent_user)) {
                $parent_uid = $parent_user['id'];
                if (empty($parent_user['parent_tree'])) {
                    $parent_tree = $parent_uid;
                } else {
                    $parent_tree = $parent_uid . '|' . $parent_user['parent_tree'];
                }
                Db::name("user")->where(['id' => $parent_uid])->setInc('invitation_count');
                $new['parent_user_id'] = $parent_uid;
                $new['parent_tree'] = $parent_tree;
                Apibase::addActionLog($parent_uid, $rst, 'invite_user_reg');
            }
        }
        Apibase::addActionLog($rst, "", 'newbie_reg');
        Db::name("user")->where(['id' => $rst])->update($new);
        if (isset($parent_tree) && !empty($parent_tree)) {
            Apibase::invite_reward($rst, $parent_tree, 'reg');
        }
        //注册后钩子
        $param  = ['uid' => $rst];
        $result = hook_one("after_register", $param);
        if ($result !== false && !empty($result['error'])) {
            $this->success("注册并激活成功,请登录!!");
        }

        if ($result === false) {
            $this->success("注册并激活成功,请登录!!!");
        }
        $this->success("注册并激活成功,请登录!");
    }

    // 用户验证码注册 适用于红包场景
    public function vcode_login()
    {
        $validate = new Validate([
            'username'          => 'require',
            'verification_code' => 'require'
        ]);

        $validate->message([
            'username.require'          => '请输入手机号!',
            'verification_code.require' => '请输入数字验证码!'
        ]);

        $data = $this->request->param();
        if (!$validate->check($data)) {
            $this->error($validate->getError());
        }

        $user = [];

        $findUserWhere = [];

        if (Validate::is($data['username'], 'email')) {
            $user['user_email']          = $data['username'];
            $findUserWhere['user_email'] = $data['username'];
        } else if (cmf_check_mobile($data['username'])) {
            $user['mobile']          = $data['username'];
            $findUserWhere['mobile'] = $data['username'];
        } else {
            $this->error("请输入正确的手机或者邮箱格式!");
        }

        $errMsg = cmf_check_verification_code($data['username'], $data['verification_code']);
        if (!empty($errMsg)) {
            $this->error($errMsg);
        }

        $findUserCount = Db::name("user")->where($findUserWhere)->count();

        if ($findUserCount > 0) {

            //登录开始
            $findUser = Db::name("user")->field("id")->where($findUserWhere)->find();
            $device_type = "web";
            $userTokenQuery = Db::name("user_token")
                ->where('user_id', $findUser['id'])
                ->where('device_type', $device_type);
            $findUserToken  = $userTokenQuery->find();
            $currentTime    = time();
            $expireTime     = $currentTime + 24 * 3600 * 180;
            $token          = md5(uniqid()) . md5(uniqid());
            if (empty($findUserToken)) {
                $result = $userTokenQuery->insert([
                    'token'       => $token,
                    'user_id'     => $findUser['id'],
                    'expire_time' => $expireTime,
                    'create_time' => $currentTime,
                    'device_type' => $device_type
                ]);
            } else {
                $result = $userTokenQuery
                    ->where('user_id', $findUser['id'])
                    ->where('device_type', $device_type)
                    ->update([
                        'token'       => $token,
                        'expire_time' => $expireTime,
                        'create_time' => $currentTime
                    ]);
            }
            if (empty($result)) {
                $this->error("登录失败!");
            }
            //$update = ['last_login_time'=>time()];
            //Db::name("user")->where(['id'=>$findUser['id']])->update($update);
            $this->success("登录成功!", ['token' => $token, 'device_type' =>  $device_type]);
            //登录结束
        } else {
            $site_info = cmf_get_option('site_info');
            $app_name = $site_info['site_name'];
            $this->error("请先注册成为" . $app_name . "会员,才能继续哦！");
        }

        $password = strval(mt_rand(100000, 999999));
        $user['create_time'] = time();
        $user['user_status'] = 1;
        $user['user_type']   = 2;
        $user['user_pass']   = cmf_password($password);

        $result = Db::name("user")->insert($user);


        if (empty($result)) {
            $this->error("注册失败,请重试!");
        }
        //生成邀请码,发放奖励
        $rst = Db::name('user')->getLastInsID();
        $new['invitation_code'] = Apibase::createCode($rst);
        if (isset($data['invitation_code']) && !empty($data['invitation_code'])) { //注册时填写邀请码，查询邀请码用户
            $invitation_code = $data['invitation_code'];
            $parent_user = Db::name("user")->where(['invitation_code' => $invitation_code])->field('id,user_login,user_status,parent_user_id,parent_tree')->find();
            if (!empty($parent_user)) {
                $parent_uid = $parent_user['id'];
                if (empty($parent_user['parent_tree'])) {
                    $parent_tree = $parent_uid;
                } else {
                    $parent_tree = $parent_uid . '|' . $parent_user['parent_tree'];
                }
                Db::name("user")->where(['id' => $parent_uid])->setInc('invitation_count');
                $new['parent_user_id'] = $parent_uid;
                $new['parent_tree'] = $parent_tree;
            }
        }
        Db::name("user")->where(['id' => $rst])->update($new);
        if (isset($parent_tree) && !empty($parent_tree)) {
            Apibase::invite_reward($rst, $parent_tree, 'reg');
        }
        //写入task任务
        $p['uid'] = $rst;
        $p['username'] = $data['username'];
        $p['password'] = $password;
        $task_data['params'] = json_encode($p);
        $task_data['task_name'] = "sms_send_pass";
        $task_data['uid'] = 0;
        $task_data['schedule_time'] = time();
        Db::name('cron')->insert($task_data);
        //注册后钩子
        $param  = ['uid' => $rst];
        $result = hook_one("after_register", $param);
        //token
        $device_type = "web";
        $userTokenQuery = Db::name("user_token")
            ->where('user_id', $rst)
            ->where('device_type', $device_type);
        $findUserToken  = $userTokenQuery->find();
        $currentTime    = time();
        $expireTime     = $currentTime + 24 * 3600 * 180;
        $token          = md5(uniqid()) . md5(uniqid());
        if (empty($findUserToken)) {
            $result = $userTokenQuery->insert([
                'token'       => $token,
                'user_id'     => $rst,
                'expire_time' => $expireTime,
                'create_time' => $currentTime,
                'device_type' => $device_type
            ]);
        } else {
            $result = $userTokenQuery
                ->where('user_id', $rst)
                ->where('device_type', $device_type)
                ->update([
                    'token'       => $token,
                    'expire_time' => $expireTime,
                    'create_time' => $currentTime
                ]);
        }
        if (empty($result)) {
            $this->error("登录失败!");
        }
        $this->success("新用户登录成功!", ['token' => $token, 'device_type' =>  $device_type]);
    }

    // 用户登录 TODO 增加最后登录信息记录,如 ip
    public function login()
    {
        $validate = new Validate([
            'username' => 'require',
            'password' => 'require'
        ]);
        $validate->message([
            'username.require' => '请输入手机号,邮箱或用户名!',
            'password.require' => '请输入您的密码!'
        ]);

        $data = $this->request->param();
        if (!$validate->check($data)) {
            $this->error($validate->getError());
        }

        $findUserWhere = [];

        if (Validate::is($data['username'], 'email')) {
            $findUserWhere['user_email'] = $data['username'];
        } else if (cmf_check_mobile($data['username'])) {
            $findUserWhere['mobile'] = $data['username'];
        } else {
            $findUserWhere['user_login'] = $data['username'];
        }
        $fieldStr = 'id,mobile,user_email,user_nickname,avatar,signature,user_pass,score,balance,user_status,create_time,invitation_code,has_paypwd,auth_id,is_google_check,last_login_time,last_login_ip,level_id,is_partner,vip_deadline';
        $findUser = Db::name("user")->field($fieldStr)->where($findUserWhere)->find();

        if (empty($findUser)) {
            $this->error("用户不存在!");
        } else {

            switch ($findUser['user_status']) {
                case 0:
                    $this->error('您已被拉黑!');
                case 2:
                    $this->error('账户还没有验证成功!');
            }

            if (!cmf_compare_password($data['password'], $findUser['user_pass'])) {
                $this->error("密码不正确!");
            }
            unset($findUser['user_pass']);
        }

        $allowedDeviceTypes = $this->allowedDeviceTypes;

        if (empty($data['device_type']) || !in_array($data['device_type'], $allowedDeviceTypes)) {
            $this->error("请求错误,未知设备!");
        }

        $userTokenQuery = Db::name("user_token")
            ->where('user_id', $findUser['id'])
            ->where('device_type', $data['device_type']);
        $findUserToken  = $userTokenQuery->find();
        $currentTime    = time();
        $expireTime     = $currentTime + 24 * 3600 * 180;
        $token          = md5(uniqid()) . md5(uniqid());
        if (empty($findUserToken)) {
            $result = $userTokenQuery->insert([
                'token'       => $token,
                'user_id'     => $findUser['id'],
                'expire_time' => $expireTime,
                'create_time' => $currentTime,
                'device_type' => $data['device_type']
            ]);
        } else {
            $result = $userTokenQuery
                ->where('user_id', $findUser['id'])
                ->where('device_type', $data['device_type'])
                ->update([
                    'token'       => $token,
                    'expire_time' => $expireTime,
                    'create_time' => $currentTime
                ]);
        }


        if (empty($result)) {
            $this->error("登录失败!");
        }
        $ip = $this->request->ip(0, true);
        $update = ['last_login_time' => time(), 'last_login_ip' => $ip];
        Db::name("user")->where(['id' => $findUser['id']])->update($update);
        //$findUser['invitation_url'] = Apibase::sp_get_host(). '/#/register?code='.$findUser['invitation_code'];
        $findUser['invitation_url'] = Apibase::sp_get_host() . '/portal/index/invite?invitation_code=' . $findUser['invitation_code'];

        $findUser['avatar'] = cmf_get_image_preview_url($findUser['avatar']);
        $this->success("登录成功!", ['token' => $token, 'user' => $findUser]);
    }

    // 用户退出
    public function logout()
    {
        $userId = $this->getUserId();
        Db::name('user_token')->where([
            'token'       => $this->token,
            'user_id'     => $userId,
            'device_type' => $this->deviceType
        ])->update(['token' => '']);

        $this->success("退出成功!");
    }

    // 用户密码重置
    public function passwordReset()
    {
        $validate = new Validate([
            'username'          => 'require',
            'password'          => 'require',
            'verification_code' => 'require'
        ]);

        $validate->message([
            'username.require'          => '请输入手机号,邮箱!',
            'password.require'          => '请输入您的密码!',
            'verification_code.require' => '请输入数字验证码!'
        ]);

        $data = $this->request->param();
        if (!$validate->check($data)) {
            $this->error($validate->getError());
        }

        $userWhere = [];
        if (Validate::is($data['username'], 'email')) {
            $userWhere['user_email'] = $data['username'];
        } else if (cmf_check_mobile($data['username'])) {
            $userWhere['mobile'] = $data['username'];
        } else {
            $this->error("请输入正确的手机或者邮箱格式!");
        }

        $errMsg = cmf_check_verification_code($data['username'], $data['verification_code']);
        if (!empty($errMsg)) {
            $this->error($errMsg);
        }

        $userPass = cmf_password($data['password']);
        Db::name("user")->where($userWhere)->update(['user_pass' => $userPass]);

        $this->success("密码重置成功,请使用新密码登录!");
    }
}
