/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.common.code.webflash.plugin.ui;

import cn.enilu.common.code.webflash.plugin.utils.GenerateConfig;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.VerticalBox;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ConfigDialog
extends DialogWrapper {
    private JBCheckBox controllerCheckBox;
    private JBCheckBox serviceCheckBox;
    private JBCheckBox repositoryCheckBox;
    private JBCheckBox viewCheckBox;
    private JBCheckBox forceCheckBox;
    private JBLabel baseUriLabel;
    private JBLabel basePackageLabel;
    private JBTextField baseUriTextField;
    private JBTextField basePackageTextField;
    private JBLabel modPackageLabel;
    private JBLabel serPackageLabel;
    private JBLabel ctrPackageLabel;
    private JBLabel repoPackageLabel;
    private JBTextField modPackageTextField;
    private JBTextField serPackageTextField;
    private JBTextField ctrPackageTextField;
    private JBTextField repoPackageTextField;
    private final PsiClass mClass;
    private final String basePackage;
    private final String baseUri;
    private final String modelPackageName;

    public ConfigDialog(PsiClass psiClass) {
        super(psiClass.getProject());
        String[] arr = psiClass.getQualifiedName().split("\\.");
        String modelName = psiClass.getName();
        this.basePackage = psiClass.getQualifiedName().replace("." + arr[arr.length - 4] + "." + arr[arr.length - 3] + "." + arr[arr.length - 2] + "." + arr[arr.length - 1], "");
        this.modelPackageName = arr[arr.length - 2];
        this.baseUri = "/" + arr[arr.length - 2];
        this.mClass = psiClass;
        this.setupViews(modelName);
        this.init();
    }

    private void setupViews(String modelName) {
        this.setTitle("Generate Model:" + modelName);
        this.controllerCheckBox = new JBCheckBox("controller", true);
        this.serviceCheckBox = new JBCheckBox("service", true);
        this.viewCheckBox = new JBCheckBox("views", true);
        this.repositoryCheckBox = new JBCheckBox("repository", true);
        this.forceCheckBox = new JBCheckBox("replace", false);
        this.baseUriTextField = new JBTextField(this.baseUri);
        this.basePackageTextField = new JBTextField(this.basePackage);
        this.baseUriLabel = new JBLabel("baseUri:");
        this.basePackageLabel = new JBLabel("base Package:");
        this.modPackageLabel = new JBLabel("entities Package:");
        this.serPackageLabel = new JBLabel("services Package:");
        this.ctrPackageLabel = new JBLabel("controllers Package:");
        this.repoPackageLabel = new JBLabel("repositories Package:");
        this.modPackageTextField = new JBTextField("bean.entity." + this.modelPackageName);
        this.serPackageTextField = new JBTextField("service." + this.modelPackageName);
        this.ctrPackageTextField = new JBTextField("api.controller." + this.modelPackageName);
        this.repoPackageTextField = new JBTextField("dao." + this.modelPackageName);
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        if (null == southPanel) {
            return null;
        }
        VerticalBox root = new VerticalBox();
        root.add((Component)this.baseUriLabel);
        root.add((Component)this.baseUriTextField);
        root.add((Component)this.basePackageLabel);
        root.add((Component)this.basePackageTextField);
        root.add((Component)this.modPackageLabel);
        root.add((Component)this.modPackageTextField);
        root.add((Component)this.serPackageLabel);
        root.add((Component)this.serPackageTextField);
        root.add((Component)this.ctrPackageLabel);
        root.add((Component)this.ctrPackageTextField);
        root.add((Component)this.repoPackageLabel);
        root.add((Component)this.repoPackageTextField);
        root.add((Component)this.forceCheckBox);
        root.add((Component)southPanel);
        return root;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createContentPane();
        VerticalBox verticalBox = new VerticalBox();
        HorizontalBox horizontalBox1 = new HorizontalBox();
        horizontalBox1.add((Component)this.controllerCheckBox);
        horizontalBox1.add((Component)this.serviceCheckBox);
        horizontalBox1.add((Component)this.viewCheckBox);
        horizontalBox1.add((Component)this.repositoryCheckBox);
        verticalBox.add((Component)horizontalBox1);
        centerPanel.add((Component)verticalBox);
        return centerPanel;
    }

    public GenerateConfig getGenerateConfig() {
        GenerateConfig config = new GenerateConfig();
        config.setBasePackage(this.basePackageTextField.getText().trim());
        config.setBaseUri(this.baseUriTextField.getText().trim());
        config.setConroller(this.controllerCheckBox.isSelected());
        config.setService(this.serviceCheckBox.isSelected());
        config.setView(this.viewCheckBox.isSelected());
        config.setForce(this.forceCheckBox.isSelected());
        config.setRepository(this.repositoryCheckBox.isSelected());
        config.setModelPakName(this.modPackageTextField.getText().trim());
        config.setServicePakName(this.serPackageTextField.getText().trim());
        config.setControllerPakName(this.ctrPackageTextField.getText().trim());
        config.setRepoPakName(this.repoPackageTextField.getText().trim());
        return config;
    }
}

