<?php

namespace framework;

use framework\session\Session;
use shangfan\model\base\ShopUser;
use shangfan\model\base\MemberUser;
use shangfan\model\base\SystemAdminUser;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Auth
 */
class Auth {

    /**
     * create
     * @param type $auth memeber|admin|shop
     * @return type
     */
    public static function refresh($key, $auth) {
        return Session::set('auth.' . $key, $auth);
    }

    /**
     * member
     * @return type
     */
    public static function member() {
        $auth = (array) Session::get('auth.member');
        if (is_array($auth) && count($auth)) {
            return new MemberUser($auth);
        }
        return null;
    }

    /**
     * memberH5
     * @return type
     */
    public static function memberH5() {
        $auth = (array) Session::get('auth.member.h5');
        if (is_array($auth) && count($auth)) {
            return new MemberUser($auth);
        }
        return null;
    }

    /**
     * admin
     * @return type
     */
    public static function admin() {
        $auth = (array) Session::get('auth.admin');
        if (is_array($auth) && count($auth)) {
            return new SystemAdminUser($auth);
        }
        return null;
    }

    /**
     * merchant
     * @return type
     */
    public static function merchant() {
        $auth = (array) Session::get('auth.merchant');
        if (is_array($auth) && count($auth)) {
            return new ShopUser($auth);
        }
        return null;
    }

    /**
     * hasLogin
     * @param type $key
     * @return type
     */
    public static function hasLogin($key = 'member') {
        return Session::get('auth.' . $key) ? true : false;
    }

    /**
     * remove
     * @param type $key
     * @return type
     */
    public static function remove($key) {
        return Session::remove('auth.' . $key);
    }

}
