<?php

namespace framework;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Header
 */
class Header {

    /**
     * headerJson
     */
    public static function headerJson() {
        header('Content-type: application/json');
    }

    /**
     * accessControl
     */
    public function accessControl() {
        header('Access-Control-Allow-Origin:*');
    }

    /**
     * headerUtf8
     */
    public static function headerUtf8() {
        header("Content-type: text/html; charset=utf-8");
    }

    /**
     * header500
     * @return type
     */
    public static function header500() {
        Header::headerUtf8();
        return View::framework('header500');
    }

    /**
     * header403
     * @return type
     */
    public static function header404() {
        Header::headerUtf8();
        return View::framework('header404');
    }

    /**
     * header403
     * @return type
     */
    public static function header403() {
        return View::output('<h1>Forbidden 403</h1>');
    }

}
