<?php

namespace framework;

use framework\database\Database;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Model
 */
class Model {

    public $table;
    public $key;
    public $attributeChange = true;
    public $attribute;

    /**
     * __construct
     * @param type $param
     */
    public function __construct($param = array()) {
        $this->attribute = new \stdClass();
        if (count($param)) {
            foreach ($param as $key => $val) {
                $this->attribute->$key = $val;
            }
        }
    }

    /**
     * fill
     * @return type
     */
    public function fill($array = array()) {
        $this->attributeChange = false;
        foreach ($array as $key => $val) {
            if ($this->attribute->$key != $val) {
                $this->attributeChange = true;
            }
            $this->attribute->$key = $val;
        }
        return $this;
    }

    /**
     * save
     * @return type
     */
    public function save($debug = false) {
        if (!$this->attributeChange) {
            return true;
        }
        $key = $this->key;
        if (!isset($this->attribute->$key) || !$this->attribute->$key) {
            throw new Exception('\framework\Model错误： save对象key值非真');
        }
        $set = [];
        foreach ($this->attribute as $key_ => $val_) {
            if ($key_ == $this->key) {
                continue;
            }
            if ($val_ === '' || $val_ === null) {
                continue;
            }
            $set[] = '`' . $key_ . '`' . '=\'' . addslashes($val_) . '\'';
        }
        if (!count($set)) {
            throw new Exception('\framework\Model错误： set属性为空');
        }
        $affectedRows = static::update("update {$this->table} set " . implode($set, ',') . " where {$this->key} = '{$this->attribute->$key}';", $debug);
        return $affectedRows ? true : false;
    }

    /**
     * update
     * @param type $sql
     * @param type $debug
     * @return type
     * @throws Exception
     */
    public static function update($sql, $debug = false) {
        $instance = static::db();
        if (!$instance) {
            throw new Exception('\framework\Model错误： 获取instance实例失败');
        }
        return $instance->update($sql, $debug);
    }

    /**
     * saveConnection
     * @param type $connectConf
     * @param type $create
     * @param type $debug
     * @return type
     * @throws Exception
     */
    public function saveConnection($connectConf = array(), $create = false, $debug = false) {
        $instance = static::connection($connectConf, $create);
        $key = $this->key;
        if (!isset($this->attribute->$key) || !$this->attribute->$key) {
            throw new Exception('\framework\Model错误： save对象key值非真');
        }
        $set = [];
        foreach ($this->attribute as $key_ => $val_) {
            if ($key_ == $this->key) {
                continue;
            }
            $set[] = '`' . $key_ . '`' . '=\'' . addslashes($val_) . '\'';
        }
        if (!count($set)) {
            throw new Exception('\framework\Model错误： set属性为空');
        }
        return $instance->update("update {$this->table} set " . implode($set, ',') . " where {$this->key} = '{$this->attribute->$key}';", $debug);
    }

    /**
     * delete
     * @param type $debug
     * @return type
     */
    public function delete($debug = false) {
        $instance = static::db();
        if (!$instance) {
            throw new Exception('\framework\Model错误： 获取instance实例失败');
        }
        $key = $this->key;
        if (!isset($this->attribute->$key) || !$this->attribute->$key) {
            throw new Exception('\framework\Model错误： save对象key值非真，对象可能为null');
        }
        if (!isset($this->table) || !$this->table) {
            throw new Exception('\framework\Database错误：delete需指定映射table');
        }
        if (!isset($this->key) || !$this->key) {
            throw new Exception('\framework\Database错误：delete需指定映射key');
        }
        return static::update("delete from {$this->table} where {$this->key} = '{$this->attribute->$key}';", $debug);
    }

    /**
     * insert
     * @param type $insert
     * @param type $debug
     * @return type
     * @throws Exception
     */
    public static function insert($insert = [], $debug = false) {
        $instance = static::db();
        if (!$instance) {
            throw new Exception('\framework\Model错误： 获取instance实例失败');
        }
        return $instance->insert($insert, $debug);
    }

    /**
     * db
     * @return type
     */
    public static function db() {
        ini_set("magic_quotes_sybase", 0);
        ini_set("magic_quotes_runtime", 0);
        $modelClass = get_called_class();
        if ($modelClass == get_class()) {
            throw new Exception('\framework\Model错误： 获取Model实例失败');
        }
        return Database::getInstance(array('modelClass' => $modelClass));
    }

    /**
     * get
     * @param type $sql
     * @return type
     * @throws Exception
     */
    public static function all($sql = '', $debug = false) {
        $instance = static::db();
        if (!$instance) {
            throw new Exception('\framework\Model错误： 获取instance实例失败');
        }
        return $instance->get($sql, true, $debug);
    }

    /**
     * get
     * @param type $sql
     * @return type
     * @throws Exception
     */
    public static function get($sql = '', $debug = false) {
        $instance = static::db();
        if (!$instance) {
            throw new Exception('\framework\Model错误： 获取instance实例失败');
        }
        return $instance->get($sql, false, $debug);
    }

    /**
     * one
     * @param type $sql
     * @return type
     * @throws Exception
     */
    public static function one($sql = '', $debug = false) {
        $first = static::first($sql, $debug);
        if (!$first) {
            return $first;
        }
        return (array) $first->attribute;
    }

    /**
     * first
     * @param type $sql
     * @return type
     * @throws Exception
     */
    public static function first($sql = '', $debug = false) {
        $instance = static::db();
        if (!$instance) {
            throw new Exception('\framework\Model错误： 获取instance实例失败');
        }
        return $instance->first($sql, $debug);
    }

    /**
     * connection
     * @param type $confArray
     * @return type
     */
    public static function connection($connectConf = array(), $create = false) {
        ini_set("magic_quotes_sybase", 0);
        ini_set("magic_quotes_runtime", 0);
        $modelClass = get_called_class();
        if ($modelClass == get_class()) {
            throw new Exception('\framework\Model错误： 获取Model实例失败');
        }
        $connectConf = array_merge($connectConf, array('modelClass' => $modelClass));
        return Database::getInstance($connectConf, $create);
    }

    /**
     * attributeArray
     * @return type
     */
    public function attributeArray() {
        return (array) $this->attribute;
    }

    /**
     * __set
     * @param type $attriName
     * @param type $attrivalue
     */
    public function __set($attriName, $attrivalue) {
        $this->attribute->$attriName = $attrivalue;
    }

    /**
     * __get
     * @param type $attriName
     * @return type
     */
    public function __get($attriName) {
        if (!isset($this->attribute->$attriName)) {
            $this->__set($attriName, null);
        }
        return $this->attribute->$attriName;
    }

    /**
     * count
     * @param type $sql
     * @param type $debug
     * @return int
     * @throws Exception
     */
    public static function count($sql, $debug = false) {
        if (strpos($sql, 'as count') === false) {
            throw new Exception('\framework\Model错误： 缺少as count，请使用first/one方法');
        }
        $one = static::first($sql, $debug);
        if (!$one) {
            return 0;
        }
        return $one->count;
    }

}
