<?php

namespace framework\config;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Config
 */
class Config {

    public static $require = array();

    /**
     * make
     * @param type $path
     * @param type $default
     * @param type $system
     * @return string
     */
    public static function make($path, $default = null, $system = false) {
        $keyArr = explode('.', $path);
        if (!key_exists($path, static::$require)) {
            if (count($keyArr) > 0) {
                if ($system == true) {
                    static::$require[$path] = require rootPath() . '/' . $keyArr[0] . '.php';
                } else {
                    static::$require[$path] = require rootPath() . '/shangfan/config/' . $keyArr[0] . '.php';
                }
            } else {
                static::$require[$path] = array();
            }
        }
        $result = static::iterationArray($keyArr, static::$require[$path]);
        return $result ? $result : $default;
    }

    /**
     * iterationArray
     * @param type $keyArr
     * @param type $search
     * @return type
     */
    public static function iterationArray($keyArr, $search = array()) {
        array_shift($keyArr);
        if (!count($keyArr)) {
            return $search;
        }
        $key = current($keyArr);
        if (!is_array($search) || !key_exists($key, $search)) {
            return $search;
        }
        return static::iterationArray($keyArr, $search[$key]);
    }

    /**
     * makeStorageConf
     * @param type $key
     * @param type $value
     * @return type
     */
    public static function setStorageConf($key, $value) {
        $storageConfDir = rootPath() . '/storage/conf';
        if (!is_dir($storageConfDir)) {
            mkdir($storageConfDir, 0777);
        }
        $storageConfFile = $storageConfDir . '/' . $key;
        if (!file_exists($storageConfFile)) {
            touch($storageConfFile);
        }
        return file_put_contents($storageConfFile, serialize($value));
    }

    /**
     * getStorageConf
     * @param type $key
     * @param type $default
     * @return type
     */
    public static function getStorageConf($key, $default = null) {
        $storageConfDir = rootPath() . '/storage/conf';
        if (!is_dir($storageConfDir)) {
            return $default;
        }
        $storageConfFile = $storageConfDir . '/' . $key;
        if (!file_exists($storageConfFile)) {
            return $default;
        }
        $fileContent = file_get_contents($storageConfFile);
        if (!$fileContent) {
            return $default;
        }
        return unserialize($fileContent);
    }

}
