<?php

namespace framework\config;

use framework\Exception;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * SystemConfig
 * template.dir.web
 * template.dir.h5
 */
class SystemConfig extends \framework\Model {

    public $table = 'shangfan_system_config';
    public $key = 'id';
    public static $_config = [];

    /**
     * createConfig
     * @param type $key
     * @param type $value
     * @return type
     */
    public static function createConfig($key, $value = '') {
        $success = SystemConfig::insert([
                    'conf_key' => $key,
                    'conf_value' => $value,
                    'create_time' => time()
        ]);
        if (!$success) {
            return null;
        }
        return SystemConfig::get($key);
    }

    /**
     * updateConfig
     * @param type $key
     * @param type $value
     * @return type
     * @throws Exception
     */
    public static function updateConfig($key, $value = '') {
        $detail = SystemConfig::get($key);
        if (!$detail) {
            throw new Exception("framework\config\SystemConfig::update错误：未查询到detail");
        }
        $detail->conf_value = $value;
        $detail->update_time = time();
        return $detail->save();
    }

    /**
     * get
     * @param type $key
     * @return type
     */
    public static function get($key) {
        if (!array_key_exists($key, static::$_config)) {
            $detail = SystemConfig::first("select * from {table} where conf_key='{$key}';");
            if (!$detail) {
                return static::createConfig($key, '');
            }
            static::$_config[$key] = $detail;
        }
        return static::$_config[$key];
    }

}
