<?php

namespace framework\file;

use framework\Exception;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * File
 */
class File {
    
    /**
     * write
     * @param type $filepath
     * @param type $log
     * @return type
     */
    public static function write($filepath, $log){
        return file_put_contents($filepath, $log, FILE_APPEND);
    }

    /**
     * make
     * @param type $dir
     * @return boolean
     */
    public static function makeDirectory($dir) {
        $logDir = rootPath() . $dir;
        if (!is_dir($logDir)) {
            try {
                $success = mkdir($logDir, 0755, true);
                if (!$success) {
                    throw new Exception('无法创建paylog目录，请检查目录权限');
                }
            } catch (Exception $ex) {
                return statusFailure($ex->getMessage());
            }
        }
        return statusSuccess();
    }
    
    /**
     * makeTouch
     * @param type $filepath
     * @return type
     * @throws Exception
     */
    public static function makeTouch($filepath){
        $logDir = rootPath() . $filepath;
        if (!is_dir($logDir)) {
            try {
                $success = touch($logDir);
                if (!$success) {
                    throw new Exception('无法创建paylog文件，请检查目录权限');
                }
            } catch (Exception $ex) {
                return statusFailure($ex->getMessage());
            }
        }
        return statusSuccess();
    }

    /**
     * writeStorageLog
     * @param type $message
     * @return type
     */
    public static function writeStorageLog($message) {
        $logDir = rootPath() . '/storage/log';
        if (!is_dir($logDir)) {
            mkdir($logDir, 0755, true);
        }
        $logPath = $logDir . '/' . date('Ymd') . '.log';
        if (!file_exists($logPath)) {
            touch($logPath);
        }
        return File::write($logPath, $message);
    }

    /**
     * writeFileCache
     * @param type $key
     * @param type $data
     * @return type
     */
    public static function writeFileCache($key, $data) {
        $logDir = rootPath() . '/storage/cache';
        if (!is_dir($logDir)) {
            mkdir($logDir, 0755, true);
        }
        $cachePath = $logDir . '/' . $key . '.cache';
        if (!file_exists($cachePath)) {
            touch($cachePath);
        }
        return file_put_contents($cachePath, $data);
    }

    /**
     * readFileCache
     * @param type $key
     * @return type
     */
    public static function readFileCache($key) {
        $cachePath = rootPath() . '/storage/cache/' . $key . '.cache';
        if (!file_exists($cachePath)) {
            return serialize([]);
        }
        return file_get_contents($cachePath);
    }

}
