<?php

namespace framework\file;

use framework\Thumb;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Upload
 */
class Upload {

    /**
     * getUploadPicDir
     * @param type $type
     * @param type $date
     * @return string
     */
    public static function getUploadPicDir($type, $date) {
        $uploadPicDir = rootPath() . "/public/upload/{$type}/{$date}";
        if (!is_dir($uploadPicDir)) {
            mkdir($uploadPicDir, 0777, true);
        }
        return $uploadPicDir;
    }

    /**
     * getTempName
     * @return type
     */
    public static function getTempName() {
        return $_FILES['file']['tmp_name'];
    }

    /**
     * getPathinfo
     * @return type
     */
    public static function getPathinfo() {
        return pathinfo($_FILES['file']['name']);
    }

    /**
     * getExtension
     * @return type
     */
    public static function getExtension() {
        $pathinfo = Upload::getPathinfo();
        return $pathinfo['extension'];
    }

    /**
     * checkExtension
     * @return boolean
     */
    public static function checkExtension() {
        $pathinfo = Upload::getPathinfo();
        if (!in_array($pathinfo['extension'], ['jpg', 'jpeg', 'gif', 'png'])) {
            return false;
        }
        return true;
    }

    /**
     * moveUploadedFile
     * @param type $uploadPicDir
     * @param type $uploadFilePath
     * @return type
     */
    public static function moveUploadedFile($uploadPicDir, $uploadFilePath) {
        $uploadRealPath = Upload::getUploadRealPath($uploadPicDir, $uploadFilePath);
        return move_uploaded_file(Upload::getTempName(), $uploadRealPath);
    }

    /**
     * createThumb
     * @param type $uploadPicDir
     * @param type $uploadFilePath
     * @return type
     */
    public static function createThumbGoods300x400($uploadPicDir, $uploadFilePath) {
        $thumb = new Thumb();
        $thumb->set_config([
            'type' => 'fit',
            'width' => 400,
            'height' => 400,
            'bgcolor' => '#fff'
        ]);
        return $thumb->create_thumb(Upload::getUploadRealPath($uploadPicDir, $uploadFilePath), Upload::getUploadRealThumbPath($uploadPicDir, $uploadFilePath));
    }

    /**
     * getUploadFilePath
     * @return type
     */
    public static function getUploadFilePath() {
        $extension = Upload::getExtension();
        return '/' . time() . '_' . rand(100, 999) . '.' . $extension;
    }

    /**
     * getUploadRealPath
     * @param type $uploadPicDir
     * @param type $uploadFilePath
     * @return type
     */
    public static function getUploadRealPath($uploadPicDir, $uploadFilePath) {
        return $uploadPicDir . $uploadFilePath;
    }

    /**
     * getUploadRealThumbPath
     * @param type $uploadPicDir
     * @param type $uploadFilePath
     * @return type
     */
    public static function getUploadRealThumbPath($uploadPicDir, $uploadFilePath) {
        $uploadRealPath = Upload::getUploadRealPath($uploadPicDir, $uploadFilePath);
        $extension = Upload::getExtension();
        return str_replace(".{$extension}", "_thumb.{$extension}", $uploadRealPath);
    }

    /**
     * getUploadHttpPath
     * @param type $type
     * @param type $date
     * @param type $uploadFilePath
     * @return type
     */
    public static function getUploadHttpPath($type, $date, $uploadFilePath) {
        return "/public/upload/{$type}/{$date}{$uploadFilePath}";
    }

    /**
     * getUploadHttpThumbPath
     * @param type $type
     * @param type $date
     * @param type $uploadFilePath
     * @return type
     */
    public static function getUploadHttpThumbPath($type, $date, $uploadFilePath) {
        $uploadFilePath = str_replace(".", "_thumb.", $uploadFilePath);
        return "/public/upload/{$type}/{$date}{$uploadFilePath}";
    }

}
