<?php

namespace framework\pay;

use framework\Exception;
use framework\Request;

/**
 * Pay
 */
class Pay {

    public $channel;
    public $chanelDriver;

    /**
     * __construct
     * @param type $conf 
     * channel blance零钱支付 wechat微信支付 alipay支付宝支付
     */
    public function __construct($conf = array()) {
        if (!array_key_exists('channel', $conf)) {
            throw new Exception('缺少通道参数');
        }
        $this->channel = $conf['channel'];
        switch ($this->channel) {
            case 'balance':
                $this->chanelDriver = '\framework\pay\balance\Balance';
                break;
            case 'wechat':
                $this->chanelDriver = '\framework\pay\wechat\WxPay';
                break;
            case 'alipay':
                $this->chanelDriver = '\framework\pay\alipay';
                break;
            default :
                throw new Exception('不支持的通道，请检查');
        }
    }

    /**
     * 二维码
     */
    public function qrcode($conf) {
        $channel = new $this->chanelDriver();
        if (!$channel) {
            throw new Exception('不存在的通道');
        }
        return $channel->qrcode($conf);
    }

    /**
     * 回调
     * @return type
     * @throws Exception
     */
    public function notify(Request $request) {
        $channel = new $this->chanelDriver();
        if (!$channel) {
            throw new Exception('不存在的通道');
        }
        return $channel->notify($request);
    }

    /**
     * 订单查询
     * @return type
     * @throws Exception
     */
    public function orderQuery($orderNumberStr) {
        $channel = new $this->chanelDriver();
        if (!$channel) {
            throw new Exception('不存在的通道');
        }
        return $channel->orderQuery($orderNumberStr);
    }

    /**
     * 余额支付
     * @return type
     * @throws Exception
     */
    public function pay($orderNumberStr, $memberUser) {
        $channel = new $this->chanelDriver();
        if (!$channel) {
            throw new Exception('不存在的通道');
        }
        return $channel->pay($orderNumberStr, $memberUser);
    }

    /**
     * 支付签名
     * @return type
     * @throws Exception
     */
    public function paySign() {
        $channel = new $this->chanelDriver();
        if (!$channel) {
            throw new Exception('不存在的通道');
        }
        return $channel->paySign();
    }

}
