<?php

namespace framework\pay\wechat;

/**
 * WxPayConfig
 */
class WxPayConfig {

    /**
     * GetAppId
     * @return string
     */
    public function GetAppId() {
        return systemConfig('wechatAppId');
    }

    /**
     * GetMerchantId
     * @return type
     */
    public function GetMerchantId() {
        return systemConfig('wechatMerchantId');
    }

    /**
     * GetNotifyUrl
     * @return string
     */
    public function GetNotifyUrl() {
        return systemConfig('wechatNotifyUrl');
    }

    /**
     * GetSignType
     * @return string
     */
    public function GetSignType() {
        return "HMAC-SHA256";
    }

    /**
     * GetProxy
     * @param string $proxyHost
     * @param int $proxyPort
     */
    public function GetProxy(&$proxyHost, &$proxyPort) {
        $proxyHost = "0.0.0.0";
        $proxyPort = 0;
    }

    /**
     * GetReportLevenl
     * @return int
     */
    public function GetReportLevenl() {
        return 1;
    }

    /**
     * GetKey
     * @return type
     */
    public function GetKey() {
        return systemConfig('wechatKey');
    }

    /**
     * GetAppSecret
     * @return type
     */
    public function GetAppSecret() {
        return systemConfig('wechatAppSecret');
    }

    /**
     * GetSSLCertPath
     * @param string $sslCertPath
     * @param string $sslKeyPath
     */
    public function GetSSLCertPath(&$sslCertPath, &$sslKeyPath) {
        $sslCertPath = frameworkPath() . '/pay/cert/apiclient_cert.pem';
        $sslKeyPath = frameworkPath() . '/pay/cert/apiclient_key.pem';
    }

}
