<?php

namespace framework\route;

/**
 * -----------------------------------------------------------------------------
 * f framework
 * @author df
 * -----------------------------------------------------------------------------
 * Driver
 */
class Driver {

    public static $_baseRouteDir = [
        'base/android',
        'base/ios',
        'base/h5',
        'base/mpwechat',
        'base/web',
    ];
    public static $_developRouteDir = [
        'develop/android',
        'develop/ios',
        'develop/h5',
        'develop/mpwechat',
        'develop/web',
    ];

    /**
     * driverReady
     */
    public static function driverReady() {
        $routeDirConf = [
            static::$_baseRouteDir,
            static::$_developRouteDir
        ];
        foreach ($routeDirConf as $dirConf) {
            if (!is_array($dirConf) || !count($dirConf)) {
                continue;
            }
            foreach ($dirConf as $waitDirLoad) {
                static::load($waitDirLoad);
            }
        }
    }

    /**
     * load
     * @param type $dir
     */
    public static function load($dir) {
        foreach (glob(appPath() . "/route/{$dir}/*.php") as $val) {
            include_once($val);
        }
    }

}
