<?php

namespace shangfan\controller\base\h5\mall;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\Order;
use framework\pay\Pay;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 支付
 */
class PayController {

    /**
     * 选择支付通道
     * @param Request $request
     * 
     * @param type $orderNumberStr
     * @return type
     * @throws Exception
     */
    public function select(Request $request, $orderNumberStr) {
        $member = Auth::memberH5();
        if (!$member) {
            return $request->redirect('/h5/member/login/index');
        }
        if (!$orderNumberStr) {
            throw new Exception('缺少订单号');
        }
        if (!Order::orderCheckAddress($orderNumberStr)) {
            return Response::json(statusSuccess('订单未选择收货地址'));
        }
        $orderNumberArr = explode(',', $orderNumberStr);
        if (!is_array($orderNumberArr) || !count($orderNumberArr)) {
            throw new Exception('缺少订单号');
        }
        $assign = compact('orderNumberStr', 'orderTotalAmount');
        setTitle('订单支付');
        return view('base.h5.mall.pay.select', $assign);
    }

    /**
     * 支付成功
     * @param Request $request
     * @param type $orderNumberStr
     * @return type
     */
    public function success(Request $request, $orderNumberStr) {
        $assign = compact('orderNumberStr');
        return view('base.h5.mall.pay.success', $assign);
    }

    /**
     * orderPayWechat
     * @param Request $request
     * @param type $orderNumberStr
     * @return type
     */
    public function wechatJsapi(Request $request, $orderNumberStr) {
        $wxpay = new WxPay();
        $jsApiParameters = $wxpay->jsApiParameters($orderNumberStr);
        $assign = compact('jsApiParameters', 'orderNumberStr');
        return view('base.h5.mall.pay.wechatJsapi', $assign);
    }

    /**
     * balance
     * @param Request $request
     * @param type $orderNumberStr
     * @return type
     */
    public function balance(Request $request, $orderNumberStr) {
        $pay = new Pay(['channel' => 'balance']);
        return Response::json($pay->pay($orderNumberStr, Auth::memberH5()));
    }

}
