<?php

namespace shangfan\controller\base\h5\shop;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\MallCategory;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\ShopGoodsImages;
use shangfan\model\base\ShopGoodsSelect;
use shangfan\model\base\ShopGoodsOption;
use shangfan\model\base\Stock;
use shangfan\model\base\MemberFocusShop;
use shangfan\model\base\ShopUser;
use shangfan\model\base\ShopInfo;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商品
 */
class ShopGoodsController {

    /**
     * 商品列表
     * @param Request $request
     * @param type $mallCategoryId
     * @return type
     */
    public function goodsLists(Request $request, $mallCategoryId) {
        $mallCategory = MallCategory::detail($mallCategoryId);
        if (!$mallCategory) {
            return $request->redirect('/h5/mall/index');
        }
        $h5Lists = ShopGoods::h5Lists($request, $mallCategoryId);
        $assign = compact('mallCategory', 'h5Lists');
        setTitle($mallCategory->name);
        return view('base.h5.shop.shopGoods.goodsLists', $assign);
    }

    /**
     * 商品搜索
     * @param Request $request
     * @param type $mallCategoryId
     * @return type
     */
    public function search(Request $request) {
        $h5Lists = ShopGoods::h5Search($request);
        $assign = compact('request', 'h5Lists');
        setTitle('商品搜索');
        return view('base.h5.shop.shopGoods.search', $assign);
    }

    /**
     * 商品详情
     * @param Request $request
     * @return string
     */
    public function goodsDetail(Request $request, $md5) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            return $request->redirect('/h5/mall/index');
        }
        $member = Auth::memberH5();
        $isFocusShop = false;
        if ($member) {
            $isFocusShop = MemberFocusShop::isFocusShop($member->id, $shopGoods->shop_user_id);
        }
        $shopInfo = ShopInfo::detailShopUserId($shopGoods->shop_user_id);
        $strCountFocus = ShopUser::strCountFocus($shopGoods->shop_user_id);
        $countShopGoods = ShopUser::countShopGoods($shopGoods->shop_user_id);
        $shopGoodsImages = ShopGoodsImages::getH5ShopGoodsDetailPics($shopGoods->id);
        $h5ListsLike = ShopGoods::h5ListsLike($request, $shopGoods->mall_category_id);
        $listsDetailMain = ShopGoodsSelect::listsDetailMain($request, $shopGoods->id);
        $listsDetailNoMain = ShopGoodsSelect::listsDetailNoMain($request, $shopGoods->id);
        $isUseNoMain = ShopGoodsSelect::isUseNoMain($shopGoods->id);
        $countSurplusGoodsId = Stock::countSurplusGoodsId($shopGoods->id);
        $assign = compact('shopGoods', 'shopInfo', 'isFocusShop', 'strCountFocus', 'countShopGoods', 'shopGoodsImages', 'h5ListsLike', 'listsDetailMain', 'listsDetailNoMain', 'countSurplusGoodsId', 'isUseNoMain');
        setTitle($shopGoods->name);
        return view('base.h5.shop.shopGoods.goodsDetail', $assign);
    }

    /**
     * ajaxGoodsOption
     * @param Request $request
     * @param type $idsOption
     * @return type
     */
    public function ajaxGoodsOption(Request $request) {
        $shopGoodsMd5 = $request->post('shopGoodsMd5', '');
        $idsOption = $request->post('idsOption', '');
        return Response::json(ShopGoodsOption::ajaxGoodsOption($shopGoodsMd5, $idsOption));
    }

}
